/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.popups;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import org.jpedal.io.ObjectStore;
import org.jpedal.utils.LogWriter;

public class DownloadProgress {
    File tempURLFile;
    boolean isDownloading = true;
    int progress;
    private final String pdfUrl;

    public DownloadProgress(String pdfUrl) {
        this.pdfUrl = pdfUrl;
    }

    public void startDownload() {
        try {
            int read;
            InputStream is;
            int fileLengthPercent = 0;
            this.progress = 0;
            String str = "file.pdf";
            if (this.pdfUrl.startsWith("jar:/")) {
                is = this.getClass().getResourceAsStream(this.pdfUrl.substring(4));
            } else {
                URL url = new URL(this.pdfUrl);
                is = url.openStream();
                str = url.getPath().substring(url.getPath().lastIndexOf(47) + 1);
                int fileLength = url.openConnection().getContentLength();
                fileLengthPercent = fileLength / 100;
            }
            String filename = str;
            this.tempURLFile = ObjectStore.createTempFile(filename);
            FileOutputStream fos = new FileOutputStream(this.tempURLFile);
            byte[] buffer = new byte[4096];
            int current = 0;
            while ((read = is.read(buffer)) != -1) {
                this.progress = (current += read) / fileLengthPercent;
                fos.write(buffer, 0, read);
            }
            fos.flush();
            is.close();
            fos.close();
            this.progress = 100;
        }
        catch (Exception e) {
            LogWriter.writeLog("[PDF] Exception " + e + " opening URL " + this.pdfUrl);
            e.printStackTrace();
            this.progress = 100;
        }
        this.isDownloading = false;
    }

    public File getFile() {
        return this.tempURLFile;
    }

    public boolean isDownloading() {
        return this.isDownloading;
    }

    public int getProgress() {
        return this.progress;
    }
}

