/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.popups;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.jpedal.io.ObjectStore;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class FileDownload {
    File tempURLFile;
    JFrame download;
    JPanel p;
    JProgressBar pb;
    JLabel downloadMessage;
    JLabel downloadFile;
    JLabel turnOff;
    int downloadCount;
    boolean visible = true;
    String progress = "";
    final Point coords;

    public FileDownload(boolean showWindow, Point pos) {
        this.visible = showWindow;
        this.coords = pos;
        if (this.visible) {
            this.download = new JFrame();
            this.download.setDefaultCloseOperation(2);
            this.p = new JPanel(new GridBagLayout());
            this.pb = new JProgressBar();
            this.downloadMessage = new JLabel();
            this.downloadFile = new JLabel();
            this.turnOff = new JLabel();
            this.download.setResizable(false);
            this.download.setTitle(Messages.getMessage("PageLayoutViewMenu.DownloadWindowTitle"));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 1;
            gbc.gridy = 0;
            gbc.gridx = 0;
            gbc.gridwidth = 2;
            this.downloadFile.setSize(250, this.downloadFile.getHeight());
            this.downloadFile.setMinimumSize(new Dimension(250, 15));
            this.downloadFile.setMaximumSize(new Dimension(250, 15));
            this.downloadFile.setPreferredSize(new Dimension(250, 15));
            this.p.add((Component)this.downloadFile, gbc);
            gbc.gridy = 1;
            this.downloadMessage.setSize(250, this.downloadFile.getHeight());
            this.downloadMessage.setMinimumSize(new Dimension(250, 15));
            this.downloadMessage.setMaximumSize(new Dimension(250, 15));
            this.downloadMessage.setPreferredSize(new Dimension(250, 15));
            this.p.add((Component)this.downloadMessage, gbc);
            gbc.gridy = 2;
            this.pb.setSize(260, this.downloadFile.getHeight());
            this.pb.setMinimumSize(new Dimension(260, 20));
            this.pb.setMaximumSize(new Dimension(260, 20));
            this.pb.setPreferredSize(new Dimension(260, 20));
            this.p.add((Component)this.pb, gbc);
            gbc.gridy = 3;
            this.p.add((Component)this.turnOff, gbc);
            this.download.getContentPane().add(this.p);
            this.download.setSize(320, 100);
        }
    }

    public File createWindow(String pdfUrl) {
        try {
            int read;
            String fraction;
            URL url = new URL(pdfUrl);
            InputStream is = url.openStream();
            String str = url.getPath().substring(url.getPath().lastIndexOf(47) + 1);
            int fileLength = url.openConnection().getContentLength();
            this.tempURLFile = File.createTempFile(str.substring(0, str.lastIndexOf(46)), str.substring(str.lastIndexOf(46)), new File(ObjectStore.temp_dir));
            FileOutputStream fos = new FileOutputStream(this.tempURLFile);
            if (this.visible && this.coords != null) {
                this.download.setLocation(this.coords.x - this.download.getWidth() / 2, this.coords.y - this.download.getHeight() / 2);
                this.download.setVisible(true);
            }
            if (this.visible) {
                this.pb.setMinimum(0);
                this.pb.setMaximum(fileLength);
                String message = Messages.getMessage("PageLayoutViewMenu.DownloadWindowMessage");
                message = message.replaceAll("FILENAME", str);
                this.downloadFile.setText(message);
                Font f = this.turnOff.getFont();
                this.turnOff.setFont(new Font(f.getName(), f.getStyle(), 8));
                this.turnOff.setAlignmentY(1.0f);
                this.turnOff.setText(Messages.getMessage("PageLayoutViewMenu.DownloadWindowTurnOff"));
            }
            byte[] buffer = new byte[4096];
            int current = 0;
            String rate = "kb";
            int mod = 1000;
            if (fileLength > 1000000) {
                rate = "mb";
                mod = 1000000;
            }
            if (this.visible) {
                this.progress = Messages.getMessage("PageLayoutViewMenu.DownloadWindowProgress");
                if (fileLength < 1000000) {
                    this.progress = this.progress.replaceAll("DVALUE", fileLength / mod + " " + rate);
                } else {
                    fraction = String.valueOf(fileLength % mod / 10000);
                    if (fileLength % mod / 10000 < 10) {
                        fraction = '0' + fraction;
                    }
                    this.progress = this.progress.replaceAll("DVALUE", fileLength / mod + "." + fraction + ' ' + rate);
                }
            }
            while ((read = is.read(buffer)) != -1) {
                current += read;
                this.downloadCount += read;
                if (this.visible) {
                    if (fileLength < 1000000) {
                        this.downloadMessage.setText(this.progress.replaceAll("DSOME", current / mod + " " + rate));
                    } else {
                        fraction = String.valueOf(current % mod / 10000);
                        if (current % mod / 10000 < 10) {
                            fraction = '0' + fraction;
                        }
                        this.downloadMessage.setText(this.progress.replaceAll("DSOME", current / mod + "." + fraction + ' ' + rate));
                    }
                    this.pb.setValue(current);
                    this.download.repaint();
                }
                fos.write(buffer, 0, read);
            }
            fos.flush();
            is.close();
            fos.close();
            if (this.visible) {
                this.downloadMessage.setText("Download of " + str + " is complete.");
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("[PDF] Exception " + e + " opening URL " + pdfUrl);
            e.printStackTrace();
        }
        if (this.visible) {
            this.download.setVisible(false);
        }
        return this.tempURLFile;
    }
}

