/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.popups;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.jpedal.utils.BrowserLauncher;
import org.jpedal.utils.LogWriter;

public class UpdateDialog
extends JDialog {
    private final String availableVersion;
    private final String currentVersion;

    public UpdateDialog(Container parent, String currentVersion, String availableVersion) {
        super((Frame)null, "Update Info", true);
        this.setDefaultCloseOperation(2);
        this.currentVersion = currentVersion;
        this.availableVersion = availableVersion;
        this.setSize(550, 350);
        this.init();
        this.setLocationRelativeTo(parent);
    }

    private void init() {
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints mainPanelConstraints = new GridBagConstraints();
        mainPanelConstraints.fill = 1;
        mainPanelConstraints.weighty = 1.0;
        mainPanelConstraints.weightx = 1.0;
        mainPanelConstraints.insets = new Insets(10, 10, 10, 10);
        this.addCenterPanel(mainPanelConstraints);
        mainPanelConstraints.weighty = 0.0;
        mainPanelConstraints.gridy = 1;
        this.addBottomButtons(mainPanelConstraints);
    }

    private void addCenterPanel(GridBagConstraints mainPanelConstraints) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)panel, mainPanelConstraints);
        GridBagConstraints panelConstraints = new GridBagConstraints();
        panelConstraints.gridx = 0;
        panelConstraints.gridy = 0;
        panelConstraints.fill = 2;
        panelConstraints.anchor = 19;
        panelConstraints.weighty = 0.0;
        panelConstraints.weightx = 0.0;
        panelConstraints.insets = new Insets(10, 10, 10, 10);
        panelConstraints.gridwidth = 2;
        SimpleAttributeSet plain = new SimpleAttributeSet();
        StyleConstants.setForeground(plain, Color.black);
        StyleConstants.setBold(plain, false);
        SimpleAttributeSet bold = new SimpleAttributeSet();
        StyleConstants.setForeground(bold, Color.black);
        StyleConstants.setBold(bold, true);
        JTextPane header = new JTextPane();
        header.setEditable(false);
        header.setOpaque(false);
        Document doc = header.getDocument();
        try {
            doc.insertString(0, "A new version of JPedal is available.", bold);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        panel.add((Component)header, panelConstraints);
        panelConstraints.gridwidth = 1;
        panelConstraints.gridy = 1;
        panelConstraints.insets = new Insets(10, 10, 0, 10);
        JTextPane currentVersionLabel = new JTextPane();
        currentVersionLabel.setEditable(false);
        currentVersionLabel.setOpaque(false);
        doc = currentVersionLabel.getDocument();
        try {
            doc.insertString(0, "Your current version:", plain);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        currentVersionLabel.setMinimumSize(currentVersionLabel.getPreferredSize());
        panel.add((Component)currentVersionLabel, panelConstraints);
        panelConstraints.weightx = 1.0;
        panelConstraints.gridx = 1;
        JTextPane currentVersionPane = new JTextPane();
        currentVersionPane.setEditable(false);
        currentVersionPane.setOpaque(false);
        doc = currentVersionPane.getDocument();
        try {
            doc.insertString(0, this.currentVersion, plain);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        panel.add((Component)currentVersionPane, panelConstraints);
        panelConstraints.insets = new Insets(0, 10, 10, 10);
        panelConstraints.weightx = 0.0;
        panelConstraints.gridx = 0;
        panelConstraints.gridy = 2;
        JTextPane availableVersionLabel = new JTextPane();
        availableVersionLabel.setEditable(false);
        availableVersionLabel.setOpaque(false);
        doc = availableVersionLabel.getDocument();
        try {
            doc.insertString(0, "Available Version:", plain);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        panel.add((Component)availableVersionLabel, panelConstraints);
        panelConstraints.gridwidth = 2;
        panelConstraints.weightx = 1.0;
        panelConstraints.gridx = 1;
        JTextPane availableVersionPane = new JTextPane();
        availableVersionPane.setEditable(false);
        availableVersionPane.setOpaque(false);
        doc = availableVersionPane.getDocument();
        try {
            doc.insertString(0, this.availableVersion, plain);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        panel.add((Component)availableVersionPane, panelConstraints);
        panelConstraints.insets = new Insets(10, 10, 10, 10);
        panelConstraints.weightx = 0.0;
        panelConstraints.gridx = 0;
        panelConstraints.gridy = 3;
        JTextPane moreInfo = new JTextPane();
        moreInfo.setEditable(false);
        moreInfo.setOpaque(false);
        doc = moreInfo.getDocument();
        try {
            doc.insertString(0, "Press ", plain);
            doc.insertString(doc.getLength(), "More info... ", bold);
            doc.insertString(doc.getLength(), "to open a web page where you can download JPedal or learn more about the new version", plain);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        panel.add((Component)moreInfo, panelConstraints);
        panelConstraints.gridy = 4;
        JTextPane configure = new JTextPane();
        doc = configure.getDocument();
        try {
            doc.insertString(0, "To configure automatic updates settings, see ", plain);
            doc.insertString(doc.getLength(), "View | Preferences", bold);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        configure.setEditable(false);
        configure.setOpaque(false);
        panel.add((Component)configure, panelConstraints);
        panelConstraints.weighty = 1.0;
        panelConstraints.gridy = 5;
        JTextPane manual = new JTextPane();
        doc = manual.getDocument();
        try {
            doc.insertString(0, "To check for new updates manually, use ", plain);
            doc.insertString(doc.getLength(), "Help | Check for Updates", bold);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        manual.setEditable(false);
        manual.setOpaque(false);
        panel.add((Component)manual, panelConstraints);
    }

    private void addBottomButtons(GridBagConstraints mainPanelConstraints) {
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 2));
        bottomPanel.add(Box.createHorizontalGlue());
        JButton moreInfo = new JButton("More Info");
        moreInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                block2: {
                    try {
                        BrowserLauncher.openURL("http://www.idrsolutions.com/jpedal-builds/");
                    }
                    catch (Exception e1) {
                        if (!LogWriter.isOutput()) break block2;
                        LogWriter.writeLog("Attempting to launch browser " + e);
                    }
                }
            }
        });
        JButton close = new JButton("Close");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdateDialog.this.dispose();
                UpdateDialog.this.setVisible(false);
            }
        });
        close.setPreferredSize(moreInfo.getPreferredSize());
        bottomPanel.add(close);
        bottomPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.setFocusTraversalPolicy(new MyFocus(this.getFocusTraversalPolicy(), moreInfo));
        moreInfo.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent event) {
            }

            @Override
            public void keyPressed(KeyEvent event) {
                block3: {
                    if (event.getKeyCode() == 10) {
                        try {
                            BrowserLauncher.openURL("http://www.idrsolutions.com/jpedal-builds/");
                        }
                        catch (Exception e1) {
                            if (!LogWriter.isOutput()) break block3;
                            LogWriter.writeLog("Attempting to launch browser " + e1);
                        }
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent event) {
            }
        });
        bottomPanel.add(moreInfo);
        this.add((Component)bottomPanel, mainPanelConstraints);
    }

    public static void main(String[] args) {
        UpdateDialog panel = new UpdateDialog(null, "3.2", "3.3");
        panel.setVisible(true);
    }

    static class MyFocus
    extends FocusTraversalPolicy {
        final FocusTraversalPolicy original;
        final JButton close;

        MyFocus(FocusTraversalPolicy original, JButton close) {
            this.original = original;
            this.close = close;
        }

        @Override
        public Component getComponentAfter(Container arg0, Component arg1) {
            return this.original.getComponentAfter(arg0, arg1);
        }

        @Override
        public Component getComponentBefore(Container arg0, Component arg1) {
            return this.original.getComponentBefore(arg0, arg1);
        }

        @Override
        public Component getFirstComponent(Container arg0) {
            return this.original.getFirstComponent(arg0);
        }

        @Override
        public Component getLastComponent(Container arg0) {
            return this.original.getLastComponent(arg0);
        }

        @Override
        public Component getDefaultComponent(Container arg0) {
            return this.close;
        }
    }
}

