/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.objects;

import java.io.File;

public class SignData {
    private boolean signMode;
    private boolean canEncrypt;
    private boolean flatten;
    private boolean isVisibleSignature;
    private String outputPath;
    private String keyFilePath;
    private String keyStorePath;
    private String alias;
    private String reason;
    private String location;
    private char[] keyFilePassword;
    private char[] keyStorePassword;
    private char[] aliasPassword;
    private char[] encryptUserPassword;
    private char[] encryptOwnerPassword;
    private int certifyMode;
    private int encryptPermissions;
    float x1;
    float y1;
    float x2;
    float y2;
    private File outputFile;
    private File keyFile;
    private boolean valid;
    private String invalidMessage;
    private int signaturePage;
    private boolean appendMode;

    public boolean isKeystoreSign() {
        return this.signMode;
    }

    public void setSignMode(boolean b) {
        this.signMode = b;
    }

    public void setOutputFilePath(String path) {
        this.outputPath = path;
    }

    public String getOutputFilePath() {
        return this.outputPath;
    }

    public File getOutput() {
        return this.outputFile;
    }

    public void setKeyFilePath(String path) {
        this.keyFilePath = path;
    }

    public String getKeyFilePath() {
        return this.keyFilePath;
    }

    public File getKeyFile() {
        return this.keyFile;
    }

    public void setKeyStorePath(String path) {
        this.keyStorePath = path;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public char[] getKeystorePassword() {
        return this.keyStorePassword;
    }

    public void setKeystorePassword(char[] password) {
        this.keyStorePassword = password;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public char[] getAliasPassword() {
        return this.aliasPassword;
    }

    public void setAliasPassword(char[] password) {
        this.aliasPassword = password;
    }

    public void setKeyFilePassword(char[] password) {
        this.keyFilePassword = password;
    }

    public char[] getKeyFilePassword() {
        return this.keyFilePassword;
    }

    public boolean canEncrypt() {
        return this.canEncrypt;
    }

    public void setEncrypt(boolean b) {
        this.canEncrypt = b;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public void setCertifyMode(int certifyMode) {
        this.certifyMode = certifyMode;
    }

    public int getCertifyMode() {
        return this.certifyMode;
    }

    public void setFlatten(boolean selected) {
        this.flatten = selected;
    }

    public boolean canFlatten() {
        return this.flatten;
    }

    public void setEncryptUserPass(char[] password) {
        this.encryptUserPassword = password;
    }

    public char[] getEncryptUserPass() {
        return this.encryptUserPassword;
    }

    public void setEncryptOwnerPass(char[] password) {
        this.encryptOwnerPassword = password;
    }

    public char[] getEncryptOwnerPass() {
        return this.encryptOwnerPassword;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public void setEncryptPermissions(int permissions) {
        this.encryptPermissions = permissions;
    }

    public int getEncryptPermissions() {
        return this.encryptPermissions;
    }

    public String toString() {
        String result;
        if (this.valid) {
            result = "Output File: " + this.outputFile.getAbsolutePath() + '\n';
            result = this.signMode ? result + "Keystore: " + this.keyStorePath + '\n' + "Alias: " + this.alias + '\n' : result + ".pfx File:" + this.keyFilePath + '\n';
        } else {
            return this.invalidMessage;
        }
        result = result + "Reason: \"" + this.reason + "\"\n" + "Location: " + this.location + '\n';
        if (this.canEncrypt()) {
            result = result + "Encrypt PDF\n";
        }
        if (this.canFlatten()) {
            result = result + "Flatten PDF\n";
        }
        if (this.certifyMode != -1) {
            result = result + "Certify PDF\n";
        }
        return result;
    }

    public boolean validate() {
        this.outputFile = new File(this.outputPath);
        if (this.outputFile.exists() || this.outputFile.isDirectory()) {
            this.invalidMessage = "Output file already exists.";
            this.valid = false;
            return false;
        }
        if (!this.signMode) {
            this.keyFile = new File(this.keyFilePath);
            if (!this.keyFile.exists() || this.keyFile.isDirectory()) {
                this.invalidMessage = "Key file not found.";
                this.valid = false;
                return false;
            }
        }
        this.valid = true;
        return true;
    }

    public boolean isVisibleSignature() {
        return this.isVisibleSignature;
    }

    public void setVisibleSignature(boolean b) {
        this.isVisibleSignature = b;
    }

    public void setRectangle(float x1, float y1, float x2, float y2) {
        if (x1 < x2) {
            this.x1 = x1;
            this.x2 = x2;
        } else {
            this.x2 = x1;
            this.x1 = x2;
        }
        if (y1 < y2) {
            this.y1 = y1;
            this.y2 = y2;
        } else {
            this.y2 = y1;
            this.y1 = y2;
        }
    }

    public float[] getRectangle() {
        return new float[]{this.x1, this.y1, this.x2, this.y2};
    }

    public int getSignPage() {
        return this.signaturePage;
    }

    public void setSignPage(int page) {
        this.signaturePage = page;
    }

    public void setAppend(boolean b) {
        this.appendMode = b;
    }

    public boolean isAppendMode() {
        return this.appendMode;
    }
}

