/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.exception.PdfFontException;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.objects.FontData;
import org.jpedal.fonts.tt.TTGlyphs;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.FastByteArrayOutputStream;

public class TrueType
extends PdfFont {
    private boolean subfontAlreadyLoaded;
    private Map fontsLoaded;
    private Rectangle BBox;

    public TrueType() {
        this.fontsLoaded = new HashMap();
        this.init(null);
    }

    private void readFontData(byte[] fontDataAsArray, FontData fontData) {
        if (this.subfontAlreadyLoaded) {
            this.glyphs = (PdfJavaGlyphs)this.fontsLoaded.get(this.substituteFont + '_' + this.glyphs.getBaseFontName() + ' ' + fontDataAsArray.length);
            this.fontTypes = this.glyphs.getType();
        } else {
            if (!this.isCIDFont && fontDataAsArray != null) {
                this.fontsLoaded.put(this.substituteFont + '_' + this.glyphs.getBaseFontName() + ' ' + fontDataAsArray.length, this.glyphs);
            }
            this.fontTypes = this.glyphs.readEmbeddedFont(this.TTstreamisCID, fontDataAsArray, fontData);
        }
    }

    protected void substituteFontUsed(String substituteFontFile) throws PdfFontException {
        block10: {
            InputStream from;
            block9: {
                from = null;
                try {
                    from = this.loader.getResourceAsStream("org/jpedal/res/fonts/" + substituteFontFile);
                    if (from == null) {
                        from = new FileInputStream(substituteFontFile);
                    }
                }
                catch (Exception e) {
                    System.err.println("Exception " + e + " reading " + substituteFontFile + " Check cid  jar installed");
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Exception " + e + " reading " + substituteFontFile + " Check cid  jar installed");
                    }
                    if (!ExternalHandlers.throwMissingCIDError || e.getMessage() == null || !e.getMessage().contains("kochi")) break block9;
                    throw new Error(e);
                }
            }
            if (from == null) {
                throw new PdfFontException("Unable to load font " + substituteFontFile);
            }
            try {
                int bytes_read;
                FastByteArrayOutputStream to = new FastByteArrayOutputStream();
                byte[] buffer = new byte[65535];
                while ((bytes_read = from.read(buffer)) != -1) {
                    to.write(buffer, 0, bytes_read);
                }
                from.close();
                FontData fontData = null;
                this.readFontData(to.toByteArray(), fontData);
                this.glyphs.setEncodingToUse(this.hasEncoding, this.getFontEncoding(false), this.isCIDFont);
                this.isFontEmbedded = true;
            }
            catch (Exception e) {
                System.err.println("Exception " + e + " reading " + substituteFontFile + " Check cid  jar installed");
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Exception " + e + " reading " + substituteFontFile + " Check cid  jar installed");
                }
                if (!ExternalHandlers.throwMissingCIDError || e.getMessage() == null || !e.getMessage().contains("kochi")) break block10;
                throw new Error(e);
            }
        }
    }

    public TrueType(PdfObjectReader current_pdf_file, String substituteFont) {
        this.glyphs = new TTGlyphs();
        this.init(current_pdf_file);
        this.substituteFont = substituteFont;
    }

    @Override
    public void createFont(PdfObject pdfObject, String fontID, boolean renderPage, ObjectStore objectStore, Map substitutedFonts) throws Exception {
        this.fontTypes = 1217103210;
        this.fontsLoaded = substitutedFonts;
        this.init(fontID, renderPage);
        PdfObject pdfFontDescriptor = pdfObject.getDictionary(-1044665361);
        this.setBoundsAndMatrix(pdfFontDescriptor);
        this.setName(pdfObject);
        this.setEncoding(pdfObject, pdfFontDescriptor);
        if (renderPage) {
            if (pdfFontDescriptor != null && this.substituteFont == null) {
                byte[] stream = null;
                PdfObject FontFile22 = pdfFontDescriptor.getDictionary(2021292334);
                if (FontFile22 == null && (FontFile22 = pdfFontDescriptor.getDictionary(746093177)) == null) {
                    FontFile22 = pdfFontDescriptor.getDictionary(2021292335);
                }
                if (FontFile22 != null) {
                    stream = this.currentPdfFile.readStream(FontFile22, true, true, false, false, false, FontFile22.getCacheName(this.currentPdfFile.getObjectReader()));
                }
                if (stream != null) {
                    this.readEmbeddedFont(stream, null, this.hasEncoding);
                }
            }
            if (!this.isFontEmbedded && this.substituteFont != null) {
                this.subfontAlreadyLoaded = !this.isCIDFont && this.fontsLoaded.containsKey(this.substituteFont + '_' + this.glyphs.getBaseFontName());
                FontData fontData = null;
                int objSize = 0;
                if (!this.subfontAlreadyLoaded) {
                    File fontFile = new File(this.substituteFont);
                    objSize = (int)fontFile.length();
                }
                if (FontData.maxSizeAllowedInMemory >= 0 && objSize > FontData.maxSizeAllowedInMemory) {
                    if (!this.subfontAlreadyLoaded) {
                        fontData = new FontData(this.substituteFont);
                    }
                    this.readEmbeddedFont(null, fontData, false);
                } else if (this.subfontAlreadyLoaded) {
                    this.readEmbeddedFont(null, null, false);
                } else {
                    int bytes_read;
                    InputStream jarFile;
                    block18: {
                        jarFile = null;
                        try {
                            jarFile = this.substituteFont.startsWith("jar:") || this.substituteFont.startsWith("http:") ? this.loader.getResourceAsStream(this.substituteFont) : this.loader.getResourceAsStream("file:///" + this.substituteFont);
                        }
                        catch (Exception e) {
                            if (LogWriter.isOutput()) {
                                LogWriter.writeLog("1.Unable to open " + this.substituteFont + ' ' + e);
                            }
                        }
                        catch (Error err) {
                            if (!LogWriter.isOutput()) break block18;
                            LogWriter.writeLog("1.Unable to open " + this.substituteFont + ' ' + err);
                        }
                    }
                    BufferedInputStream from = jarFile == null ? new BufferedInputStream(new FileInputStream(this.substituteFont)) : new BufferedInputStream(jarFile);
                    FastByteArrayOutputStream to = new FastByteArrayOutputStream();
                    byte[] buffer = new byte[65535];
                    while ((bytes_read = from.read(buffer)) != -1) {
                        to.write(buffer, 0, bytes_read);
                    }
                    from.close();
                    this.readEmbeddedFont(to.toByteArray(), null, false);
                }
                this.isFontSubstituted = true;
            }
        }
        this.readWidths(pdfObject, true);
        if (renderPage) {
            this.setFont(this.glyphs.fontName, 1);
        }
    }

    protected final void readEmbeddedFont(byte[] fontDataAsArray, FontData fontDataAsObject, boolean hasEncoding) {
        block3: {
            try {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Embedded TrueType font used");
                }
                this.readFontData(fontDataAsArray, fontDataAsObject);
                this.isFontEmbedded = true;
                this.glyphs.setFontEmbedded(true);
                this.glyphs.setEncodingToUse(hasEncoding, this.getFontEncoding(false), this.TTstreamisCID);
            }
            catch (Exception e) {
                this.isFontEmbedded = false;
                if (!LogWriter.isOutput()) break block3;
                LogWriter.writeLog("Exception " + e + " processing TrueType font");
            }
        }
    }

    @Override
    public Rectangle getBoundingBox() {
        if (this.BBox == null) {
            this.BBox = this.isFontEmbedded && !this.isFontSubstituted ? new Rectangle((int)this.FontBBox[0], (int)this.FontBBox[1], (int)(this.FontBBox[2] - this.FontBBox[0]), (int)(this.FontBBox[3] - this.FontBBox[1])) : super.getBoundingBox();
        }
        return this.BBox;
    }
}

