/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.glyph;

import java.awt.geom.GeneralPath;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.fonts.glyph.GlyphFactory;
import org.jpedal.fonts.glyph.JavaFXSupport;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.T1Glyph;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Glyf;
import org.jpedal.fonts.tt.Hmtx;
import org.jpedal.fonts.tt.hinting.TTVM;
import org.jpedal.utils.repositories.Vector_Float;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Path;

public class T1GlyphFactory
implements GlyphFactory {
    private static JavaFXSupport javaFXSupport;
    final boolean useFX;
    private static final float zero = 0.0f;
    private Vector_Float shape_primitive_x2 = new Vector_Float(1000);
    private Vector_Float shape_primitive_y = new Vector_Float(1000);
    private Vector_Int shape_primitives = new Vector_Int(1000);
    private Vector_Float shape_primitive_x3 = new Vector_Float(1000);
    private Vector_Float shape_primitive_y3 = new Vector_Float(1000);
    private Vector_Float shape_primitive_y2 = new Vector_Float(1000);
    private Vector_Float shape_primitive_x = new Vector_Float(1000);
    protected static final int H = 3;
    protected static final int L = 2;
    protected static final int M = 1;
    protected static final int C = 5;
    private float ymin;
    private int leftSideBearing;

    public T1GlyphFactory(boolean useFX) {
        this.useFX = useFX;
        if (useFX) {
            javaFXSupport = ExternalHandlers.getFXHandler();
        }
    }

    @Override
    public PdfGlyph getGlyph() {
        if (this.useFX) {
            return this.getFXGlyph();
        }
        return this.getSwingGlyph();
    }

    private PdfGlyph getSwingGlyph() {
        Vector_Path cached_current_path = new Vector_Path(100);
        GeneralPath current_path = new GeneralPath(1);
        current_path.moveTo(0.0f, 0.0f);
        float[] x = this.shape_primitive_x.get();
        float[] y = this.shape_primitive_y.get();
        float[] x2 = this.shape_primitive_x2.get();
        float[] y2 = this.shape_primitive_y2.get();
        float[] x3 = this.shape_primitive_x3.get();
        float[] y3 = this.shape_primitive_y3.get();
        int end = this.shape_primitives.size() - 1;
        int[] commands = this.shape_primitives.get();
        for (int i = 0; i < end; ++i) {
            if (commands[i] == 2) {
                current_path.lineTo(x[i], y[i] - this.ymin);
                continue;
            }
            if (commands[i] == 3) {
                current_path.closePath();
                cached_current_path.addElement(current_path);
                current_path = new GeneralPath(1);
                current_path.moveTo(0.0f, 0.0f);
                continue;
            }
            if (commands[i] == 1) {
                current_path.moveTo(x[i], y[i] - this.ymin);
                continue;
            }
            if (commands[i] != 5) continue;
            current_path.curveTo(x[i], y[i] - this.ymin, x2[i], y2[i] - this.ymin, x3[i], y3[i] - this.ymin);
        }
        this.shape_primitive_x2.reuse();
        this.shape_primitive_y.reuse();
        this.shape_primitives.reuse();
        this.shape_primitive_x3.reuse();
        this.shape_primitive_y3.reuse();
        this.shape_primitive_y2.reuse();
        this.shape_primitive_x.reuse();
        return new T1Glyph(cached_current_path);
    }

    private PdfGlyph getFXGlyph() {
        float[] x = this.shape_primitive_x.get();
        float[] y = this.shape_primitive_y.get();
        float[] x2 = this.shape_primitive_x2.get();
        float[] y2 = this.shape_primitive_y2.get();
        float[] x3 = this.shape_primitive_x3.get();
        float[] y3 = this.shape_primitive_y3.get();
        int end = this.shape_primitives.size() - 1;
        int[] commands = this.shape_primitives.get();
        this.shape_primitive_x2 = new Vector_Float(1000);
        this.shape_primitive_y = new Vector_Float(1000);
        this.shape_primitives = new Vector_Int(1000);
        this.shape_primitive_x3 = new Vector_Float(1000);
        this.shape_primitive_y3 = new Vector_Float(1000);
        this.shape_primitive_y2 = new Vector_Float(1000);
        this.shape_primitive_x = new Vector_Float(1000);
        if (javaFXSupport == null) {
            return null;
        }
        return javaFXSupport.getGlyph(x, y, x2, y2, x3, y3, this.ymin, end, commands);
    }

    @Override
    public final void closePath() {
        this.shape_primitives.addElement(3);
        this.shape_primitive_x.addElement(0.0f);
        this.shape_primitive_y.addElement(0.0f);
        this.shape_primitive_x2.addElement(0.0f);
        this.shape_primitive_y2.addElement(0.0f);
        this.shape_primitive_x3.addElement(0.0f);
        this.shape_primitive_y3.addElement(0.0f);
    }

    @Override
    public final void curveTo(float x, float y, float x2, float y2, float x3, float y3) {
        this.shape_primitives.addElement(5);
        this.shape_primitive_x.addElement(x);
        this.shape_primitive_y.addElement(y);
        this.shape_primitive_x2.addElement(x2);
        this.shape_primitive_y2.addElement(y2);
        this.shape_primitive_x3.addElement(x3);
        this.shape_primitive_y3.addElement(y3);
    }

    @Override
    public final void lineTo(float x, float y) {
        this.shape_primitives.addElement(2);
        this.shape_primitive_x.addElement(x);
        this.shape_primitive_y.addElement(y);
        this.shape_primitive_x2.addElement(0.0f);
        this.shape_primitive_y2.addElement(0.0f);
        this.shape_primitive_x3.addElement(0.0f);
        this.shape_primitive_y3.addElement(0.0f);
    }

    @Override
    public final void moveTo(float x, float y) {
        this.shape_primitives.addElement(1);
        this.shape_primitive_x.addElement(x);
        this.shape_primitive_y.addElement(y);
        this.shape_primitive_x2.addElement(0.0f);
        this.shape_primitive_y2.addElement(0.0f);
        this.shape_primitive_x3.addElement(0.0f);
        this.shape_primitive_y3.addElement(0.0f);
    }

    @Override
    public void setYMin(float ymin) {
        this.ymin = ymin;
    }

    @Override
    public int getLSB() {
        return this.leftSideBearing;
    }

    @Override
    public boolean useFX() {
        return this.useFX;
    }

    @Override
    public PdfGlyph getGlyph(Glyf currentGlyf, FontFile2 fontTable, Hmtx currentHmtx, int idx, float unitsPerEm, TTVM vm, String baseFontName) {
        if (javaFXSupport != null) {
            return javaFXSupport.getGlyph(currentGlyf, fontTable, currentHmtx, idx, unitsPerEm, vm, baseFontName);
        }
        return null;
    }
}

