/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.util.HashSet;
import javafx.scene.shape.Path;
import org.jpedal.color.PdfPaint;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Glyf;
import org.jpedal.fonts.tt.Hmtx;
import org.jpedal.fonts.tt.hinting.TTVM;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_Double;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;
import org.jpedal.utils.repositories.Vector_Path;
import org.jpedal.utils.repositories.Vector_Short;

public abstract class BaseTTGlyph {
    transient Vector_Path paths = new Vector_Path(10);
    protected boolean ttHintingRequired;
    public static boolean useHinting = true;
    protected boolean containsBrokenGlyfData;
    protected short compMinX;
    protected short compMinY;
    protected short compMaxX;
    protected short compMaxY;
    protected short minX;
    protected short minY;
    protected short maxX;
    protected short maxY;
    protected int[] scaledX;
    protected int[] scaledY;
    protected int BPoint1;
    protected int BPoint2;
    protected final Vector_Int xtranslateValues = new Vector_Int(5);
    protected final Vector_Int ytranslateValues = new Vector_Int(5);
    protected final short leftSideBearing;
    protected final Vector_Double xscaleValues = new Vector_Double(5);
    protected final Vector_Double yscaleValues = new Vector_Double(5);
    protected final Vector_Double scale01Values = new Vector_Double(5);
    protected final Vector_Double scale10Values = new Vector_Double(5);
    protected double xscale = 1.0;
    protected double yscale = 1.0;
    protected double scale01;
    protected double scale10;
    protected int[] instructions;
    protected int xtranslate;
    protected int ytranslate;
    protected int currentInstructionDepth = Integer.MAX_VALUE;
    protected final Vector_Object glyfX = new Vector_Object(5);
    protected final Vector_Object glyfY = new Vector_Object(5);
    protected final Vector_Object curves = new Vector_Object(5);
    protected final Vector_Object contours = new Vector_Object(5);
    protected final Vector_Int endPtIndices = new Vector_Int(5);
    protected int contourCount;
    protected float unitsPerEm = 64.0f;
    public static boolean debug;
    protected int glyphNumber = -1;
    protected int compCount = 1;
    protected boolean isComposite;
    protected double pixelSize;
    private static final HashSet<String> testedFonts;
    int BP1x = -1;
    int BP2x = -1;
    int BP1y = -1;
    int BP2y = -1;
    int existingXTranslate;
    int existingYTranslate;
    int depth;
    public static boolean redecodePage;
    boolean isHinted;
    private TTVM vm;
    private String baseFontName;

    public BaseTTGlyph(Glyf currentGlyf, FontFile2 glyfTable, Hmtx currentHmtx, int idx, float unitsPerEm, TTVM vm) {
        this.glyphNumber = idx + 1;
        this.isHinted = true;
        this.leftSideBearing = currentHmtx.getLeftSideBearing(idx);
        this.unitsPerEm = unitsPerEm;
        int p = currentGlyf.getCharString(idx);
        glyfTable.setPointer(p);
        if (glyfTable.getBytesLeft() > 4) {
            this.readGlyph(currentGlyf, glyfTable);
            this.vm = vm;
            this.createGlyph(this.isHinted);
        }
    }

    public BaseTTGlyph(Glyf currentGlyf, FontFile2 glyfTable, Hmtx currentHmtx, int idx, float unitsPerEm, String baseFontName) {
        this.glyphNumber = idx + 1;
        this.leftSideBearing = currentHmtx.getLeftSideBearing(idx);
        this.unitsPerEm = unitsPerEm;
        this.baseFontName = baseFontName;
        int p = currentGlyf.getCharString(idx);
        glyfTable.setPointer(p);
        if (glyfTable.getBytesLeft() > 4) {
            this.readGlyph(currentGlyf, glyfTable);
            this.createGlyph(false);
        }
    }

    void createGlyph(boolean isHinted) {
        if (isHinted) {
            this.createHintedGlyph();
        } else {
            this.createUnhintedGlyph();
        }
    }

    void createUnhintedGlyph() {
        for (int i = 0; i < this.compCount; ++i) {
            int[] pX = (int[])this.glyfX.elementAt(i);
            int[] pY = (int[])this.glyfY.elementAt(i);
            boolean[] onCurve = (boolean[])this.curves.elementAt(i);
            boolean[] endOfContour = (boolean[])this.contours.elementAt(i);
            int endIndex = this.endPtIndices.elementAt(i);
            if (this.isComposite) {
                this.xtranslate = this.xtranslateValues.elementAt(i);
                this.ytranslate = this.ytranslateValues.elementAt(i);
                this.xscale = this.xscaleValues.elementAt(i);
                this.yscale = this.yscaleValues.elementAt(i);
                this.scale01 = this.scale01Values.elementAt(i);
                this.scale10 = this.scale10Values.elementAt(i);
                if (this.BPoint1 != -1 && this.BPoint2 != -1) {
                    if (this.BP1x == -1 && this.BP2x == -1 && this.BP1y == -1 && this.BP2y == -1) {
                        this.BP1x = pX[this.BPoint1];
                        this.BP1y = pY[this.BPoint1];
                    } else {
                        this.BP2x = pX[this.BPoint2];
                        this.BP2y = pY[this.BPoint2];
                        int xx = this.BP1x - this.BP2x;
                        int yy = this.BP1y - this.BP2y;
                        int count = pX.length;
                        int ii = 0;
                        while (ii < count) {
                            int n = ii;
                            pX[n] = pX[n] + xx;
                            if (debug) {
                                System.out.println(pY[ii] + " " + yy + " BP1y=" + this.BP1y + " BP1y=" + this.BP1y);
                            }
                            int n2 = ii++;
                            pY[n2] = pY[n2] + yy;
                        }
                        this.BP1x = -1;
                        this.BP2x = -1;
                        this.BP1y = -1;
                        this.BP2y = -1;
                    }
                }
            }
            if (this.baseFontName != null && this.instructions != null && !testedFonts.contains(this.baseFontName)) {
                testedFonts.add(this.baseFontName);
                this.baseFontName = this.baseFontName.toLowerCase();
                if (this.baseFontName.contains("mingli") || this.baseFontName.contains("kai") || this.baseFontName.contains("huatian")) {
                    this.ttHintingRequired = true;
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("TrueType hinting probably required for font " + this.baseFontName);
                    }
                }
            }
            this.createPaths(pX, pY, onCurve, endOfContour, endIndex);
        }
    }

    static int midPt(int a, int b) {
        return a + (b - a) / 2;
    }

    public float getmaxWidth() {
        return 0.0f;
    }

    public void setT3Colors(PdfPaint strokeColor, PdfPaint nonstrokeColor, boolean lockColours) {
    }

    public boolean ignoreColors() {
        return false;
    }

    public void scaler(int[] pX, int[] pY) {
        this.scaledX = new int[pX.length];
        this.scaledY = new int[pY.length];
        double scale = this.pixelSize / (double)(this.unitsPerEm * 1000.0f) * 64.0;
        for (int i = 0; i < pX.length; ++i) {
            this.scaledX[i] = (int)(scale * (double)pX[i] + 0.5);
            this.scaledY[i] = (int)(scale * (double)pY[i] + 0.5);
        }
        this.scaledX[pX.length - 2] = 0;
        this.scaledY[pY.length - 2] = 0;
        this.scaledX[pX.length - 1] = (int)(scale * (double)this.leftSideBearing + 0.5);
        this.scaledY[pY.length - 1] = 0;
    }

    public final void readComplexGlyph(Glyf currentGlyf, FontFile2 currentFontFile) {
        this.isComposite = true;
        this.xtranslateValues.pull();
        this.ytranslateValues.pull();
        this.xscaleValues.pull();
        this.yscaleValues.pull();
        this.scale01Values.pull();
        this.scale10Values.pull();
        this.BPoint1 = -1;
        this.BPoint2 = -1;
        boolean WE_HAVE_INSTRUCTIONS = false;
        int count = currentGlyf.getGlypfCount();
        while (true) {
            int flag = currentFontFile.getNextUint16();
            int glyphIndex = currentFontFile.getNextUint16();
            if (debug) {
                System.err.println("Index=" + glyphIndex + " flag=" + flag + ' ' + count);
            }
            if (glyphIndex >= count) {
                this.containsBrokenGlyfData = true;
                break;
            }
            boolean ARG_1AND_2_ARE_WORDS = (flag & 1) == 1;
            boolean ARGS_ARE_XY_VALUES = (flag & 2) == 2;
            boolean WE_HAVE_A_SCALE = (flag & 8) == 8;
            boolean WE_HAVE_AN_X_AND_Y_SCALE = (flag & 0x40) == 64;
            boolean WE_HAVE_A_TWO_BY_TWO = (flag & 0x80) == 128;
            boolean bl = WE_HAVE_INSTRUCTIONS = WE_HAVE_INSTRUCTIONS || (flag & 0x100) == 256;
            if (ARG_1AND_2_ARE_WORDS && ARGS_ARE_XY_VALUES) {
                this.xtranslate = currentFontFile.getNextInt16();
                this.ytranslate = currentFontFile.getNextInt16();
            } else if (!ARG_1AND_2_ARE_WORDS && ARGS_ARE_XY_VALUES) {
                this.xtranslate = currentFontFile.getNextint8();
                this.ytranslate = currentFontFile.getNextint8();
            } else if (ARG_1AND_2_ARE_WORDS && !ARGS_ARE_XY_VALUES) {
                this.BPoint1 = currentFontFile.getNextUint16();
                this.BPoint2 = currentFontFile.getNextUint16();
                this.xtranslate = 0;
                this.ytranslate = 0;
            } else if (!ARG_1AND_2_ARE_WORDS && !ARGS_ARE_XY_VALUES) {
                this.BPoint1 = currentFontFile.getNextUint8();
                this.BPoint2 = currentFontFile.getNextUint8();
                this.xtranslate = 0;
                this.ytranslate = 0;
            }
            this.xscale = 1.0;
            this.scale01 = 0.0;
            this.scale10 = 0.0;
            this.yscale = 1.0;
            if (WE_HAVE_A_SCALE || WE_HAVE_AN_X_AND_Y_SCALE || WE_HAVE_A_TWO_BY_TWO) {
                if (WE_HAVE_A_SCALE && !WE_HAVE_AN_X_AND_Y_SCALE && !WE_HAVE_A_TWO_BY_TWO) {
                    this.xscale = currentFontFile.getF2Dot14();
                    this.scale01 = 0.0;
                    this.scale10 = 0.0;
                    this.yscale = this.xscale;
                } else if (!WE_HAVE_A_SCALE && WE_HAVE_AN_X_AND_Y_SCALE && !WE_HAVE_A_TWO_BY_TWO) {
                    this.xscale = currentFontFile.getF2Dot14();
                    this.scale01 = 0.0;
                    this.scale10 = 0.0;
                    this.yscale = currentFontFile.getF2Dot14();
                } else if (!WE_HAVE_A_SCALE && !WE_HAVE_AN_X_AND_Y_SCALE && WE_HAVE_A_TWO_BY_TWO) {
                    this.xscale = currentFontFile.getF2Dot14();
                    this.scale01 = currentFontFile.getF2Dot14();
                    this.scale10 = currentFontFile.getF2Dot14();
                    this.yscale = currentFontFile.getF2Dot14();
                }
            }
            int localX = this.xtranslate;
            int localY = this.ytranslate;
            this.xtranslate += this.existingXTranslate;
            this.ytranslate += this.existingYTranslate;
            this.xtranslateValues.addElement(this.xtranslate);
            this.ytranslateValues.addElement(this.ytranslate);
            this.xscaleValues.addElement(this.xscale);
            this.yscaleValues.addElement(this.yscale);
            this.scale01Values.addElement(this.scale01);
            this.scale10Values.addElement(this.scale10);
            int pointer = currentFontFile.getPointer();
            int p = currentGlyf.getCharString(glyphIndex);
            if (p != -1) {
                if (p < 0) {
                    p = -p;
                }
                currentFontFile.setPointer(p);
                this.existingXTranslate = this.xtranslate;
                this.existingYTranslate = this.ytranslate;
                ++this.depth;
                this.readGlyph(currentGlyf, currentFontFile);
                --this.depth;
                this.existingXTranslate -= localX;
                this.existingYTranslate -= localY;
            } else {
                System.err.println("Wrong value in complex");
            }
            currentFontFile.setPointer(pointer);
            if ((flag & 0x20) == 0) {
                if (WE_HAVE_INSTRUCTIONS) {
                    int instructionLength = currentFontFile.getNextUint16();
                    int[] instructions = new int[instructionLength];
                    for (int i = 0; i < instructionLength; ++i) {
                        instructions[i] = currentFontFile.getNextUint8();
                    }
                    if (this.depth > this.currentInstructionDepth) break;
                    this.instructions = instructions;
                    this.currentInstructionDepth = this.depth;
                    break;
                }
                if (this.depth > this.currentInstructionDepth) break;
                this.instructions = new int[0];
                this.currentInstructionDepth = this.depth;
                break;
            }
            ++this.compCount;
        }
    }

    public void readSimpleGlyph(FontFile2 currentFontFile) {
        block27: {
            int flagCount = 1;
            Vector_Int rawFlags = new Vector_Int(50);
            Vector_Int endPts = new Vector_Int(50);
            Vector_Short XX = new Vector_Short(50);
            Vector_Short Y = new Vector_Short(50);
            if (debug) {
                System.out.println("endPoints");
                System.out.println("---------");
            }
            try {
                int lastPt = 0;
                for (int i = 0; i < this.contourCount; ++i) {
                    lastPt = currentFontFile.getNextUint16();
                    if (debug) {
                        System.out.println(i + " " + lastPt);
                    }
                    endPts.addElement(lastPt);
                }
                if (currentFontFile.hasValuesLeft()) {
                    int i;
                    int flag;
                    int i2;
                    int instructionLength = currentFontFile.getNextUint16();
                    int[] instructions = new int[instructionLength];
                    for (int i3 = 0; i3 < instructionLength; ++i3) {
                        instructions[i3] = currentFontFile.getNextUint8();
                    }
                    if (this.depth < this.currentInstructionDepth) {
                        this.instructions = instructions;
                    }
                    if (debug) {
                        System.out.println("Instructions");
                        System.out.println("------------");
                        System.out.println("count=" + instructionLength);
                    }
                    int count = lastPt + 1;
                    for (i2 = 0; i2 < count; ++i2) {
                        if (currentFontFile.getBytesLeft() < 1) {
                            return;
                        }
                        flag = currentFontFile.getNextUint8();
                        rawFlags.addElement(flag);
                        ++flagCount;
                        if ((flag & 8) != 8) continue;
                        int repeatCount = currentFontFile.getNextUint8();
                        for (int r = 1; r <= repeatCount; ++r) {
                            rawFlags.addElement(flag);
                            ++flagCount;
                        }
                        i2 += repeatCount;
                    }
                    for (i2 = 0; i2 < count; ++i2) {
                        short x1;
                        flag = rawFlags.elementAt(i2);
                        if ((flag & 0x10) != 0) {
                            if ((flag & 2) != 0) {
                                x1 = (short)currentFontFile.getNextUint8();
                                XX.addElement(x1);
                                continue;
                            }
                            XX.addElement((short)0);
                            continue;
                        }
                        if ((flag & 2) != 0) {
                            x1 = (short)(-currentFontFile.getNextUint8());
                            XX.addElement(x1);
                            continue;
                        }
                        x1 = currentFontFile.getNextSignedInt16();
                        XX.addElement(x1);
                    }
                    for (i2 = 0; i2 < count; ++i2) {
                        flag = rawFlags.elementAt(i2);
                        if ((flag & 0x20) != 0) {
                            if ((flag & 4) != 0) {
                                if (currentFontFile.getBytesLeft() < 1) {
                                    return;
                                }
                                Y.addElement((short)currentFontFile.getNextUint8());
                                continue;
                            }
                            Y.addElement((short)0);
                            continue;
                        }
                        if ((flag & 4) != 0) {
                            Y.addElement((short)(-currentFontFile.getNextUint8()));
                            continue;
                        }
                        short val = currentFontFile.getNextSignedInt16();
                        Y.addElement(val);
                    }
                    int endPtIndex = 0;
                    int x = 0;
                    int y = 0;
                    int[] flags = rawFlags.get();
                    int[] endPtsOfContours = endPts.get();
                    short[] XPoints = XX.get();
                    short[] YPoints = Y.get();
                    count = XPoints.length;
                    int[] pX = new int[count + 2];
                    int[] pY = new int[count + 2];
                    boolean[] onCurve = new boolean[count + 2];
                    boolean[] endOfContour = new boolean[count + 2];
                    int endIndex = 0;
                    if (debug) {
                        System.out.println("Points");
                        System.out.println("------");
                    }
                    for (i = 0; i < count; ++i) {
                        boolean endPt;
                        boolean bl = endPt = endPtsOfContours[endPtIndex] == i;
                        if (endPt) {
                            ++endPtIndex;
                            endIndex = i + 1;
                        }
                        pX[i] = x += XPoints[i];
                        pY[i] = y += YPoints[i];
                        onCurve[i] = i < flagCount && (flags[i] & 1) != 0;
                        endOfContour[i] = endPt;
                        if (!debug) continue;
                        System.out.println(i + " " + pX[i] + ' ' + pY[i] + " on curve=" + onCurve[i] + " endOfContour[i]=" + endOfContour[i]);
                    }
                    for (i = 0; i < pX.length; ++i) {
                        int lX = pX[i];
                        int lY = pY[i];
                        pX[i] = !this.isComposite ? (!useHinting ? (int)((float)lX / this.unitsPerEm) : lX) : (!useHinting ? (int)(((double)lX * this.xscale + (double)lY * this.scale10 + (double)this.xtranslate) / (double)this.unitsPerEm) : (int)((double)lX * this.xscale + (double)lY * this.scale10 + (double)this.xtranslate));
                        if (!this.isComposite) {
                            if (!useHinting) {
                                pY[i] = (int)((float)lY / this.unitsPerEm);
                                continue;
                            }
                            pY[i] = lY;
                            continue;
                        }
                        pY[i] = !useHinting ? (int)(((double)lX * this.scale01 + (double)lY * this.yscale + (double)this.ytranslate) / (double)this.unitsPerEm) : (int)((double)lX * this.scale01 + (double)lY * this.yscale + (double)this.ytranslate);
                    }
                    this.glyfX.addElement(pX);
                    this.glyfY.addElement(pY);
                    this.curves.addElement(onCurve);
                    this.contours.addElement(endOfContour);
                    this.endPtIndices.addElement(endIndex);
                }
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block27;
                LogWriter.writeLog("Caught an Exception while reading TTGlyph bytes" + e);
            }
        }
    }

    public void readGlyph(Glyf currentGlyf, FontFile2 currentFontFile) {
        this.contourCount = currentFontFile.getNextUint16();
        this.minX = (short)currentFontFile.getNextUint16();
        this.minY = (short)currentFontFile.getNextUint16();
        this.maxX = (short)currentFontFile.getNextUint16();
        this.maxY = (short)currentFontFile.getNextUint16();
        if (this.minX > this.maxX || this.minY > this.maxY) {
            return;
        }
        if (debug) {
            System.out.println("------------------------------------------------------------");
            System.out.println("min=" + this.minX + ' ' + this.minY + " max=" + this.maxX + ' ' + this.maxY + " contourCount=" + this.contourCount);
        }
        if (this.contourCount != 65535) {
            if (this.contourCount > 0) {
                this.readSimpleGlyph(currentFontFile);
            }
        } else {
            this.compMinX = this.minX;
            this.compMinY = this.minY;
            this.compMaxX = this.maxX;
            this.compMaxY = this.maxY;
            if (debug) {
                System.out.println("XXmain=" + this.minX + ' ' + this.minY + ' ' + this.maxX + ' ' + this.maxY);
            }
            this.readComplexGlyph(currentGlyf, currentFontFile);
        }
    }

    public boolean isTTHintingRequired() {
        return this.ttHintingRequired;
    }

    public void createPaths(int[] pX, int[] pY, boolean[] onCurve, boolean[] endOfContour, int endIndex) {
        throw new UnsupportedOperationException("createPaths Not supported yet.");
    }

    void clearPaths() {
        throw new UnsupportedOperationException("clearPaths Not supported yet.");
    }

    public void render(int text_fill_type, Graphics2D g2, float scaling, boolean isFormGlyph) {
        throw new UnsupportedOperationException("render Not supported yet.");
    }

    public void setWidth(float width) {
    }

    public int getFontBB(int type) {
        if (this.isComposite) {
            if (type == 1) {
                return this.compMinX;
            }
            if (type == 2) {
                return this.compMinY;
            }
            if (type == 3) {
                return this.compMaxX;
            }
            if (type == 4) {
                return this.compMaxY;
            }
            return 0;
        }
        if (type == 1) {
            return this.minX;
        }
        if (type == 2) {
            return this.minY;
        }
        if (type == 3) {
            return this.maxX;
        }
        if (type == 4) {
            return this.maxY;
        }
        return 0;
    }

    public void setStrokedOnly(boolean b) {
    }

    public boolean containsBrokenData() {
        return this.containsBrokenGlyfData;
    }

    public Path getPath() {
        throw new UnsupportedOperationException("getPath Not supported yet.");
    }

    public int getGlyphNumber() {
        return this.glyphNumber;
    }

    public void setGlyphNumber(int no) {
        this.glyphNumber = no;
    }

    public Area getShape() {
        throw new UnsupportedOperationException("getShape Not supported yet.");
    }

    void createHintedGlyph() {
        for (int i = 0; i < this.compCount; ++i) {
            int[] pX = (int[])this.glyfX.elementAt(i);
            int[] pY = (int[])this.glyfY.elementAt(i);
            if (!this.isComposite) continue;
            this.xtranslate = this.xtranslateValues.elementAt(i);
            this.ytranslate = this.ytranslateValues.elementAt(i);
            this.xscale = this.xscaleValues.elementAt(i);
            this.yscale = this.yscaleValues.elementAt(i);
            this.scale01 = this.scale01Values.elementAt(i);
            this.scale10 = this.scale10Values.elementAt(i);
            if (this.BPoint1 == -1 || this.BPoint2 == -1) continue;
            if (this.BP1x == -1 && this.BP2x == -1 && this.BP1y == -1 && this.BP2y == -1) {
                this.BP1x = pX[this.BPoint1];
                this.BP1y = pY[this.BPoint1];
                continue;
            }
            this.BP2x = pX[this.BPoint2];
            this.BP2y = pY[this.BPoint2];
            int xx = this.BP1x - this.BP2x;
            int yy = this.BP1y - this.BP2y;
            int count = pX.length;
            int ii = 0;
            while (ii < count) {
                int n = ii;
                pX[n] = pX[n] + xx;
                if (debug) {
                    System.out.println(pY[ii] + " " + yy + " BP1y=" + this.BP1y + " BP1y=" + this.BP1y);
                }
                int n2 = ii++;
                pY[n2] = pY[n2] + yy;
            }
            this.BP1x = -1;
            this.BP2x = -1;
            this.BP1y = -1;
            this.BP2y = -1;
        }
        this.pixelSize = 1562.5;
        int coordCount = 2;
        int[] componentLengths = new int[this.compCount];
        for (int i = 0; i < this.compCount; ++i) {
            coordCount += this.endPtIndices.elementAt(i);
            componentLengths[i] = this.endPtIndices.elementAt(i);
        }
        int[] allX = new int[coordCount];
        int[] allY = new int[coordCount];
        int[] unscaledX = new int[coordCount];
        int[] unscaledY = new int[coordCount];
        boolean[] allOnCurve = new boolean[coordCount];
        boolean[] allEndOfContour = new boolean[coordCount];
        int[] allEndIndex = new int[this.compCount];
        int offset = 0;
        for (int i = 0; i < this.compCount; ++i) {
            int[] pX = (int[])this.glyfX.elementAt(i);
            int[] pY = (int[])this.glyfY.elementAt(i);
            boolean[] onCurve = (boolean[])this.curves.elementAt(i);
            boolean[] endOfContour = (boolean[])this.contours.elementAt(i);
            int endIndex = this.endPtIndices.elementAt(i);
            if (pX != null) {
                this.scaler(pX, pY);
            }
            for (int j = 0; j < componentLengths[i]; ++j) {
                allX[offset + j] = this.scaledX[j];
                allY[offset + j] = this.scaledY[j];
                unscaledX[offset + j] = pX[j];
                unscaledY[offset + j] = pY[j];
                allOnCurve[offset + j] = onCurve[j];
                allEndOfContour[offset + j] = endOfContour[j];
                allEndIndex[i] = endIndex;
            }
            offset += componentLengths[i];
        }
        double scaler = this.pixelSize / (double)(this.unitsPerEm * 1000.0f) * 64.0;
        allX[allX.length - 1] = (int)(scaler * (double)this.leftSideBearing + 0.5);
        this.vm.setScaleVars(scaler, this.pixelSize, this.pixelSize * 72.0 / 96.0);
        this.vm.processGlyph(this.instructions, allX, allY, allOnCurve, allEndOfContour);
        this.clearPaths();
        offset = 0;
        for (int i = 0; i < this.compCount; ++i) {
            int[] thisX = (int[])this.glyfX.elementAt(i);
            int[] thisY = (int[])this.glyfY.elementAt(i);
            boolean[] onCurve = (boolean[])this.curves.elementAt(i);
            boolean[] endOfContour = (boolean[])this.contours.elementAt(i);
            int endIndex = allEndIndex[i];
            for (int j = 0; j < componentLengths[i]; ++j) {
                thisX[j] = allX[offset + j];
                thisY[j] = allY[offset + j];
                onCurve[j] = allOnCurve[offset + j];
                endOfContour[j] = allEndOfContour[offset + j];
            }
            this.createPaths(thisX, thisY, onCurve, endOfContour, endIndex);
            offset += componentLengths[i];
        }
    }

    static {
        testedFonts = new HashSet();
        String value = System.getProperty("org.jpedal.useTTFontHinting");
        if (value != null) {
            useHinting = value.equalsIgnoreCase("true");
        }
    }
}

