/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Table;
import org.jpedal.utils.LogWriter;

public class CMAP
extends Table {
    protected int[][] glyphIndexToChar;
    private boolean remapType4;
    private boolean hasFormatZero;
    private int[] glyphToIndex;
    private boolean hasSix;
    private boolean hasFormat4;
    private boolean hasFormat6;
    private int lastFormat4Found = -1;
    private int firstCode = -1;
    private int entryCount = -1;
    private int segCount;
    private int fontMapping;
    protected int[] endCode;
    protected int[] startCode;
    protected int[] idDelta;
    protected int[] idRangeOffset;
    protected int[] glyphIdArray;
    private int[] f6glyphIdArray;
    private int[] offset;
    int nGroups;
    private int[] startCharCode;
    private int[] endCharCode;
    private int[] startGlyphCode;
    protected int[] CMAPformats;
    protected int[] CMAPlength;
    protected int[] CMAPlang;
    protected int[] CMAPsegCount;
    protected int[] CMAPsearchRange;
    protected int[] CMAPentrySelector;
    protected int[] CMAPrangeShift;
    protected int[] CMAPreserved;
    protected int[] platformID;
    private static final Map exceptions = new HashMap();
    private int formatToUse;
    protected int id;
    protected int numberSubtables;
    protected int[] CMAPsubtables;
    protected int[] platformSpecificID;
    private int fontEncoding;

    public CMAP(FontFile2 currentFontFile, int startPointer) {
        boolean debug = false;
        if (startPointer == 0) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("No CMAP table found");
            }
        } else {
            this.id = currentFontFile.getNextUint16();
            this.numberSubtables = currentFontFile.getNextUint16();
            this.CMAPsubtables = new int[this.numberSubtables];
            this.platformID = new int[this.numberSubtables];
            this.platformSpecificID = new int[this.numberSubtables];
            this.CMAPformats = new int[this.numberSubtables];
            this.CMAPsearchRange = new int[this.numberSubtables];
            this.CMAPentrySelector = new int[this.numberSubtables];
            this.CMAPrangeShift = new int[this.numberSubtables];
            this.CMAPreserved = new int[this.numberSubtables];
            this.CMAPsegCount = new int[this.numberSubtables];
            this.CMAPlength = new int[this.numberSubtables];
            this.CMAPlang = new int[this.numberSubtables];
            this.glyphIndexToChar = new int[this.numberSubtables][256];
            this.glyphToIndex = new int[256];
            for (int i = 0; i < this.numberSubtables; ++i) {
                this.platformID[i] = currentFontFile.getNextUint16();
                this.platformSpecificID[i] = currentFontFile.getNextUint16();
                this.CMAPsubtables[i] = currentFontFile.getNextUint32();
            }
            for (int j = 0; j < this.numberSubtables; ++j) {
                currentFontFile.selectTable(2);
                currentFontFile.skip(this.CMAPsubtables[j]);
                this.CMAPformats[j] = currentFontFile.getNextUint16();
                this.CMAPlength[j] = currentFontFile.getNextUint16();
                this.CMAPlang[j] = currentFontFile.getNextUint16();
                if (this.CMAPformats[j] == 6) {
                    this.hasSix = true;
                }
                if (this.CMAPformats[j] == 0 && this.CMAPlength[j] == 262) {
                    this.readFormatZeroTable(currentFontFile, j);
                    continue;
                }
                if (this.CMAPformats[j] == 4) {
                    this.readFormat4Table(j, currentFontFile);
                    continue;
                }
                if (this.CMAPformats[j] == 6) {
                    this.readFormat6Table(currentFontFile);
                    continue;
                }
                if (this.CMAPformats[j] == 12) {
                    this.readFormat12Table(currentFontFile);
                    continue;
                }
                this.CMAPformats[j] = -1;
            }
        }
    }

    private void readFormat4Table(int j, FontFile2 currentFontFile) {
        int i;
        this.CMAPsegCount[j] = currentFontFile.getNextUint16();
        this.segCount = this.CMAPsegCount[j] / 2;
        this.CMAPsearchRange[j] = currentFontFile.getNextUint16();
        this.CMAPentrySelector[j] = currentFontFile.getNextUint16();
        this.CMAPrangeShift[j] = currentFontFile.getNextUint16();
        if (this.hasFormat4) {
            if (this.CMAPlength[this.lastFormat4Found] > this.CMAPlength[j]) {
                this.CMAPlength[j] = this.CMAPlength[this.lastFormat4Found];
                this.CMAPsegCount[j] = this.CMAPsegCount[this.lastFormat4Found];
                this.CMAPsearchRange[j] = this.CMAPsearchRange[this.lastFormat4Found];
                this.CMAPentrySelector[j] = this.CMAPentrySelector[this.lastFormat4Found];
                this.CMAPrangeShift[j] = this.CMAPrangeShift[this.lastFormat4Found];
                return;
            }
            if (this.CMAPlength[this.lastFormat4Found] < this.CMAPlength[j]) {
                this.CMAPlength[this.lastFormat4Found] = this.CMAPlength[j];
                this.CMAPsegCount[this.lastFormat4Found] = this.CMAPsegCount[j];
                this.CMAPsearchRange[this.lastFormat4Found] = this.CMAPsearchRange[j];
                this.CMAPentrySelector[this.lastFormat4Found] = this.CMAPentrySelector[j];
                this.CMAPrangeShift[this.lastFormat4Found] = this.CMAPrangeShift[j];
            }
        }
        this.lastFormat4Found = j;
        this.hasFormat4 = true;
        this.endCode = new int[this.segCount];
        for (i = 0; i < this.segCount; ++i) {
            this.endCode[i] = currentFontFile.getNextUint16();
        }
        this.CMAPreserved[j] = currentFontFile.getNextUint16();
        this.startCode = new int[this.segCount];
        for (i = 0; i < this.segCount; ++i) {
            this.startCode[i] = currentFontFile.getNextUint16();
        }
        this.idDelta = new int[this.segCount];
        for (i = 0; i < this.segCount; ++i) {
            this.idDelta[i] = currentFontFile.getNextUint16();
        }
        this.idRangeOffset = new int[this.segCount];
        for (i = 0; i < this.segCount; ++i) {
            this.idRangeOffset[i] = currentFontFile.getNextUint16();
        }
        this.offset = new int[this.segCount];
        int cumulative = 0;
        for (int i2 = 0; i2 < this.segCount; ++i2) {
            if (this.idDelta[i2] != 0) continue;
            this.offset[i2] = cumulative;
            int diff = 1 + this.endCode[i2] - this.startCode[i2];
            if (this.startCode[i2] == this.endCode[i2] && this.idRangeOffset[i2] == 0) {
                diff = 0;
            }
            cumulative += diff;
        }
        int count = (this.CMAPlength[j] - 16 - this.segCount * 8) / 2;
        this.glyphIdArray = new int[count];
        for (int i3 = 0; i3 < count; ++i3) {
            this.glyphIdArray[i3] = currentFontFile.getNextUint16();
        }
    }

    private void readFormat6Table(FontFile2 currentFontFile) {
        this.hasFormat6 = true;
        this.firstCode = currentFontFile.getNextUint16();
        this.entryCount = currentFontFile.getNextUint16();
        this.f6glyphIdArray = new int[this.firstCode + this.entryCount];
        for (int jj = 0; jj < this.entryCount; ++jj) {
            this.f6glyphIdArray[jj + this.firstCode] = currentFontFile.getNextUint16();
        }
    }

    private void readFormat12Table(FontFile2 currentFontFile) {
        currentFontFile.getNextUint16();
        currentFontFile.getNextUint32();
        this.nGroups = currentFontFile.getNextUint32();
        this.startCharCode = new int[this.nGroups];
        this.endCharCode = new int[this.nGroups];
        this.startGlyphCode = new int[this.nGroups];
        for (int ii = 0; ii < this.nGroups; ++ii) {
            this.startCharCode[ii] = currentFontFile.getNextUint32();
            this.endCharCode[ii] = currentFontFile.getNextUint32();
            this.startGlyphCode[ii] = currentFontFile.getNextUint32();
        }
    }

    private void readFormatZeroTable(FontFile2 currentFontFile, int j) {
        this.hasFormatZero = true;
        int glyphNum = 0;
        while (glyphNum < 256) {
            int index;
            this.glyphIndexToChar[j][glyphNum] = index = currentFontFile.getNextUint8();
            this.glyphToIndex[index] = glyphNum++;
        }
    }

    public CMAP() {
    }

    public int convertIndexToCharacterCode(String glyph, int index) {
        int index2 = -1;
        int rawIndex = index;
        int format = this.CMAPformats[this.formatToUse];
        boolean debugMapping = false;
        if (this.fontMapping == 1 || this.fontMapping == 2 || this.fontMapping == 3 || this.fontMapping == 4 && this.remapType4) {
            if (glyph != null && !"notdef".equals(glyph)) {
                index2 = index;
                index = StandardFonts.getAdobeMap(glyph);
            } else if (exceptions.containsKey(glyph)) {
                index = (Integer)exceptions.get(glyph);
            }
        }
        int value = -1;
        if (rawIndex == 128 && this.endCode != null && "Euro".equals(glyph)) {
            value = this.getFormat4Value(8364, value);
        } else if (format == 0) {
            if (index > 255) {
                index = 0;
            }
            if ((value = this.glyphIndexToChar[this.formatToUse][index]) == 0 && index2 != -1) {
                value = this.glyphIndexToChar[this.formatToUse][index2];
            }
        } else if (format == 4) {
            if ((value = this.getFormat4Value(index, value)) == -1) {
                value = index > 61440 ? this.getFormat4Value(index - 61440, value) : this.getFormat4Value(index + 61440, value);
            }
            if (value == -1) {
                value = this.getFormat4Value(rawIndex + 61440, value);
            }
        } else if (format == 12) {
            value = this.getFormat12Value(index, false, value);
        }
        if (value == -1 && this.hasSix) {
            index = rawIndex;
            format = 6;
        }
        if (format == 6) {
            if (this.fontEncoding != 1) {
                index = StandardFonts.lookupCharacterIndex(glyph, 0);
            }
            value = index >= this.f6glyphIdArray.length ? 0 : this.f6glyphIdArray[index];
        }
        return value;
    }

    private int getFormat12Value(int index, boolean debugMapping, int value) {
        for (int i = 0; i < this.nGroups; ++i) {
            if (debugMapping) {
                System.out.println("table=" + i + " start=" + this.startCharCode[i] + ' ' + index + " end=" + this.endCharCode[i] + " glypgStartCode[i]=" + this.startGlyphCode[i]);
            }
            if (this.endCharCode[i] < index || this.startCharCode[i] > index) continue;
            value = this.startGlyphCode[i] + index - this.startCharCode[i];
            i = this.nGroups;
        }
        return value;
    }

    private int getFormat4Value(int index, int value) {
        boolean debugMapping = false;
        for (int i = 0; i < this.segCount; ++i) {
            if (this.endCode[i] < index || this.startCode[i] > index) continue;
            if (this.idRangeOffset[i] == 0) {
                value = (this.idDelta[i] + index) % 65536;
                i = this.segCount;
                continue;
            }
            int idx = this.offset[i] + (index - this.startCode[i]);
            if (idx < this.glyphIdArray.length) {
                value = this.glyphIdArray[idx];
            }
            i = this.segCount;
        }
        return value;
    }

    public void setEncodingToUse(boolean hasEncoding, int fontEncoding, boolean isCID) {
        int i;
        boolean encodingDebug = false;
        this.fontEncoding = fontEncoding;
        this.formatToUse = -1;
        int count = this.platformID.length;
        for (int i2 = 0; i2 < count; ++i2) {
            if (this.platformID[i2] != 3 || this.CMAPformats[i2] != 1 && this.CMAPformats[i2] != 0) continue;
            this.formatToUse = i2;
            this.fontMapping = 1;
            i2 = count;
        }
        boolean wasCase2 = false;
        if (this.formatToUse == -1 && this.hasFormatZero && !isCID) {
            for (i = 0; i < count; ++i) {
                if (this.platformID[i] != 1 || this.CMAPformats[i] != 0) continue;
                this.formatToUse = i;
                boolean bl = wasCase2 = this.glyphIndexToChar[this.formatToUse][223] == 0 || this.getFormat4Value(223, 0) != 0;
                if (hasEncoding) {
                    this.fontMapping = 2;
                    StandardFonts.checkLoaded(0);
                } else if (!wasCase2 && this.platformSpecificID[this.formatToUse] == 0 && this.platformID[this.formatToUse] == 1) {
                    this.fontMapping = 3;
                    StandardFonts.checkLoaded(2);
                } else {
                    this.fontMapping = -1;
                }
                i = count;
            }
        }
        if (this.formatToUse == -1 || this.fontMapping == 3 || wasCase2) {
            for (i = 0; i < count; ++i) {
                if (this.CMAPformats[i] != 4) continue;
                this.formatToUse = i;
                this.fontMapping = 4;
                i = count;
                if (this.platformSpecificID[this.formatToUse] == 3 && this.platformID[this.formatToUse] == 0 && (hasEncoding || fontEncoding == 1)) {
                    this.remapType4 = true;
                    continue;
                }
                if (this.platformSpecificID[this.formatToUse] == 1 && this.platformID[this.formatToUse] == 0 && hasEncoding && fontEncoding == 2) {
                    this.remapType4 = true;
                    continue;
                }
                if (this.platformSpecificID[this.formatToUse] == 0 && this.platformID[this.formatToUse] == 0 && hasEncoding && fontEncoding == 2) {
                    this.remapType4 = true;
                    continue;
                }
                if (this.platformSpecificID[this.formatToUse] == 1 && this.platformID[this.formatToUse] == 3 && hasEncoding && fontEncoding == 2 && (wasCase2 || this.getFormat4Value(223, 0) == 0)) {
                    this.remapType4 = true;
                    continue;
                }
                if (this.platformSpecificID[this.formatToUse] == 1 && this.platformID[this.formatToUse] == 3 && hasEncoding && (fontEncoding == 0 || count == 1 && fontEncoding == 2)) {
                    this.remapType4 = true;
                    continue;
                }
                if (hasEncoding || fontEncoding == 1) continue;
                this.remapType4 = true;
            }
        }
        if (this.formatToUse == -1) {
            for (i = 0; i < count; ++i) {
                if (this.CMAPformats[i] != 6) continue;
                this.formatToUse = i;
                if (!hasEncoding) {
                    this.fontMapping = 2;
                    StandardFonts.checkLoaded(0);
                } else {
                    this.fontMapping = 6;
                }
                i = count;
            }
        }
        if (this.formatToUse == -1) {
            for (i = 0; i < count; ++i) {
                if (this.CMAPformats[i] != 12) continue;
                this.formatToUse = i;
                if (!hasEncoding) {
                    this.fontMapping = 2;
                    StandardFonts.checkLoaded(0);
                } else {
                    this.fontMapping = 12;
                }
                i = count;
            }
        }
        if (fontEncoding == 5) {
            this.fontMapping = 2;
            StandardFonts.checkLoaded(0);
        }
    }

    public Map buildCharStringTable() {
        HashMap<Integer, Integer> glyfValues = new HashMap<Integer, Integer>();
        if (this.hasFormat4) {
            ArrayList<Integer> list4 = new ArrayList<Integer>();
            for (int z = 0; z < this.segCount; ++z) {
                int total = this.endCode[z] - this.startCode[z] + 1;
                for (int q = 0; q < total; ++q) {
                    list4.add(this.startCode[z] + q);
                }
            }
            for (Integer i : list4) {
                glyfValues.put(i, this.getFormat4Value(i, 0));
            }
        } else if (this.hasFormat6) {
            for (int z = 0; z < this.entryCount; ++z) {
                glyfValues.put(this.firstCode + z, this.f6glyphIdArray[this.firstCode + z]);
            }
        } else {
            for (int z = 0; z < this.glyphToIndex.length; ++z) {
                if (this.glyphToIndex[z] <= 0) continue;
                glyfValues.put(this.glyphToIndex[z], z);
            }
        }
        return glyfValues;
    }

    static {
        String[] keys = new String[]{"notequal", "infinity", "lessequal", "greaterequal", "partialdiff", "summation", "product", "pi", "integral", "Omega", "radical", "approxequal", "Delta", "lozenge", "Euro", "apple"};
        int[] values = new int[]{173, 176, 178, 179, 182, 183, 184, 185, 186, 189, 195, 197, 198, 215, 219, 240};
        for (int i = 0; i < values.length; ++i) {
            exceptions.put(keys[i], values[i]);
        }
        StandardFonts.checkLoaded(2);
    }
}

