/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import java.util.HashMap;
import java.util.Map;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Table;

public class Glyf
extends Table {
    private final int[] charStrings;
    private final int glyfCount;
    private final boolean[] emptyCharStrings;
    private byte[] glyphTable;

    Glyf(FontFile2 currentFontFile, int glyphCount, int[] glyphIndexStart) {
        this.glyfCount = glyphCount;
        this.charStrings = new int[glyphCount];
        this.emptyCharStrings = new boolean[glyphCount];
        int startPointer = currentFontFile.selectTable(3);
        if (startPointer != 0) {
            for (int i = 0; i < glyphCount; ++i) {
                if (glyphIndexStart[i] == glyphIndexStart[i + 1]) {
                    this.charStrings[i] = -1;
                    this.emptyCharStrings[i] = true;
                    continue;
                }
                this.charStrings[i] = glyphIndexStart[i];
            }
            this.glyphTable = currentFontFile.getTableBytes(4);
        }
    }

    public int getCharString(int glyph) {
        int value = glyph < 0 || glyph >= this.glyfCount ? glyph : this.charStrings[glyph];
        return value;
    }

    public byte[] getTableData() {
        return this.glyphTable;
    }

    public int getGlypfCount() {
        return this.glyfCount;
    }

    public Map buildCharStringTable() {
        HashMap<Integer, Integer> returnStrings = new HashMap<Integer, Integer>();
        for (int key = 0; key < this.glyfCount; ++key) {
            if (this.emptyCharStrings[key]) continue;
            returnStrings.put(key, key);
        }
        return returnStrings;
    }
}

