/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Table;
import org.jpedal.utils.LogWriter;

public class Hmtx
extends Table {
    private int[] hMetrics;
    private short[] leftSideBearing;
    private float scaling;

    public Hmtx(FontFile2 currentFontFile, int glyphCount, int metricsCount, int maxAdvance) {
        block11: {
            this.scaling = 0.001f;
            this.scaling = maxAdvance;
            if (metricsCount < 0) {
                metricsCount = -metricsCount;
            }
            int startPointer = currentFontFile.selectTable(6);
            int lsbCount = glyphCount - metricsCount;
            this.hMetrics = new int[glyphCount];
            this.leftSideBearing = new short[glyphCount];
            int currentMetric = 0;
            if (startPointer == 0) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("No Htmx table found");
                }
            } else if (lsbCount < 0) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Invalid Htmx table found");
                }
            } else {
                int i;
                for (i = 0; i < metricsCount; ++i) {
                    this.hMetrics[i] = currentMetric = currentFontFile.getNextUint16();
                    this.leftSideBearing[i] = currentFontFile.getNextInt16();
                }
                int tableLength = currentFontFile.getTableSize(6);
                int lsbBytes = tableLength - i * 4;
                lsbCount = lsbBytes / 2;
                try {
                    for (int j = i; j < lsbCount; ++j) {
                        this.hMetrics[j] = currentMetric;
                        this.leftSideBearing[j] = currentFontFile.getFWord();
                    }
                }
                catch (Exception ee) {
                    if (!LogWriter.isOutput()) break block11;
                    LogWriter.writeLog("Exception in reading Hmtx " + ee);
                }
            }
        }
    }

    public Hmtx() {
        this.scaling = 0.001f;
    }

    public short getRAWLSB(int i) {
        if (this.leftSideBearing == null || i >= this.leftSideBearing.length) {
            return 0;
        }
        return this.leftSideBearing[i];
    }

    public short getLeftSideBearing(int i) {
        int length = this.hMetrics.length;
        if (i < length) {
            return (short)(this.hMetrics[i] & 0xFFFF);
        }
        if (this.leftSideBearing == null) {
            return 0;
        }
        int ptr = i - length;
        if (ptr >= 0 && ptr < this.leftSideBearing.length) {
            return this.leftSideBearing[i - this.hMetrics.length];
        }
        return 0;
    }

    public float getAdvanceWidth(int i) {
        return (float)(this.hMetrics[i] - this.getLeftSideBearing(i)) / this.scaling;
    }

    public float getWidth(int i) {
        float w = this.hMetrics[i];
        return w / this.scaling;
    }

    public float getUnscaledWidth(int i) {
        return this.hMetrics[i];
    }
}

