/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.hinting;

import java.io.Serializable;
import org.jpedal.fonts.tt.hinting.TTVM;

public class TTGraphicsState
implements Cloneable,
Serializable {
    public static final int x_axis = 0x40000000;
    public static final int y_axis = 16384;
    public static final int hg = 104;
    public static final int g = 72;
    public static final int dg = 8;
    public static final int dtg = 68;
    public static final int utg = 64;
    public static final int off = -1;
    public boolean autoFlip = true;
    public int controlValueTableCutIn = 68;
    public int deltaBase = 9;
    public int deltaShift = 3;
    public int freedomVector = 0x40000000;
    public int projectionVector = 0x40000000;
    public int dualProjectionVector = 0x40000000;
    public int instructControl;
    public int loop = 1;
    public int minimumDistance = 1;
    public int roundState = 72;
    public double gridPeriod = 1.0;
    public int rp0;
    public int rp1;
    public int rp2;
    public int singleWidthCutIn;
    public int singleWidthValue;
    public int zp0 = 1;
    public int zp1 = 1;
    public int zp2 = 1;

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public double round(double n) {
        if (this.roundState == -1) {
            return n;
        }
        boolean isPositive = n > 0.0;
        int p = this.roundState >> 6 & 3;
        double period = p == 0 ? this.gridPeriod / 2.0 : (p == 1 ? this.gridPeriod : this.gridPeriod * 2.0);
        p = this.roundState >> 4 & 3;
        double phase = p == 0 ? 0.0 : (p == 1 ? period / 4.0 : (p == 2 ? period / 2.0 : 3.0 * period / 4.0));
        p = this.roundState & 0xF;
        if (p == 0) {
            double result;
            for (result = phase; result < n; result += period) {
            }
            return result;
        }
        double threshold = (double)(p - 4) * period / 8.0;
        n -= phase;
        double lower = 0.0;
        if (n > 0.0) {
            n += threshold;
            while (lower + period <= n) {
                lower += period;
            }
        } else {
            n -= threshold;
            while (lower - period >= n) {
                lower -= period;
            }
        }
        n = lower;
        n += phase;
        if (isPositive && n < 0.0) {
            n = phase % period;
        }
        if (!isPositive && n > 0.0) {
            n = (phase - 10.0 * period) % period;
        }
        return n;
    }

    public int round(int f26dot6) {
        double d = TTVM.getDoubleFromF26Dot6(f26dot6);
        d = this.round(d);
        return TTVM.storeDoubleAsF26Dot6(d);
    }

    public int[] getFVMoveforPVDistance(int distance) {
        if (distance == 0) {
            return new int[]{0, 0};
        }
        int[] fv = TTGraphicsState.getVectorComponents(this.freedomVector);
        fv[0] = TTVM.storeDoubleAsF26Dot6(TTVM.getDoubleFromF2Dot14(fv[0]));
        fv[1] = TTVM.storeDoubleAsF26Dot6(TTVM.getDoubleFromF2Dot14(fv[1]));
        double fvWorth = TTVM.getDoubleFromF26Dot6(TTGraphicsState.getCoordsOnVector(this.projectionVector, fv[0], fv[1]));
        if (fvWorth != 0.0) {
            double mul = TTVM.getDoubleFromF26Dot6(distance);
            fv[0] = (int)((double)fv[0] * mul / fvWorth);
            fv[1] = (int)((double)fv[1] * mul / fvWorth);
        } else {
            fv[0] = 0;
            fv[1] = 0;
        }
        return fv;
    }

    static int[] getVectorComponents(int vector) {
        return new int[]{vector >> 16, vector << 16 >> 16};
    }

    static int createVector(int x, int y) {
        return ((x & 0xFFFF) << 16) + (y & 0xFFFF);
    }

    static int getCoordsOnVector(int vector, int x, int y) {
        long yProj;
        int[] pv = TTGraphicsState.getVectorComponents(vector);
        long xProj = (long)pv[0] * (long)x;
        long bigResult = xProj + (yProj = (long)pv[1] * (long)y);
        boolean roundUp = (bigResult & 0x3FFFL) >= 127L;
        bigResult >>= 14;
        if (roundUp) {
            ++bigResult;
        }
        return (int)bigResult;
    }

    public void resetForGlyph() {
        this.zp0 = 1;
        this.zp1 = 1;
        this.zp2 = 1;
        this.projectionVector = 0x40000000;
        this.dualProjectionVector = 0x40000000;
        this.freedomVector = 0x40000000;
        this.roundState = 72;
        this.loop = 1;
        this.controlValueTableCutIn = 68;
    }
}

