/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import org.jpedal.function.PDFFunction;
import org.jpedal.function.PDFGenericFunction;

public class PDFSampled
extends PDFGenericFunction
implements PDFFunction {
    private final int[] size;
    private final int m;
    private final int n;
    private final float[] outputs;
    private final double[] sampleArray;
    private float[] prevInputs;

    public PDFSampled(byte[] stream, int bits, float[] domain, float[] range, float[] encode, float[] decode, int[] size) {
        super(domain, range);
        int defaultSize;
        int i;
        this.size = size;
        this.m = domain.length / 2;
        this.n = range.length / 2;
        int sampleLen = 1;
        for (int i2 = 0; i2 < size.length; ++i2) {
            sampleLen *= size[i2];
        }
        this.sampleArray = new double[sampleLen *= range.length / 2];
        int pos = 0;
        int buffer = 0;
        double sampleMul = 1.0 / (Math.pow(2.0, bits) - 1.0);
        int index = 0;
        for (i = 0; i < sampleLen; ++i) {
            while (pos < bits) {
                buffer <<= 8;
                buffer |= stream[index++] & 0xFF;
                pos += 8;
            }
            this.sampleArray[i] = (double)(buffer >> (pos -= bits)) * sampleMul;
            buffer = (int)((long)buffer & (1L << pos) - 1L);
        }
        if (encode != null) {
            this.encode = encode;
        } else {
            defaultSize = size.length;
            this.encode = new float[defaultSize * 2];
            for (int ii = 0; ii < defaultSize; ++ii) {
                this.encode[ii * 2 + 1] = size[ii] - 1;
            }
        }
        if (decode != null) {
            this.decode = decode;
        } else {
            defaultSize = range.length;
            this.decode = new float[defaultSize];
            System.arraycopy(range, 0, this.decode, 0, defaultSize);
        }
        this.outputs = new float[this.n];
        this.prevInputs = new float[this.m];
        for (i = 0; i < this.m; ++i) {
            this.prevInputs[i] = Float.MAX_VALUE;
        }
    }

    @Override
    public float[] computeStitch(float[] subinput) {
        return this.compute(subinput);
    }

    private static boolean isSame(float[] arr0, float[] arr1) {
        for (int i = 0; i < arr0.length; ++i) {
            if (arr0[i] == arr1[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public float[] compute(float[] input) {
        int next;
        int first;
        int i;
        if (PDFSampled.isSame(input, this.prevInputs)) {
            return this.outputs;
        }
        this.prevInputs = (float[])input.clone();
        int cubeVertices = 1 << this.m;
        double[] cubeN = new double[cubeVertices];
        int[] cubeVertex = new int[cubeVertices];
        for (int i2 = 0; i2 < cubeVertices; ++i2) {
            cubeN[i2] = 1.0;
        }
        int k = this.n;
        int pos = 1;
        for (i = 0; i < this.m; ++i) {
            first = 2 * i;
            next = first + 1;
            double xi = Math.min(Math.max(input[i], this.domain[first]), this.domain[next]);
            double e = PDFSampled.interpolateDouble(xi, this.domain[first], this.domain[next], this.encode[first], this.encode[next]);
            int cur = this.size[i];
            double e0 = (e = Math.min(Math.max(e, 0.0), (double)(cur - 1))) < (double)(cur - 1) ? (double)((int)e) : e - 1.0;
            double n0 = e0 + 1.0 - e;
            double n1 = e - e0;
            double offset0 = e0 * (double)k;
            double offset1 = offset0 + (double)k;
            for (int j = 0; j < cubeVertices; ++j) {
                if ((j & pos) != 0) {
                    int n = j;
                    cubeN[n] = cubeN[n] * n1;
                    int n2 = j;
                    cubeVertex[n2] = (int)((double)cubeVertex[n2] + offset1);
                    continue;
                }
                int n = j;
                cubeN[n] = cubeN[n] * n0;
                int n3 = j;
                cubeVertex[n3] = (int)((double)cubeVertex[n3] + offset0);
            }
            k *= cur;
            pos <<= 1;
        }
        for (i = 0; i < this.n; ++i) {
            first = 2 * i;
            next = first + 1;
            double pp = 0.0;
            for (int j = 0; j < cubeVertices; ++j) {
                pp += this.sampleArray[cubeVertex[j] + i] * cubeN[j];
            }
            pp = PDFSampled.interpolateDouble(pp, 0.0, 1.0, this.decode[first], this.decode[next]);
            this.outputs[i] = (float)Math.min(Math.max(pp, (double)this.range[first]), (double)this.range[next]);
        }
        return this.outputs;
    }

    private static double interpolateDouble(double x, double xmin, double xmax, double ymin, double ymax) {
        return (x - xmin) * (ymax - ymin) / (xmax - xmin) + ymin;
    }
}

