/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.grouping;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jpedal.exception.PdfException;
import org.jpedal.grouping.SearchListener;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.Fonts;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Sorts;
import org.jpedal.utils.Strip;
import org.jpedal.utils.repositories.Vector_Float;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;
import org.jpedal.utils.repositories.Vector_Rectangle;
import org.jpedal.utils.repositories.Vector_String;
import org.jpedal.utils.repositories.generic.Vector_Rectangle_Int;

public class PdfGroupingAlgorithms {
    private boolean includeHTMLtags;
    private static final String SystemSeparator = System.getProperty("line.separator");
    private boolean[] isUsed;
    private float[] f_x1;
    private float[] f_x2;
    private float[] f_y1;
    private float[] f_y2;
    private boolean[] hadSpace;
    private String[] f_colorTag;
    private int[] writingMode;
    private int[] fontSize;
    private float[] spaceWidth;
    private StringBuilder[] content;
    private int[] textLength;
    private final PdfData pdf_data;
    private boolean isXHTML = true;
    private int nextSlot;
    private Vector_Int lineBreaks = new Vector_Int();
    private Vector_Object lines;
    private Vector_Int lineY2;
    private static final String MARKER = PdfData.marker;
    public static final char MARKER2 = MARKER.charAt(0);
    private int max_rows;
    private int master;
    private boolean colorExtracted;
    private int[] line_order;
    private static final int increment = 100;
    public static boolean useUnrotatedCoords;
    private boolean includeTease;
    private String[] teasers;
    private final List multipleTermTeasers = new ArrayList();
    private boolean usingMultipleTerms;
    private boolean isXMLExtraction = true;
    private static final int linkedSearchAreas = -101;

    public PdfGroupingAlgorithms(PdfData pdf_data, PdfPageData pageData, boolean isXMLExtraction) {
        this.pdf_data = pdf_data;
        this.isXMLExtraction = isXMLExtraction;
        this.colorExtracted = pdf_data.isColorExtracted();
    }

    private static String getLineDownSeparator(StringBuilder rawLine1, StringBuilder rawLine2, boolean isXMLExtraction) {
        StringBuilder line2;
        StringBuilder line1;
        String returnValue = " ";
        boolean hasUnderline = false;
        if (isXMLExtraction) {
            line1 = Strip.stripXML(rawLine1, isXMLExtraction);
            line2 = Strip.stripXML(rawLine2, isXMLExtraction);
        } else {
            line1 = Strip.trim(rawLine1);
            line2 = Strip.trim(rawLine2);
        }
        int line1Len = line1.length();
        int line2Len = line2.length();
        if (line1Len > 1 && line2Len > 1) {
            char line1Char2 = line1.charAt(line1Len - 1);
            char line1Char1 = line1.charAt(line1Len - 2);
            char line2Char1 = line2.charAt(0);
            char line2Char2 = line2.charAt(1);
            String hyphen_values = "";
            if ("".indexOf(line1Char2) != -1) {
                returnValue = "";
                if (line1Char1 == ':') {
                    returnValue = "\n";
                }
                if (line1Char2 == ' ') {
                    returnValue = " ";
                }
            } else if ((line1Char1 == '.' || line1Char2 == '.') && (Character.isUpperCase(line2Char1) || line2Char1 == '&' || Character.isUpperCase(line2Char2) || line2Char2 == '&')) {
                returnValue = isXMLExtraction ? "<p></p>\n" : "\n";
            }
        }
        return returnValue;
    }

    private void cleanupShadowsAndDrownedObjects(boolean avoidSpaces) {
        int[] items = this.getUnusedFragments();
        int count = items.length;
        for (int p = 0; p < count; ++p) {
            int c = items[p];
            if (this.isUsed[c]) continue;
            float midX = (this.f_x1[c] + this.f_x2[c]) / 2.0f;
            float midY = (this.f_y1[c] + this.f_y2[c]) / 2.0f;
            for (int p2 = p + 1; p2 < count; ++p2) {
                String separator;
                boolean b_in_a;
                float diff;
                int n = items[p2];
                if (this.isUsed[n] || this.isUsed[c]) continue;
                float fontDiff = this.fontSize[n] - this.fontSize[c];
                if (fontDiff < 0.0f) {
                    fontDiff = -fontDiff;
                }
                if ((diff = this.f_x2[n] - this.f_x1[n] - (this.f_x2[c] - this.f_x1[c])) < 0.0f) {
                    diff = -diff;
                }
                if (fontDiff == 0.0f && midX > this.f_x1[n] && midX < this.f_x2[n] && diff < 10.0f && midY < this.f_y1[n] && midY > this.f_y2[n]) {
                    this.isUsed[n] = true;
                    continue;
                }
                boolean a_in_b = this.f_x1[n] > this.f_x1[c] && this.f_x2[n] < this.f_x2[c] && this.f_y1[n] < this.f_y1[c] && this.f_y2[n] > this.f_y2[c];
                boolean bl = b_in_a = this.f_x1[c] > this.f_x1[n] && this.f_x2[c] < this.f_x2[n] && this.f_y1[c] < this.f_y1[n] && this.f_y2[c] > this.f_y2[n];
                if (!a_in_b && !b_in_a) continue;
                if (this.f_y2[c] > this.f_y2[n]) {
                    separator = PdfGroupingAlgorithms.getLineDownSeparator(this.content[c], this.content[n], this.isXMLExtraction);
                    if (!avoidSpaces || separator.indexOf(32) == -1) {
                        this.merge(c, n, separator, true);
                    }
                } else {
                    separator = PdfGroupingAlgorithms.getLineDownSeparator(this.content[n], this.content[c], this.isXMLExtraction);
                    if (!avoidSpaces || separator.indexOf(32) == -1) {
                        this.merge(n, c, separator, true);
                    }
                }
                midX = (this.f_x1[c] + this.f_x2[c]) / 2.0f;
                midY = (this.f_y1[c] + this.f_y2[c]) / 2.0f;
            }
        }
    }

    private String isGapASpace(int c, int l, float actualGap, boolean addMultiplespaceXMLTag, int writingMode) {
        int spaceCount;
        String sep = "";
        float gapA = this.spaceWidth[c] * (float)this.fontSize[c];
        float gapB = this.spaceWidth[l] * (float)this.fontSize[l];
        float gap = gapA > gapB ? gapB : gapA;
        if ((gap = actualGap / (gap / 1000.0f)) > 0.51f && gap < 1.0f) {
            gap = 1.0f;
        }
        if ((spaceCount = (int)gap) > 0) {
            sep = " ";
        }
        if (spaceCount > 1 && addMultiplespaceXMLTag && writingMode == 0) {
            sep = " <SpaceCount space=\"" + spaceCount + "\" />";
        }
        return sep;
    }

    private void merge(int m, int c, String separator, boolean moveFont) {
        if (this.f_x1[m] > this.f_x1[c]) {
            this.f_x1[m] = this.f_x1[c];
        }
        if (this.f_y1[m] < this.f_y1[c]) {
            this.f_y1[m] = this.f_y1[c];
        }
        if (this.f_x2[m] < this.f_x2[c]) {
            this.f_x2[m] = this.f_x2[c];
        }
        if (this.f_y2[m] > this.f_y2[c]) {
            this.f_y2[m] = this.f_y2[c];
        }
        if (this.isXMLExtraction) {
            String test = "</font>";
            if (this.colorExtracted) {
                test = "</font></color>";
            }
            if (moveFont && this.content[m].toString().lastIndexOf(test) != -1) {
                String master = this.content[m].toString();
                this.content[m] = new StringBuilder(master.substring(0, master.lastIndexOf(test)));
                this.content[m].append(separator);
                this.content[m].append(master.substring(master.lastIndexOf(test)));
            } else {
                this.content[m].append(separator);
            }
            if (this.textLength[c] > 1 && this.content[m].toString().endsWith(" ")) {
                this.content[m].deleteCharAt(this.content[m].lastIndexOf(" "));
            }
            this.fontSize[m] = this.fontSize[c];
            if (this.content[c].indexOf("<color") != -1 && this.content[m].indexOf("<color") != -1 && this.content[c].toString().startsWith(this.content[m].substring(this.content[m].lastIndexOf("<color"), this.content[m].indexOf(">", this.content[m].lastIndexOf("<color")))) && this.content[m].lastIndexOf("</color>") + 7 == this.content[m].lastIndexOf(">")) {
                this.content[c].replace(this.content[c].indexOf("<color"), this.content[c].indexOf(">") + 1, "");
                this.content[m].replace(this.content[m].lastIndexOf("</color>"), this.content[m].lastIndexOf("</color>") + 8, "");
            }
            if (this.content[c].indexOf("<font") != -1 && this.content[m].indexOf("<font") != -1 && this.content[c].toString().startsWith(this.content[m].substring(this.content[m].lastIndexOf("<font"), this.content[m].indexOf(">", this.content[m].lastIndexOf("<font")))) && this.content[m].lastIndexOf("</font>") + 6 == this.content[m].lastIndexOf(">")) {
                this.content[c].replace(this.content[c].indexOf("<font"), this.content[c].indexOf(">") + 1, "");
                this.content[m].replace(this.content[m].lastIndexOf("</font>"), this.content[m].lastIndexOf("</font>") + 7, "");
            }
            this.content[m] = this.content[m].append((CharSequence)this.content[c]);
            int n = m;
            this.textLength[n] = this.textLength[n] + this.textLength[c];
            this.isUsed[c] = true;
            this.content[c] = null;
        } else {
            this.fontSize[m] = this.fontSize[c];
            this.content[m] = this.content[m].append(separator).append((CharSequence)this.content[c]);
            int n = m;
            this.textLength[n] = this.textLength[n] + this.textLength[c];
            this.isUsed[c] = true;
            this.content[c] = null;
        }
    }

    private void removeEncoding() {
        int[] items;
        for (int item : items = this.getUnusedFragments()) {
            int current = item;
            if (this.isUsed[current]) continue;
            this.content[current] = this.removeHiddenMarkers(current);
        }
    }

    private void copyToArraysPartial(int minX, int minY, int maxX, int maxY) {
        int i;
        this.colorExtracted = this.pdf_data.isColorExtracted();
        int count = this.pdf_data.getRawTextElementCount();
        boolean[] isUsed = new boolean[count];
        int[] fontSize = new int[count];
        int[] writingMode = new int[count];
        float[] spaceWidth = new float[count];
        StringBuilder[] content = new StringBuilder[count];
        int[] textLength = new int[count];
        float[] f_x1 = new float[count];
        String[] f_colorTag = new String[count];
        float[] f_x2 = new float[count];
        float[] f_y1 = new float[count];
        float[] f_y2 = new float[count];
        int currentPoint = 0;
        for (i = 0; i < count; ++i) {
            float x1 = this.pdf_data.f_x1[i];
            float x2 = this.pdf_data.f_x2[i];
            float y1 = this.pdf_data.f_y1[i];
            float y2 = this.pdf_data.f_y2[i];
            int mode = this.pdf_data.f_writingMode[i];
            boolean accepted = false;
            switch (mode) {
                case 0: 
                case 1: {
                    float height = y1 - y2;
                    if (!((float)minX < x1 && x1 < (float)maxX || (float)minX < x2 && x2 < (float)maxX || x1 < (float)minX && (float)minX < x2) && (!(x1 < (float)maxX) || !((float)maxX < x2)) || !((float)minY < y2 + height / 4.0f) || !((double)y2 + (double)height * 0.75 < (double)maxY)) break;
                    accepted = true;
                    break;
                }
                case 2: 
                case 3: {
                    float height = x2 - x1;
                    if (!((float)minY < y1 && y1 < (float)maxY || (float)minY < y2 && y2 < (float)maxY || y2 < (float)minY && (float)minY < y1) && (!(y2 < (float)maxY) || !((float)maxY < y1)) || !((float)minX < x1 + height / 4.0f) || !((double)x1 + (double)height * 0.75 < (double)maxX)) break;
                    accepted = true;
                }
            }
            if (!accepted) continue;
            content[currentPoint] = new StringBuilder(this.pdf_data.contents[i]);
            fontSize[currentPoint] = this.pdf_data.f_end_font_size[i];
            writingMode[currentPoint] = this.pdf_data.f_writingMode[i];
            f_x1[currentPoint] = this.pdf_data.f_x1[i];
            f_colorTag[currentPoint] = this.pdf_data.colorTag[i];
            f_x2[currentPoint] = this.pdf_data.f_x2[i];
            f_y1[currentPoint] = this.pdf_data.f_y1[i];
            f_y2[currentPoint] = this.pdf_data.f_y2[i];
            spaceWidth[currentPoint] = this.pdf_data.space_width[i];
            textLength[currentPoint] = this.pdf_data.text_length[i];
            StringBuilder startTags = new StringBuilder(content[currentPoint].toString().substring(0, content[currentPoint].toString().indexOf(MARKER)));
            String contentText = content[currentPoint].toString().substring(content[currentPoint].toString().indexOf(MARKER), content[currentPoint].toString().indexOf(60, content[currentPoint].toString().lastIndexOf(MARKER)));
            String endTags = content[currentPoint].toString().substring(content[currentPoint].toString().lastIndexOf(MARKER));
            endTags = endTags.substring(endTags.indexOf(60));
            StringTokenizer tokenizer = new StringTokenizer(contentText, MARKER);
            boolean setX1 = true;
            float width = 0.0f;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                float xCoord = Float.parseFloat(token);
                token = tokenizer.nextToken();
                width = Float.parseFloat(token);
                String character = token = tokenizer.nextToken();
                if (setX1) {
                    if (mode == 0 || mode == 1) {
                        f_x1[currentPoint] = xCoord;
                    } else {
                        f_y2[currentPoint] = xCoord;
                    }
                    setX1 = false;
                }
                if (mode == 0 || mode == 1) {
                    f_x2[currentPoint] = xCoord;
                } else {
                    f_y1[currentPoint] = xCoord;
                }
                boolean storeValues = false;
                if (mode == 0 || mode == 1) {
                    if ((float)minX < xCoord && xCoord + width < (float)maxX) {
                        storeValues = true;
                    }
                } else if ((float)minY < xCoord && xCoord + width < (float)maxY) {
                    storeValues = true;
                }
                if (!storeValues) continue;
                startTags.append(MARKER);
                startTags.append(xCoord);
                startTags.append(MARKER);
                startTags.append(width);
                startTags.append(MARKER);
                startTags.append(character);
            }
            content[currentPoint] = new StringBuilder(startTags.append(endTags).toString());
            if (mode == 0 || mode == 1) {
                int n = currentPoint;
                f_x2[n] = f_x2[n] + width;
            } else {
                int n = currentPoint;
                f_y1[n] = f_y1[n] + width;
            }
            ++currentPoint;
        }
        this.isUsed = new boolean[currentPoint];
        this.fontSize = new int[currentPoint];
        this.writingMode = new int[currentPoint];
        this.spaceWidth = new float[currentPoint];
        this.content = new StringBuilder[currentPoint];
        this.textLength = new int[currentPoint];
        this.f_x1 = new float[currentPoint];
        this.f_colorTag = new String[currentPoint];
        this.f_x2 = new float[currentPoint];
        this.f_y1 = new float[currentPoint];
        this.f_y2 = new float[currentPoint];
        for (i = 0; i != currentPoint; ++i) {
            this.isUsed[i] = isUsed[i];
            this.fontSize[i] = fontSize[i];
            this.writingMode[i] = writingMode[i];
            this.spaceWidth[i] = spaceWidth[i];
            this.content[i] = content[i];
            this.textLength[i] = textLength[i];
            this.f_x1[i] = f_x1[i];
            this.f_colorTag[i] = f_colorTag[i];
            this.f_x2[i] = f_x2[i];
            this.f_y1[i] = f_y1[i];
            this.f_y2[i] = f_y2[i];
        }
    }

    private void copyToArrays() {
        this.colorExtracted = this.pdf_data.isColorExtracted();
        int count = this.pdf_data.getRawTextElementCount();
        this.isUsed = new boolean[count];
        this.fontSize = new int[count];
        this.writingMode = new int[count];
        this.spaceWidth = new float[count];
        this.content = new StringBuilder[count];
        this.textLength = new int[count];
        this.f_x1 = new float[count];
        this.f_colorTag = new String[count];
        this.f_x2 = new float[count];
        this.f_y1 = new float[count];
        this.f_y2 = new float[count];
        for (int i = 0; i < count; ++i) {
            this.content[i] = new StringBuilder(this.pdf_data.contents[i]);
            this.fontSize[i] = this.pdf_data.f_end_font_size[i];
            this.writingMode[i] = this.pdf_data.f_writingMode[i];
            this.f_x1[i] = this.pdf_data.f_x1[i];
            this.f_colorTag[i] = this.pdf_data.colorTag[i];
            this.f_x2[i] = this.pdf_data.f_x2[i];
            this.f_y1[i] = this.pdf_data.f_y1[i];
            this.f_y2[i] = this.pdf_data.f_y2[i];
            this.spaceWidth[i] = this.pdf_data.space_width[i];
            this.textLength[i] = this.pdf_data.text_length[i];
        }
    }

    private int[] getUnusedFragments() {
        int total_fragments = this.isUsed.length;
        int ii = 0;
        int[] temp_index = new int[total_fragments];
        for (int i = 0; i < total_fragments; ++i) {
            if (this.isUsed[i]) continue;
            temp_index[ii] = i;
            ++ii;
        }
        int[] items = new int[ii];
        System.arraycopy(temp_index, 0, items, 0, ii);
        return items;
    }

    private StringBuilder removeHiddenMarkers(int c) {
        if (this.content[c].indexOf(MARKER) == -1) {
            return this.content[c];
        }
        StringTokenizer tokens = new StringTokenizer(this.content[c].toString(), MARKER, true);
        StringBuilder processedData = new StringBuilder();
        while (tokens.hasMoreTokens()) {
            String temp = tokens.nextToken();
            if (temp.equals(MARKER)) {
                tokens.nextToken();
                tokens.nextToken();
                tokens.nextToken();
                tokens.nextToken();
                processedData = processedData.append(tokens.nextToken());
                continue;
            }
            processedData = processedData.append(temp);
        }
        return processedData;
    }

    public void setIncludeHTML(boolean value) {
        this.includeHTMLtags = value;
    }

    public static String removeHiddenMarkers(String contents) {
        if (contents == null) {
            return null;
        }
        if (!contents.contains(MARKER)) {
            return contents;
        }
        StringTokenizer tokens = new StringTokenizer(contents, MARKER, true);
        StringBuilder processed_data = new StringBuilder();
        while (tokens.hasMoreTokens()) {
            String temp_token = tokens.nextToken();
            if (temp_token.equals(MARKER)) {
                tokens.nextToken();
                tokens.nextToken();
                tokens.nextToken();
                tokens.nextToken();
                processed_data = processed_data.append(tokens.nextToken());
                continue;
            }
            processed_data = processed_data.append(temp_token);
        }
        return processed_data.toString();
    }

    private void findVerticalLines(float minX, float minY, float maxX, float maxY, int currentWritingMode) throws PdfException {
        HashMap<Integer, Integer> xLines = new HashMap<Integer, Integer>();
        int most_frequent = 0;
        int count = this.pdf_data.getRawTextElementCount();
        for (int i = 0; i < count; ++i) {
            float y2;
            float y1;
            float x2;
            float x1;
            float currentX = 0.0f;
            String raw = this.pdf_data.contents[i];
            if (currentWritingMode == 0) {
                x1 = this.f_x1[i];
                x2 = this.f_x2[i];
                y1 = this.f_y1[i];
                y2 = this.f_y2[i];
            } else if (currentWritingMode == 1) {
                x2 = this.f_x1[i];
                x1 = this.f_x2[i];
                y1 = this.f_y1[i];
                y2 = this.f_y2[i];
            } else if (currentWritingMode == 3) {
                x1 = this.f_y1[i];
                x2 = this.f_y2[i];
                y1 = this.f_x2[i];
                y2 = this.f_x1[i];
            } else if (currentWritingMode == 2) {
                x1 = this.f_y2[i];
                x2 = this.f_y1[i];
                y2 = this.f_x1[i];
                y1 = this.f_x2[i];
            } else {
                throw new PdfException("Illegal value " + currentWritingMode + "for currentWritingMode");
            }
            if (!((double)x1 > (double)minX - 0.5) || !((double)x2 < (double)maxX + 0.5) || !((double)y2 > (double)minY - 0.5) || !((double)y1 < (double)maxY + 0.5)) continue;
            StringTokenizer tokens = new StringTokenizer(raw, MARKER, true);
            String lastValue = "";
            while (tokens.hasMoreTokens()) {
                String value = tokens.nextToken();
                if (!value.equals(MARKER)) continue;
                value = tokens.nextToken();
                if (!value.isEmpty()) {
                    float lastX = currentX;
                    currentX = Float.parseFloat(value);
                    try {
                        if (lastValue.isEmpty() || lastValue.indexOf(32) != -1) {
                            Integer intX = (int)currentX;
                            Object currentValue = xLines.get(intX);
                            if (currentValue == null) {
                                xLines.put(intX, 1);
                            } else {
                                int countReached = (Integer)currentValue;
                                if (++countReached > most_frequent) {
                                    most_frequent = countReached;
                                }
                                xLines.put(intX, countReached);
                            }
                            int middle = (int)(lastX + (currentX - lastX) / 2.0f);
                            if (lastX != 0.0f) {
                                intX = middle;
                                currentValue = xLines.get(intX);
                                if (currentValue == null) {
                                    xLines.put(intX, 1);
                                } else {
                                    int count_reached = (Integer)currentValue;
                                    if (++count_reached > most_frequent) {
                                        most_frequent = count_reached;
                                    }
                                    xLines.put(intX, count_reached);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        LogWriter.writeLog("Exception " + e + " stripping x values");
                    }
                }
                tokens.nextToken();
                tokens.nextToken();
                tokens.nextToken();
                lastValue = value = tokens.nextToken();
            }
        }
        Iterator keys = xLines.keySet().iterator();
        int minimum_needed = most_frequent / 2;
        while (keys.hasNext()) {
            Integer current_key = (Integer)keys.next();
            int current_count = (Integer)xLines.get(current_key);
            if (current_count <= minimum_needed) continue;
            this.lineBreaks.addElement(current_key);
        }
    }

    private boolean isFragmentWithinArea(Fragment fragment, float minX, float minY, float maxX, float maxY) {
        if (fragment.getWritingMode() == 0 || fragment.getWritingMode() == 1) {
            float textHeight = fragment.getY1() - fragment.getY2();
            if ((fragment.getY2() > minY && fragment.getY1() < maxY || fragment.getY2() > minY && (double)(maxY - fragment.getY2()) > (double)textHeight * 0.5 || fragment.getY1() < maxY && (double)(fragment.getY1() - minY) > (double)textHeight * 0.5) && minX + maxX > 0.0f && !(fragment.getX2() < minX) && !(fragment.getX1() > maxX)) {
                return true;
            }
        } else if ((fragment.getWritingMode() == 3 || fragment.getWritingMode() == 2) && fragment.getX1() > minX && fragment.getX2() < maxX && fragment.getY1() > minY && fragment.getY2() < maxY) {
            return true;
        }
        return false;
    }

    private void copyToArrays(float minX, float minY, float maxX, float maxY, boolean keepFont, boolean breakOnSpace, boolean findLines, String punctuation, boolean isWordlist) throws PdfException {
        boolean debugSplit = false;
        int count = this.pdf_data.getRawTextElementCount() + 100;
        this.initArrays(count);
        boolean linesScanned = false;
        count -= 100;
        String char_width = "";
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            float max;
            float min;
            float last_pt;
            float pt;
            Fragment fragment = new Fragment(this.pdf_data, i);
            if (!this.isFragmentWithinArea(fragment, minX, minY, maxX, maxY)) continue;
            if (!linesScanned && findLines) {
                this.findVerticalLines(minX, minY, maxX, maxY, fragment.getWritingMode());
                linesScanned = true;
            }
            if (fragment.getWritingMode() == 0 || fragment.getWritingMode() == 1) {
                pt = fragment.getX1();
                last_pt = fragment.getX1();
                min = minX;
                max = maxX;
            } else {
                pt = fragment.getY2();
                last_pt = fragment.getY2();
                min = minY;
                max = maxY;
            }
            float linePos = -1.0f;
            char[] line = fragment.getRawData().toCharArray();
            int end = line.length;
            int pointer = 0;
            String textValue = "";
            if (!fragment.getRawData().contains(MARKER)) {
                text = new StringBuilder(fragment.getRawData());
            }
            boolean isFirstValue = true;
            boolean breakPointset = false;
            while (pointer < end) {
                String value;
                do {
                    float midPoint;
                    int startPointer;
                    if (line[pointer] != MARKER2) {
                        startPointer = pointer;
                        while (pointer < end && line[pointer] != MARKER2) {
                            ++pointer;
                        }
                        value = fragment.getRawData().substring(startPointer, pointer);
                    } else {
                        while (pointer < end && line[pointer] != MARKER2) {
                            ++pointer;
                        }
                        startPointer = ++pointer;
                        while (pointer < end && line[pointer] != MARKER2) {
                            ++pointer;
                        }
                        String pt_reached = fragment.getRawData().substring(startPointer, pointer);
                        startPointer = ++pointer;
                        while (pointer < end && line[pointer] != MARKER2) {
                            ++pointer;
                        }
                        char_width = fragment.getRawData().substring(startPointer, pointer);
                        startPointer = ++pointer;
                        while (pointer < end && line[pointer] != MARKER2) {
                            ++pointer;
                        }
                        textValue = value = fragment.getRawData().substring(startPointer, pointer);
                        if (!pt_reached.isEmpty()) {
                            last_pt = pt;
                            pt = Float.parseFloat(pt_reached);
                            if (breakPointset) {
                                PdfGroupingAlgorithms.alterCoordsBasedOnWritingMode(fragment, pt);
                                breakPointset = false;
                            }
                        }
                        if (this.isXMLExtraction && last_pt < min && pt > min && !value.startsWith("<font ")) {
                            value = Fonts.getActiveFontTag(fragment.getRawData(), "") + value;
                        }
                    }
                    if (!char_width.isEmpty() && (midPoint = pt + Float.parseFloat(char_width) * 0.3f) > min & midPoint < max) {
                        this.setFragmentCoord(fragment, min, max, pt);
                        break;
                    }
                    value = "";
                    textValue = "";
                } while (pointer < end);
                if (isFirstValue) {
                    isFirstValue = false;
                    if (this.isXMLExtraction && keepFont && !value.startsWith("<font ") && !value.startsWith("<color ")) {
                        text.append(Fonts.getActiveFontTag(text.toString(), fragment.getRawData()));
                    }
                }
                boolean is_broken = false;
                if (findLines && fragment.getCharacterSpacing() > 0.0f && text.toString().endsWith(" ")) {
                    int counts = this.lineBreaks.size();
                    for (int jj = 0; jj < counts; ++jj) {
                        int test_x = this.lineBreaks.elementAt(jj);
                        if (!(last_pt < (float)test_x & pt > (float)test_x)) continue;
                        jj = counts;
                        is_broken = true;
                    }
                }
                boolean endsWithPunctuation = PdfGroupingAlgorithms.checkForPunctuation(textValue, punctuation);
                if (is_broken) {
                    text = this.writeOutFragment(keepFont, isWordlist, false, last_pt, pt, char_width, text, fragment, i, end, value);
                    continue;
                }
                if (endsWithPunctuation || breakOnSpace && (textValue.indexOf(32) != -1 || value.endsWith(" ")) || textValue.contains("   ")) {
                    pt = this.writeOut(keepFont, isWordlist, false, pt, char_width, text, fragment, i, value, textValue, endsWithPunctuation);
                    if (!char_width.isEmpty()) {
                        int ptr = 0;
                        if (textValue.indexOf(32) != -1) {
                            ptr = textValue.indexOf(32);
                        }
                        if (isWordlist) {
                            int len = textValue.length();
                            while (ptr < len && textValue.charAt(ptr) == ' ') {
                                ++ptr;
                            }
                        }
                        pt = ptr > 0 ? (pt += (float)ptr * Float.parseFloat(char_width)) : (pt += Float.parseFloat(char_width));
                        breakPointset = ptr > 0;
                    }
                    if (breakOnSpace & this.nextSlot > 0) {
                        this.hadSpace[this.nextSlot - 1] = true;
                    }
                    text = new StringBuilder(Fonts.getActiveFontTag(text.toString(), fragment.getRawData()));
                    PdfGroupingAlgorithms.alterCoordsBasedOnWritingMode(fragment, pt);
                    continue;
                }
                if (linePos != -1.0f & pt > linePos) {
                    text = this.writeOnVerticalLineBreak(keepFont, isWordlist, linePos, text, fragment, i, value);
                    linePos = -1.0f;
                    continue;
                }
                if (this.isXMLExtraction && value.endsWith(" </font>")) {
                    value = "</font>";
                    textValue = "";
                    PdfGroupingAlgorithms.alterCoordsBasedOnWritingMode(fragment, last_pt);
                }
                text.append(value);
            }
            if (keepFont && this.isXMLExtraction && !text.toString().endsWith("</font>") && !text.toString().endsWith("</color>")) {
                text.append("</font>");
            }
            this.completeLine(keepFont, isWordlist, text, fragment, i);
            text = new StringBuilder();
        }
        this.isUsed = new boolean[this.nextSlot];
    }

    private void completeLine(boolean keepFont, boolean isWordlist, StringBuilder text, Fragment fragment, int i) {
        if (fragment.getWritingMode() == 0 || fragment.getWritingMode() == 1) {
            if (fragment.getX1() < fragment.getX2()) {
                this.addFragment(i, text, fragment.getX1(), fragment.getX2(), fragment.getY1(), fragment.getY2(), keepFont, fragment, isWordlist);
            } else {
                this.addFragment(i, text, fragment.getX2(), fragment.getX1(), fragment.getY1(), fragment.getY2(), keepFont, fragment, isWordlist);
            }
        } else if ((fragment.getWritingMode() == 3 || fragment.getWritingMode() == 2) && fragment.getY1() > fragment.getY2()) {
            this.addFragment(i, text, fragment.getX1(), fragment.getX2(), fragment.getY1(), fragment.getY2(), keepFont, fragment, isWordlist);
        }
    }

    private StringBuilder writeOnVerticalLineBreak(boolean keepFont, boolean isWordlist, float linePos, StringBuilder text, Fragment fragment, int i, String value) {
        if (fragment.getWritingMode() == 0) {
            this.addFragment(i, text, fragment.getX1(), linePos, fragment.getY1(), fragment.getY2(), keepFont, fragment, isWordlist);
        } else if (fragment.getWritingMode() == 1) {
            this.addFragment(i, text, linePos, fragment.getX2(), fragment.getY1(), fragment.getY2(), keepFont, fragment, isWordlist);
        } else if (fragment.getWritingMode() == 3) {
            this.addFragment(i, text, fragment.getX1(), fragment.getX2(), linePos, fragment.getY2(), keepFont, fragment, isWordlist);
        } else if (fragment.getWritingMode() == 2) {
            this.addFragment(i, text, fragment.getX1(), fragment.getX2(), fragment.getY1(), linePos, keepFont, fragment, isWordlist);
        }
        text = new StringBuilder(Fonts.getActiveFontTag(text.toString(), fragment.getRawData()));
        text.append(value);
        PdfGroupingAlgorithms.alterCoordsBasedOnWritingMode(fragment, linePos);
        return text;
    }

    private float writeOut(boolean keepFont, boolean isWordlist, boolean debugSplit, float pt, String char_width, StringBuilder text, Fragment fragment, int i, String value, String textValue, boolean endsWithPunctuation) {
        int ptr;
        if (textValue.length() > 1 && textValue.indexOf(32) != -1 && (ptr = textValue.indexOf(32)) > 0) {
            pt += (float)ptr * (Float.parseFloat(char_width) / (float)textValue.length());
        }
        if (!endsWithPunctuation) {
            text.append(value.trim());
        }
        if (fragment.getWritingMode() == 0) {
            if (debugSplit) {
                System.out.println("Add " + fragment.getX1() + ' ' + pt + " text=" + text + " i=" + i);
            }
            this.addFragment(i, text, fragment.getX1(), pt, fragment.getY1(), fragment.getY2(), keepFont, fragment, isWordlist);
        } else if (fragment.getWritingMode() == 1) {
            if (debugSplit) {
                System.out.println("b");
            }
            this.addFragment(i, text, pt, fragment.getX2(), fragment.getY1(), fragment.getY2(), keepFont, fragment, isWordlist);
        } else if (fragment.getWritingMode() == 3) {
            if (debugSplit) {
                System.out.println("c");
            }
            this.addFragment(i, text, fragment.getX1(), fragment.getX2(), pt, fragment.getY2(), keepFont, fragment, isWordlist);
        } else if (fragment.getWritingMode() == 2) {
            if (debugSplit) {
                System.out.println("d");
            }
            this.addFragment(i, text, fragment.getX1(), fragment.getX2(), fragment.getY1(), pt, keepFont, fragment, isWordlist);
        }
        return pt;
    }

    private StringBuilder writeOutFragment(boolean keepFont, boolean isWordlist, boolean debugSplit, float last_pt, float pt, String char_width, StringBuilder text, Fragment fragment, int i, int end, String value) {
        if (debugSplit) {
            System.out.println("Break 1 is_broken");
        }
        Fragment temp = new Fragment(this.pdf_data, end);
        temp.setX1(fragment.getX1());
        temp.setY1(fragment.getY1());
        temp.setX2(fragment.getX2());
        temp.setY2(fragment.getY2());
        PdfGroupingAlgorithms.alterCoordsBasedOnWritingMode(temp, last_pt + Float.parseFloat(char_width));
        this.addFragment(i, text, temp.getX1(), temp.getX2(), temp.getY1(), temp.getY2(), keepFont, fragment, isWordlist);
        text = new StringBuilder(Fonts.getActiveFontTag(text.toString(), fragment.getRawData()));
        text.append(value);
        PdfGroupingAlgorithms.alterCoordsBasedOnWritingMode(fragment, pt);
        return text;
    }

    private void setFragmentCoord(Fragment fragment, float min, float max, float pt) {
        if (fragment.getWritingMode() == 0) {
            if ((fragment.getX1() < min || fragment.getX1() > max) && pt >= min) {
                fragment.setX1(pt);
            } else if (fragment.getWritingMode() == 1) {
                if ((fragment.getX2() > max || fragment.getX2() < min) && pt <= max) {
                    fragment.setX2(pt);
                } else if (fragment.getWritingMode() == 3) {
                    if ((fragment.getY2() < min || fragment.getY2() > max) && pt >= min) {
                        fragment.setY2(pt);
                    } else if (fragment.getWritingMode() == 2 && (fragment.getY1() < min || fragment.getY1() > max) && pt <= min) {
                        fragment.setY1(pt);
                    }
                }
            }
        }
    }

    static void alterCoordsBasedOnWritingMode(Fragment fragment, float value) {
        if (fragment.getWritingMode() == 0) {
            fragment.setX1(value);
        } else if (fragment.getWritingMode() == 1) {
            fragment.setX2(value);
        } else if (fragment.getWritingMode() == 3) {
            fragment.setY2(value);
        } else if (fragment.getWritingMode() == 2) {
            fragment.setY1(value);
        }
    }

    private void initArrays(int count) {
        this.f_x1 = new float[count];
        this.f_colorTag = new String[count];
        this.hadSpace = new boolean[count];
        this.f_x2 = new float[count];
        this.f_y1 = new float[count];
        this.f_y2 = new float[count];
        this.spaceWidth = new float[count];
        this.content = new StringBuilder[count];
        this.fontSize = new int[count];
        this.textLength = new int[count];
        this.writingMode = new int[count];
        this.isUsed = new boolean[count];
    }

    private static boolean checkForPunctuation(String textValue, String punctuation) {
        if (punctuation == null || punctuation != null && punctuation.isEmpty()) {
            return false;
        }
        boolean endsWithPunctuation = false;
        int textLength = textValue.length();
        int ii = textLength - 1;
        if (textLength > 0) {
            char testChar = textValue.charAt(ii);
            boolean inTag = testChar == '>';
            while ((inTag | testChar == ' ') & ii > 0) {
                if (testChar == '<') {
                    inTag = false;
                }
                if ((testChar = textValue.charAt(--ii)) != '>') continue;
                inTag = true;
            }
            if (testChar == ';') {
                endsWithPunctuation = true;
                --ii;
                while (ii > -1) {
                    testChar = textValue.charAt(ii);
                    if (testChar == '&' || testChar == '#') {
                        endsWithPunctuation = false;
                        ii = 0;
                    }
                    if (ii != 0 && testChar != ' ' && Character.isLetterOrDigit(testChar)) {
                        --ii;
                        continue;
                    }
                    break;
                }
            } else if (punctuation.indexOf(testChar) != -1) {
                endsWithPunctuation = true;
            }
        }
        return endsWithPunctuation;
    }

    private void addFragment(int index, StringBuilder contentss, float x1, float x2, float y1, float y2, boolean keepFontTokens, Fragment fragment, boolean isWordlist) {
        StringBuilder current_text = contentss;
        String str = current_text.toString();
        int text_len = fragment.getTextLength();
        String currentColorTag = fragment.getColorTag();
        if (isWordlist) {
            if (str.contains("&#")) {
                current_text = Strip.stripAmpHash(current_text);
            }
            if (this.isXMLExtraction && (str.contains("&lt;") || str.contains("&gt;"))) {
                current_text = Strip.stripXMLArrows(current_text, true);
            } else if (!(this.isXMLExtraction || str.indexOf(60) == -1 && str.indexOf(62) == -1)) {
                current_text = Strip.stripArrows(current_text);
            }
        }
        if (this.getFirstChar(current_text) != -1) {
            if (!keepFontTokens) {
                current_text = Strip.stripXML(current_text, this.isXMLExtraction);
            } else if (this.isXMLExtraction) {
                if (this.pdf_data.isColorExtracted() && !current_text.toString().endsWith("</color>")) {
                    if (!current_text.toString().endsWith("</font>")) {
                        current_text = current_text.append("</font>");
                    }
                    current_text = current_text.append("</color>");
                } else if (!this.pdf_data.isColorExtracted() && !current_text.toString().endsWith("</font>")) {
                    current_text = current_text.append("</font>");
                }
            }
            int count = this.f_x1.length;
            if (this.nextSlot < count) {
                this.f_x1[this.nextSlot] = x1;
                this.f_colorTag[this.nextSlot] = currentColorTag;
                this.f_x2[this.nextSlot] = x2;
                this.f_y1[this.nextSlot] = y1;
                this.f_y2[this.nextSlot] = y2;
                this.fontSize[this.nextSlot] = this.pdf_data.f_end_font_size[index];
                this.writingMode[this.nextSlot] = this.pdf_data.f_writingMode[index];
                this.textLength[this.nextSlot] = text_len;
                this.spaceWidth[this.nextSlot] = this.pdf_data.space_width[index];
                this.content[this.nextSlot] = current_text;
                ++this.nextSlot;
            } else {
                float[] t_x1 = new float[count += 100];
                String[] t_colorTag = new String[count];
                float[] t_x2 = new float[count];
                float[] t_y1 = new float[count];
                float[] t_y2 = new float[count];
                float[] t_spaceWidth = new float[count];
                StringBuilder[] t_content = new StringBuilder[count];
                int[] t_font_size = new int[count];
                int[] t_text_len = new int[count];
                int[] t_writingMode = new int[count];
                boolean[] t_isUsed = new boolean[count];
                boolean[] t_hadSpace = new boolean[count];
                for (int i = 0; i < count - 100; ++i) {
                    t_x1[i] = this.f_x1[i];
                    t_colorTag[i] = this.f_colorTag[i];
                    t_x2[i] = this.f_x2[i];
                    t_y1[i] = this.f_y1[i];
                    t_y2[i] = this.f_y2[i];
                    t_hadSpace[i] = this.hadSpace[i];
                    t_spaceWidth[i] = this.spaceWidth[i];
                    t_content[i] = this.content[i];
                    t_font_size[i] = this.fontSize[i];
                    t_writingMode[i] = this.writingMode[i];
                    t_text_len[i] = this.textLength[i];
                    t_isUsed[i] = this.isUsed[i];
                }
                this.f_x1 = t_x1;
                this.f_colorTag = t_colorTag;
                this.hadSpace = t_hadSpace;
                this.f_x2 = t_x2;
                this.f_y1 = t_y1;
                this.f_y2 = t_y2;
                this.isUsed = t_isUsed;
                this.fontSize = t_font_size;
                this.writingMode = t_writingMode;
                this.textLength = t_text_len;
                this.spaceWidth = t_spaceWidth;
                this.content = t_content;
                this.f_x1[this.nextSlot] = x1;
                this.f_colorTag[this.nextSlot] = currentColorTag;
                this.f_x2[this.nextSlot] = x2;
                this.f_y1[this.nextSlot] = y1;
                this.f_y2[this.nextSlot] = y2;
                this.fontSize[this.nextSlot] = this.pdf_data.f_end_font_size[index];
                this.writingMode[this.nextSlot] = this.pdf_data.f_writingMode[index];
                t_text_len[this.nextSlot] = text_len;
                this.content[this.nextSlot] = current_text;
                this.spaceWidth[this.nextSlot] = this.pdf_data.space_width[index];
                ++this.nextSlot;
            }
        }
    }

    private void mergeTableRows(int border_width) {
        String separator = "</tr>\n<tr>";
        if (!this.isXHTML) {
            separator = "\n";
        }
        this.master = ((Vector_Int)this.lines.elementAt(this.line_order[0])).elementAt(0);
        for (int rr = 1; rr < this.max_rows; ++rr) {
            int item = ((Vector_Int)this.lines.elementAt(this.line_order[rr])).elementAt(0);
            if (this.content[this.master] == null) {
                this.master = item;
                continue;
            }
            if (this.content[item] == null) continue;
            this.merge(this.master, item, separator, false);
        }
        if (this.isXHTML) {
            if (border_width == 0) {
                this.content[this.master].insert(0, "<TABLE>\n<tr>");
                this.content[this.master].append("</tr>\n</TABLE>\n");
            } else {
                StringBuilder startTag = new StringBuilder("<TABLE border='");
                startTag.append(border_width);
                startTag.append("'>\n<tr>");
                startTag.append((CharSequence)this.content[this.master]);
                this.content[this.master] = startTag;
                this.content[this.master].append("</tr>\n</TABLE>\n");
            }
        }
    }

    private int[] getsortedUnusedFragments(boolean sortOnX, boolean use_y1) {
        int total_fragments = this.isUsed.length;
        int ii = 0;
        int[] sorted_temp_index = new int[total_fragments];
        for (int i = 0; i < total_fragments; ++i) {
            if (this.isUsed[i]) continue;
            sorted_temp_index[ii] = i;
            ++ii;
        }
        int[] unsorted_items = new int[ii];
        int[] sorted_temp_x1 = new int[ii];
        int[] sorted_temp_y1 = new int[ii];
        int[] sorted_temp_y2 = new int[ii];
        for (int pointer = 0; pointer < ii; ++pointer) {
            int i;
            unsorted_items[pointer] = i = sorted_temp_index[pointer];
            sorted_temp_x1[pointer] = (int)this.f_x1[i];
            sorted_temp_y1[pointer] = (int)this.f_y1[i];
            sorted_temp_y2[pointer] = (int)this.f_y2[i];
        }
        int[] sorted_items = !sortOnX ? (use_y1 ? Sorts.quicksort(sorted_temp_y1, sorted_temp_x1, unsorted_items) : Sorts.quicksort(sorted_temp_y2, sorted_temp_x1, unsorted_items)) : Sorts.quicksort(sorted_temp_x1, sorted_temp_y1, unsorted_items);
        return sorted_items;
    }

    private void createTableRows(boolean keep_alignment_information, boolean keep_width_information, int currentWritingMode) throws PdfException {
        int item;
        boolean all_done;
        int i;
        float[] f_x2;
        float[] f_x1;
        if (currentWritingMode == 0) {
            f_x1 = this.f_x1;
            f_x2 = this.f_x2;
        } else if (currentWritingMode == 1) {
            f_x2 = this.f_x1;
            f_x1 = this.f_x2;
        } else if (currentWritingMode == 3) {
            f_x1 = this.f_y2;
            f_x2 = this.f_y1;
        } else if (currentWritingMode == 2) {
            f_x1 = this.f_y1;
            f_x2 = this.f_y2;
            int maxX = 0;
            for (float aF_x1 : f_x1) {
                if (!((float)maxX < aF_x1)) continue;
                maxX = (int)aF_x1;
            }
            ++maxX;
            for (int ii = 0; ii < f_x2.length; ++ii) {
                f_x1[ii] = (float)maxX - f_x1[ii];
                f_x2[ii] = (float)maxX - f_x2[ii];
            }
        } else {
            throw new PdfException("Illegal value " + currentWritingMode + "for currentWritingMode");
        }
        int itemsInTable = 0;
        int items_added = 0;
        int[] currentItem = new int[this.max_rows];
        Vector_Int[] rowContents = new Vector_Int[this.max_rows];
        Vector_String alignments = new Vector_String();
        Vector_Float widths = new Vector_Float();
        Vector_Float cell_x1 = new Vector_Float();
        String separator = "";
        String empty_cell = "&nbsp;";
        if (!this.isXHTML) {
            separator = "\",\"";
            empty_cell = "";
        }
        int[] itemCount = new int[this.max_rows];
        for (i = 0; i < this.max_rows; ++i) {
            itemCount[i] = ((Vector_Int)this.lines.elementAt(i)).size() - 1;
            itemsInTable += itemCount[i];
            currentItem[i] = 0;
            rowContents[i] = new Vector_Int(20);
        }
        do {
            float c_x2;
            float c_x1;
            float current_x1;
            float x1 = 9999.0f;
            float min_x2 = 9999.0f;
            float next_x1 = 9999.0f;
            float items_in_column = 0.0f;
            all_done = true;
            float total_x1 = 0.0f;
            float total_x2 = 0.0f;
            float left_gap = 0.0f;
            String alignment = "center";
            if (items_added >= itemsInTable) continue;
            for (i = 0; i < this.max_rows; ++i) {
                if (itemCount[i] <= currentItem[i]) continue;
                item = ((Vector_Int)this.lines.elementAt(i)).elementAt(currentItem[i]);
                current_x1 = f_x1[item];
                float current_x2 = f_x2[item];
                if (current_x1 < x1) {
                    x1 = current_x1;
                }
                if (!(current_x2 < min_x2)) continue;
                min_x2 = current_x2;
            }
            cell_x1.addElement(x1);
            float x2 = min_x2;
            for (i = 0; i < this.max_rows; ++i) {
                item = ((Vector_Int)this.lines.elementAt(i)).elementAt(currentItem[i]);
                c_x1 = f_x1[item];
                if (c_x1 >= x1 & c_x1 < min_x2 & (c_x2 = f_x2[item]) > x2) {
                    x2 = c_x2;
                }
                if (currentItem[i] >= itemCount[i] || !((current_x1 = f_x1[item = ((Vector_Int)this.lines.elementAt(i)).elementAt(currentItem[i] + 1)]) > min_x2 & current_x1 < next_x1)) continue;
                next_x1 = current_x1;
            }
            if (x1 != x2) {
                if (next_x1 == 9999.0f) {
                    next_x1 = x2;
                }
                for (i = 0; i < this.max_rows; ++i) {
                    item = ((Vector_Int)this.lines.elementAt(i)).elementAt(currentItem[i]);
                    c_x1 = f_x1[item];
                    if (!(c_x1 >= x1 & c_x1 < min_x2 & (c_x2 = f_x2[item]) <= next_x1)) continue;
                    total_x1 += c_x1;
                    total_x2 += c_x2;
                    items_in_column += 1.0f;
                }
                if (i == 0) {
                    left_gap = x1;
                }
                float right_gap = next_x1 == -1.0f ? 0.0f : (float)((int)((next_x1 - x2) / 2.0f));
                int width = (int)(x2 - x1 + right_gap + left_gap);
                widths.addElement(width);
                float x1_diff = total_x1 / items_in_column - x1;
                float x2_diff = x2 - total_x2 / items_in_column;
                if (x1_diff < 1.0f) {
                    alignment = "left";
                } else if (x2_diff < 1.0f) {
                    alignment = "right";
                }
                alignments.addElement(alignment);
                for (i = 0; i < this.max_rows; ++i) {
                    this.master = ((Vector_Int)this.lines.elementAt(i)).elementAt(0);
                    if (itemCount[i] > currentItem[i]) {
                        item = ((Vector_Int)this.lines.elementAt(i)).elementAt(currentItem[i]);
                        c_x1 = f_x1[item];
                        all_done = false;
                    } else {
                        item = -1;
                        c_x1 = -1.0f;
                    }
                    if (item == -1 & items_added <= itemsInTable) {
                        rowContents[i].addElement(-1);
                        continue;
                    }
                    if (c_x1 >= x1 & c_x1 < x2) {
                        rowContents[i].addElement(item);
                        int n = i;
                        currentItem[n] = currentItem[n] + 1;
                        ++items_added;
                        continue;
                    }
                    if (!(c_x1 > x2)) continue;
                    rowContents[i].addElement(-1);
                }
            }
            break;
        } while (!all_done);
        for (int row = 0; row < this.max_rows; ++row) {
            StringBuilder line_content = new StringBuilder(100);
            int count = rowContents[row].size() - 1;
            this.master = ((Vector_Int)this.lines.elementAt(row)).elementAt(0);
            for (i = 0; i < count; ++i) {
                item = rowContents[row].elementAt(i);
                if (this.isXHTML) {
                    float current_width = widths.elementAt(i);
                    String current_alignment = alignments.elementAt(i);
                    int colspan = 1;
                    int pointer = i + 1;
                    if (item != -1) {
                        int test;
                        while (!((test = rowContents[row].elementAt(i + 1)) != -1 | count == i + 1 || itemCount[row] > 1 && cell_x1.elementAt(i + 1) > f_x2[item])) {
                            --count;
                            rowContents[row].removeElementAt(i + 1);
                            ++colspan;
                            current_width += widths.elementAt(pointer);
                            ++pointer;
                        }
                    }
                    line_content.append("<td");
                    if (keep_alignment_information) {
                        line_content.append(" align='");
                        line_content.append(current_alignment);
                        line_content.append('\'');
                        if (colspan > 1) {
                            line_content.append(" colspan='").append(colspan).append('\'');
                        }
                    }
                    if (keep_width_information) {
                        line_content.append(" width='").append((int)current_width).append('\'');
                    }
                    line_content.append(" nowrap>");
                    if (item == -1) {
                        line_content.append(empty_cell);
                    } else {
                        line_content.append((CharSequence)this.content[item]);
                    }
                    line_content.append("</td>");
                } else if (item == -1) {
                    line_content.append("\"\",");
                } else {
                    line_content.append('\"');
                    line_content.append((CharSequence)this.content[item]);
                    line_content.append("\",");
                }
                if (item == -1 || this.master == item) continue;
                this.merge(this.master, item, separator, false);
            }
            this.content[this.master] = line_content;
        }
    }

    private void createLinesInTable(int itemCount, int[] items, boolean addSpaceXMLTag, int mode) throws PdfException {
        float[] f_y2;
        float[] f_y1;
        float[] f_x2;
        float[] f_x1;
        if (mode == 1) {
            items = PdfGroupingAlgorithms.reverse(items);
        }
        switch (mode) {
            case 0: {
                f_x1 = this.f_x1;
                f_x2 = this.f_x2;
                f_y1 = this.f_y1;
                f_y2 = this.f_y2;
                break;
            }
            case 1: {
                f_x2 = this.f_x1;
                f_x1 = this.f_x2;
                f_y1 = this.f_y1;
                f_y2 = this.f_y2;
                break;
            }
            case 3: {
                f_x1 = this.f_y1;
                f_x2 = this.f_y2;
                f_y1 = this.f_x2;
                f_y2 = this.f_x1;
                break;
            }
            case 2: {
                f_x1 = this.f_y2;
                f_x2 = this.f_y1;
                f_y2 = this.f_x1;
                f_y1 = this.f_x2;
                items = this.getsortedUnusedFragments(false, true);
                items = PdfGroupingAlgorithms.reverse(items);
                break;
            }
            default: {
                throw new PdfException("Illegal value " + mode + "for currentWritingMode");
            }
        }
        for (int j = 0; j < itemCount; ++j) {
            int c = items[j];
            int id = -1;
            int last = c;
            float smallest_gap = -1.0f;
            if (this.isUsed[c] || this.writingMode[c] != mode) continue;
            Vector_Int current_line = new Vector_Int(20);
            current_line.addElement(c);
            this.lineY2.addElement((int)f_y2[c]);
            while (true) {
                for (int ii = 0; ii < itemCount; ++ii) {
                    float yMidPt;
                    int i = items[ii];
                    if (this.isUsed[i] || i == c || this.writingMode[c] != mode || !(f_x1[i] > f_x1[c] && mode != 2) && (!(f_x1[i] < f_x1[c]) || mode != 2)) continue;
                    float gap = f_x1[i] - f_x2[c];
                    if (mode == 1 || mode == 2) {
                        gap = -gap;
                    }
                    if (gap < 0.0f && gap > -2.0f) {
                        gap = 0.0f;
                    }
                    if (!((yMidPt = (f_y1[i] + f_y2[i]) / 2.0f) < f_y1[c]) || !(yMidPt > f_y2[c]) || !(smallest_gap < 0.0f) && !(gap < smallest_gap)) continue;
                    smallest_gap = gap;
                    id = i;
                }
                if (id == -1) break;
                float t = f_x1[id] - f_x2[last];
                float possSpace = f_x1[id] - f_x2[c];
                float av_char1 = 1.5f * ((f_x2[id] - f_x1[id]) / (float)this.textLength[id]);
                float av_char2 = 1.5f * ((f_x2[last] - f_x1[last]) / (float)this.textLength[last]);
                if (mode == 1 || mode == 2) {
                    possSpace = -possSpace;
                    t = -t;
                    av_char1 = -av_char1;
                    av_char2 = -av_char2;
                }
                if (t < av_char1 && t < av_char2) {
                    this.merge(last, id, this.isGapASpace(id, last, possSpace, addSpaceXMLTag, mode), true);
                } else {
                    current_line.addElement(id);
                    last = id;
                }
                this.isUsed[id] = true;
                id = -1;
                smallest_gap = 1000000.0f;
            }
            this.lines.addElement(current_line);
            ++this.max_rows;
        }
    }

    public final Map extractTextAsTable(int x1, int y1, int x2, int y2, int pageNumber, boolean isCSV, boolean keepFontInfo, boolean keepWidthInfo, boolean keepAlignmentInfo, int borderWidth) throws PdfException {
        int[] v = PdfGroupingAlgorithms.validateCoordinates(x1, y1, x2, y2);
        x1 = v[0];
        y1 = v[1];
        x2 = v[2];
        y2 = v[3];
        HashMap<String, String> table_content = new HashMap<String, String>();
        LogWriter.writeLog("extracting Text As Table");
        this.isXHTML = !isCSV;
        this.lines = new Vector_Object(20);
        this.lineY2 = new Vector_Int(20);
        this.max_rows = 0;
        this.copyToArrays(x1, y2, x2, y1, keepFontInfo, false, true, null, false);
        this.removeEncoding();
        this.cleanupShadowsAndDrownedObjects(false);
        int[] items = this.getsortedUnusedFragments(true, false);
        int item_count = items.length;
        if (item_count == 0) {
            return table_content;
        }
        int writingMode = this.getWritingMode(items, item_count);
        String message = "Table Merging algorithm being applied " + item_count + " items";
        LogWriter.writeLog(message);
        if (item_count > 1) {
            this.createLinesInTable(item_count, items, this.isXHTML, writingMode);
            int dx = 1;
            if (writingMode == 0 || writingMode == 2) {
                dx = -1;
            }
            this.line_order = new int[this.max_rows];
            int[] line_y = new int[this.max_rows];
            for (int i = 0; i < this.max_rows; ++i) {
                line_y[i] = dx * this.lineY2.elementAt(i);
                this.line_order[i] = i;
            }
            this.line_order = Sorts.quicksort(line_y, this.line_order);
            this.createTableRows(keepAlignmentInfo, keepWidthInfo, writingMode);
            this.mergeTableRows(borderWidth);
        }
        this.content[this.master] = this.cleanup(this.content[this.master]);
        String processed_value = this.content[this.master].toString();
        if (processed_value != null) {
            if (!isCSV) {
                processed_value = Fonts.cleanupTokens(processed_value);
            }
            table_content.put("content", processed_value);
            table_content.put("x1", String.valueOf(x1));
            table_content.put("x2", String.valueOf(x2));
            table_content.put("y1", String.valueOf(y1));
            table_content.put("y2", String.valueOf(y2));
        }
        return table_content;
    }

    private static int[] validateCoordinates(int x1, int y1, int x2, int y2) {
        if (x1 > x2 | y1 < y2) {
            int temp;
            if (x1 > x2) {
                temp = x1;
                x1 = x2;
                x2 = temp;
                LogWriter.writeLog("x1 > x2, coordinates were swapped to validate");
            }
            if (y1 < y2) {
                temp = y1;
                y1 = y2;
                y2 = temp;
                LogWriter.writeLog("y1 < y2, coordinates were swapped to validate");
            }
        }
        return new int[]{x1, y1, x2, y2};
    }

    public final List extractTextAsWordlist(int x1, int y1, int x2, int y2, int page_number, boolean breakFragments, String punctuation) throws PdfException {
        int[] v = PdfGroupingAlgorithms.validateCoordinates(x1, y1, x2, y2);
        x1 = v[0];
        y1 = v[1];
        x2 = v[2];
        y2 = v[3];
        if (breakFragments) {
            this.copyToArrays(x1, y2, x2, y1, true, true, false, punctuation, true);
        } else {
            this.copyToArrays();
        }
        this.removeEncoding();
        this.cleanupShadowsAndDrownedObjects(true);
        int[] items = this.getsortedUnusedFragments(true, false);
        int count = items.length;
        if (count == 0) {
            LogWriter.writeLog("Less than 1 text item on page");
            return null;
        }
        int writingMode = this.getWritingMode(items, count);
        this.createLines(count, items, writingMode, true, false, false, false);
        float[] f_x1 = null;
        float[] f_x2 = null;
        float[] f_y1 = null;
        float[] f_y2 = null;
        if (useUnrotatedCoords || writingMode == 0) {
            f_x1 = this.f_x1;
            f_x2 = this.f_x2;
            f_y1 = this.f_y1;
            f_y2 = this.f_y2;
        } else if (writingMode == 1) {
            f_x2 = this.f_x1;
            f_x1 = this.f_x2;
            f_y1 = this.f_y1;
            f_y2 = this.f_y2;
        } else if (writingMode == 3) {
            f_x1 = this.f_y2;
            f_x2 = this.f_y1;
            f_y1 = this.f_x2;
            f_y2 = this.f_x1;
        } else if (writingMode == 2) {
            f_x1 = this.f_y1;
            f_x2 = this.f_y2;
            f_y2 = this.f_x1;
            f_y1 = this.f_x2;
        }
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < this.content.length; ++i) {
            if (this.content[i] == null) continue;
            if (this.colorExtracted && this.isXMLExtraction) {
                if (!this.content[i].toString().toLowerCase().startsWith("<color ")) {
                    this.content[i].insert(0, this.f_colorTag[this.master]);
                }
                if (!this.content[i].toString().toLowerCase().endsWith("</color>")) {
                    this.content[i].append("</color>");
                }
            }
            if (this.isXMLExtraction) {
                values.add(this.content[i].toString());
            } else {
                values.add(Strip.convertToText(this.content[i].toString(), this.isXMLExtraction));
            }
            if (!useUnrotatedCoords && writingMode == 2) {
                values.add(String.valueOf(f_x1[i]));
                values.add(String.valueOf(f_y1[i]));
                values.add(String.valueOf(f_x2[i]));
                values.add(String.valueOf(f_y2[i]));
                continue;
            }
            if (!useUnrotatedCoords && writingMode == 3) {
                values.add(String.valueOf(f_x1[i]));
                values.add(String.valueOf(f_y2[i]));
                values.add(String.valueOf(f_x2[i]));
                values.add(String.valueOf(f_y1[i]));
                continue;
            }
            values.add(String.valueOf(f_x1[i]));
            values.add(String.valueOf(f_y1[i]));
            values.add(String.valueOf(f_x2[i]));
            values.add(String.valueOf(f_y2[i]));
        }
        LogWriter.writeLog("Text extraction as wordlist completed");
        return values;
    }

    private void reset() {
        this.isXHTML = true;
        this.nextSlot = 0;
        this.lineBreaks = new Vector_Int();
        this.max_rows = 0;
        this.master = 0;
        this.colorExtracted = false;
    }

    public final String extractTextInRectangle(int x1, int y1, int x2, int y2, int page_number, boolean estimateParagraphs, boolean breakFragments) throws PdfException {
        this.reset();
        if (breakFragments && !this.pdf_data.IsEmbedded()) {
            throw new PdfException("[PDF] Request to breakfragments and width not added. Please add call to init(true) of PdfDecoder to your code.");
        }
        int[] v = PdfGroupingAlgorithms.validateCoordinates(x1, y1, x2, y2);
        x1 = v[0];
        y1 = v[1];
        x2 = v[2];
        y2 = v[3];
        if (breakFragments) {
            this.copyToArrays(x1, y2, x2, y1, this.isXMLExtraction, false, false, null, false);
        } else {
            this.copyToArrays();
        }
        this.removeEncoding();
        this.cleanupShadowsAndDrownedObjects(false);
        int[] items = this.getsortedUnusedFragments(true, false);
        int count = items.length;
        if (count == 0) {
            LogWriter.writeLog("Less than 1 text item on page");
            return null;
        }
        int writingMode = this.getWritingMode(items, count);
        this.createLines(count, items, writingMode, false, this.isXMLExtraction, false, false);
        int master = this.mergeLinesTogether(writingMode, estimateParagraphs, x1, x2, y1, y2);
        if (this.isXMLExtraction) {
            this.content[master] = new StringBuilder(Fonts.cleanupTokens(this.content[master].toString()));
            this.content[master].insert(0, "<p>");
            this.content[master].append("</p>");
        }
        LogWriter.writeLog("Text extraction completed");
        return this.cleanup(this.content[master]).toString();
    }

    private StringBuilder cleanup(StringBuilder buffer) {
        if (buffer == null) {
            return buffer;
        }
        if (this.isXMLExtraction) {
            int i;
            String buf = buffer.toString();
            buf = buf.replaceAll("&#", "XX#");
            buf = buf.replaceAll("&lt", "XXlt");
            buf = buf.replaceAll("&gt", "XXgt");
            buf = buf.replaceAll("&", "&amp;");
            buf = buf.replaceAll("XX#", "&#");
            buf = buf.replaceAll("XXlt", "&lt");
            buf = buf.replaceAll("XXgt", "&gt");
            boolean removeInvalidXMLValues = true;
            HashMap<String, String> asciiMappings = new HashMap<String, String>();
            for (i = 1; i <= 8; ++i) {
                asciiMappings.put("&#" + i + ';', "");
            }
            for (i = 11; i <= 12; ++i) {
                asciiMappings.put("&#" + i + ';', "");
            }
            for (i = 14; i <= 31; ++i) {
                asciiMappings.put("&#" + i + ';', "");
            }
            for (Object o : asciiMappings.keySet()) {
                String character = (String)o;
                String mappedCharacter = (String)asciiMappings.get(character);
                buf = buf.replace(character, mappedCharacter);
            }
            buffer = new StringBuilder(buf);
        }
        return buffer;
    }

    private int getWritingMode(int[] items, int count) {
        int[] counts = new int[4];
        for (int j = 0; j < count; ++j) {
            int c = items[j];
            if (this.isUsed[c]) continue;
            int n = this.writingMode[c];
            counts[n] = counts[n] + 1;
        }
        int mode = 0;
        for (int i = 1; i != counts.length; ++i) {
            if (counts[i] <= counts[mode]) continue;
            mode = i;
        }
        return mode;
    }

    private int mergeLinesTogether(int currentWritingMode, boolean estimateParagraphs, int x1, int x2, int y1, int y2) throws PdfException {
        int middlePage;
        int[] indices;
        float[] f_y2;
        float[] f_y1;
        float[] f_x2;
        float[] f_x1;
        if (currentWritingMode == 0) {
            f_x1 = this.f_x1;
            f_x2 = this.f_x2;
            f_y1 = this.f_y1;
            f_y2 = this.f_y2;
            indices = this.getsortedUnusedFragments(false, true);
            middlePage = (x1 + x2) / 2;
        } else if (currentWritingMode == 1) {
            f_x2 = this.f_x1;
            f_x1 = this.f_x2;
            f_y1 = this.f_y1;
            f_y2 = this.f_y2;
            indices = this.getsortedUnusedFragments(false, true);
            middlePage = (x1 + x2) / 2;
        } else if (currentWritingMode == 3) {
            f_x1 = this.f_y1;
            f_x2 = this.f_y2;
            f_y1 = this.f_x2;
            f_y2 = this.f_x1;
            indices = this.getsortedUnusedFragments(true, true);
            indices = PdfGroupingAlgorithms.reverse(indices);
            middlePage = (y1 + y2) / 2;
        } else if (currentWritingMode == 2) {
            f_x1 = this.f_y2;
            f_x2 = this.f_y1;
            f_y2 = this.f_x2;
            f_y1 = this.f_x1;
            indices = this.getsortedUnusedFragments(true, true);
            middlePage = (y1 + y2) / 2;
        } else {
            throw new PdfException("Illegal value " + currentWritingMode + "for currentWritingMode");
        }
        int quarter = middlePage / 2;
        int count = indices.length;
        int master = indices[count - 1];
        boolean debug = false;
        for (int i = count - 2; i > -1; --i) {
            int child = indices[i];
            StringBuilder separator = new StringBuilder();
            int ClastChar = this.getLastChar(this.content[child]);
            if (ClastChar == -1) continue;
            this.addAlignmentFormatting(estimateParagraphs, middlePage, f_x1, f_x2, quarter, child);
            String lineSpace = "</p>" + SystemSeparator + "<p>";
            if (this.isXMLExtraction) {
                lineSpace = SystemSeparator;
            }
            float gap = f_y2[master] - f_y1[child];
            float line_height = f_y1[child] - f_y2[child];
            if (line_height < 1.0f) {
                line_height = f_y1[master] - f_y2[master];
            }
            if (currentWritingMode == 3) {
                gap = -gap;
                line_height = -line_height;
            }
            if (gap > line_height & line_height > 0.0f) {
                while (gap > line_height) {
                    separator.append(lineSpace);
                    gap -= line_height;
                }
                if (this.isXMLExtraction) {
                    separator.append("</p>").append(SystemSeparator).append("<p>");
                } else {
                    separator = new StringBuilder(SystemSeparator);
                }
            } else if (estimateParagraphs) {
                int CFirstChar = this.getFirstChar(this.content[child]);
                int MlastChar = this.getLastChar(this.content[master]);
                if ((MlastChar == 46 || MlastChar == 34) && CFirstChar >= 65 && CFirstChar <= 90) {
                    if (this.isXMLExtraction) {
                        separator.append("</p>").append(SystemSeparator).append("<p>");
                    } else {
                        separator = new StringBuilder(SystemSeparator);
                    }
                } else if (this.fontSize[child] > 70 && this.fontSize[child] == this.fontSize[master] && line_height > 70.0f && gap > 5.0f && line_height > 0.0f) {
                    if (this.isXMLExtraction) {
                        this.content[child].insert(0, ' ');
                    } else {
                        this.content[master].append(' ');
                    }
                }
            } else if (this.isXMLExtraction) {
                this.content[child].insert(0, "</p>" + SystemSeparator + "<p>");
            } else {
                this.content[master].append(SystemSeparator);
            }
            this.merge(master, child, separator.toString(), false);
        }
        return master;
    }

    private int getFirstChar(StringBuilder buffer) {
        int i = -1;
        boolean inTag = false;
        int count = buffer.length();
        int openChar = 32;
        for (int ptr = 0; ptr < count; ++ptr) {
            char nextChar = buffer.charAt(ptr);
            if (!inTag && (nextChar == '<' || this.isXMLExtraction && nextChar == '&')) {
                inTag = true;
                openChar = nextChar;
                if (openChar == 38) {
                    if (ptr + 1 == count) {
                        i = 38;
                        ptr = count;
                    } else {
                        char c = buffer.charAt(ptr + 1);
                        if (c != '#' && c != 'g' && c != 'l') {
                            i = 38;
                            ptr = count;
                        }
                    }
                }
            }
            if (!inTag && nextChar != ' ') {
                i = nextChar;
                ptr = count;
            }
            if (inTag && openChar == 38 && nextChar == ' ') {
                i = openChar;
                ptr = count;
                continue;
            }
            if (!inTag || nextChar != '>' && (!this.isXMLExtraction || openChar != 38 || nextChar != ';')) continue;
            if (nextChar == ';' && openChar == 38 && ptr > 2 && buffer.charAt(ptr - 1) == 't') {
                if (buffer.charAt(ptr - 2) == 'l') {
                    i = 60;
                    ptr = count;
                } else if (buffer.charAt(ptr - 2) == 'g') {
                    i = 62;
                    ptr = count;
                }
            }
            inTag = false;
        }
        return i;
    }

    private int getLastChar(StringBuilder buffer) {
        int i = -1;
        boolean inTag = false;
        int count = buffer.length();
        int size = count--;
        int openChar = 32;
        while (count > -1) {
            char nextChar = buffer.charAt(count);
            if (inTag && openChar == 59 && nextChar == ';') {
                i = 59;
                count = -1;
            }
            if (!inTag && (nextChar == '>' || this.isXMLExtraction && nextChar == ';')) {
                inTag = true;
                int lastTokenStart = buffer.lastIndexOf("</");
                if (lastTokenStart == -1) {
                    inTag = false;
                } else {
                    for (int ptr = lastTokenStart; ptr < count; ++ptr) {
                        char charToTest = buffer.charAt(ptr);
                        if (charToTest != ' ' && charToTest != '>') continue;
                        inTag = false;
                        ptr = count;
                    }
                }
                if (inTag) {
                    openChar = nextChar;
                } else {
                    i = nextChar;
                    count = -1;
                }
            }
            if (!inTag && nextChar != ' ') {
                i = nextChar;
                count = -1;
            }
            if (nextChar == '<' || this.isXMLExtraction && openChar == 59 && nextChar == '&') {
                inTag = false;
                if (nextChar == '&' && count + 3 < size && buffer.charAt(count + 2) == 't' && buffer.charAt(count + 3) == ';') {
                    if (buffer.charAt(count + 1) == 'l') {
                        i = 60;
                        count = -1;
                    } else if (buffer.charAt(count + 1) == 'g') {
                        i = 62;
                        count = -1;
                    }
                }
            }
            if (inTag && openChar == 59 && nextChar == ' ') {
                count = -1;
                i = 59;
            }
            --count;
        }
        return i;
    }

    private static int[] reverse(int[] indices) {
        int count = indices.length;
        int[] newIndex = new int[count];
        for (int i = 0; i < count; ++i) {
            newIndex[i] = indices[count - i - 1];
        }
        return newIndex;
    }

    private void addAlignmentFormatting(boolean estimateParagraphs, int middlePage, float[] f_x1, float[] f_x2, int quarter, int child) {
        float left_gap = (float)middlePage - f_x1[child];
        float right_gap = f_x2[child] - (float)middlePage;
        if (!estimateParagraphs && this.isXMLExtraction && left_gap > 0.0f && right_gap > 0.0f && f_x1[child] > (float)quarter && f_x1[child] < (float)(middlePage + quarter)) {
            float ratio = left_gap / right_gap;
            if (ratio > 1.0f) {
                ratio = 1.0f / ratio;
            }
            if ((double)ratio > 0.95) {
                this.content[child] = new StringBuilder(Fonts.cleanupTokens(this.content[child].toString()));
                this.content[child].insert(0, "<center>");
                this.content[child].append("</center>\n");
            } else if (right_gap < 10.0f & left_gap > 30.0f) {
                this.content[child] = new StringBuilder(Fonts.cleanupTokens(this.content[child].toString()));
                this.content[child].insert(0, "<right>");
                this.content[child].append("</right>\n");
            }
        }
    }

    private void createLinesForSearch(int count, int[] items, int mode, boolean breakOnSpace, boolean addMultiplespaceXMLTag, boolean sameLineOnly, boolean isSearch) throws PdfException {
        float[] f_y2;
        float[] f_y1;
        float[] f_x2;
        float[] f_x1;
        boolean debug = false;
        if (mode == 1 || mode == 2) {
            items = PdfGroupingAlgorithms.reverse(items);
        }
        if (mode == 0) {
            f_x1 = this.f_x1;
            f_x2 = this.f_x2;
            f_y1 = this.f_y1;
            f_y2 = this.f_y2;
        } else if (mode == 1) {
            f_x2 = this.f_x1;
            f_x1 = this.f_x2;
            f_y1 = this.f_y1;
            f_y2 = this.f_y2;
        } else if (mode == 3) {
            f_x1 = this.f_y2;
            f_x2 = this.f_y1;
            f_y1 = this.f_x2;
            f_y2 = this.f_x1;
        } else if (mode == 2) {
            f_x1 = this.f_y2;
            f_x2 = this.f_y1;
            f_y2 = this.f_x1;
            f_y1 = this.f_x2;
        } else {
            throw new PdfException("Illegal value " + mode + "for currentWritingMode");
        }
        block0: for (int j = 0; j < count; ++j) {
            int id = -1;
            int c = items[j];
            if (this.isUsed[c] || this.writingMode[c] != mode) continue;
            for (int j2 = 0; j2 < count && id == -1; ++j2) {
                float distance;
                int i = items[j2];
                if (this.isUsed[i] || c == i || this.writingMode[c] != this.writingMode[i]) continue;
                float mx = f_x1[c] + (f_x2[c] - f_x1[c]) / 2.0f;
                float my = f_y2[c] + (f_y1[c] - f_y2[c]) / 2.0f;
                float cx = f_x1[i] + (f_x2[i] - f_x1[i]) / 2.0f;
                float cy = f_y2[i] + (f_y1[i] - f_y2[i]) / 2.0f;
                float smallestHeight = f_y1[c] - f_y2[c];
                float fontDifference = f_y1[i] - f_y2[i] - smallestHeight;
                if (fontDifference < 0.0f) {
                    smallestHeight = f_y1[i] - f_y2[i];
                }
                if (Math.abs(fontDifference) < smallestHeight * 2.0f && (double)Math.abs(my - cy) < (double)smallestHeight * 0.5 && mx < cx && (distance = f_x1[i] - f_x2[c]) <= smallestHeight / 2.0f) {
                    id = i;
                }
                if (id == -1) continue;
                float possSpace = f_x1[id] - f_x2[c];
                if (mode == 1 || mode == 2) {
                    possSpace = -possSpace;
                }
                String separator = this.isGapASpace(c, id, possSpace, addMultiplespaceXMLTag, mode);
                if (breakOnSpace && this.hadSpace != null && (this.hadSpace[c] || separator.startsWith(" "))) continue block0;
                if (isSearch && i != c && (f_x1[i] > f_x1[c] && mode != 2 || f_x1[i] < f_x1[c] && mode == 2 && this.writingMode[c] == mode) || !isSearch && i != c && (f_x1[i] > f_x1[c] && mode != 2 || f_x1[i] < f_x1[c] && mode == 2 && this.writingMode[c] == mode)) {
                    this.merge(c, id, separator, true);
                }
                id = -1;
            }
        }
    }

    private void createLines(int count, int[] items, int mode, boolean breakOnSpace, boolean addMultiplespaceXMLTag, boolean sameLineOnly, boolean isSearch) throws PdfException {
        float[] f_y2;
        float[] f_y1;
        float[] f_x2;
        float[] f_x1;
        boolean debug = false;
        if (mode == 1 || mode == 2) {
            items = PdfGroupingAlgorithms.reverse(items);
        }
        if (mode == 0) {
            f_x1 = this.f_x1;
            f_x2 = this.f_x2;
            f_y1 = this.f_y1;
            f_y2 = this.f_y2;
        } else if (mode == 1) {
            f_x2 = this.f_x1;
            f_x1 = this.f_x2;
            f_y1 = this.f_y1;
            f_y2 = this.f_y2;
        } else if (mode == 3) {
            f_x1 = this.f_y1;
            f_x2 = this.f_y2;
            f_y1 = this.f_x2;
            f_y2 = this.f_x1;
        } else if (mode == 2) {
            f_x1 = this.f_y2;
            f_x2 = this.f_y1;
            f_y2 = this.f_x1;
            f_y1 = this.f_x2;
        } else {
            throw new PdfException("Illegal value " + mode + "for currentWritingMode");
        }
        block0: for (int j = 0; j < count; ++j) {
            int id = -1;
            int c = items[j];
            float smallest_gap = -1.0f;
            if (this.isUsed[c] || this.writingMode[c] != mode) continue;
            while (true) {
                for (int j2 = 0; j2 < count; ++j2) {
                    float yMidPt;
                    int fontSizeChange;
                    int topLineDifference;
                    int i = items[j2];
                    if (this.isUsed[i]) continue;
                    int baseLineDifference = (int)(f_y2[i] - f_y2[c]);
                    if (baseLineDifference < 0) {
                        baseLineDifference = -baseLineDifference;
                    }
                    if ((topLineDifference = (int)(f_y1[i] - f_y1[c])) < 0) {
                        topLineDifference = -topLineDifference;
                    }
                    int lineGap = (int)(f_x1[i] - f_x2[c]);
                    if (!isSearch && lineGap > (int)(f_x1[c] - f_x2[i])) {
                        lineGap = (int)(f_x1[c] - f_x2[i]);
                    }
                    if ((fontSizeChange = this.fontSize[c] - this.fontSize[i]) < 0) {
                        fontSizeChange = -fontSizeChange;
                    }
                    if (sameLineOnly && lineGap > this.fontSize[c] && lineGap > 0 || sameLineOnly && baseLineDifference > 1 && lineGap > 2 * this.fontSize[c] && this.fontSize[c] == this.fontSize[i] || sameLineOnly && baseLineDifference > 3 || sameLineOnly && fontSizeChange > 2 || !(isSearch && i != c && lineGap <= 2 * this.fontSize[c] && -lineGap <= 2 * this.fontSize[c] && (f_x1[i] > f_x1[c] && mode != 2 || f_x1[i] < f_x1[c] && mode == 2 && this.writingMode[c] == mode && (fontSizeChange <= 2 || fontSizeChange > 2 && topLineDifference < 3))) && (isSearch || i == c || !(f_x1[i] > f_x1[c] && mode != 2) && (!(f_x1[i] < f_x1[c]) || mode != 2 || this.writingMode[c] != mode || fontSizeChange > 2 && (fontSizeChange <= 2 || topLineDifference >= 3)))) continue;
                    float gap = f_x1[i] - f_x2[c];
                    if (mode == 1 || mode == 2) {
                        gap = -gap;
                    }
                    if (gap < 0.0f && gap > -2.0f) {
                        gap = 0.0f;
                    }
                    if (!((yMidPt = (f_y1[i] + f_y2[i]) / 2.0f) < f_y1[c]) || !(yMidPt > f_y2[c]) || !(smallest_gap < 0.0f) && !(gap < smallest_gap)) continue;
                    smallest_gap = gap;
                    id = i;
                }
                if (id == -1) continue block0;
                float possSpace = f_x1[id] - f_x2[c];
                if (mode == 1 || mode == 2) {
                    possSpace = -possSpace;
                } else if (mode == 3) {
                    possSpace = f_x2[id] - f_x1[c];
                }
                String separator = this.isGapASpace(c, id, possSpace, addMultiplespaceXMLTag, mode);
                if (breakOnSpace && this.hadSpace != null && (this.hadSpace[c] || separator.startsWith(" "))) continue block0;
                this.merge(c, id, separator, true);
                id = -1;
                smallest_gap = 1000000.0f;
            }
        }
    }

    public SortedMap findMultipleTermsInRectangleWithMatchingTeasers(int x1, int y1, int x2, int y2, int rotation, int page_number, String[] terms, int searchType, SearchListener listener) throws PdfException {
        this.usingMultipleTerms = true;
        this.multipleTermTeasers.clear();
        this.teasers = null;
        boolean origIncludeTease = this.includeTease;
        this.includeTease = true;
        List highlights = this.findMultipleTermsInRectangle(x1, y1, x2, y2, page_number, terms, searchType, listener);
        TreeMap highlightsWithTeasers = new TreeMap(new ResultsComparatorRectangle(rotation));
        for (int i = 0; i < highlights.size(); ++i) {
            highlightsWithTeasers.put(highlights.get(i), this.multipleTermTeasers.get(i));
        }
        this.usingMultipleTerms = false;
        this.includeTease = origIncludeTease;
        return highlightsWithTeasers;
    }

    public SortedMap findTextWithinInAreaWithTeasers(int x1, int y1, int x2, int y2, int rotation, int page_number, String[] terms, int searchType, SearchListener listener) throws PdfException {
        this.usingMultipleTerms = true;
        this.multipleTermTeasers.clear();
        this.teasers = null;
        boolean origIncludeTease = this.includeTease;
        this.includeTease = true;
        List highlights = this.findTextWithinArea(x1, y1, x2, y2, terms, searchType, listener);
        TreeMap highlightsWithTeasers = new TreeMap(new ResultsComparator(rotation));
        for (int i = 0; i < highlights.size(); ++i) {
            highlightsWithTeasers.put(highlights.get(i), this.multipleTermTeasers.get(i));
        }
        this.usingMultipleTerms = false;
        this.includeTease = origIncludeTease;
        return highlightsWithTeasers;
    }

    public List findMultipleTermsInRectangle(int x1, int y1, int x2, int y2, int rotation, int page_number, String[] terms, boolean orderResults, int searchType, SearchListener listener) throws PdfException {
        this.usingMultipleTerms = true;
        this.multipleTermTeasers.clear();
        this.teasers = null;
        List highlights = this.findMultipleTermsInRectangle(x1, y1, x2, y2, page_number, terms, searchType, listener);
        if (orderResults) {
            Collections.sort(highlights, new ResultsComparator(rotation));
        }
        this.usingMultipleTerms = false;
        return highlights;
    }

    private List findMultipleTermsInRectangle(int x1, int y1, int x2, int y2, int page_number, String[] terms, int searchType, SearchListener listener) throws PdfException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (String term : terms) {
            if (listener != null && listener.isCanceled()) break;
            float[] co_ords = this.findText(x1, y1, x2, y2, new String[]{term}, searchType);
            if (co_ords == null) continue;
            int count = co_ords.length;
            for (int ii = 0; ii < count; ii += 5) {
                int wx1 = (int)co_ords[ii];
                int wy1 = (int)co_ords[ii + 1];
                int wx2 = (int)co_ords[ii + 2];
                int wy2 = (int)co_ords[ii + 3];
                Rectangle rectangle = new Rectangle(wx1, wy2, wx2 - wx1, wy1 - wy2);
                int seperator = (int)co_ords[ii + 4];
                if (seperator == -101) {
                    Vector_Rectangle vr = new Vector_Rectangle();
                    vr.addElement(rectangle);
                    while (seperator == -101) {
                        wx1 = (int)co_ords[ii += 5];
                        wy1 = (int)co_ords[ii + 1];
                        wx2 = (int)co_ords[ii + 2];
                        wy2 = (int)co_ords[ii + 3];
                        seperator = (int)co_ords[ii + 4];
                        rectangle = new Rectangle(wx1, wy2, wx2 - wx1, wy1 - wy2);
                        vr.addElement(rectangle);
                    }
                    vr.trim();
                    list.add(vr.get());
                    continue;
                }
                list.add(rectangle);
            }
        }
        return list;
    }

    private List findTextWithinArea(int x1, int y1, int x2, int y2, String[] terms, int searchType, SearchListener listener) throws PdfException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (String term : terms) {
            if (listener != null && listener.isCanceled()) break;
            float[] co_ords = this.findText(x1, y1, x2, y2, new String[]{term}, searchType);
            if (co_ords == null) continue;
            int count = co_ords.length;
            for (int ii = 0; ii < count; ii += 5) {
                int wx1 = (int)co_ords[ii];
                int wy1 = (int)co_ords[ii + 1];
                int wx2 = (int)co_ords[ii + 2];
                int wy2 = (int)co_ords[ii + 3];
                int[] rectangle = new int[]{wx1, wy2, wx2 - wx1, wy1 - wy2};
                int seperator = (int)co_ords[ii + 4];
                if (seperator == -101) {
                    Vector_Rectangle_Int vr = new Vector_Rectangle_Int();
                    vr.addElement(rectangle);
                    while (seperator == -101) {
                        wx1 = (int)co_ords[ii += 5];
                        wy1 = (int)co_ords[ii + 1];
                        wx2 = (int)co_ords[ii + 2];
                        wy2 = (int)co_ords[ii + 3];
                        seperator = (int)co_ords[ii + 4];
                        rectangle = new int[]{wx1, wy2, wx2 - wx1, wy1 - wy2};
                        vr.addElement(rectangle);
                    }
                    vr.trim();
                    list.add(vr.get());
                    continue;
                }
                list.add(rectangle);
            }
        }
        return list;
    }

    public final float[] findText(int x1, int y1, int x2, int y2, String[] terms, int searchType) throws PdfException {
        if (terms == null) {
            return new float[0];
        }
        Vector_Float resultCoords = new Vector_Float(0);
        Vector_String resultTeasers = new Vector_String(0);
        int[] v = PdfGroupingAlgorithms.validateCoordinates(x1, y1, x2, y2);
        x1 = v[0];
        y1 = v[1];
        x2 = v[2];
        y2 = v[3];
        this.copyToArraysPartial(x1, y2, x2, y1);
        this.cleanupShadowsAndDrownedObjects(false);
        int[] items = this.getsortedUnusedFragments(true, false);
        int[] unsorted = this.getWritingModeCounts(items);
        int[] writingModes = PdfGroupingAlgorithms.getWritingModeOrder(unsorted);
        for (int u = 0; u != writingModes.length; ++u) {
            int mode = writingModes[u];
            if (unsorted[mode] == 0) continue;
            this.searchWritingMode(items, mode, searchType, terms, resultCoords, resultTeasers);
        }
        return resultCoords.get();
    }

    public final float[] findText(Rectangle searchArea, int page_number, String[] terms, int searchType) throws PdfException {
        return this.findText(searchArea.x, searchArea.y, searchArea.x + searchArea.width, searchArea.y + searchArea.height, terms, searchType);
    }

    public final float[] findText(String[] terms, int searchType) throws PdfException {
        if (terms == null) {
            return new float[0];
        }
        Vector_Float resultCoords = new Vector_Float(0);
        Vector_String resultTeasers = new Vector_String(0);
        this.copyToArrays();
        this.cleanupShadowsAndDrownedObjects(false);
        int[] items = this.getsortedUnusedFragments(true, false);
        int[] unsorted = this.getWritingModeCounts(items);
        int[] writingModes = PdfGroupingAlgorithms.getWritingModeOrder(unsorted);
        for (int u = 0; u != writingModes.length; ++u) {
            int mode = writingModes[u];
            if (unsorted[mode] == 0) continue;
            this.searchWritingMode(items, mode, searchType, terms, resultCoords, resultTeasers);
        }
        return resultCoords.get();
    }

    private static String removeDuplicateSpaces(String textValue) {
        if (textValue.contains("  ")) {
            textValue = textValue.replace("  ", " ");
        }
        return textValue;
    }

    public String[] getTeasers() {
        return this.teasers;
    }

    public void generateTeasers() {
        this.includeTease = true;
    }

    private static int loadSearcherOptions(int searchType) {
        int options = 0;
        if ((searchType & 2) != 2) {
            options |= 2;
        }
        if ((searchType & 8) == 8) {
            options = options | 8 | 0x20;
        }
        return options;
    }

    private int[] getWritingModeCounts(int[] items) {
        int l2r = 0;
        int r2l = 0;
        int t2b = 0;
        int b2t = 0;
        block6: for (int i = 0; i != items.length; ++i) {
            switch (this.writingMode[items[i]]) {
                case 0: {
                    ++l2r;
                    continue block6;
                }
                case 1: {
                    ++r2l;
                    continue block6;
                }
                case 2: {
                    ++t2b;
                    continue block6;
                }
                case 3: {
                    ++b2t;
                }
            }
        }
        return new int[]{l2r, r2l, t2b, b2t};
    }

    private static int[] getWritingModeOrder(int[] unsorted) {
        int[] sorted = new int[]{unsorted[0], unsorted[1], unsorted[2], unsorted[3]};
        int[] writingModes = new int[]{-1, -1, -1, -1};
        Arrays.sort(sorted);
        for (int i = 0; i != unsorted.length; ++i) {
            for (int j = 0; j < sorted.length; ++j) {
                if (unsorted[i] != sorted[j]) continue;
                int pos = j - 3;
                if (pos < 0) {
                    pos = -pos;
                }
                if (writingModes[pos] != -1) continue;
                writingModes[pos] = i;
                j = sorted.length;
            }
        }
        return writingModes;
    }

    private static String alterStringTooDisplayOrder(String testTerm) {
        String currentBlock = "";
        String searchValue = "";
        byte lastDirection = Character.getDirectionality(testTerm.charAt(0));
        for (int i = 0; i != testTerm.length(); ++i) {
            byte dir = Character.getDirectionality(testTerm.charAt(i));
            switch (dir) {
                case 1: 
                case 2: 
                case 16: 
                case 17: {
                    dir = 1;
                    break;
                }
                case 0: 
                case 14: 
                case 15: {
                    dir = 0;
                    break;
                }
                default: {
                    dir = lastDirection;
                }
            }
            if (dir != lastDirection) {
                searchValue = searchValue + currentBlock;
                currentBlock = "";
                lastDirection = dir;
            }
            currentBlock = dir == 1 ? testTerm.charAt(i) + currentBlock : currentBlock + testTerm.charAt(i);
        }
        searchValue = searchValue + currentBlock;
        return searchValue;
    }

    private void searchWritingMode(int[] items, int mode, int searchType, String[] terms, Vector_Float resultCoords, Vector_String resultTeasers) throws PdfException {
        boolean firstOccuranceOnly = false;
        boolean wholeWordsOnly = false;
        boolean foundFirst = false;
        boolean useRegEx = false;
        this.createLinesForSearch(items.length, items, mode, true, false, true, true);
        int options = PdfGroupingAlgorithms.loadSearcherOptions(searchType);
        if ((searchType & 4) == 4) {
            firstOccuranceOnly = true;
        }
        if ((searchType & 1) == 1) {
            wholeWordsOnly = true;
        }
        if ((searchType & 0x20) == 32) {
            useRegEx = true;
        }
        boolean valuesSwapped = mode == 3 || mode == 2;
        String searchText = this.buildSearchText(false, mode);
        String coordsText = this.buildSearchText(true, mode);
        for (int j = 0; j != terms.length; ++j) {
            String searchValue = PdfGroupingAlgorithms.alterStringTooDisplayOrder(terms[j]);
            String sep = " ";
            if ((searchType & 8) == 8) {
                sep = "[ \\\\n]+";
            }
            if (!useRegEx) {
                searchValue = "\\Q" + searchValue + "\\E";
                sep = "\\\\E" + sep + "\\\\Q";
            }
            if (!sep.equals(" ")) {
                searchValue = searchValue.replaceAll(" ", sep);
            }
            if (wholeWordsOnly) {
                searchValue = "\\b" + searchValue + "\\b";
            }
            Pattern searchTerm = Pattern.compile(searchValue, options);
            Pattern teaserTerm = Pattern.compile("(?:\\S+\\s)?\\S*(?:\\S+\\s)?\\S*" + searchValue + "\\S*(?:\\s\\S+)?\\S*(?:\\s\\S+)?", options);
            if (searchText == null) continue;
            Matcher termFinder = searchTerm.matcher(searchText);
            Matcher teaserFinder = teaserTerm.matcher(searchText);
            boolean needToFindTeaser = true;
            while (termFinder.find()) {
                int[] resultStart = null;
                String foundTerm = termFinder.group();
                int termStarts = termFinder.start();
                int termEnds = termFinder.end() - 1;
                if (this.includeTease) {
                    if (this.includeHTMLtags) {
                        foundTerm = "<b>" + foundTerm + "</b>";
                    }
                    if (needToFindTeaser) {
                        this.findTeaser(foundTerm, teaserFinder, termStarts, termEnds, resultTeasers);
                    }
                }
                this.getResultCoords(coordsText, mode, resultStart, termStarts, termEnds, valuesSwapped, resultCoords);
                if (!firstOccuranceOnly) continue;
                foundFirst = true;
                break;
            }
            if (firstOccuranceOnly && foundFirst) break;
        }
        resultCoords.trim();
        if (this.includeTease) {
            this.storeTeasers(resultTeasers);
        }
    }

    private String buildSearchText(boolean includeCoords, int mode) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i != this.content.length; ++i) {
            if (this.content[i] == null || mode != this.writingMode[i]) continue;
            str.append((CharSequence)this.content[i]).append('\n');
        }
        String searchText = PdfGroupingAlgorithms.removeDuplicateSpaces(str.toString());
        if (!includeCoords) {
            searchText = PdfGroupingAlgorithms.removeHiddenMarkers(searchText);
        }
        searchText = Strip.stripXML(searchText, this.isXMLExtraction).toString();
        return searchText;
    }

    private void getResultCoords(String coordText, int mode, int[] resultStart, int termStarts, int termEnds, boolean valuesSwapped, Vector_Float resultCoords) {
        int pointInLine = -1;
        int lineCounter = 0;
        while (this.content[lineCounter] == null || mode != this.writingMode[lineCounter]) {
            ++lineCounter;
        }
        boolean startFound = false;
        boolean endFound = false;
        for (int pointer = 1; pointer < coordText.length(); ++pointer) {
            int currentY;
            int startPointer = pointer;
            while (pointer < coordText.length() && coordText.charAt(pointer) != MARKER2) {
                ++pointer;
            }
            float currentX = Float.parseFloat(coordText.substring(startPointer, pointer));
            startPointer = ++pointer;
            while (pointer < coordText.length() && coordText.charAt(pointer) != MARKER2) {
                ++pointer;
            }
            float width = Float.parseFloat(coordText.substring(startPointer, pointer));
            startPointer = ++pointer;
            while (pointer < coordText.length() && coordText.charAt(pointer) != MARKER2) {
                ++pointer;
            }
            String text = coordText.substring(startPointer, pointer);
            if (!startFound && (pointInLine += text.length()) >= termStarts) {
                currentY = (int)this.f_y1[lineCounter];
                if (valuesSwapped) {
                    currentY = (int)this.f_x2[lineCounter];
                }
                resultStart = new int[]{(int)currentX, currentY};
                startFound = true;
            }
            if (!endFound && pointInLine >= termEnds) {
                currentY = (int)this.f_y2[lineCounter];
                if (valuesSwapped) {
                    currentY = (int)this.f_x1[lineCounter];
                }
                PdfGroupingAlgorithms.storeResultsCoords(valuesSwapped, mode, resultCoords, resultStart[0], resultStart[1], currentX + width, currentY, 0.0f);
                endFound = true;
            }
            if (startFound && !endFound && text.contains("\n")) {
                PdfGroupingAlgorithms.storeResultsCoords(valuesSwapped, mode, resultCoords, resultStart[0], resultStart[1], currentX + width, this.f_y2[lineCounter], -101.0f);
                startFound = false;
                termStarts = pointInLine;
            }
            if (!text.contains("\n")) continue;
            ++lineCounter;
            while (lineCounter < this.content.length && (this.content[lineCounter] == null || mode != this.writingMode[lineCounter])) {
                ++lineCounter;
            }
        }
    }

    private void storeTeasers(Vector_String resultTeasers) {
        resultTeasers.trim();
        if (this.usingMultipleTerms) {
            for (int i = 0; i != resultTeasers.size(); ++i) {
                this.multipleTermTeasers.add(resultTeasers.elementAt(i));
            }
            resultTeasers.clear();
        } else {
            this.teasers = resultTeasers.get();
        }
    }

    private static void storeResultsCoords(boolean valuesSwapped, int mode, Vector_Float resultCoords, float x1, float y1, float x2, float y2, float connected) {
        if (valuesSwapped) {
            if (mode == 3) {
                resultCoords.addElement(y2);
                resultCoords.addElement(x2);
                resultCoords.addElement(y1);
                resultCoords.addElement(x1);
                resultCoords.addElement(connected);
            } else {
                resultCoords.addElement(y2);
                resultCoords.addElement(x1);
                resultCoords.addElement(y1);
                resultCoords.addElement(x2);
                resultCoords.addElement(connected);
            }
        } else {
            resultCoords.addElement(x1);
            resultCoords.addElement(y1);
            resultCoords.addElement(x2);
            resultCoords.addElement(y2);
            resultCoords.addElement(connected);
        }
    }

    private void findTeaser(String teaser, Matcher teaserFinder, int termStarts, int termEnds, Vector_String resultTeasers) {
        if (teaserFinder.find() && teaserFinder.start() < termStarts && teaserFinder.end() > termEnds) {
            teaser = teaserFinder.group();
            if (this.includeHTMLtags) {
                int teaseStarts = termStarts - teaserFinder.start();
                int teaseEnds = termEnds - teaserFinder.start() + 1;
                teaser = teaser.substring(0, teaseStarts) + "<b>" + teaser.substring(teaseStarts, teaseEnds) + "</b>" + teaser.substring(teaseEnds, teaser.length());
            }
        }
        resultTeasers.addElement(teaser);
    }

    private class Fragment {
        float x1;
        float y1;
        float x2;
        float y2;
        float character_spacing;
        String raw;
        String currentColor;
        int text_length;
        int mode;

        Fragment(PdfData pdf_data, int index) {
            this.loadData(pdf_data, index);
        }

        public void loadData(PdfData pdf_data, int index) {
            this.character_spacing = pdf_data.f_character_spacing[index];
            this.x1 = pdf_data.f_x1[index];
            this.x2 = pdf_data.f_x2[index];
            this.y1 = pdf_data.f_y1[index];
            this.y2 = pdf_data.f_y2[index];
            this.currentColor = pdf_data.colorTag[index];
            this.text_length = pdf_data.text_length[index];
            this.mode = pdf_data.f_writingMode[index];
            this.raw = pdf_data.contents[index];
        }

        public float getX1() {
            return this.x1;
        }

        public float getY1() {
            return this.y1;
        }

        public float getX2() {
            return this.x2;
        }

        public float getY2() {
            return this.y2;
        }

        public float getCharacterSpacing() {
            return this.character_spacing;
        }

        public String getRawData() {
            return this.raw;
        }

        public String getColorTag() {
            return this.currentColor;
        }

        public int getWritingMode() {
            return this.mode;
        }

        public int getTextLength() {
            return this.text_length;
        }

        public void setX1(float value) {
            this.x1 = value;
        }

        public void setY1(float value) {
            this.y1 = value;
        }

        public void setX2(float value) {
            this.x2 = value;
        }

        public void setY2(float value) {
            this.y2 = value;
        }
    }

    static class ResultsComparator
    implements Comparator {
        private final int rotation;

        ResultsComparator(int rotation) {
            this.rotation = rotation;
        }

        public int compare(Object o1, Object o2) {
            Object ra1 = o1 instanceof int[][] ? (int[][])o1 : (Object)new int[][]{(int[])o1};
            Object ra2 = o2 instanceof int[][] ? (int[][])o2 : (Object)new int[][]{(int[])o2};
            for (int i = 0; i != ((int[][])ra1).length; ++i) {
                for (int j = 0; j != ((int[][])ra2).length; ++j) {
                    int[] r1 = ra1[i];
                    int[] r2 = ra2[j];
                    switch (this.rotation) {
                        case 0: {
                            if (r1[1] == r2[1]) {
                                if (r1[0] > r2[0]) {
                                    return 1;
                                }
                                return -1;
                            }
                            if (r1[1] > r2[1]) {
                                return -1;
                            }
                            return 1;
                        }
                        case 90: {
                            if (r1[0] == r2[0]) {
                                if (r1[1] > r2[1]) {
                                    return 1;
                                }
                                return -1;
                            }
                            if (r1[0] > r2[0]) {
                                return 1;
                            }
                            return -1;
                        }
                        case 180: {
                            if (r1[1] == r2[1]) {
                                if (r1[0] > r2[0]) {
                                    return 1;
                                }
                                return -1;
                            }
                            if (r1[1] > r2[1]) {
                                return -1;
                            }
                            return 1;
                        }
                        case 270: {
                            if (r1[0] == r2[0]) {
                                if (r1[1] > r2[1]) {
                                    return 1;
                                }
                                return -1;
                            }
                            if (r1[0] < r2[0]) {
                                return 1;
                            }
                            return -1;
                        }
                    }
                }
            }
            return -1;
        }
    }

    static class ResultsComparatorRectangle
    implements Comparator {
        private final int rotation;

        ResultsComparatorRectangle(int rotation) {
            this.rotation = rotation;
        }

        public int compare(Object o1, Object o2) {
            Rectangle ra1 = o1 instanceof Rectangle[] ? ((Rectangle[])o1)[0] : (Rectangle)o1;
            Rectangle ra2 = o2 instanceof Rectangle[] ? ((Rectangle[])o2)[0] : (Rectangle)o2;
            if (this.rotation == 0 || this.rotation == 180) {
                if (ra1.y == ra2.y) {
                    if (ra1.x > ra2.x) {
                        return 1;
                    }
                    return -1;
                }
                if (ra1.y > ra2.y) {
                    return -1;
                }
                return 1;
            }
            if (ra1.x == ra2.x) {
                if (ra1.y > ra2.y) {
                    return 1;
                }
                return -1;
            }
            if (ra1.x > ra2.x) {
                return 1;
            }
            return -1;
        }
    }
}

