/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.images;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import org.jpedal.color.ColorSpaces;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.GraphicsState;
import org.jpedal.render.BaseDisplay;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Matrix;

public class ImageTransformerDouble {
    private static final boolean debug = false;
    double ny;
    double nx;
    private Area clip;
    private BufferedImage current_image;
    private final float[][] CTM;
    private float[][] Trm;
    private float[][] Trm1;
    private float[][] Trm2;
    private int i_x;
    private int i_y;
    private int i_w;
    private int i_h;
    private final boolean scaleImage;
    private boolean hasClip;
    float scaling = 1.0f;
    final int pageRotation;

    public ImageTransformerDouble(GraphicsState currentGS, BufferedImage new_image, boolean scaleImage, float scaling, int pageRotation) {
        this.current_image = new_image;
        this.scaleImage = scaleImage;
        this.scaling = scaling;
        this.pageRotation = pageRotation;
        this.CTM = currentGS.CTM;
        this.createMatrices();
        if (currentGS.getClippingShape() != null) {
            this.clip = (Area)currentGS.getClippingShape().clone();
        }
        this.calcCoordinates();
    }

    public final void doubleScaleTransformShear() {
        this.scale(this.Trm1);
        if (this.clip != null) {
            Area final_clip = (Area)this.clip.clone();
            Area unscaled_clip = this.getUnscaledClip((Area)this.clip.clone());
            int segCount = BaseDisplay.isRectangle(final_clip);
            this.clipImage(unscaled_clip, final_clip, segCount);
            this.i_x = (int)this.clip.getBounds2D().getMinX();
            this.i_y = (int)this.clip.getBounds2D().getMinY();
            this.i_w = (int)(this.clip.getBounds2D().getMaxX() - (double)this.i_x);
            this.i_h = (int)(this.clip.getBounds2D().getMaxY() - (double)this.i_y);
        } else if (this.current_image.getType() != 10) {
            this.current_image = ColorSpaceConvertor.convertToARGB(this.current_image);
        }
    }

    public final void doubleScaleTransformScale() {
        if ((double)this.CTM[0][0] != 0.0 & (double)this.CTM[1][1] != 0.0) {
            this.scale(this.Trm2);
        }
    }

    public final void completeImage() {
        if (this.hasClip) {
            this.i_x = (int)this.clip.getBounds2D().getMinX();
            this.i_y = (int)this.clip.getBounds2D().getMinY();
            this.i_w = this.current_image.getWidth();
            this.i_h = this.current_image.getHeight();
        }
    }

    private void scale(float[][] Trm) {
        if ((double)Trm[0][0] != 1.0 || (double)Trm[1][1] != 1.0 || (double)Trm[0][1] != 0.0 || (double)Trm[1][0] != 0.0) {
            int w = this.current_image.getWidth();
            int h = this.current_image.getHeight();
            AffineTransform image_at = new AffineTransform(Trm[0][0], -Trm[0][1], -Trm[1][0], Trm[1][1], 0.0f, 0.0f);
            Area r = new Area(new Rectangle(0, 0, w, h));
            r.transform(image_at);
            this.ny = r.getBounds2D().getY();
            this.nx = r.getBounds2D().getX();
            image_at = new AffineTransform((double)Trm[0][0], (double)(-Trm[0][1]), (double)(-Trm[1][0]), (double)Trm[1][1], -this.nx, -this.ny);
            AffineTransformOp invert = w > 10 & h > 10 ? new AffineTransformOp(image_at, ColorSpaces.hints) : new AffineTransformOp(image_at, null);
            if (this.scaleImage) {
                if (h == 1 && Trm[0][0] == 0.0f && Trm[0][1] > 0.0f && Trm[1][0] < 0.0f && Trm[1][1] == 0.0f) {
                    BufferedImage newImage = new BufferedImage(h, w, 2);
                    for (int i = 0; i < w; ++i) {
                        int col = this.current_image.getRGB(i, 0);
                        newImage.setRGB(0, w - 1 - i, col);
                    }
                    this.current_image = newImage;
                } else {
                    this.current_image = invert.filter(this.current_image, null);
                }
            }
        }
    }

    private void createMatrices() {
        int x;
        int y;
        float y2;
        float y1;
        float x2;
        int w = (int)((float)this.current_image.getWidth() / this.scaling);
        int h = (int)((float)this.current_image.getHeight() / this.scaling);
        this.Trm = new float[3][3];
        this.Trm[0][0] = this.CTM[0][0] / (float)w;
        this.Trm[0][1] = this.CTM[0][1] / (float)w;
        this.Trm[0][2] = 0.0f;
        this.Trm[1][0] = this.CTM[1][0] / (float)h;
        this.Trm[1][1] = this.CTM[1][1] / (float)h;
        this.Trm[1][2] = 0.0f;
        this.Trm[2][0] = this.CTM[2][0];
        this.Trm[2][1] = this.CTM[2][1];
        this.Trm[2][2] = 1.0f;
        for (int y3 = 0; y3 < 3; ++y3) {
            for (int x3 = 0; x3 < 3; ++x3) {
                if (!((double)this.Trm[x3][y3] > 0.99 & this.Trm[x3][y3] < 1.0f)) continue;
                this.Trm[x3][y3] = 1.0f;
            }
        }
        this.Trm1 = new float[3][3];
        this.Trm2 = new float[3][3];
        float x1 = this.CTM[0][0];
        if (x1 < 0.0f) {
            x1 = -x1;
        }
        if ((x2 = this.CTM[0][1]) < 0.0f) {
            x2 = -x2;
        }
        if ((y1 = this.CTM[1][1]) < 0.0f) {
            y1 = -y1;
        }
        if ((y2 = this.CTM[1][0]) < 0.0f) {
            y2 = -y2;
        }
        if ((double)this.CTM[0][0] == 0.0 || (double)this.CTM[1][1] == 0.0) {
            this.Trm1 = this.Trm;
        } else if ((double)this.CTM[0][1] == 0.0 && (double)this.CTM[1][0] == 0.0) {
            this.Trm1[0][0] = (float)w / this.CTM[0][0];
            this.Trm1[0][1] = 0.0f;
            this.Trm1[0][2] = 0.0f;
            this.Trm1[1][0] = 0.0f;
            this.Trm1[1][1] = (float)h / this.CTM[1][1];
            this.Trm1[1][2] = 0.0f;
            this.Trm1[2][0] = 0.0f;
            this.Trm1[2][1] = 0.0f;
            this.Trm1[2][2] = 1.0f;
            this.Trm1 = Matrix.multiply(this.Trm, this.Trm1);
            for (y = 0; y < 3; ++y) {
                for (x = 0; x < 3; ++x) {
                    if (!((double)this.Trm1[x][y] > 0.99 & this.Trm1[x][y] < 1.0f)) continue;
                    this.Trm1[x][y] = 1.0f;
                }
            }
            if (this.Trm1[2][0] < 0.0f && this.Trm1[0][0] > 0.0f && this.CTM[0][0] < 0.0f) {
                this.Trm1[2][0] = 0.0f;
                this.Trm1[0][0] = -1.0f;
            }
            if (this.Trm1[2][1] < 0.0f && this.Trm1[1][1] > 0.0f && this.CTM[1][1] < 0.0f && this.CTM[0][0] < 0.0f) {
                this.Trm1[2][1] = 0.0f;
                this.Trm1[1][1] = -1.0f;
            }
        } else {
            this.Trm1[0][0] = x1 > x2 ? (float)w / this.CTM[0][0] : (float)w / this.CTM[0][1];
            if (this.Trm1[0][0] < 0.0f) {
                this.Trm1[0][0] = -this.Trm1[0][0];
            }
            this.Trm1[0][1] = 0.0f;
            this.Trm1[0][2] = 0.0f;
            this.Trm1[1][0] = 0.0f;
            this.Trm1[1][1] = y1 > y2 ? (float)h / this.CTM[1][1] : (float)h / this.CTM[1][0];
            if (this.Trm1[1][1] < 0.0f) {
                this.Trm1[1][1] = -this.Trm1[1][1];
            }
            this.Trm1[1][2] = 0.0f;
            this.Trm1[2][0] = 0.0f;
            this.Trm1[2][1] = 0.0f;
            this.Trm1[2][2] = 1.0f;
            this.Trm1 = Matrix.multiply(this.Trm, this.Trm1);
            for (y = 0; y < 3; ++y) {
                for (x = 0; x < 3; ++x) {
                    if (!((double)this.Trm1[x][y] > 0.99 & this.Trm1[x][y] < 1.0f)) continue;
                    this.Trm1[x][y] = 1.0f;
                }
            }
        }
        this.Trm2[0][0] = x1 > x2 ? this.CTM[0][0] / (float)w : this.CTM[0][1] / (float)w;
        if (this.Trm2[0][0] < 0.0f) {
            this.Trm2[0][0] = -this.Trm2[0][0];
        }
        this.Trm2[0][1] = 0.0f;
        this.Trm2[0][2] = 0.0f;
        this.Trm2[1][0] = 0.0f;
        this.Trm2[1][1] = y1 > y2 ? this.CTM[1][1] / (float)h : this.CTM[1][0] / (float)h;
        if (this.Trm2[1][1] < 0.0f) {
            this.Trm2[1][1] = -this.Trm2[1][1];
        }
        this.Trm2[1][2] = 0.0f;
        this.Trm2[2][0] = 0.0f;
        this.Trm2[2][1] = 0.0f;
        this.Trm2[2][2] = 1.0f;
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 3; ++x) {
                if (!((double)this.Trm2[x][y] > 0.99 & this.Trm2[x][y] < 1.0f)) continue;
                this.Trm2[x][y] = 1.0f;
            }
        }
    }

    private void calcCoordinates() {
        if (this.CTM[1][0] == 0.0f & this.CTM[0][1] == 0.0f) {
            this.i_x = (int)this.CTM[2][0];
            this.i_y = (int)this.CTM[2][1];
            this.i_w = (int)this.CTM[0][0];
            this.i_h = (int)this.CTM[1][1];
            if (this.i_w < 0) {
                this.i_w = -this.i_w;
            }
            if (this.i_h < 0) {
                this.i_h = -this.i_h;
            }
        } else {
            this.i_w = (int)Math.sqrt(this.CTM[0][0] * this.CTM[0][0] + this.CTM[0][1] * this.CTM[0][1]);
            this.i_h = (int)Math.sqrt(this.CTM[1][1] * this.CTM[1][1] + this.CTM[1][0] * this.CTM[1][0]);
            if (this.CTM[1][0] > 0.0f & this.CTM[0][1] < 0.0f) {
                this.i_x = (int)this.CTM[2][0];
                this.i_y = (int)(this.CTM[2][1] + this.CTM[0][1]);
            } else if (this.CTM[1][0] < 0.0f & this.CTM[0][1] > 0.0f) {
                this.i_x = (int)(this.CTM[2][0] + this.CTM[1][0]);
                this.i_y = (int)this.CTM[2][1];
            } else if (this.CTM[1][0] > 0.0f & this.CTM[0][1] > 0.0f) {
                this.i_x = (int)this.CTM[2][0];
                this.i_y = (int)this.CTM[2][1];
            } else {
                this.i_x = (int)this.CTM[2][0];
                this.i_y = (int)this.CTM[2][1];
            }
        }
        if (this.CTM[1][1] < 0.0f) {
            this.i_y -= this.i_h;
        }
        if (this.CTM[0][0] < 0.0f) {
            this.i_x -= this.i_w;
        }
    }

    public final int getImageY() {
        return this.i_y;
    }

    public final BufferedImage getImage() {
        return this.current_image;
    }

    public final int getImageW() {
        return this.i_w;
    }

    public final int getImageH() {
        return this.i_h;
    }

    public final int getImageX() {
        return this.i_x;
    }

    private void clipImage(Area final_clip, Area unscaled_clip, int segCount) {
        double shape_x = unscaled_clip.getBounds2D().getX();
        double shape_y = unscaled_clip.getBounds2D().getY();
        int image_w = this.current_image.getWidth();
        int image_h = this.current_image.getHeight();
        int x = (int)final_clip.getBounds().getX();
        int y = (int)final_clip.getBounds().getY();
        int w = (int)final_clip.getBounds().getWidth();
        int h = (int)final_clip.getBounds().getHeight();
        if (segCount > 5) {
            AffineTransform image_at = new AffineTransform();
            image_at.scale(1.0, -1.0);
            image_at.translate(0.0, -this.current_image.getHeight());
            AffineTransformOp invert = new AffineTransformOp(image_at, ColorSpaces.hints);
            this.current_image = invert.filter(this.current_image, null);
            Area inverseClip = new Area(new Rectangle(0, 0, image_w, image_h));
            inverseClip.exclusiveOr(final_clip);
            this.current_image = ColorSpaceConvertor.convertToARGB(this.current_image);
            Graphics2D image_g2 = this.current_image.createGraphics();
            image_g2.setComposite(AlphaComposite.Clear);
            image_g2.fill(inverseClip);
            AffineTransform image_at2 = new AffineTransform();
            image_at2.scale(1.0, -1.0);
            image_at2.translate(0.0, -this.current_image.getHeight());
            AffineTransformOp invert3 = new AffineTransformOp(image_at2, ColorSpaces.hints);
            this.current_image = invert3.filter(this.current_image, null);
        }
        if (!(this.CTM[1][1] < 0.0f) || this.pageRotation != 0 || !(this.CTM[0][0] > 0.0f) || this.CTM[1][0] != 0.0f || this.CTM[0][1] != 0.0f) {
            y = image_h - h - y;
        }
        if (y < 0) {
            y = 0;
        }
        if (x < 0) {
            w -= x;
            x = 0;
        }
        if (w > image_w) {
            w = image_w;
        }
        if (h > image_h) {
            h = image_h;
        }
        if (y + h > image_h) {
            h = image_h - y;
        }
        if (x + w > image_w) {
            w = image_w - x;
        }
        if (!(h < 1 || w < 1 || x == 0 && y == 0 && w == this.current_image.getWidth() && h == this.current_image.getHeight() || this.CTM[1][1] == 0.0f && this.pageRotation == 0 && this.CTM[0][0] == 0.0f && this.CTM[1][0] < 0.0f && this.CTM[0][1] > 0.0f)) {
            try {
                this.current_image = this.current_image.getSubimage(x, y, w, h);
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception " + e + " extracting clipped image with values x=" + x + " y=" + y + " w=" + w + " h=" + h + " from image " + this.current_image);
            }
            catch (Error err) {
                LogWriter.writeLog("Exception " + err + " extracting clipped image with values x=" + x + " y=" + y + " w=" + w + " h=" + h + " from image " + this.current_image);
            }
        }
        double x1 = (double)this.i_x > shape_x ? (double)this.i_x : shape_x;
        double y1 = (double)this.i_y > shape_y ? (double)this.i_y : shape_y;
        this.i_x = (int)x1;
        this.i_y = (int)y1;
        this.i_w = w;
        this.i_h = h;
    }

    private Area getUnscaledClip(Area final_clip) {
        double dx = -this.CTM[2][0];
        double dy = -this.CTM[2][1];
        if (this.CTM[1][0] < 0.0f) {
            dx -= (double)this.CTM[1][0];
        }
        if (this.CTM[0][0] < 0.0f && this.CTM[1][0] >= 0.0f) {
            dx -= (double)this.CTM[1][0];
        }
        if (this.CTM[0][1] < 0.0f) {
            dy -= (double)this.CTM[0][1];
        }
        if (this.CTM[1][1] < 0.0f) {
            if (this.CTM[0][1] > 0.0f) {
                dy -= (double)this.CTM[0][1];
            } else if (this.CTM[1][1] < 0.0f) {
                dy -= (double)this.CTM[1][1];
            }
        }
        AffineTransform align_clip = new AffineTransform();
        align_clip.translate(dx, dy);
        final_clip.transform(align_clip);
        AffineTransform invert2 = new AffineTransform(1.0f / this.Trm2[0][0], 0.0f, 0.0f, 1.0f / this.Trm2[1][1], 0.0f, 0.0f);
        final_clip.transform(invert2);
        int dxx = (int)final_clip.getBounds().getX();
        if (dxx < 0) {
            final_clip.transform(AffineTransform.getTranslateInstance(-dxx, 0.0));
        }
        return final_clip;
    }
}

