/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.Serializable;
import org.jpedal.io.DecryptionFactory;
import org.jpedal.io.ObjectUtils;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.PdfObjectFactory;
import org.jpedal.io.types.Array;
import org.jpedal.io.types.BooleanValue;
import org.jpedal.io.types.Dictionary;
import org.jpedal.io.types.FloatValue;
import org.jpedal.io.types.Form;
import org.jpedal.io.types.General;
import org.jpedal.io.types.Name;
import org.jpedal.io.types.NumberValue;
import org.jpedal.io.types.Stream;
import org.jpedal.io.types.StringValue;
import org.jpedal.io.types.TextStream;
import org.jpedal.objects.raw.ObjectFactory;
import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.NumberUtils;
import org.jpedal.utils.StringUtils;

public class ObjectDecoder
implements Serializable {
    public PdfFileReader objectReader;
    public DecryptionFactory decryption;
    private Object PDFkey;
    static final byte[] endPattern = new byte[]{101, 110, 100, 111, 98, 106};
    public static final boolean debugFastCode = false;
    private int pdfKeyType;
    private int PDFkeyInt;
    public static String padding = "";
    boolean isInlineImage;
    private int endPt = -1;

    public ObjectDecoder(PdfFileReader pdfFileReader) {
        this.init(pdfFileReader);
    }

    private void init(PdfFileReader objectReader) {
        this.objectReader = objectReader;
        this.decryption = objectReader.getDecryptionObject();
    }

    public int readDictionaryAsObject(PdfObject pdfObject, int i, byte[] raw) {
        if (this.endPt == -1) {
            this.endPt = raw.length;
        }
        int length = raw.length;
        i = this.readObjectDataValues(pdfObject, i, raw, length);
        if (!pdfObject.ignoreStream() && pdfObject.getGeneralType(-1) != 6420) {
            Stream.readStreamData(pdfObject, i, raw, length, this.objectReader);
        }
        if (pdfObject.getObjectType() == 373244477) {
            Form.setFieldNames(pdfObject, this.objectReader);
        }
        return i;
    }

    private int readObjectDataValues(PdfObject pdfObject, int i, byte[] raw, int length) {
        int level = 0;
        if (this.isInlineImage) {
            level = 1;
        }
        while (true) {
            if (i < length && raw[i] == 37) {
                i = ObjectDecoder.stripComment(length, i, raw);
            }
            if (i >= length || this.endPt != -1 && i >= this.endPt || raw[i] == 101 && raw[i + 1] == 110 && raw[i + 2] == 100 && raw[i + 3] == 111 || raw[i] == 115 && raw[i + 1] == 116 && raw[i + 2] == 114 && raw[i + 3] == 101 && raw[i + 4] == 97 && raw[i + 5] == 109) break;
            if (raw[i] == 60 && raw[i + 1] == 60) {
                ++i;
                ++level;
            } else if (raw[i] == 62 && i + 1 != length && raw[i + 1] == 62 && raw[i - 1] != 62) {
                ++i;
                if (--level == 0) {
                    break;
                }
            } else if (raw[i] == 47 && (raw[i + 1] == 47 || raw[i + 1] == 32)) {
                ++i;
            } else if (raw[i] == 47) {
                int keyLength;
                int keyStart = ++i;
                if ((i += (keyLength = Dictionary.findDictionaryEnd(i, raw, length))) == length) break;
                boolean isStringPair = false;
                if (pdfObject.getID() == 1184787) {
                    isStringPair = Dictionary.isStringPair(i, raw, isStringPair);
                }
                int type = pdfObject.getObjectType();
                boolean isMap = this.isMapObject(pdfObject, i, raw, length, keyStart, keyLength, isStringPair, type);
                if (raw[i] == 47 || raw[i] == 40 || raw[i] == 91 && raw[i + 1] != 93) {
                    --i;
                }
                if (this.pdfKeyType == -1) {
                    i = ObjectUtils.handleUnknownType(i, raw, length);
                }
                if (this.PDFkeyInt != -1 && this.pdfKeyType != -1) {
                    i = this.setValue(pdfObject, i, raw, length, isMap);
                }
            } else if (raw[i] == 91 && level == 0 && pdfObject.getObjectType() == 1485011327) {
                Array objDecoder = new Array(this.objectReader, i, raw.length, 18, null, 826094945);
                objDecoder.readArray(false, raw, pdfObject, 339034948);
            }
            ++i;
        }
        return i;
    }

    private boolean isMapObject(PdfObject pdfObject, int i, byte[] raw, int length, int keyStart, int keyLength, boolean stringPair, int type) {
        boolean isMap;
        if (type == 487790868 && (pdfObject.getID() == 893350012 || pdfObject.getID() == 1184787 && stringPair || pdfObject.getID() == 17 && raw[i - 2] == 47)) {
            this.pdfKeyType = 30;
            this.PDFkey = PdfDictionary.getKey(keyStart, keyLength, raw);
            this.PDFkeyInt = 487790868;
            isMap = true;
        } else {
            isMap = false;
            this.PDFkey = null;
            this.getKeyType(pdfObject, i, raw, length, keyLength, keyStart, type);
        }
        return isMap;
    }

    private void getKeyType(PdfObject pdfObject, int i, byte[] raw, int length, int keyLength, int keyStart, int type) {
        int ptr;
        this.PDFkeyInt = PdfDictionary.getIntKey(keyStart, keyLength, raw);
        if (this.PDFkeyInt == 895578984 && (type == 7451 || type == 373244477 || type == 2004845231 || type == 1111442775)) {
            this.PDFkeyInt = 25;
        }
        if (this.isInlineImage) {
            this.PDFkeyInt = PdfObjectFactory.getInlineID(this.PDFkeyInt);
        }
        int id = pdfObject.getID();
        if (type == 2004251818 && (this.PDFkeyInt == 2087749783 || this.PDFkeyInt == -1938465939 || this.PDFkeyInt == 878474856 || this.PDFkeyInt == 979194486 || this.PDFkeyInt == 373243460 || this.PDFkeyInt == 1146450818)) {
            this.pdfKeyType = 2;
        } else if (type == 1485011327 && this.PDFkeyInt == 20) {
            this.PDFkeyInt = 339034948;
            this.pdfKeyType = 18;
        } else if ((type == 373244477 || type == 7451) && this.PDFkeyInt == 20) {
            if (id == 4384 || id == 4369) {
                this.pdfKeyType = 40;
            } else if (id == 2570558) {
                this.pdfKeyType = 25;
            } else {
                this.PDFkeyInt = 339034948;
                this.pdfKeyType = 18;
            }
        } else {
            this.pdfKeyType = !(type != 373244477 && type != 7451 || id != 4384 && id != 4369 || this.PDFkeyInt != 17) ? 40 : (this.PDFkeyInt == 1110717793 && type == -1567847737 ? 22 : (this.PDFkeyInt == 506543413 && type == -1567847737 ? 25 : ((type == 2087749783 || type == 1518239089) && this.PDFkeyInt == 30 ? 7 : (this.PDFkeyInt == 826096968 && type == 2087749783 && pdfObject.getParameterConstant(2087749783) == 391471749 ? 7 : (id == 2570558 && pdfObject.getObjectType() == 373244477 && (this.PDFkeyInt == 32 || this.PDFkeyInt == 31) ? 25 : (this.isInlineImage && this.PDFkeyInt == 2087749783 ? 1 : PdfDictionary.getKeyType(this.PDFkeyInt, type)))))));
        }
        if (id == 878474856 && this.PDFkeyInt == 1518239089) {
            ptr = i;
            while (raw[ptr] >= 48 && raw[ptr] < 58 || raw[ptr] == 32) {
                ++ptr;
            }
            if (raw[ptr] == 91) {
                this.pdfKeyType = 14;
            }
        }
        if (this.pdfKeyType == -1 && id == 1448698499) {
            this.pdfKeyType = Dictionary.getPairedValues(pdfObject, i, raw, this.pdfKeyType, length, keyLength, keyStart);
        } else if ((id == 30 || id == 20 || id == 34) && pdfObject.getParentID() == 4384 && pdfObject.getObjectType() == 373244477 && raw[i] != 91) {
            ptr = i;
            while (raw[ptr] >= 48 && raw[ptr] < 58 || raw[ptr] == 32) {
                ++ptr;
            }
            if (!(raw[keyStart] == 76 && raw[keyStart + 1] == 101 && raw[keyStart + 2] == 110 && raw[keyStart + 3] == 103 && raw[keyStart + 4] == 116 && raw[keyStart + 5] == 104 || raw[keyStart] == 79 && raw[keyStart + 1] == 110 || raw[keyStart] == 79 && raw[keyStart + 1] == 102 && raw[keyStart + 2] == 102 || raw[ptr] != 82)) {
                this.pdfKeyType = Dictionary.getPairedValues(pdfObject, i, raw, this.pdfKeyType, length, keyLength, keyStart);
            }
        }
        if (this.PDFkeyInt == 1888135062) {
            this.pdfKeyType = ObjectDecoder.setTypeForDecodeParams(i, raw, length, this.pdfKeyType);
        }
    }

    private int setValue(PdfObject pdfObject, int i, byte[] raw, int length, boolean map) {
        boolean ignoreRecursion = pdfObject.ignoreRecursion();
        if (this.pdfKeyType == 5 && pdfObject.isDataExternal()) {
            this.pdfKeyType = 1;
        }
        switch (this.pdfKeyType) {
            case 25: {
                i = TextStream.setTextStreamValue(pdfObject, i, raw, ignoreRecursion, this.PDFkeyInt, this.objectReader);
                break;
            }
            case 35: {
                i = Name.setNameTreeValue(pdfObject, i, raw, length, ignoreRecursion, this.PDFkeyInt, this.objectReader);
                break;
            }
            case 2: {
                i = Dictionary.setDictionaryValue(pdfObject, i, raw, length, ignoreRecursion, this.objectReader, this.PDFkeyInt);
                break;
            }
            case 20: {
                Array objDecoder = new Array(this.objectReader, i, this.endPt, 20);
                i = objDecoder.readArray(ignoreRecursion, raw, pdfObject, this.PDFkeyInt);
                break;
            }
            case 12: {
                Array objDecoder = new Array(this.objectReader, i, this.endPt, 12);
                i = objDecoder.readArray(false, raw, pdfObject, this.PDFkeyInt);
                break;
            }
            case 14: {
                Array objDecoder = new Array(this.objectReader, i, this.endPt, 14);
                i = objDecoder.readArray(ignoreRecursion, raw, pdfObject, this.PDFkeyInt);
                break;
            }
            case 18: {
                Array objDecoder = new Array(this.objectReader, i, this.endPt, 18);
                i = objDecoder.readArray(ignoreRecursion, raw, pdfObject, this.PDFkeyInt);
                break;
            }
            case 22: {
                Array objDecoder = new Array(this.objectReader, i, this.endPt, 22);
                i = objDecoder.readArray(false, raw, pdfObject, this.PDFkeyInt);
                break;
            }
            case 16: {
                Array objDecoder = new Array(this.objectReader, i, this.endPt, 16);
                i = objDecoder.readArray(false, raw, pdfObject, this.PDFkeyInt);
                break;
            }
            case 9: {
                Array objDecoder = new Array(this.objectReader, i, this.endPt, 9);
                i = objDecoder.readArray(false, raw, pdfObject, this.PDFkeyInt);
                break;
            }
            case 10: {
                Array objDecoder = new Array(this.objectReader, i, this.endPt, 10);
                i = objDecoder.readArray(false, raw, pdfObject, this.PDFkeyInt);
                break;
            }
            case 30: {
                i = Name.setNameStringValue(pdfObject, i, raw, map, this.PDFkey, this.PDFkeyInt, this.objectReader);
                break;
            }
            case 8: {
                i = BooleanValue.set(pdfObject, i, raw, this.PDFkeyInt);
                break;
            }
            case 3: {
                i = StringValue.setStringConstantValue(pdfObject, i, raw, this.PDFkeyInt);
                break;
            }
            case 4: {
                i = StringValue.setStringKeyValue(pdfObject, i, raw, this.PDFkeyInt);
                break;
            }
            case 6: {
                ++i;
                while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47) {
                    ++i;
                }
                i = NumberValue.setNumberValue(pdfObject, i, raw, this.PDFkeyInt, this.objectReader);
                break;
            }
            case 7: {
                i = FloatValue.setFloatValue(pdfObject, i, raw, length, this.PDFkeyInt, this.objectReader);
                break;
            }
            case 5: {
                i = this.setUnreadDictionaryValue(pdfObject, i, raw);
                break;
            }
            case 40: {
                if (raw.length - 5 > 0 && raw[i + 1] == 110 && raw[i + 2] == 117 && raw[i + 3] == 108 && raw[i + 4] == 108) {
                    i += 5;
                    break;
                }
                i = this.setVariousValue(pdfObject, i, raw, length, this.PDFkeyInt, map, ignoreRecursion, this.objectReader);
                break;
            }
            case 1: {
                i = this.setDictionaryValue(pdfObject, i, raw, ignoreRecursion);
            }
        }
        return i;
    }

    static int stripComment(int length, int i, byte[] raw) {
        while (i < length && raw[i] != 10 && raw[i] != 13) {
            ++i;
        }
        while (i < length && (raw[i] == 9 || raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 60)) {
            ++i;
        }
        return i;
    }

    int setVariousValue(PdfObject pdfObject, int i, byte[] raw, int length, int PDFkeyInt, boolean map, boolean ignoreRecursion, PdfFileReader objectReader) {
        if (raw[i] != 60) {
            ++i;
        }
        if (raw[i] == 47) {
            i = Name.setNameStringValue(pdfObject, i, raw, map, this.PDFkey, PDFkeyInt, objectReader);
        } else if (raw[i] == 102 && raw[i + 1] == 97 && raw[i + 2] == 108 && raw[i + 3] == 115 && raw[i + 4] == 101) {
            pdfObject.setBoolean(PDFkeyInt, false);
            i += 4;
        } else if (raw[i] == 116 && raw[i + 1] == 114 && raw[i + 2] == 117 && raw[i + 3] == 101) {
            pdfObject.setBoolean(PDFkeyInt, true);
            i += 3;
        } else {
            i = raw[i] == 40 || raw[i] == 60 && raw[i - 1] != 60 && raw[i + 1] != 60 ? TextStream.readTextStream(pdfObject, i, raw, PDFkeyInt, ignoreRecursion, objectReader) : (raw[i] == 91 ? ObjectDecoder.setArray(pdfObject, i, raw, PDFkeyInt, ignoreRecursion, objectReader, this.endPt) : (raw[i] == 60 && raw[i + 1] == 60 ? Dictionary.readDictionary(pdfObject, i, raw, PDFkeyInt, ignoreRecursion, objectReader, this.isInlineImage) : General.readGeneral(pdfObject, i, raw, length, PDFkeyInt, map, ignoreRecursion, objectReader, this.PDFkey, this.endPt)));
        }
        return i;
    }

    static int setArray(PdfObject pdfObject, int i, byte[] raw, int PDFkeyInt, boolean ignoreRecursion, PdfFileReader objectReader, int endPt) {
        if (PDFkeyInt == 2627089) {
            Array objDecoder = new Array(objectReader, i, endPt, 18);
            i = objDecoder.readArray(ignoreRecursion, raw, pdfObject, PDFkeyInt);
        } else if (PDFkeyInt == 27) {
            Array objDecoder = new Array(objectReader, i, endPt, 20);
            i = objDecoder.readArray(ignoreRecursion, raw, pdfObject, PDFkeyInt);
        } else if (PDFkeyInt == 19) {
            Array objDecoder = new Array(objectReader, i, endPt, 10);
            i = objDecoder.readArray(ignoreRecursion, raw, pdfObject, PDFkeyInt);
        } else if (PDFkeyInt == 521344835) {
            Array objDecoder = new Array(objectReader, i, endPt, 14);
            i = objDecoder.readArray(ignoreRecursion, raw, pdfObject, PDFkeyInt);
        } else {
            Array objDecoder = new Array(objectReader, i, endPt, 20);
            i = objDecoder.readArray(ignoreRecursion, raw, pdfObject, PDFkeyInt);
        }
        return i;
    }

    static int setTypeForDecodeParams(int i, byte[] raw, int length, int pdfKeyType) {
        int ii;
        for (ii = i; ii < length && (raw[ii] == 32 || raw[ii] == 9 || raw[ii] == 13 || raw[ii] == 10); ++ii) {
        }
        if (raw[ii] != 60) {
            while (ii < length && (raw[ii] == 32 || raw[ii] == 9 || raw[ii] == 13 || raw[ii] == 10 || raw[ii] == 91)) {
                ++ii;
            }
            if (raw[ii] == 60 || raw[ii] >= 48 && raw[ii] <= 57) {
                pdfKeyType = 22;
            }
        }
        return pdfKeyType;
    }

    private int setDictionaryValue(PdfObject pdfObject, int i, byte[] raw, boolean ignoreRecursion) {
        boolean isKey;
        int end = i;
        int nextC = i;
        while (raw[nextC] == 10 || raw[nextC] == 32 || raw[nextC] == 9) {
            ++nextC;
        }
        if (raw[nextC] == 110 && raw[nextC + 1] == 117 && raw[nextC + 2] == 108 && raw[nextC + 3] == 108) {
            i = nextC + 4;
            return i;
        }
        if (raw[nextC] == 91 && raw[nextC + 1] == 93) {
            i = nextC;
            return i;
        }
        if (raw[i] != 60 && raw[i + 1] != 60) {
            end += 2;
        }
        boolean inDictionary = true;
        boolean bl = isKey = raw[end - 1] == 47;
        while (inDictionary) {
            if (raw[end] == 60 && raw[end + 1] == 60) {
                int level2 = 1;
                ++end;
                while (level2 > 0) {
                    if (raw[end] == 60 && raw[end + 1] == 60) {
                        ++level2;
                        end += 2;
                        continue;
                    }
                    if (raw[end - 1] == 62 && raw[end] == 62) {
                        if (--level2 <= 0) continue;
                        end += 2;
                        continue;
                    }
                    if (raw[end] == 40) {
                        ++end;
                        while (raw[end] != 41 || ObjectUtils.isEscaped(raw, end)) {
                            ++end;
                        }
                        continue;
                    }
                    ++end;
                }
                inDictionary = false;
                continue;
            }
            if (raw[end] == 82) {
                inDictionary = false;
                continue;
            }
            if (isKey && (raw[end] == 32 || raw[end] == 13 || raw[end] == 10 || raw[end] == 9)) {
                inDictionary = false;
                continue;
            }
            if (raw[end] == 47) {
                inDictionary = false;
                --end;
                continue;
            }
            if (raw[end] == 62 && raw[end + 1] == 62) {
                inDictionary = false;
                --end;
                continue;
            }
            ++end;
        }
        Dictionary.readDictionary(pdfObject, i, raw, this.PDFkeyInt, ignoreRecursion, this.objectReader, this.isInlineImage);
        return end;
    }

    private int setUnreadDictionaryValue(PdfObject pdfObject, int i, byte[] raw) {
        if (raw[i] != 60) {
            ++i;
        }
        while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 9) {
            ++i;
        }
        int start = i;
        PdfObject valueObj = ObjectFactory.createObject(this.PDFkeyInt, pdfObject.getObjectRefAsString(), pdfObject.getObjectType(), pdfObject.getID());
        valueObj.setID(this.PDFkeyInt);
        if (raw[i] != 110 || raw[i + 1] != 117 || raw[i + 2] != 108 || raw[i + 3] != 108) {
            pdfObject.setDictionary(this.PDFkeyInt, valueObj);
        }
        int status = 2;
        if (raw[i] == 47) {
            while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47 || raw[i] == 60) {
                ++i;
            }
            int keyStart = i;
            int keyLength = 0;
            while (raw[i] != 10 && raw[i] != 13 && raw[i] != 32 && raw[i] != 47 && raw[i] != 60 && raw[i] != 62) {
                ++i;
                ++keyLength;
            }
            --i;
            int constant = valueObj.setConstant(this.PDFkeyInt, keyStart, keyLength, raw);
            if (constant == -1 || this.isInlineImage) {
                byte[] newStr = new byte[keyLength];
                System.arraycopy(raw, keyStart, newStr, 0, keyLength);
                String s = new String(newStr);
                valueObj.setGeneralStringValue(s);
            }
            status = 0;
        } else if (raw[i] != 101 || raw[i + 1] != 110 || raw[i + 2] != 100 || raw[i + 3] != 111 || raw[i + 4] != 98) {
            int reflevel;
            while (raw[i] == 91 && this.PDFkeyInt != 2087749783 || raw[i] == 32 || raw[i] == 13 || raw[i] == 10) {
                ++i;
            }
            if (raw[i] == 60 && raw[i + 1] == 60) {
                i += 2;
                reflevel = 1;
                while (reflevel > 0) {
                    if (raw[i] == 60 && raw[i + 1] == 60) {
                        i += 2;
                        ++reflevel;
                        continue;
                    }
                    if (raw[i] == 40) {
                        ++i;
                        while (raw[i] != 41 || ObjectUtils.isEscaped(raw, i)) {
                            ++i;
                        }
                        continue;
                    }
                    if (raw[i] == 62 && i + 1 == raw.length) {
                        reflevel = 0;
                        continue;
                    }
                    if (raw[i] == 62 && raw[i + 1] == 62) {
                        i += 2;
                        --reflevel;
                        continue;
                    }
                    ++i;
                }
            } else if (raw[i] == 91) {
                ++i;
                reflevel = 1;
                while (reflevel > 0) {
                    if (raw[i] == 40) {
                        ++i;
                        while (raw[i] != 41 || ObjectUtils.isEscaped(raw, i)) {
                            ++i;
                        }
                    } else if (raw[i] == 91) {
                        ++reflevel;
                    } else if (raw[i] == 93) {
                        --reflevel;
                    }
                    ++i;
                }
                --i;
            } else if (raw[i] == 110 && raw[i + 1] == 117 && raw[i + 2] == 108 && raw[i + 3] == 108) {
                i += 4;
            } else {
                status = 1;
                while ((raw[i] != 82 || raw[i - 1] == 101) && ++i != raw.length) {
                }
                if (++i >= raw.length) {
                    i = raw.length - 1;
                }
            }
        }
        valueObj.setStatus(status);
        if (status != 0) {
            int StrLength = i - start;
            byte[] unresolvedData = new byte[StrLength];
            System.arraycopy(raw, start, unresolvedData, 0, StrLength);
            if (unresolvedData[StrLength - 1] == 82) {
                for (int jj = 0; jj < StrLength; ++jj) {
                    if (unresolvedData[jj] != 10 && unresolvedData[jj] != 13) continue;
                    unresolvedData[jj] = 32;
                }
            }
            valueObj.setUnresolvedData(unresolvedData, this.PDFkeyInt);
        }
        if (raw[i] == 47 || raw[i] == 62) {
            --i;
        }
        return i;
    }

    public static int handleValue(PdfObject pdfObject, int i, int PDFkeyInt, int j, int ref, int generation, byte[] data, PdfFileReader objectReader) {
        int dataLen = data.length;
        if (data[j] == 47) {
            int keyStart = ++j;
            int keyLength = 0;
            while (j < dataLen && data[j] != 10 && data[j] != 13 && data[j] != 32 && data[j] != 47 && data[j] != 60 && data[j] != 62) {
                ++j;
                ++keyLength;
            }
            --i;
            if (PDFkeyInt == -1) {
                pdfObject.setConstant(PDFkeyInt, keyStart, keyLength, data);
            } else {
                PdfObject valueObj = ObjectFactory.createObject(PDFkeyInt, null, pdfObject.getObjectType(), pdfObject.getID());
                valueObj.setID(PDFkeyInt);
                valueObj.setConstant(PDFkeyInt, keyStart, keyLength, data);
                pdfObject.setDictionary(PDFkeyInt, valueObj);
                if (pdfObject.isDataExternal()) {
                    valueObj.isDataExternal(true);
                    if (!ObjectDecoder.resolveFully(valueObj, objectReader)) {
                        pdfObject.setFullyResolved(false);
                    }
                }
            }
        } else {
            PdfObject valueObj;
            if (PDFkeyInt == -1) {
                valueObj = pdfObject;
            } else {
                valueObj = ObjectFactory.createObject(PDFkeyInt, ref, generation, pdfObject.getObjectType());
                valueObj.setID(PDFkeyInt);
                valueObj.setInCompressedStream(pdfObject.isInCompressedStream());
                if (pdfObject.isDataExternal()) {
                    valueObj.isDataExternal(true);
                    if (!ObjectDecoder.resolveFully(valueObj, objectReader)) {
                        pdfObject.setFullyResolved(false);
                    }
                }
                if (PDFkeyInt != 2004251818) {
                    valueObj.ignoreRecursion(pdfObject.ignoreRecursion());
                }
            }
            ObjectDecoder objDecoder = new ObjectDecoder(objectReader);
            objDecoder.readDictionaryAsObject(valueObj, j, data);
            if (PDFkeyInt != -1) {
                pdfObject.setDictionary(PDFkeyInt, valueObj);
            }
        }
        return i;
    }

    public static synchronized boolean resolveFully(PdfObject pdfObject, PdfFileReader objectReader) {
        boolean fullyResolved;
        boolean bl = fullyResolved = pdfObject != null;
        if (fullyResolved) {
            byte[] raw = pdfObject.getStatus() == 0 ? StringUtils.toBytes(pdfObject.getObjectRefAsString()) : pdfObject.getUnresolvedData();
            pdfObject.setStatus(0);
            if (raw[0] != 101 && raw[1] != 110 && raw[2] != 100 && raw[3] != 111 && raw[4] != 98) {
                int j = 0;
                while (raw[j] == 91 || raw[j] == 32 || raw[j] == 13 || raw[j] == 10) {
                    ++j;
                }
                int keyStart = j;
                while (raw[j] != 10 && raw[j] != 13 && raw[j] != 32 && raw[j] != 47 && raw[j] != 60 && raw[j] != 62) {
                    ++j;
                }
                int ref = NumberUtils.parseInt(keyStart, j, raw);
                while (raw[j] == 10 || raw[j] == 13 || raw[j] == 32) {
                    ++j;
                }
                keyStart = j;
                while (raw[j] != 10 && raw[j] != 13 && raw[j] != 32 && raw[j] != 47 && raw[j] != 60 && raw[j] != 62) {
                    ++j;
                }
                int generation = NumberUtils.parseInt(keyStart, j, raw);
                if (raw[raw.length - 1] == 82) {
                    fullyResolved = ObjectDecoder.resolveFullyChildren(pdfObject, fullyResolved, raw, ref, generation, objectReader);
                }
                if (fullyResolved) {
                    pdfObject.ignoreRecursion(false);
                    ObjectDecoder objDecoder = new ObjectDecoder(objectReader);
                    objDecoder.readDictionaryAsObject(pdfObject, j, raw);
                }
            }
        }
        return fullyResolved;
    }

    static boolean resolveFullyChildren(PdfObject pdfObject, boolean fullyResolved, byte[] raw, int ref, int generation, PdfFileReader objectReader) {
        pdfObject.setRef(new String(raw));
        pdfObject.isDataExternal(true);
        byte[] pageData = objectReader.readObjectAsByteArray(pdfObject, objectReader.isCompressed(ref, generation), ref, generation);
        if (pageData == null) {
            pdfObject.setFullyResolved(false);
            fullyResolved = false;
        } else {
            pdfObject.setStatus(2);
            pdfObject.setUnresolvedData(pageData, 2004845231);
            pdfObject.isDataExternal(true);
            if (!ObjectDecoder.resolveFully(pdfObject, objectReader)) {
                pdfObject.setFullyResolved(false);
            }
        }
        return fullyResolved;
    }

    public void checkResolved(PdfObject pdfObject) {
        if (pdfObject != null && pdfObject.getStatus() != 0) {
            byte[] raw = pdfObject.getUnresolvedData();
            pdfObject.setStatus(0);
            if (!(raw[0] == 101 && raw[1] == 110 && raw[2] == 100 && raw[3] == 111 && raw[4] == 98 || raw[0] == 110 && raw[1] == 117 && raw[2] == 108 && raw[3] == 108)) {
                String objectRef = pdfObject.getObjectRefAsString();
                if (raw[0] == 91) {
                    int ptr = 0;
                    int len = raw.length;
                    for (int jj = 0; jj < len; ++jj) {
                        if (raw[jj] < 48 || raw[jj] > 57) continue;
                        ptr = jj;
                        jj = len;
                    }
                    int end = ptr;
                    while (raw[end] >= 48 && raw[end] <= 57 || raw[end] == 32 || raw[end] == 10 || raw[end] == 13 || raw[end] == 9) {
                        ++end;
                    }
                    if (raw[end] == 82) {
                        pdfObject.setRef(new String(raw, ptr, len - ptr));
                    }
                } else if (raw[raw.length - 1] == 82) {
                    objectRef = new String(raw);
                    pdfObject.setRef(objectRef);
                }
                Dictionary.readDictionaryFromRefOrDirect(-1, pdfObject, objectRef, 0, raw, -1, this.objectReader);
            }
        }
    }

    public void setEndPt(int dataPointer) {
        this.endPt = dataPointer;
    }
}

