/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.types.ArrayUtils;
import org.jpedal.objects.raw.DecodeParmsObject;
import org.jpedal.objects.raw.PdfObject;

public class ObjectUtils {
    public static byte[] checkEndObject(byte[] array) {
        long objStart = -1L;
        long lastEndStream = -1L;
        int ObjStartCount = 0;
        for (int i = 0; i < array.length - 8; ++i) {
            if (ObjStartCount < 2 && array[i] == 32 && array[i + 1] == 111 && array[i + 2] == 98 && array[i + 3] == 106) {
                ++ObjStartCount;
                objStart = i;
            }
            if (ObjStartCount >= 2 || array[i] != 101 || array[i + 1] != 110 || array[i + 2] != 100 || array[i + 3] != 115 || array[i + 4] != 116 || array[i + 5] != 114 || array[i + 6] != 101 || array[i + 7] != 97 || array[i + 8] != 109) continue;
            lastEndStream = i + 9;
        }
        if (lastEndStream > 0L && objStart > lastEndStream) {
            byte[] newArray = new byte[(int)lastEndStream];
            System.arraycopy(array, 0, newArray, 0, (int)lastEndStream);
            array = newArray;
        }
        return array;
    }

    public static byte[] readEscapedValue(int j, byte[] data, int start, boolean keepReturns) {
        byte[] newString;
        boolean escapedValues = false;
        for (int aa = start; aa < j; ++aa) {
            if (data[aa] != 92 && data[aa] != 10 && data[aa] != 13) continue;
            escapedValues = true;
            aa = j;
        }
        if (!escapedValues) {
            int stringLength = j - start;
            if (stringLength < 1) {
                return new byte[0];
            }
            newString = new byte[stringLength];
            System.arraycopy(data, start, newString, 0, stringLength);
        } else {
            int jj = 0;
            int stringLength = j - start;
            newString = new byte[stringLength];
            for (int aa = start; aa < j; ++aa) {
                if (data[aa] == 92) {
                    byte nextByte;
                    if (data[++aa] == 13 && data[aa + 1] != 92 && newString[0] == -2 && newString[1] == -1) {
                        ++aa;
                    }
                    if ((nextByte = data[aa]) == 98) {
                        newString[jj] = 8;
                    } else if (nextByte == 110) {
                        newString[jj] = 10;
                    } else if (nextByte == 116) {
                        newString[jj] = 9;
                    } else if (nextByte == 114) {
                        newString[jj] = 13;
                    } else if (nextByte == 102) {
                        newString[jj] = 12;
                    } else if (nextByte == 92) {
                        newString[jj] = 92;
                    } else if (nextByte > 47 && nextByte < 58) {
                        StringBuilder octal = new StringBuilder(3);
                        boolean notOctal = false;
                        for (int ii = 0; ii < 3; ++ii) {
                            if (data[aa] == 92 || data[aa] == 41 || data[aa] < 48 || data[aa] > 57) {
                                ii = 3;
                                continue;
                            }
                            octal.append((char)data[aa]);
                            if (data[aa] > 55) {
                                notOctal = true;
                            }
                            ++aa;
                        }
                        --aa;
                        newString[jj] = notOctal ? (byte)Integer.parseInt(octal.toString()) : (byte)Integer.parseInt(octal.toString(), 8);
                    } else if (!(keepReturns || nextByte != 13 && nextByte != 10)) {
                        --jj;
                    } else {
                        newString[jj] = nextByte;
                    }
                    ++jj;
                    continue;
                }
                if (!(keepReturns || data[aa] != 13 && data[aa] != 10)) {
                    newString[jj] = 32;
                    ++jj;
                    continue;
                }
                newString[jj] = data[aa];
                ++jj;
            }
            byte[] rawString = newString;
            newString = new byte[jj];
            System.arraycopy(rawString, 0, newString, 0, jj);
        }
        return newString;
    }

    public static PdfObject[] setupDecodeParms(PdfObject pdfObject, PdfFileReader objReader) {
        PdfObject[] decodeParmsValues;
        Object[] DecodeParmsArray = pdfObject.getObjectArray(1888135062);
        if (DecodeParmsArray != null) {
            int count = DecodeParmsArray.length;
            decodeParmsValues = new PdfObject[count];
            for (int i = 0; i < count; ++i) {
                byte[] decodeByteData = (byte[])DecodeParmsArray[i];
                if (decodeByteData != null) {
                    String key = new String(decodeByteData);
                    DecodeParmsObject DecodeParms = new DecodeParmsObject(key);
                    if (decodeByteData[0] == 60) {
                        DecodeParms.setStatus(2);
                    } else {
                        DecodeParms.setStatus(1);
                    }
                    DecodeParms.setUnresolvedData(decodeByteData, 1888135062);
                    ObjectDecoder objDecoder = new ObjectDecoder(objReader);
                    objDecoder.checkResolved(DecodeParms);
                    decodeParmsValues[i] = DecodeParms;
                    continue;
                }
                decodeParmsValues[i] = null;
            }
        } else {
            decodeParmsValues = new PdfObject[]{pdfObject.getDictionary(1888135062)};
        }
        return decodeParmsValues;
    }

    public static byte[] convertReturnsToSpaces(byte[] newValues) {
        if (newValues == null) {
            return null;
        }
        int returnCount = 0;
        int len = newValues.length;
        for (int aa = 0; aa < len; ++aa) {
            if (newValues[aa] != 13 || newValues[aa + 1] != 10) continue;
            ++aa;
            ++returnCount;
        }
        if (returnCount > 0) {
            int newLen = len - returnCount;
            int jj = 0;
            byte[] oldValue = newValues;
            newValues = new byte[newLen];
            for (int aa = 0; aa < len; ++aa) {
                if (oldValue[aa] == 13 && aa < len - 1 && oldValue[aa + 1] == 10) {
                    newValues[jj] = 32;
                    ++aa;
                } else {
                    newValues[jj] = oldValue[aa];
                }
                ++jj;
            }
        }
        return newValues;
    }

    static int handleUnknownType(int i, byte[] raw, int length) {
        int count = length - 1;
        for (int jj = i; jj < count; ++jj) {
            if (raw[jj] == 82 && raw[jj - 2] == 48) {
                i = jj;
                jj = count;
                continue;
            }
            if (raw[jj] == 60 && raw[jj + 1] == 60) {
                int levels = 0;
                do {
                    if (raw[jj] == 60 && raw[jj + 1] == 60) {
                        ++levels;
                        continue;
                    }
                    if (raw[jj] != 62 || raw[jj + 1] != 62) continue;
                    --levels;
                    if (raw[jj + 2] != 62) continue;
                    ++jj;
                } while (levels != 0 && ++jj < count);
                i = jj;
                jj = count;
                continue;
            }
            if (raw[jj] == 47) {
                jj = count;
                continue;
            }
            if (raw[jj] == 62 && raw[jj + 1] == 62) {
                i = jj - 1;
                jj = count;
                continue;
            }
            if (raw[jj] != 40) continue;
            while (jj < count && (raw[jj] != 41 || ObjectUtils.isEscaped(raw, jj))) {
                ++jj;
            }
            i = jj;
            jj = count;
        }
        return i;
    }

    public static boolean isEscaped(byte[] raw, int i) {
        int j = i - 1;
        int escapedFound = 0;
        while (j > -1 && raw[j] == 92) {
            --j;
            ++escapedFound;
        }
        return escapedFound & true;
    }

    public static int setDirectValue(PdfObject pdfObject, int i, byte[] raw, int PDFkeyInt) {
        int keyStart = ++i;
        while (i < raw.length && raw[i] != 32 && raw[i] != 10 && raw[i] != 13) {
            ++i;
        }
        pdfObject.setConstant(PDFkeyInt, keyStart, i - keyStart, raw);
        return i;
    }

    static void showData(PdfObject pdfObject, int i, int length, byte[] raw, String padding) {
        System.out.println("\n\n" + padding + " ------------readDictionaryAsObject ref=" + pdfObject.getObjectRefAsString() + " into " + pdfObject + "-----------------\ni=" + i + "\nData=>>>>");
        System.out.print(padding);
        for (int jj = i; jj < length; ++jj) {
            System.out.print((char)raw[jj]);
            if (raw[jj] == 37) {
                jj = ArrayUtils.skipComment(raw, jj);
            }
            if (jj > 5 && raw[jj - 5] == 115 && raw[jj - 4] == 116 && raw[jj - 3] == 114 && raw[jj - 2] == 101 && raw[jj - 1] == 97 && raw[jj] == 109) {
                jj = length;
            }
            if (jj <= 2 || raw[jj - 2] != 66 || raw[jj - 1] != 68 || raw[jj] != 67) continue;
            jj = length;
        }
        System.out.println(padding + "\n<<<<-----------------------------------------------------\n");
    }

    public static String showMixedValuesAsString(Object[] objectValues, String values) {
        if (objectValues == null) {
            return "null";
        }
        values = values + '[';
        int count = objectValues.length;
        for (int jj = 0; jj < count; ++jj) {
            if (objectValues[jj] == null) {
                values = values + "null ";
                continue;
            }
            if (objectValues[jj] instanceof byte[]) {
                values = values + new String((byte[])objectValues[jj]);
                if (count - jj <= 1) continue;
                values = values + " , ";
                continue;
            }
            values = ObjectUtils.showMixedValuesAsString((Object[])objectValues[jj], values) + ']';
            if (count - jj <= 1) continue;
            values = values + " ,";
        }
        return values;
    }
}

