/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.exception.PdfException;
import org.jpedal.exception.PdfSecurityException;
import org.jpedal.io.DecryptionFactory;
import org.jpedal.io.LinearizedHintTable;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.ObjectUtils;
import org.jpedal.io.PdfFilteredReader;
import org.jpedal.io.RandomAccessBuffer;
import org.jpedal.io.types.CompressedObjects;
import org.jpedal.io.types.ObjectReader;
import org.jpedal.io.types.Offsets;
import org.jpedal.io.types.RefTable;
import org.jpedal.objects.raw.CompressedObject;
import org.jpedal.objects.raw.EncryptionObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.StreamObject;
import org.jpedal.utils.LogWriter;

public class PdfFileReader {
    ObjectReader objectReader;
    private PrivateKey key;
    private Certificate certificate;
    private LinearizedHintTable linHintTable;
    private byte[] lastCompressedStream;
    private Map lastOffsetStart;
    private Map lastOffsetEnd;
    private PdfObject compressedObj;
    private int lastFirst = -1;
    private int lastCompressedID = -1;
    private RefTable refTable;
    PdfObject encyptionObj;
    private DecryptionFactory decryption;
    private byte[] encryptionPassword;
    private RandomAccessBuffer pdf_datafile;
    private Offsets offset = new Offsets(2000);
    public static int alwaysCacheInMemory = 16384;
    private long eof;
    private int[] ObjLengthTable;

    public PdfObject getInfoObject() {
        return this.refTable.getInfoObject();
    }

    public void setCacheSize(int miniumumCacheSize) {
        this.objectReader.setCacheSize(miniumumCacheSize);
    }

    public byte[] getBuffer() {
        return this.pdf_datafile.getPdfBuffer();
    }

    public void init(RandomAccessBuffer pdf_datafile) {
        block2: {
            this.pdf_datafile = pdf_datafile;
            try {
                this.eof = pdf_datafile.length();
            }
            catch (IOException e) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        this.objectReader = new ObjectReader(pdf_datafile, this.eof, this);
        this.refTable = new RefTable(pdf_datafile, this.eof, this.offset);
    }

    public final void readObject(PdfObject pdfObject) {
        if (pdfObject.isDataExternal() && this.linHintTable != null) {
            this.readExternalObject(pdfObject);
        } else {
            byte[] raw;
            String objectRef = pdfObject.getObjectRefAsString();
            int id = pdfObject.getObjectRefID();
            boolean debug = false;
            boolean isCompressed = this.offset.isCompressed(id);
            pdfObject.setCompressedStream(isCompressed);
            if (isCompressed) {
                raw = this.readCompressedObject(pdfObject);
            } else {
                this.movePointer(this.offset.elementAt(id));
                if (objectRef.charAt(0) == '<') {
                    raw = this.objectReader.readObjectData(-1, pdfObject);
                } else if (this.ObjLengthTable == null || this.offset.isRefTableInvalid()) {
                    raw = this.getPointer() == 0L ? new byte[]{} : this.objectReader.readObjectData(-1, pdfObject);
                } else if (id > this.ObjLengthTable.length || this.ObjLengthTable[id] == 0) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog(objectRef + " cannot have offset 0");
                    }
                    raw = new byte[]{};
                } else {
                    raw = this.objectReader.readObjectData(this.ObjLengthTable[id], pdfObject);
                }
            }
            if (raw.length > 1) {
                ObjectDecoder objDecoder = new ObjectDecoder(this);
                objDecoder.readDictionaryAsObject(pdfObject, 0, raw);
            }
        }
    }

    private void readExternalObject(PdfObject pdfObject) {
        int ref = pdfObject.getObjectRefID();
        int generation = pdfObject.getObjectRefGeneration();
        byte[] pageData = this.readObjectAsByteArray(pdfObject, this.isCompressed(ref, generation), ref, generation);
        pdfObject.setStatus(2);
        pdfObject.setUnresolvedData(pageData, 540096309);
        ObjectDecoder.resolveFully(pdfObject, this);
    }

    private byte[] readCompressedObject(PdfObject pdfObject) {
        byte[] raw;
        int objectID = pdfObject.getObjectRefID();
        int compressedID = this.offset.elementAt(objectID);
        String startID = null;
        int First2 = this.lastFirst;
        boolean isCached = true;
        byte[] compressedStream = this.lastCompressedStream;
        HashMap offsetStart = this.lastOffsetStart;
        HashMap offsetEnd = this.lastOffsetEnd;
        PdfObject Extends = null;
        if (this.lastOffsetStart != null && compressedID == this.lastCompressedID) {
            startID = (String)this.lastOffsetStart.get(String.valueOf(objectID));
        }
        while (startID == null) {
            if (Extends != null) {
                this.compressedObj = Extends;
            } else if (compressedID != this.lastCompressedID) {
                isCached = false;
                this.movePointer(this.offset.elementAt(compressedID));
                raw = this.objectReader.readObjectData(this.ObjLengthTable[compressedID], null);
                this.compressedObj = new CompressedObject(compressedID, 0);
                ObjectDecoder objDecoder = new ObjectDecoder(this);
                objDecoder.readDictionaryAsObject(this.compressedObj, 0, raw);
            }
            offsetStart = new HashMap();
            offsetEnd = new HashMap();
            First2 = this.compressedObj.getInt(960643930);
            compressedStream = this.compressedObj.getDecodedStream();
            CompressedObjects.extractCompressedObjectOffset(offsetStart, offsetEnd, First2, compressedStream, compressedID, this.offset);
            startID = (String)offsetStart.get(String.valueOf(objectID));
            Extends = this.compressedObj.getDictionary(894663815);
            if (Extends != null) continue;
        }
        if (!isCached) {
            this.lastCompressedStream = compressedStream;
            this.lastCompressedID = compressedID;
            this.lastOffsetStart = offsetStart;
            this.lastOffsetEnd = offsetEnd;
            this.lastFirst = First2;
        }
        int start = First2 + Integer.parseInt(startID);
        int end = compressedStream.length;
        String endID = (String)offsetEnd.get(String.valueOf(objectID));
        if (endID != null) {
            end = First2 + Integer.parseInt(endID);
        }
        int streamLength = end - start;
        raw = new byte[streamLength];
        System.arraycopy(compressedStream, start, raw, 0, streamLength);
        pdfObject.setInCompressedStream(true);
        return raw;
    }

    public final byte[] readStream(PdfObject pdfObject, boolean cacheValue, boolean decompress, boolean keepRaw, boolean isMetaData, boolean isCompressedStream, String cacheName) {
        byte[] stream;
        boolean debugStream = false;
        boolean isCachedOnDisk = pdfObject.isCached();
        byte[] data = null;
        if (!isCachedOnDisk) {
            data = pdfObject.getDecodedStream();
        }
        if (data == null) {
            block34: {
                block33: {
                    stream = pdfObject.stream;
                    if (isCachedOnDisk) {
                        try {
                            if (!(this.decryption == null || isCompressedStream || !this.decryption.getBooleanValue(102) && isMetaData)) {
                                this.decryption.decrypt(null, pdfObject.getObjectRefAsString(), false, cacheName, false, false);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            stream = null;
                            if (!LogWriter.isOutput()) break block33;
                            LogWriter.writeLog("Exception " + e);
                        }
                    }
                }
                if (stream != null) {
                    try {
                        if (!(this.decryption == null || isCompressedStream || !this.decryption.getBooleanValue(102) && isMetaData || pdfObject.getObjectType() == 2087749783 && pdfObject.getObjectRefAsString().startsWith("["))) {
                            stream = this.decryption.decrypt(stream, pdfObject.getObjectRefAsString(), false, null, false, false);
                        }
                    }
                    catch (PdfSecurityException e) {
                        stream = null;
                        if (!LogWriter.isOutput()) break block34;
                        LogWriter.writeLog("Exception " + e + " with " + pdfObject.getObjectRefAsString());
                    }
                }
            }
            if (keepRaw) {
                pdfObject.stream = null;
            }
            int length = 1;
            if (stream != null || isCachedOnDisk) {
                int newLength;
                int newW;
                int height = 1;
                int width = 1;
                int newH = pdfObject.getInt(959926393);
                if (newH != -1) {
                    height = newH;
                }
                if ((newW = pdfObject.getInt(959726687)) != -1) {
                    width = newW;
                }
                if ((newLength = pdfObject.getInt(1043816557)) != -1) {
                    length = newLength;
                }
                if (height * width == 1) {
                    width = length;
                }
                PdfArrayIterator filters = pdfObject.getMixedArray(1011108731);
                int firstValue = -1;
                if (filters != null && filters.hasMoreTokens()) {
                    firstValue = filters.getNextValueAsConstant(false);
                }
                if (filters != null && firstValue != -1 && firstValue != 1399277700 && firstValue != 1180911742) {
                    try {
                        PdfFilteredReader filter = new PdfFilteredReader();
                        stream = filter.decodeFilters(ObjectUtils.setupDecodeParms(pdfObject, this), stream, filters, width, height, cacheName);
                        pdfObject.setStreamMayBeCorrupt(filter.hasError());
                    }
                    catch (Exception e) {
                        if (LogWriter.isOutput()) {
                            LogWriter.writeLog("[PDF] Problem " + e + " decompressing stream ");
                        }
                        stream = null;
                        isCachedOnDisk = false;
                    }
                    length = 1;
                } else if (stream != null && length != -1 && length < stream.length) {
                    if (stream.length != length && length > 0) {
                        byte[] newStream = new byte[length];
                        System.arraycopy(stream, 0, newStream, 0, length);
                        stream = newStream;
                    } else if (stream.length == 1 && length == 0) {
                        stream = new byte[]{};
                    }
                }
            }
            if (stream != null && cacheValue) {
                pdfObject.setDecodedStream(stream);
            }
            if (decompress && isCachedOnDisk) {
                byte[] bytes;
                int streamLength;
                block35: {
                    streamLength = (int)new File(cacheName).length();
                    bytes = new byte[streamLength];
                    try {
                        new BufferedInputStream(new FileInputStream(cacheName)).read(bytes);
                    }
                    catch (Exception e) {
                        if (!LogWriter.isOutput()) break block35;
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                }
                if (length != 1 && length < streamLength) {
                    byte[] newStream = new byte[length];
                    System.arraycopy(bytes, 0, newStream, 0, length);
                    bytes = newStream;
                }
                return bytes;
            }
        } else {
            stream = data;
        }
        if (stream == null) {
            return null;
        }
        int len = stream.length;
        byte[] copy = new byte[len];
        System.arraycopy(stream, 0, copy, 0, len);
        return copy;
    }

    public int getPDFflag(Integer flag) {
        if (this.decryption == null) {
            return -1;
        }
        return this.decryption.getPDFflag(flag);
    }

    public void spoolStreamDataToDisk(File tmpFile, long start, int size) throws Exception {
        BufferedOutputStream array;
        block13: {
            this.movePointer(start);
            boolean hasValues = false;
            boolean startStreamFound = false;
            array = new BufferedOutputStream(new FileOutputStream(tmpFile));
            int bufSize = -1;
            int startStreamCount = 0;
            int realPos = 0;
            int XXX = 0x200000;
            boolean debug = false;
            if (bufSize < 1) {
                bufSize = 128;
            }
            int ptr = 0;
            int maxPtr = bufSize;
            byte[] readData = new byte[maxPtr];
            byte[] buffer = null;
            try {
                int i = bufSize - 1;
                int offset = -bufSize;
                while (true) {
                    if (++i == bufSize) {
                        long pointer = this.getPointer();
                        if (start == -1L) {
                            start = pointer;
                        }
                        if (pointer + (long)bufSize > this.eof) {
                            bufSize = (int)(this.eof - pointer);
                        }
                        buffer = new byte[bufSize += 6];
                        this.pdf_datafile.read(buffer);
                        offset += i;
                        i = 0;
                    }
                    void currentByte = buffer[i];
                    if (startStreamFound && (hasValues || currentByte != 13 && currentByte != 10)) {
                        array.write((int)currentByte);
                        hasValues = true;
                        ++realPos;
                    }
                    if (startStreamCount < 6 && currentByte == ObjectReader.startStream[startStreamCount]) {
                        if (++startStreamCount == 6) {
                            startStreamFound = true;
                        }
                    } else {
                        startStreamCount = 0;
                    }
                    if (realPos < size) {
                        readData[ptr] = currentByte;
                        if (++ptr != maxPtr) continue;
                        maxPtr = maxPtr < 0x200000 ? (maxPtr *= 2) : (maxPtr += 100000);
                        byte[] tmpArray = new byte[maxPtr];
                        System.arraycopy(readData, 0, tmpArray, 0, readData.length);
                        readData = tmpArray;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!LogWriter.isOutput()) break block13;
                LogWriter.writeLog("Exception " + e + " reading object");
            }
        }
        if (array != null) {
            array.flush();
            array.close();
        }
    }

    public void spoolStreamDataToDisk(File tmpFile, long start) throws Exception {
        BufferedOutputStream array;
        block19: {
            this.movePointer(start);
            boolean hasValues = false;
            array = new BufferedOutputStream(new FileOutputStream(tmpFile));
            int bufSize = -1;
            int startStreamCount = 0;
            boolean startStreamFound = false;
            int XXX = 0x200000;
            int rawSize = bufSize;
            int realPos = 0;
            boolean debug = false;
            boolean lengthSet = false;
            if (bufSize < 1) {
                bufSize = 128;
            }
            int ptr = 0;
            int maxPtr = bufSize;
            byte[] readData = new byte[maxPtr];
            int charReached = 0;
            int charReached3 = 0;
            byte[] buffer = null;
            try {
                int i = bufSize - 1;
                int offset = -bufSize;
                while (true) {
                    if (++i == bufSize) {
                        long pointer = this.getPointer();
                        if (start == -1L) {
                            start = pointer;
                        }
                        if (pointer + (long)bufSize > this.eof) {
                            bufSize = (int)(this.eof - pointer);
                        }
                        buffer = new byte[bufSize += 6];
                        this.pdf_datafile.read(buffer);
                        offset += i;
                        i = 0;
                    }
                    void currentByte = buffer[i];
                    boolean ignoreByte = false;
                    charReached = currentByte == ObjectDecoder.endPattern[charReached] ? ++charReached : 0;
                    int charReached2 = 0;
                    if (startStreamFound && (hasValues || currentByte != 13 && currentByte != 10)) {
                        array.write((int)currentByte);
                        hasValues = true;
                    }
                    startStreamCount = startStreamCount < 6 && currentByte == ObjectReader.startStream[startStreamCount] ? ++startStreamCount : 0;
                    if (!startStreamFound && startStreamCount == 6) {
                        startStreamFound = true;
                    }
                    if (!lengthSet) {
                        if (rawSize != -1 && currentByte == ObjectReader.lengthString[charReached3]) {
                            if (++charReached3 == 6) {
                                lengthSet = true;
                            }
                        } else {
                            charReached3 = 0;
                        }
                    }
                    if (charReached == 6 || charReached2 == 4) {
                        if (!lengthSet) break;
                        charReached = 0;
                    }
                    if (!lengthSet || realPos < rawSize) {
                        if (!ignoreByte) {
                            readData[ptr] = currentByte;
                            if (++ptr == maxPtr) {
                                maxPtr = maxPtr < 0x200000 ? (maxPtr *= 2) : (maxPtr += 100000);
                                byte[] tmpArray = new byte[maxPtr];
                                System.arraycopy(readData, 0, tmpArray, 0, readData.length);
                                readData = tmpArray;
                            }
                        }
                        ++realPos;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!LogWriter.isOutput()) break block19;
                LogWriter.writeLog("Exception " + e + " reading object");
            }
        }
        if (array != null) {
            array.flush();
            array.close();
        }
    }

    void closeFile() throws IOException {
        if (this.pdf_datafile != null) {
            this.pdf_datafile.close();
            this.pdf_datafile = null;
        }
    }

    public long getOffset(int currentID) {
        return this.offset.elementAt(currentID);
    }

    public byte[] getBytes(long start, int count) {
        byte[] buffer;
        block2: {
            buffer = new byte[count];
            this.movePointer(start);
            try {
                this.pdf_datafile.read(buffer);
            }
            catch (IOException e) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        return buffer;
    }

    public void storeLinearizedTables(LinearizedHintTable linHintTable) {
        this.linHintTable = linHintTable;
    }

    public void dispose() {
        block7: {
            if (this.decryption != null) {
                this.decryption.flush();
                this.decryption.dispose();
            }
            if (this.decryption != null) {
                this.decryption.cipher = null;
            }
            this.decryption = null;
            this.compressedObj = null;
            if (this.linHintTable != null) {
                this.linHintTable = null;
            }
            this.offset = null;
            try {
                if (this.pdf_datafile != null) {
                    this.pdf_datafile.close();
                }
            }
            catch (IOException e) {
                if (!LogWriter.isOutput()) break block7;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        this.pdf_datafile = null;
        if (this.offset != null) {
            this.offset.dispose();
        }
    }

    public final String getType() {
        String pdf_type;
        block3: {
            pdf_type = "";
            try {
                this.movePointer(0L);
                pdf_type = this.pdf_datafile.readLine();
                int pos = pdf_type.indexOf("%PDF");
                if (pos != -1) {
                    pdf_type = pdf_type.substring(pos + 5);
                }
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block3;
                LogWriter.writeLog("Exception " + e + " in reading type");
            }
        }
        return pdf_type;
    }

    public void movePointer(long pointer) {
        block5: {
            try {
                if (pointer > this.pdf_datafile.length()) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Attempting to access ref outside file");
                    }
                } else {
                    this.pdf_datafile.seek(pointer);
                }
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block5;
                LogWriter.writeLog("Exception " + e + " moving pointer to  " + pointer + " in file.");
            }
        }
    }

    private long getPointer() {
        long old_pointer;
        block2: {
            old_pointer = 0L;
            try {
                old_pointer = this.pdf_datafile.getFilePointer();
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception " + e + " getting pointer in file");
            }
        }
        return old_pointer;
    }

    public final boolean isCompressed(int ref, int gen) {
        return this.offset.isCompressed(ref);
    }

    public DecryptionFactory getDecryptionObject() {
        return this.decryption;
    }

    public void setPassword(String password) {
        this.encryptionPassword = password.getBytes();
        if (this.decryption != null) {
            this.decryption.reset(this.encryptionPassword);
        }
    }

    public byte[] readObjectData(PdfObject pdfObject) {
        byte[] raw;
        byte[] data;
        String objectRef = pdfObject.getObjectRefAsString();
        int id = pdfObject.getObjectRefID();
        if (pdfObject.isDataExternal() && (data = this.readObjectAsByteArray(pdfObject, false, id, 0)) == null) {
            pdfObject.setFullyResolved(false);
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (15)");
            }
            return data;
        }
        boolean debug = false;
        boolean isCompressed = this.offset.isCompressed(id);
        pdfObject.setCompressedStream(isCompressed);
        if (isCompressed) {
            raw = this.readCompressedObjectData(pdfObject, this.offset);
        } else {
            this.movePointer(this.offset.elementAt(id));
            if (objectRef.charAt(0) == '<') {
                raw = this.objectReader.readObjectData(-1, pdfObject);
            } else if (this.ObjLengthTable == null || this.offset.isRefTableInvalid()) {
                raw = this.getPointer() == 0L ? new byte[]{} : this.objectReader.readObjectData(-1, pdfObject);
            } else if (id > this.ObjLengthTable.length || this.ObjLengthTable[id] == 0) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog(objectRef + " cannot have offset 0");
                }
                raw = new byte[]{};
            } else {
                raw = this.objectReader.readObjectData(this.ObjLengthTable[id], pdfObject);
            }
        }
        return raw;
    }

    private byte[] readCompressedObjectData(PdfObject pdfObject, Offsets offset) {
        byte[] raw;
        int objectID = pdfObject.getObjectRefID();
        int compressedID = offset.elementAt(objectID);
        String startID = null;
        int First2 = this.lastFirst;
        boolean isCached = true;
        byte[] compressedStream = this.lastCompressedStream;
        HashMap offsetStart = this.lastOffsetStart;
        HashMap offsetEnd = this.lastOffsetEnd;
        PdfObject Extends = null;
        if (this.lastOffsetStart != null) {
            startID = (String)this.lastOffsetStart.get(String.valueOf(objectID));
        }
        while (startID == null) {
            if (Extends != null) {
                this.compressedObj = Extends;
            } else if (compressedID != this.lastCompressedID) {
                isCached = false;
                this.movePointer(offset.elementAt(compressedID));
                raw = this.objectReader.readObjectData(this.ObjLengthTable[compressedID], null);
                this.compressedObj = new CompressedObject(compressedID, 0);
                ObjectDecoder objDecoder = new ObjectDecoder(this);
                objDecoder.readDictionaryAsObject(this.compressedObj, 0, raw);
            }
            offsetStart = new HashMap();
            offsetEnd = new HashMap();
            First2 = this.compressedObj.getInt(960643930);
            compressedStream = this.compressedObj.getDecodedStream();
            CompressedObjects.extractCompressedObjectOffset(offsetStart, offsetEnd, First2, compressedStream, compressedID, offset);
            startID = (String)offsetStart.get(String.valueOf(objectID));
            Extends = this.compressedObj.getDictionary(894663815);
            if (Extends != null) continue;
        }
        if (!isCached) {
            this.lastCompressedStream = compressedStream;
            this.lastCompressedID = compressedID;
            this.lastOffsetStart = offsetStart;
            this.lastOffsetEnd = offsetEnd;
            this.lastFirst = First2;
        }
        int start = First2 + Integer.parseInt(startID);
        int end = compressedStream.length;
        String endID = (String)offsetEnd.get(String.valueOf(objectID));
        if (endID != null) {
            end = First2 + Integer.parseInt(endID);
        }
        int streamLength = end - start;
        raw = new byte[streamLength];
        System.arraycopy(compressedStream, start, raw, 0, streamLength);
        pdfObject.setInCompressedStream(true);
        return raw;
    }

    public byte[] readObjectAsByteArray(PdfObject pdfObject, boolean isCompressed, int objectID, int gen) {
        byte[] raw = null;
        if (this.linHintTable != null) {
            raw = this.linHintTable.getObjData(objectID);
        }
        if (raw == null) {
            if (isCompressed) {
                raw = this.readCompressedObjectAsByteArray(pdfObject, objectID, gen);
            } else {
                this.movePointer(this.offset.elementAt(objectID));
                if (this.ObjLengthTable == null || this.offset.isRefTableInvalid()) {
                    raw = this.objectReader.readObjectData(-1, pdfObject);
                } else {
                    if (objectID > this.ObjLengthTable.length) {
                        return null;
                    }
                    raw = this.objectReader.readObjectData(this.ObjLengthTable[objectID], pdfObject);
                }
            }
        }
        int j = 0;
        if (raw.length > 15) {
            for (int i2 = 0; i2 < 10 && (raw[i2] != 111 || raw[i2 + 1] != 98 || raw[i2 + 2] != 106); ++i2) {
                if (raw[i2] != 101 || raw[i2 + 1] != 110 || raw[i2 + 2] != 100 || raw[i2 + 3] != 111 || raw[i2 + 4] != 98 || raw[i2 + 5] != 106) continue;
                j = i2 + 6;
                this.objectReader.fileIsBroken = true;
                break;
            }
        }
        while (raw[j] == 10 || raw[j] == 12 || raw[j] == 32) {
            ++j;
        }
        if (j > 0) {
            byte[] oldBuffer = raw;
            int newLength = raw.length - j;
            raw = new byte[newLength];
            System.arraycopy(oldBuffer, j, raw, 0, newLength);
        }
        return raw;
    }

    private byte[] readCompressedObjectAsByteArray(PdfObject pdfObject, int objectID, int gen) {
        byte[] raw;
        int compressedID = this.offset.elementAt(objectID);
        String startID = null;
        HashMap offsetStart = this.lastOffsetStart;
        HashMap offsetEnd = this.lastOffsetEnd;
        int First2 = this.lastFirst;
        boolean isCached = true;
        byte[] compressedStream = this.lastCompressedStream;
        if (this.lastOffsetStart != null) {
            startID = (String)this.lastOffsetStart.get(String.valueOf(objectID));
        }
        int lastCompressedID = -1;
        while (startID == null) {
            block7: {
                isCached = false;
                if (lastCompressedID == compressedID) {
                    throw new RuntimeException("Compressed Object stream corrupted - PDF file broken");
                }
                try {
                    this.pdf_datafile.seek(this.offset.elementAt(compressedID));
                }
                catch (IOException e) {
                    if (!LogWriter.isOutput()) break block7;
                    LogWriter.writeLog("Exception " + e + " moving pointer in file.");
                }
            }
            lastCompressedID = compressedID;
            raw = this.objectReader.readObjectData(this.ObjLengthTable[compressedID], null);
            String compref = compressedID + " " + gen + " R";
            CompressedObject compressedObj = new CompressedObject(compref);
            ObjectDecoder objDecoder = new ObjectDecoder(this);
            objDecoder.readDictionaryAsObject(compressedObj, 0, raw);
            offsetStart = new HashMap();
            offsetEnd = new HashMap();
            First2 = ((PdfObject)compressedObj).getInt(960643930);
            compressedStream = compressedObj.getDecodedStream();
            CompressedObjects.extractCompressedObjectOffset(offsetStart, offsetEnd, First2, compressedStream, compressedID, this.offset);
            startID = (String)offsetStart.get(String.valueOf(objectID));
            PdfObject Extends = ((PdfObject)compressedObj).getDictionary(894663815);
            String compressedRef = Extends == null ? null : Extends.getObjectRefAsString();
            if (compressedRef == null) continue;
            compressedID = Integer.parseInt(compressedRef.substring(0, compressedRef.indexOf(32)));
        }
        if (!isCached) {
            this.lastCompressedStream = compressedStream;
            this.lastOffsetStart = offsetStart;
            this.lastOffsetEnd = offsetEnd;
            this.lastFirst = First2;
        }
        int start = First2 + Integer.parseInt(startID);
        int end = compressedStream.length;
        String endID = (String)offsetEnd.get(String.valueOf(objectID));
        if (endID != null) {
            end = First2 + Integer.parseInt(endID);
        }
        int streamLength = end - start;
        raw = new byte[streamLength];
        System.arraycopy(compressedStream, start, raw, 0, streamLength);
        pdfObject.setInCompressedStream(true);
        return raw;
    }

    public byte[] readPageIntoStream(PdfObject pdfObject) {
        byte[][] pageContents = pdfObject.getKeyArray(1216184967);
        byte[] binary_data = new byte[]{};
        if (pageContents == null || pageContents != null && pageContents.length > 0 && pageContents[0] == null) {
            return binary_data;
        }
        if (pageContents != null) {
            int count = pageContents.length;
            for (int ii = 0; ii < count; ++ii) {
                StreamObject streamData = new StreamObject(new String(pageContents[ii]));
                streamData.isDataExternal(pdfObject.isDataExternal());
                this.readObject(streamData);
                byte[] decoded_stream_data = streamData.getDecodedStream();
                binary_data = ii == 0 && decoded_stream_data != null ? decoded_stream_data : PdfFileReader.appendData(binary_data, decoded_stream_data);
            }
        }
        return binary_data;
    }

    static byte[] appendData(byte[] binary_data, byte[] decoded_stream_data) {
        if (decoded_stream_data != null) {
            int current_length = binary_data.length + 1;
            int processed_length = decoded_stream_data.length;
            if (processed_length > 0) {
                while (decoded_stream_data[processed_length - 1] == 0) {
                    --processed_length;
                }
                byte[] temp = new byte[current_length];
                System.arraycopy(binary_data, 0, temp, 0, current_length - 1);
                temp[current_length - 1] = 32;
                binary_data = new byte[current_length + processed_length];
                System.arraycopy(temp, 0, binary_data, 0, current_length);
                System.arraycopy(decoded_stream_data, 0, binary_data, current_length, processed_length);
            }
        }
        return binary_data;
    }

    public void setCertificate(Certificate certificate, PrivateKey key) {
        this.certificate = certificate;
        this.key = key;
    }

    public final PdfObject readReferenceTable(PdfObject linearObj) throws PdfException {
        PdfObject rootObj = this.refTable.readReferenceTable(linearObj, this, this.objectReader);
        PdfObject encryptObj = this.refTable.getEncryptionObject();
        if (encryptObj != null) {
            this.setupDecryption(encryptObj);
        }
        this.ObjLengthTable = this.offset.calculateObjectLength((int)this.eof);
        return rootObj;
    }

    public void setupDecryption(PdfObject encryptObj) throws PdfSecurityException {
        try {
            byte[] ID2 = this.refTable.getID();
            this.decryption = this.certificate != null ? new DecryptionFactory(ID2, this.certificate, this.key) : new DecryptionFactory(ID2, this.encryptionPassword);
            if (this.encyptionObj == null) {
                this.encyptionObj = new EncryptionObject(new String(encryptObj.getUnresolvedData()));
                this.readObject(this.encyptionObj);
            }
            this.decryption.readEncryptionObject(this.encyptionObj);
        }
        catch (Error err) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("No Bouncy castle on classpath " + err);
            }
            throw new RuntimeException("This PDF file is encrypted and JPedal needs an additional library to \ndecode on the classpath (we recommend bouncycastle library).\nThere is additional explanation at http://www.idrsolutions.com/additional-jars\n");
        }
    }
}

