/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.security.Key;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import org.jpedal.io.CertificateReader;
import org.jpedal.utils.LogWriter;

public class SetSecurity {
    private static String altSP;

    public static void init() {
        altSP = System.getProperty("org.jpedal.securityprovider");
        if (altSP == null) {
            altSP = "org.bouncycastle.jce.provider.BouncyCastleProvider";
        }
        try {
            Class<?> c = Class.forName(altSP);
            Provider provider = (Provider)c.newInstance();
            Security.addProvider(provider);
        }
        catch (Exception e) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Unable to run custom security provider " + altSP + " Exception " + e);
            }
            throw new RuntimeException("This PDF file is encrypted and JPedal needs an additional library to \ndecode on the classpath (we recommend bouncycastle library).\nThere is additional explanation at http://www.idrsolutions.com/additional-jars\n");
        }
    }

    public static byte[] extractCertificateData(byte[][] recipients, Certificate certificate, Key key) {
        if (altSP == null || !altSP.equals("org.bouncycastle.jce.provider.BouncyCastleProvider")) {
            throw new RuntimeException("only Bouncy castle currently supported with certificates");
        }
        return CertificateReader.readCertificate(recipients, certificate, key);
    }
}

