/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import org.jpedal.exception.PdfSecurityException;
import org.jpedal.io.DecryptionFactory;
import org.jpedal.utils.LogWriter;

public class ArrayUtils {
    static boolean handleIndirect(int endPoint, byte[] raw, int aa) {
        boolean indirect = true;
        int length = raw.length;
        while (raw[aa] != 93 && ++aa < endPoint && aa < length && (raw[aa] != 82 || raw[aa - 1] != 32 && raw[aa - 1] != 10 && raw[aa - 1] != 13)) {
            if (raw[aa] == 62 && raw[aa - 1] == 62) {
                indirect = false;
                break;
            }
            if (raw[aa] != 47) continue;
            indirect = false;
            break;
        }
        return indirect;
    }

    static int skipToEndOfRef(int i, byte[] raw) {
        byte b = raw[i];
        while (b != 10 && b != 13 && b != 32 && b != 47 && b != 60 && b != 62) {
            b = raw[++i];
        }
        return i;
    }

    public static int skipComment(byte[] raw, int i) {
        while (raw[i] != 10 && raw[i] != 13) {
            ++i;
        }
        while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 9) {
            ++i;
        }
        return i;
    }

    static byte[] handleHexString(byte[] newValues, DecryptionFactory decryptor, String ref) {
        String str = new String(newValues);
        byte[] IDbytes = new byte[newValues.length / 2];
        for (int ii = 0; ii < newValues.length; ii += 2) {
            if (ii + 2 > newValues.length) continue;
            if (str.charAt(ii) == '\n') {
                ++ii;
            }
            String nextValue = str.substring(ii, ii + 2);
            IDbytes[ii / 2] = (byte)Integer.parseInt(nextValue, 16);
        }
        newValues = IDbytes;
        if (decryptor != null) {
            byte[] decryptedValue;
            block5: {
                decryptedValue = null;
                try {
                    decryptedValue = decryptor.decryptString(IDbytes, ref);
                }
                catch (PdfSecurityException ex) {
                    if (!LogWriter.isOutput()) break block5;
                    LogWriter.writeLog("Exception: " + ex.getMessage());
                }
            }
            newValues = decryptedValue == null ? IDbytes : decryptedValue;
        }
        return newValues;
    }

    public static int skipSpaces(byte[] data, int start) {
        while (data[start] == 10 || data[start] == 13 || data[start] == 32) {
            ++start;
        }
        return start;
    }
}

