/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import org.jpedal.exception.PdfSecurityException;
import org.jpedal.io.RandomAccessBuffer;
import org.jpedal.io.types.Offsets;
import org.jpedal.utils.LogWriter;

public class BrokenRefTable {
    public static String findOffsets(RandomAccessBuffer pdf_datafile, Offsets offset) throws PdfSecurityException {
        String root_id;
        block10: {
            int i;
            String line;
            block8: {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Corrupt xref table - trying to find objects manually");
                }
                root_id = "";
                line = null;
                i = 0;
                try {
                    pdf_datafile.seek(0L);
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) break block8;
                    LogWriter.writeLog("Exception " + e + " reading line");
                }
            }
            while (true) {
                int pointer;
                block9: {
                    try {
                        i = (int)pdf_datafile.getFilePointer();
                        line = pdf_datafile.readLine();
                    }
                    catch (Exception e) {
                        if (!LogWriter.isOutput()) break block9;
                        LogWriter.writeLog("Exception " + e + " reading line");
                    }
                }
                if (line == null) break block10;
                if (line.contains(" obj")) {
                    pointer = line.indexOf(32);
                    if (pointer <= 0) continue;
                    offset.storeObjectOffset(Integer.parseInt(line.substring(0, pointer)), i, 1, false, true);
                    continue;
                }
                if (line.contains("/Root")) {
                    int start = line.indexOf("/Root") + 5;
                    pointer = line.indexOf(82, start);
                    if (pointer <= -1) continue;
                    root_id = line.substring(start, pointer + 1).trim();
                    continue;
                }
                if (line.contains("/Encrypt")) break;
            }
            throw new PdfSecurityException("Corrupted, encrypted file");
        }
        return root_id;
    }
}

