/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import org.jpedal.exception.PdfSecurityException;
import org.jpedal.io.DecryptionFactory;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.ObjectUtils;
import org.jpedal.io.PdfFileReader;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;
import org.jpedal.utils.StringUtils;

public class Name {
    public static int setNameTreeValue(PdfObject pdfObject, int i, byte[] raw, int length, boolean ignoreRecursion, int PDFkeyInt, PdfFileReader objectReader) {
        boolean isRef = false;
        while (raw[i] != 91) {
            if (raw[i] == 40) {
                isRef = false;
                break;
            }
            if (raw[i] >= 48 && raw[i] <= 57) {
                isRef = true;
                break;
            }
            ++i;
        }
        byte[] data = raw;
        int start = i;
        int j = i;
        int count = 0;
        if (isRef) {
            int keyStart2 = i;
            while (raw[i] != 10 && raw[i] != 13 && raw[i] != 32 && raw[i] != 47 && raw[i] != 60 && raw[i] != 62) {
                ++i;
            }
            int number = NumberUtils.parseInt(keyStart2, i, raw);
            while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47 || raw[i] == 60) {
                ++i;
            }
            keyStart2 = i;
            while (raw[i] != 10 && raw[i] != 13 && raw[i] != 32 && raw[i] != 47 && raw[i] != 60 && raw[i] != 62) {
                ++i;
            }
            int generation = NumberUtils.parseInt(keyStart2, i, raw);
            while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47 || raw[i] == 60) {
                ++i;
            }
            if (raw[i] != 82) {
                throw new RuntimeException("3. Unexpected value in file " + raw[i] + " - please send to IDRsolutions for analysis");
            }
            if (!ignoreRecursion) {
                data = objectReader.readObjectAsByteArray(pdfObject, objectReader.isCompressed(number, generation), number, generation);
                if (data == null) {
                    pdfObject.setFullyResolved(false);
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (1)");
                    }
                    i = length;
                    return i;
                }
                j = 3;
                while (data[j - 1] != 106 && data[j - 2] != 98 && data[j - 3] != 111 && data[j - 3] != 60) {
                    ++j;
                }
                while (data[j] == 10 || data[j] == 13 || data[j] == 32) {
                    ++j;
                }
                start = j;
            }
        }
        while (j < data.length) {
            if (data[j] == 91 || data[j] == 40) {
                ++count;
            } else if (data[j] == 93 || data[j] == 41) {
                --count;
            }
            if (count == 0) break;
            ++j;
        }
        if (!ignoreRecursion) {
            byte[] newString;
            block23: {
                DecryptionFactory decryption;
                int stringLength = j - start + 1;
                newString = new byte[stringLength];
                System.arraycopy(data, start, newString, 0, stringLength);
                if (pdfObject.getObjectType() != 1113489015 && (decryption = objectReader.getDecryptionObject()) != null) {
                    try {
                        newString = decryption.decrypt(newString, pdfObject.getObjectRefAsString(), false, null, false, false);
                    }
                    catch (PdfSecurityException e) {
                        if (!LogWriter.isOutput()) break block23;
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                }
            }
            pdfObject.setTextStreamValue(PDFkeyInt, newString);
        }
        if (!isRef) {
            i = j;
        }
        return i;
    }

    public static int setNameStringValue(PdfObject pdfObject, int i, byte[] raw, boolean isMap, Object PDFkey, int PDFkeyInt, PdfFileReader objectReader) {
        byte[] stringBytes;
        while (raw[i] != 10 && raw[i] != 13 && raw[i] != 32 && raw[i] != 47 && raw[i] != 40 && raw[i] != 60) {
            ++i;
        }
        while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32) {
            ++i;
        }
        int j2 = i;
        byte[] arrayData = raw;
        boolean isIndirect = raw[i] != 47 && raw[i] != 40 && raw[i] != 60;
        boolean startsWithBrace = raw[i] == 40;
        boolean isInsideArray = false;
        if (isIndirect) {
            int aa;
            for (aa = i + 1; aa < raw.length && (raw[aa] == 10 || raw[aa] == 13 || raw[aa] == 32); ++aa) {
            }
            if (raw[aa] == 47 || raw[aa] == 93) {
                isIndirect = false;
                i = aa + 1;
                isInsideArray = true;
            }
        }
        if (isIndirect) {
            int keyStart = i;
            while (raw[i] != 10 && raw[i] != 13 && raw[i] != 32 && raw[i] != 47 && raw[i] != 60 && raw[i] != 62) {
                ++i;
            }
            int ref = NumberUtils.parseInt(keyStart, i, raw);
            while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47 || raw[i] == 60) {
                ++i;
            }
            keyStart = i;
            while (raw[i] != 10 && raw[i] != 13 && raw[i] != 32 && raw[i] != 47 && raw[i] != 60 && raw[i] != 62) {
                ++i;
            }
            int generation = NumberUtils.parseInt(keyStart, i, raw);
            while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47 || raw[i] == 60) {
                ++i;
            }
            if (raw[i] != 82) {
                throw new RuntimeException(ObjectDecoder.padding + "2. Unexpected value in file - please send to IDRsolutions for analysis");
            }
            arrayData = objectReader.readObjectAsByteArray(pdfObject, objectReader.isCompressed(ref, generation), ref, generation);
            if (arrayData == null) {
                pdfObject.setFullyResolved(false);
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (13)");
                }
                return raw.length;
            }
            if (arrayData[0] == 47) {
                j2 = 0;
            } else {
                j2 = 3;
                while (arrayData[j2] != 47) {
                    ++j2;
                }
            }
        }
        if (arrayData[++j2] == 47) {
            return j2 - 1;
        }
        int end = j2 + 1;
        if (isInsideArray) {
            while (arrayData[j2] == 10 || arrayData[j2] == 13 || arrayData[j2] == 32 || arrayData[j2] == 47) {
                ++j2;
            }
            int slashes = 0;
            int lastChar = 0;
            while (arrayData[end] != 93) {
                if (arrayData[end] == 47 && (lastChar == 32 || lastChar == 10 || lastChar == 13)) {
                    ++slashes;
                }
                lastChar = arrayData[end];
                if (++end != arrayData.length) continue;
            }
            int charCount = end - slashes;
            int ptr = 0;
            stringBytes = new byte[charCount - j2];
            int previous = 0;
            for (int ii = j2; ii < charCount; ++ii) {
                int nextChar = arrayData[ii];
                if (nextChar == 47) {
                    if (previous != 32 && previous != 10 && previous != 13) {
                        stringBytes[ptr] = 32;
                        ++ptr;
                    }
                } else {
                    stringBytes[ptr] = nextChar;
                    ++ptr;
                }
                previous = nextChar;
            }
        } else {
            while (!(!startsWithBrace ? arrayData[end] == 32 || arrayData[end] == 10 || arrayData[end] == 13 || arrayData[end] == 47 || arrayData[end] == 62 : arrayData[end] == 41 && !ObjectUtils.isEscaped(arrayData, end))) {
                if (++end != arrayData.length) continue;
            }
            int charCount = end - j2;
            stringBytes = new byte[charCount];
            System.arraycopy(arrayData, j2, stringBytes, 0, charCount);
        }
        if (isMap) {
            pdfObject.setName(PDFkey, StringUtils.getTextString(stringBytes, false));
        } else {
            pdfObject.setName(PDFkeyInt, stringBytes);
        }
        if (!isIndirect) {
            i = end - 1;
        }
        return i;
    }
}

