/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import java.io.IOException;
import org.jpedal.io.ObjectUtils;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.RandomAccessBuffer;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class ObjectReader {
    public boolean fileIsBroken;
    static final byte[] endPattern = new byte[]{101, 110, 100, 111, 98, 106};
    public static final byte[] lengthString = new byte[]{47, 76, 101, 110, 103, 116, 104};
    public static final byte[] startStream = new byte[]{115, 116, 114, 101, 97, 109};
    private final RandomAccessBuffer pdf_datafile;
    private int newCacheSize = -1;
    private final long eof;
    final PdfFileReader currentPdfFile;

    public ObjectReader(RandomAccessBuffer pdf_datafile, long eof, PdfFileReader currentPdfFile) {
        this.pdf_datafile = pdf_datafile;
        this.eof = eof;
        this.currentPdfFile = currentPdfFile;
    }

    public byte[] readObjectData(int bufSize, PdfObject pdfObject) {
        if (bufSize < 1 || this.newCacheSize != -1 || this.fileIsBroken) {
            return this.readObjectDataXX(bufSize, pdfObject);
        }
        byte[] dataRead = null;
        if (bufSize > 0) {
            dataRead = new byte[bufSize += 6];
            try {
                this.pdf_datafile.read(dataRead);
            }
            catch (IOException ex) {
                LogWriter.writeLog("Unable to fill buffer " + ex);
            }
        }
        return dataRead;
    }

    private byte[] readObjectDataXX(int bufSize, PdfObject pdfObject) {
        int newCacheSize = -1;
        int startStreamCount = 0;
        int charReached = 0;
        int charReached3 = 0;
        boolean startStreamFound = false;
        boolean reachedCacheLimit = false;
        boolean inStream = false;
        boolean inLoop = true;
        long start = this.getPointer();
        if (pdfObject != null) {
            newCacheSize = this.newCacheSize;
        }
        int rawSize = bufSize;
        int realPos = 0;
        boolean lengthSet = false;
        if (bufSize < 1) {
            bufSize = 128;
        }
        if (newCacheSize != -1 && bufSize > newCacheSize) {
            bufSize = newCacheSize;
        }
        byte[] dataRead = null;
        int i = bufSize - 1;
        while (inLoop) {
            byte currentByte;
            if (++i == bufSize) {
                long pointer = this.getPointer();
                if (pointer + (long)bufSize > this.eof) {
                    bufSize = (int)(this.eof - pointer);
                }
                if (bufSize == 0) break;
                byte[] buffer = new byte[bufSize += 6];
                try {
                    this.pdf_datafile.read(buffer);
                }
                catch (IOException ex) {
                    LogWriter.writeLog("Unable to fill buffer " + ex);
                }
                if (dataRead == null) {
                    int j = 0;
                    for (int i2 = 0; i2 < 10; ++i2) {
                        if (buffer[i2] != 101 || buffer[i2 + 1] != 110 || buffer[i2 + 2] != 100 || buffer[i2 + 3] != 111 || buffer[i2 + 4] != 98 || buffer[i2 + 5] != 106) continue;
                        j = i2;
                        break;
                    }
                    while (buffer[j] == 101 || buffer[j] == 110 || buffer[j] == 100 || buffer[j] == 111 || buffer[j] == 98 || buffer[j] == 106) {
                        ++j;
                    }
                    if (j > 0) {
                        byte[] oldBuffer = buffer;
                        int newLength = buffer.length - j;
                        buffer = new byte[newLength];
                        System.arraycopy(oldBuffer, j, buffer, 0, newLength);
                        bufSize = buffer.length;
                    }
                    dataRead = buffer;
                } else {
                    dataRead = ObjectReader.appendDataBlock(buffer.length, buffer, dataRead);
                }
                i = 0;
            }
            charReached = (currentByte = dataRead[realPos]) == endPattern[charReached] ? ++charReached : 0;
            if (!startStreamFound && newCacheSize != -1 && !reachedCacheLimit) {
                if (startStreamCount < 6 && currentByte == startStream[startStreamCount]) {
                    if (++startStreamCount == 6) {
                        startStreamFound = true;
                    }
                } else {
                    startStreamCount = 0;
                }
            }
            if (startStreamFound && dataRead != null && dataRead.length > newCacheSize) {
                pdfObject.setCache(start, this.currentPdfFile);
                reachedCacheLimit = true;
            }
            if (!startStreamFound && !lengthSet && rawSize != -1) {
                if (currentByte == lengthString[charReached3]) {
                    if (++charReached3 == 6) {
                        lengthSet = true;
                    }
                } else {
                    charReached3 = 0;
                }
            }
            ++realPos;
            if (charReached == 6) {
                if (!lengthSet) {
                    inLoop = false;
                }
                charReached = 0;
            }
            if (!lengthSet || realPos <= rawSize) continue;
            inLoop = false;
        }
        if (!lengthSet) {
            dataRead = ObjectUtils.checkEndObject(dataRead);
        }
        return dataRead;
    }

    static byte[] appendDataBlock(int newBytes, byte[] buffer, byte[] dataRead) {
        int bytesRead = dataRead.length;
        byte[] tmp = new byte[bytesRead + newBytes];
        System.arraycopy(dataRead, 0, tmp, 0, bytesRead);
        System.arraycopy(buffer, 0, tmp, bytesRead, newBytes);
        return tmp;
    }

    private long getPointer() {
        long old_pointer;
        block2: {
            old_pointer = 0L;
            try {
                old_pointer = this.pdf_datafile.getFilePointer();
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception " + e + " getting pointer in file");
            }
        }
        return old_pointer;
    }

    public void setCacheSize(int miniumumCacheSize) {
        this.newCacheSize = miniumumCacheSize;
    }
}

