/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import org.jpedal.io.DecryptionFactory;
import org.jpedal.io.PdfFileReader;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;

public class Stream {
    public static void readStreamData(PdfObject pdfObject, int i, byte[] raw, int length, PdfFileReader objectReader) {
        for (int xx = i; xx < length - 5 && (raw[xx] != 62 || raw[xx + 1] != 62); ++xx) {
            if (raw[xx] != 115 || raw[xx + 1] != 116 || raw[xx + 2] != 114 || raw[xx + 3] != 101 || raw[xx + 4] != 97 || raw[xx + 5] != 109) continue;
            if (!pdfObject.isCached()) {
                Stream.readStreamIntoObject(pdfObject, xx, raw, objectReader);
            }
            xx = length;
        }
    }

    public static void readStreamIntoObject(PdfObject pdfObject, int j, byte[] data, PdfFileReader objectReader) {
        DecryptionFactory decryption = objectReader.getDecryptionObject();
        int count = data.length;
        byte[] stream = null;
        PdfArrayIterator maskFilters = pdfObject.getMixedArray(1011108731);
        boolean isJBigEncoded = false;
        int firstMaskValue = -1;
        if (maskFilters != null && maskFilters.hasMoreTokens()) {
            firstMaskValue = maskFilters.getNextValueAsConstant(true);
            if (firstMaskValue == 1247500931) {
                isJBigEncoded = true;
            }
            while (maskFilters.hasMoreTokens() && !isJBigEncoded) {
                firstMaskValue = maskFilters.getNextValueAsConstant(true);
                if (firstMaskValue != 1247500931) continue;
                isJBigEncoded = true;
            }
        }
        for (int a = j; a < count; ++a) {
            int ptr;
            if (data[a] != 115 || data[a + 1] != 116 || data[a + 2] != 114 || data[a + 3] != 101 || data[a + 4] != 97 || data[a + 5] != 109) continue;
            a += 6;
            while (data[a] == 32) {
                ++a;
            }
            if (data[a] == 13 && data[a + 1] == 10) {
                a += 2;
            } else if (data[a] == 10 && data[a + 1] == 10 && data[a + 2] == 10 && data[a + 3] == -1 && firstMaskValue == 1180911742) {
                a += 3;
            } else if (data[a] == 10 && data[a + 1] == 10 && data[a + 2] == -1 && firstMaskValue == 1180911742) {
                a += 2;
            } else if (data[a] == 10 || data[a] == 13) {
                // empty if block
            }
            int start = ++a;
            --a;
            int streamLength = 0;
            int setStreamLength = pdfObject.getInt(1043816557);
            boolean isValid = false;
            if (setStreamLength != -1) {
                streamLength = setStreamLength;
                a = start + streamLength;
                if (a < count && data[a] == 13 && a + 1 < count && data[a + 1] == 10) {
                    a += 2;
                }
                if (count <= a + 9 || data[a] != 101 || data[a + 1] != 110 || data[a + 2] != 100 || data[a + 3] != 115 || data[a + 4] != 116 || data[a + 5] != 114 || data[a + 6] != 101 || data[a + 7] != 97 || data[a + 8] != 109) {
                    int current = a;
                    if (a < count) {
                        while (!isValid && ++a != count) {
                            if (count - a <= 9 || data[a] != 101 || data[a + 1] != 110 || data[a + 2] != 100 || data[a + 3] != 115 || data[a + 4] != 116 || data[a + 5] != 114 || data[a + 6] != 101 || data[a + 7] != 97 || data[a + 8] != 109) continue;
                            streamLength = a - start;
                            isValid = true;
                        }
                    }
                    if (!isValid) {
                        a = current;
                        if (a > count) {
                            a = count;
                        }
                        while (!isValid && --a >= 0) {
                            if (data[a] != 101 || data[a + 1] != 110 || data[a + 2] != 100 || data[a + 3] != 115 || data[a + 4] != 116 || data[a + 5] != 114 || data[a + 6] != 101 || data[a + 7] != 97 || data[a + 8] != 109) continue;
                            streamLength = a - start;
                            isValid = true;
                        }
                    }
                }
                if (decryption != null && decryption.getBooleanValue(101)) {
                    streamLength = setStreamLength;
                }
            } else {
                while (++a != count && (data[a] != 101 || data[a + 1] != 110 || data[a + 2] != 100 || data[a + 3] != 115 || data[a + 4] != 116 || data[a + 5] != 114 || data[a + 6] != 101 || data[a + 7] != 97 || data[a + 8] != 109)) {
                }
                int end = a - 1;
                if (end > start) {
                    streamLength = end - start + 1;
                }
            }
            if (streamLength > 1 && (decryption == null || !decryption.getBooleanValue(101)) && (ptr = start + streamLength - 1) < data.length && ptr > 0 && (data[ptr] == 10 || data[ptr] == 13 && (pdfObject != null && isJBigEncoded || ptr > 0 && data[ptr - 1] == 10))) {
                --streamLength;
            }
            if (start + streamLength > count) {
                streamLength = count - start;
            }
            if (streamLength < 0) {
                return;
            }
            if (streamLength < 0) {
                throw new RuntimeException("Negative stream length " + streamLength + " start=" + start + " count=" + count);
            }
            stream = new byte[streamLength];
            System.arraycopy(data, start, stream, 0, streamLength);
            a = count;
        }
        if (pdfObject != null) {
            pdfObject.setStream(stream);
            if (pdfObject.decompressStreamWhenRead()) {
                objectReader.readStream(pdfObject, true, true, false, pdfObject.getObjectType() == 1365674082, pdfObject.isCompressedStream(), null);
            }
        }
    }
}

