/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2.examples.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.PixelGrabber;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import org.jpedal.jbig2.JBIG2Decoder;
import org.jpedal.jbig2.JBIG2Exception;
import org.jpedal.jbig2.examples.viewer.FileFilterer;
import org.jpedal.jbig2.examples.viewer.NavigationToolbar;
import org.jpedal.jbig2.image.JBIG2Bitmap;

public class JBIG2Viewer
extends JFrame {
    private JFrame mainFrame = this;
    private JScrollPane jsp;
    private BufferedImage image;
    private JLabel imageLabel = new JLabel();
    private JComboBox scalingBox;
    private String scalingItem = "";
    private double scaling;
    private JComboBox rotationBox;
    private String rotationItem = "";
    private int rotation;
    private NavigationToolbar navToolbar;
    private JBIG2Decoder decoder;
    private int currentPage;

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            new JBIG2Viewer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JBIG2Viewer() {
        this.setSize(500, 500);
        this.getContentPane().setLayout(new BorderLayout());
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout(new BorderLayout());
        this.setUpToolbar();
        this.imageLabel.setHorizontalAlignment(0);
        this.imageLabel.setVerticalAlignment(1);
        this.jsp = new JScrollPane(this.imageLabel);
        this.getContentPane().add((Component)this.jsp, "Center");
        this.navToolbar = new NavigationToolbar(this);
        this.navToolbar.setFloatable(false);
        this.getContentPane().add((Component)this.navToolbar, "South");
        this.setTitle("JPedal JBIG2 Image Decoder");
        this.setVisible(true);
    }

    private void setUpToolbar() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.setBorder(BorderFactory.createEtchedBorder());
        JButton openButton = new JButton(new AbstractAction("Open", new ImageIcon(this.getClass().getResource("/org/jpedal/jbig2/examples/viewer/res/open.png"))){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JBIG2Viewer.this.openFile();
            }
        });
        openButton.setText(null);
        openButton.setToolTipText("Open New File");
        toolbar.add(openButton);
        toolbar.add(Box.createRigidArea(new Dimension(7, 0)));
        JButton saveButton = new JButton(new AbstractAction("Save", new ImageIcon(this.getClass().getResource("/org/jpedal/jbig2/examples/viewer/res/save.png"))){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (JBIG2Viewer.this.image == null) {
                    JOptionPane.showMessageDialog(JBIG2Viewer.this.mainFrame, "No image is open");
                } else {
                    JBIG2Viewer.this.saveFile();
                }
            }
        });
        saveButton.setText(null);
        saveButton.setToolTipText("Save File As");
        toolbar.add(saveButton);
        toolbar.add(Box.createRigidArea(new Dimension(7, 0)));
        JButton propertiesButton = new JButton(new AbstractAction("Properties", new ImageIcon(this.getClass().getResource("/org/jpedal/jbig2/examples/viewer/res/properties.png"))){

            @Override
            public void actionPerformed(ActionEvent evt) {
            }
        });
        propertiesButton.setText(null);
        propertiesButton.setToolTipText("File Properties");
        toolbar.add(Box.createRigidArea(new Dimension(7, 0)));
        toolbar.add(new JLabel("Zoom:"));
        toolbar.add(Box.createRigidArea(new Dimension(3, 0)));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JBIG2Viewer.this.setScalingAndRotation();
            }
        };
        this.scalingBox = new JComboBox<String>(new String[]{"Window", "Height", "Width", "25", "50", "75", "100", "125", "150", "200", "250", "500", "750", "1000"});
        this.scalingBox.setEditable(true);
        this.scalingBox.setPreferredSize(new Dimension(this.scalingBox.getPreferredSize().width, toolbar.getHeight()));
        this.scalingBox.setPrototypeDisplayValue("XXXXXXXX");
        this.scalingBox.setMaximumSize(new Dimension(100, 100));
        toolbar.add(this.scalingBox);
        toolbar.add(Box.createRigidArea(new Dimension(7, 0)));
        toolbar.add(new JLabel("Rotation:"));
        toolbar.add(Box.createRigidArea(new Dimension(3, 0)));
        this.rotationBox = new JComboBox<String>(new String[]{"0", "90", "180", "270"});
        this.rotationBox.setEditable(true);
        this.rotationBox.setPreferredSize(new Dimension(this.rotationBox.getPreferredSize().width, toolbar.getHeight()));
        this.rotationBox.setMaximumSize(new Dimension(100, 100));
        toolbar.add(this.rotationBox);
        this.getContentPane().add((Component)toolbar, "North");
        this.rotationBox.addActionListener(actionListener);
        this.scalingBox.addActionListener(actionListener);
    }

    private void saveFile() {
        JFileChooser chooser = new JFileChooser();
        chooser.addChoosableFileFilter(new FileFilterer(new String[]{"png"}, "PNG (*.png)"));
        chooser.setFileSelectionMode(0);
        int approved = chooser.showSaveDialog(null);
        if (approved == 0) {
            File file = chooser.getSelectedFile();
            String fileToSave = file.getAbsolutePath();
            if (!fileToSave.toLowerCase().endsWith(".png")) {
                file = new File(fileToSave + ".png");
            }
            try {
                ImageIO.write((RenderedImage)this.image, "png", file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void openFile() {
        JFileChooser open = new JFileChooser(".");
        open.setFileSelectionMode(0);
        String[] png = new String[]{"jb2", "jbig2"};
        open.addChoosableFileFilter(new FileFilterer(png, "JBIG2 (jb2, jbig2)"));
        int resultOfFileSelect = open.showOpenDialog(this.mainFrame);
        if (resultOfFileSelect == 0) {
            this.rotation = 0;
            this.rotationItem = "0";
            this.rotationBox.setSelectedItem(this.rotationItem);
            this.scaling = 1.0;
            this.scalingItem = "Window";
            this.scalingBox.setSelectedItem(this.scalingItem);
            this.decoder = new JBIG2Decoder();
            try {
                this.decoder.decodeJBIG2(open.getSelectedFile());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (JBIG2Exception e) {
                e.printStackTrace();
            }
            this.navToolbar.setCurrentPage(1);
            this.navToolbar.setTotalNoOfPages(this.decoder.getNumberOfPages());
            this.currentPage = 1;
            this.image = this.decoder.getPageAsBufferedImage(this.currentPage - 1);
            this.setScalingAndRotation();
        }
    }

    private void setScalingAndRotation() {
        if (this.image == null) {
            return;
        }
        String selectedScaling = (String)this.scalingBox.getSelectedItem();
        if (selectedScaling.equals("Window")) {
            int imageHeight;
            int windowWidth = this.jsp.getWidth();
            int windowHeight = this.jsp.getHeight();
            int imageWidth = this.image.getWidth();
            if ((double)windowWidth / (double)imageWidth < (double)windowHeight / (double)(imageHeight = this.image.getHeight())) {
                this.scaleToWidth();
            } else {
                this.scaleToHeight();
            }
            this.jsp.setHorizontalScrollBarPolicy(31);
            this.jsp.setVerticalScrollBarPolicy(21);
        } else {
            this.jsp.setHorizontalScrollBarPolicy(30);
            this.jsp.setVerticalScrollBarPolicy(20);
            if (selectedScaling.equals("Height")) {
                this.scaleToHeight();
            } else if (selectedScaling.equals("Width")) {
                this.scaleToWidth();
            } else {
                try {
                    int scale = Integer.parseInt(selectedScaling);
                    this.scaling = (double)scale / 100.0;
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    this.scalingBox.setSelectedItem(this.scalingItem);
                    return;
                }
            }
        }
        String selectedRotation = (String)this.rotationBox.getSelectedItem();
        try {
            this.rotation = Integer.parseInt(selectedRotation);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            this.rotationBox.setSelectedItem(this.rotationItem);
            return;
        }
        Image scaledImage = this.image.getScaledInstance((int)((double)this.image.getWidth() * this.scaling), -1, 1);
        BufferedImage rotatedImage = JBIG2Viewer.rotate(this.toBufferedImage(scaledImage), (double)this.rotation * Math.PI / 180.0);
        this.imageLabel.setIcon(new ImageIcon(rotatedImage));
        this.scalingItem = (String)this.scalingBox.getSelectedItem();
    }

    private void setRotation() {
        String selectedRotation = (String)this.rotationBox.getSelectedItem();
        try {
            this.rotation = Integer.parseInt(selectedRotation);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            this.rotationBox.setSelectedItem(this.rotationItem);
            return;
        }
        BufferedImage rotatedImage = JBIG2Viewer.rotate(this.image, (double)this.rotation * Math.PI / 180.0);
        this.imageLabel.setIcon(new ImageIcon(rotatedImage));
        this.rotationItem = (String)this.rotationBox.getSelectedItem();
    }

    private void scaleToWidth() {
        if (this.image == null) {
            return;
        }
        this.scaling = (double)this.jsp.getWidth() / (double)this.image.getWidth();
    }

    private void scaleToHeight() {
        if (this.image == null) {
            return;
        }
        this.scaling = (double)this.jsp.getHeight() / (double)this.image.getHeight();
    }

    private static BufferedImage rotate(BufferedImage src, double angle) {
        if (src == null) {
            return null;
        }
        int w = src.getWidth();
        int h = src.getHeight();
        int newW = (int)Math.round((double)h * Math.abs(Math.sin(angle)) + (double)w * Math.abs(Math.cos(angle)));
        int newH = (int)Math.round((double)h * Math.abs(Math.cos(angle)) + (double)w * Math.abs(Math.sin(angle)));
        AffineTransform at = AffineTransform.getTranslateInstance((newW - w) / 2, (newH - h) / 2);
        at.rotate(angle, w / 2, h / 2);
        BufferedImage dst = new BufferedImage(newW, newH, 2);
        Graphics2D g = dst.createGraphics();
        g.drawRenderedImage(src, at);
        g.dispose();
        return dst;
    }

    private static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }

    private BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = JBIG2Viewer.hasAlpha(image);
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            if (hasAlpha) {
                transparency = 2;
            }
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException e) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static void displayJBIG2AsImage(JBIG2Bitmap bitmap) {
        byte[] bytes = bitmap.getData(true);
        if (bytes == null) {
            return;
        }
        int len = bytes.length;
        byte[] copy = new byte[len];
        System.arraycopy(bytes, 0, copy, 0, len);
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        DataBufferByte db = new DataBufferByte(copy, copy.length);
        WritableRaster raster = Raster.createPackedRaster(db, width, height, 1, null);
        BufferedImage image = new BufferedImage(width, height, 12);
        image.setData(raster);
        Image scaledImage = image.getScaledInstance(500, -1, 16);
        BufferedImage result = new BufferedImage(scaledImage.getWidth(null), scaledImage.getHeight(null), 4);
        Graphics2D g = result.createGraphics();
        g.drawImage(scaledImage, 0, 0, null);
        g.dispose();
        JLabel label = new JLabel(new ImageIcon(result));
        JOptionPane.showConfirmDialog(null, label, "JBIG2 Display", -1, -1);
    }

    public JBIG2Decoder getDecoder() {
        return this.decoder;
    }

    public void displayPage(int page) {
        if (this.image != null && page > 0 && page <= this.decoder.getNumberOfPages()) {
            this.image = this.decoder.getPageAsBufferedImage(page - 1);
            this.currentPage = page;
            this.setScalingAndRotation();
            this.navToolbar.setCurrentPage(this.currentPage);
        }
    }

    public int getCurrentPage() {
        return this.currentPage;
    }
}

