/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.io.Serializable;
import javafx.collections.ObservableList;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.QuadCurveTo;
import org.jpedal.objects.PdfShape;

public class JavaFXShape
implements Serializable,
PdfShape {
    int complexClipCount;
    private boolean isClip;
    private Path path = new Path();
    ObservableList<PathElement> elements = this.path.getElements();
    private FillRule windingRule;
    private final float[] currentPos = new float[2];
    private boolean isClosed;

    @Override
    public final void closeShape() {
        this.elements.add((Object)new ClosePath());
    }

    @Override
    public final void addBezierCurveC(float x, float y, float x2, float y2, float x3, float y3) {
        this.elements.add((Object)new CubicCurveTo((double)x, (double)y, (double)x2, (double)y2, (double)x3, (double)y3));
        this.currentPos[0] = x3;
        this.currentPos[1] = y3;
    }

    @Override
    public final void setNONZEROWindingRule() {
        this.setWindingRule(FillRule.NON_ZERO);
    }

    @Override
    public final void lineTo(float x, float y) {
        this.elements.add((Object)new LineTo((double)x, (double)y));
        this.currentPos[0] = x;
        this.currentPos[1] = y;
    }

    @Override
    public final void addBezierCurveV(float x2, float y2, float x3, float y3) {
        this.elements.add((Object)new CubicCurveTo((double)this.currentPos[0], (double)this.currentPos[1], (double)x2, (double)y2, (double)x3, (double)y3));
        this.currentPos[0] = x3;
        this.currentPos[1] = y3;
    }

    @Override
    public final Shape generateShapeFromPath(float[][] CTM, float thickness, int cmd, int type) {
        return new GeneralPath();
    }

    @Override
    public final void appendRectangle(float x, float y, float w, float h) {
        this.moveTo(x, y);
        this.lineTo(x + w, y);
        this.lineTo(x + w, y + h);
        this.lineTo(x, y + h);
        this.lineTo(x, y);
        this.closeShape();
    }

    @Override
    public final void moveTo(float x, float y) {
        this.elements.add((Object)new MoveTo((double)x, (double)y));
        this.currentPos[0] = x;
        this.currentPos[1] = y;
    }

    @Override
    public final void addBezierCurveY(float x, float y, float x3, float y3) {
        this.elements.add((Object)new QuadCurveTo((double)x, (double)y, (double)x3, (double)y3));
        this.currentPos[0] = x3;
        this.currentPos[1] = y3;
    }

    @Override
    public final void resetPath() {
        this.path = new Path();
        this.elements = this.path.getElements();
        this.windingRule = FillRule.NON_ZERO;
    }

    @Override
    public final void setEVENODDWindingRule() {
        this.setWindingRule(FillRule.EVEN_ODD);
    }

    public final void setWindingRule(FillRule rule) {
        this.windingRule = rule;
        this.path.setFillRule(this.windingRule);
    }

    @Override
    public int getSegmentCount() {
        if (this.path == null) {
            return 0;
        }
        return this.elements.size();
    }

    @Override
    public void setClip(boolean b) {
        this.isClip = b;
    }

    @Override
    public boolean isClip() {
        return this.isClip;
    }

    @Override
    public int getComplexClipCount() {
        return this.complexClipCount;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public boolean adjustLineWidth() {
        throw new RuntimeException("JavaFX should not call JavaFXShape.adjustLineWidth()");
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }
}

