/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.actions.JavaFX;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TouchEvent;
import org.jpedal.objects.acroforms.actions.ActionHandler;
import org.jpedal.objects.acroforms.actions.PDFListener;
import org.jpedal.objects.raw.FormObject;

public class JavaFXFormsListener
extends PDFListener {
    private boolean debug;
    private final EventHandler<MouseEvent> mouseHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            JavaFXFormsListener.this.handleMouseEvent(event);
        }
    };
    private EventHandler<TouchEvent> touchHandler;
    private final ChangeListener<Boolean> focusHandler = new ChangeListener<Boolean>(){

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            JavaFXFormsListener.this.handleFocusEvent(newValue);
        }
    };
    private final EventHandler<KeyEvent> keyHandler = new EventHandler<KeyEvent>(){

        public void handle(KeyEvent event) {
            JavaFXFormsListener.this.handleKeyEvent(event);
        }
    };

    public JavaFXFormsListener(FormObject form, ActionHandler handler) {
        super(form, handler);
    }

    public EventHandler<MouseEvent> getMouseHandler() {
        return this.mouseHandler;
    }

    public EventHandler<TouchEvent> getTouchHandler() {
        return this.touchHandler;
    }

    public ChangeListener<Boolean> getFocusHandler() {
        return this.focusHandler;
    }

    public EventHandler<KeyEvent> getKeyHandler() {
        return this.keyHandler;
    }

    private void handleMouseEvent(MouseEvent event) {
        if (this.debug) {
            System.out.println("JavaFXFormsMouseListener event: " + event.getEventType().getName());
        }
        if (event.getEventType() == MouseEvent.MOUSE_CLICKED) {
            super.mouseClicked(event);
        } else if (event.getEventType() == MouseEvent.MOUSE_PRESSED) {
            super.mousePressed(event);
        } else if (event.getEventType() == MouseEvent.MOUSE_RELEASED) {
            super.mouseReleased(event);
        } else if (event.getEventType() == MouseEvent.MOUSE_ENTERED) {
            this.handler.A(event, this.formObject, 4);
            this.handler.E(event, this.formObject);
            if (this.formObject.getCharacteristics()[8]) {
                ((Node)this.formObject.getGUIComponent()).setVisible(true);
            }
        } else if (event.getEventType() == MouseEvent.MOUSE_EXITED) {
            this.handler.A(event, this.formObject, 5);
            this.handler.X(event, this.formObject);
            if (this.formObject.getCharacteristics()[8]) {
                ((Node)this.formObject.getGUIComponent()).setVisible(false);
            }
        }
    }

    private void handleFocusEvent(boolean gainedFocus) {
        if (gainedFocus) {
            super.focusGained(null);
        } else {
            super.focusLost(null);
        }
    }

    private void handleKeyEvent(KeyEvent event) {
        if (!event.getEventType().equals(KeyEvent.KEY_PRESSED) && event.getEventType().equals(KeyEvent.KEY_RELEASED)) {
            super.keyReleased(event);
        }
    }
}

