/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.creation;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseListener;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.objects.acroforms.GUIData;
import org.jpedal.objects.acroforms.SwingData;
import org.jpedal.objects.acroforms.actions.SwingDownIconListener;
import org.jpedal.objects.acroforms.actions.SwingFormButtonListener;
import org.jpedal.objects.acroforms.actions.SwingListener;
import org.jpedal.objects.acroforms.creation.ComboColorRenderer;
import org.jpedal.objects.acroforms.creation.ComboListener;
import org.jpedal.objects.acroforms.creation.FormFactory;
import org.jpedal.objects.acroforms.creation.GenericFormFactory;
import org.jpedal.objects.acroforms.creation.ListListener;
import org.jpedal.objects.acroforms.creation.PopupFactory;
import org.jpedal.objects.acroforms.creation.RadioListener;
import org.jpedal.objects.acroforms.creation.TextDocumentListener;
import org.jpedal.objects.acroforms.overridingImplementations.FixImageIcon;
import org.jpedal.objects.acroforms.overridingImplementations.PdfSwingPopup;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class SwingFormFactory
extends GenericFormFactory
implements FormFactory {
    private JButton setupAnnotationButton(FormObject form) {
        JButton but = new JButton();
        this.setupButton(but, form);
        this.setupUniversalFeatures(but, form);
        return but;
    }

    private JButton createAnntoationHighlight(FormObject form) {
        JButton but = this.setupAnnotationButton(form);
        but.setBackground(new Color(0, 0, 0, 0));
        but.setIcon(new FixImageIcon(form, PopupFactory.getIcon(form), 0));
        return but;
    }

    private JButton createAnnotationFreeText(FormObject form) {
        JButton but = this.setupAnnotationButton(form);
        but.setText("<html>" + form.getTextStreamValue(1216184967) + "</html>");
        Font font = new Font("TimesRoman", 0, 12);
        form.setTextSize(12);
        but.setFont(font);
        form.setFontName("TimesRoman");
        form.setTextFont(font);
        return but;
    }

    private JButton createAnnotationText(FormObject form) {
        JButton but = this.setupAnnotationButton(form);
        int rot = this.pageData.getRotation(form.getPageNumber());
        BufferedImage commentIcon = PopupFactory.getIcon(form);
        if (commentIcon != null) {
            float[] rect = form.getFloatArray(573911876);
            rect[1] = rect[3] - (float)commentIcon.getHeight();
            rect[2] = rect[0] + (float)commentIcon.getWidth();
            form.setFloatArray(573911876, rect);
        }
        but.setIcon(new FixImageIcon(form, commentIcon, rot));
        return but;
    }

    private JComponent createAnnotationPopup(FormObject form) {
        JComponent comp = (JComponent)this.getPopupComponent(form, this.pageData.getCropBoxWidth(form.getPageNumber()));
        form.setGUIComponent(comp, 1);
        comp.setVisible(form.getBoolean(524301630));
        return comp;
    }

    private JButton createAnnotationUnderline(FormObject form) {
        JButton but = this.setupAnnotationButton(form);
        Color color = SwingFormFactory.getAnnotationColor(form);
        but.setBounds(form.getBoundingRectangle());
        float[] quad = form.getFloatArray(1785890247);
        if (quad == null) {
            quad = form.getFloatArray(573911876);
        }
        BufferedImage icon = new BufferedImage(form.getBoundingRectangle().width, form.getBoundingRectangle().height, 6);
        Graphics g = icon.getGraphics();
        if (quad.length >= 8) {
            for (int hi = 0; hi != quad.length; hi += 8) {
                int x = (int)quad[hi] - form.getBoundingRectangle().x;
                int y = (int)quad[hi + 5] - form.getBoundingRectangle().y;
                y = form.getBoundingRectangle().height - y - (int)(quad[hi + 1] - quad[hi + 5]);
                int width = (int)(quad[hi + 2] - quad[hi]);
                int height = (int)(quad[hi + 1] - quad[hi + 5]);
                Rectangle rh = new Rectangle(x, y, width, height);
                try {
                    g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
                    g.fillRect(rh.x, rh.y, rh.width, rh.height);
                    g.setColor(color);
                    g.fillRect(rh.x, rh.y + rh.height - 1, rh.width, 1);
                    but.setBackground(new Color(0, 0, 0, 0));
                    but.setIcon(new FixImageIcon(form, icon, 0));
                    continue;
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) continue;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
        }
        return but;
    }

    private JButton createAnnotationInk(FormObject form) {
        JButton but = this.setupAnnotationButton(form);
        but.setToolTipText(form.getTextStreamValue(1216184967));
        Object[] InkListArray = form.getObjectArray(475169151);
        float[] r = SwingFormFactory.scanInkListTree(InkListArray, form, null);
        form.setFloatArray(573911876, new float[]{r[0], r[1], r[2], r[3]});
        BufferedImage icon1 = new BufferedImage(form.getBoundingRectangle().width, form.getBoundingRectangle().height, 6);
        SwingFormFactory.scanInkListTree(InkListArray, form, icon1.getGraphics());
        but.setBackground(new Color(0, 0, 0, 0));
        but.setIcon(new FixImageIcon(form, icon1, 0));
        return but;
    }

    private JButton createAnnotationStrikeOut(FormObject form) {
        JButton but = this.setupAnnotationButton(form);
        Color color = SwingFormFactory.getAnnotationColor(form);
        float[] quad = form.getFloatArray(1785890247);
        if (quad == null) {
            quad = form.getFloatArray(573911876);
        }
        BufferedImage icon = new BufferedImage(form.getBoundingRectangle().width, form.getBoundingRectangle().height, 6);
        Graphics g = icon.getGraphics();
        if (quad.length >= 8) {
            for (int hi = 0; hi != quad.length; hi += 8) {
                int x = (int)quad[hi] - form.getBoundingRectangle().x;
                int y = (int)quad[hi + 5] - form.getBoundingRectangle().y;
                y = form.getBoundingRectangle().height - y - (int)(quad[hi + 1] - quad[hi + 5]);
                int width = (int)(quad[hi + 2] - quad[hi]);
                int height = (int)(quad[hi + 1] - quad[hi + 5]);
                Rectangle rh = new Rectangle(x, y, width, height);
                try {
                    g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
                    g.fillRect(0, 0, rh.width, rh.height);
                    g.setColor(color);
                    g.fillRect(rh.x, rh.y + rh.height / 2, rh.width, 1);
                    but.setBackground(new Color(0, 0, 0, 0));
                    but.setIcon(new FixImageIcon(form, icon, 0));
                    continue;
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) continue;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
        }
        return but;
    }

    private static Color getAnnotationColor(FormObject form) {
        float[] formColor = form.getFloatArray(19);
        Color color = new Color(0);
        if (formColor != null) {
            switch (formColor.length) {
                case 0: {
                    break;
                }
                case 1: {
                    color = new Color(formColor[0], formColor[0], formColor[0], 1.0f);
                    break;
                }
                case 3: {
                    color = new Color(formColor[0], formColor[1], formColor[2], 1.0f);
                    break;
                }
                case 4: {
                    DeviceCMYKColorSpace cmyk = new DeviceCMYKColorSpace();
                    cmyk.setColor(formColor, 4);
                    int rgb = cmyk.getColor().getRGB();
                    int r = rgb >> 16 & 0xFF;
                    int g = rgb >> 8 & 0xFF;
                    int b = rgb & 0xFF;
                    color = new Color(r, g, b, 1);
                    break;
                }
            }
        }
        return color;
    }

    @Override
    public Object annotationButton(FormObject form) {
        int subtype = form.getParameterConstant(1147962727);
        if (subtype == 1061176672) {
            return this.createAnnotationPopup(form);
        }
        if (!form.isAppearanceUsed()) {
            switch (subtype) {
                case 607471684: {
                    return this.createAnnotationText(form);
                }
                case 980909433: {
                    return this.createAnnotationFreeText(form);
                }
                case 1919840408: {
                    return this.createAnntoationHighlight(form);
                }
                case 2053993372: {
                    return this.createAnnotationUnderline(form);
                }
                case 1654331: {
                    return this.createAnnotationInk(form);
                }
                case 2036432546: {
                    return this.createAnnotationStrikeOut(form);
                }
            }
        }
        return this.setupAnnotationButton(form);
    }

    static float[] curveInk(float[] points) {
        double smooth_value = 1.0;
        int currentIndex = 0;
        float[] returnPoints = new float[(points.length - 2) / 2 * 8];
        for (int i = 0; i < points.length; i += 2) {
            double[] cps;
            double y3;
            double x3;
            double y2;
            double x2;
            double y1;
            double x1;
            double y0;
            double x0;
            if (i == 0) {
                x0 = points[i];
                y0 = points[i + 1];
                x1 = points[i];
                y1 = points[i + 1];
                x2 = points[i + 2];
                y2 = points[i + 3];
                x3 = points[i + 4];
                y3 = points[i + 5];
                cps = SwingFormFactory.findControlPoint(x0, y0, x1, y1, x2, y2, x3, y3, 1.0);
                returnPoints[currentIndex] = (float)x1;
                returnPoints[++currentIndex] = (float)y1;
                returnPoints[++currentIndex] = (float)cps[0];
                returnPoints[++currentIndex] = (float)cps[1];
                returnPoints[++currentIndex] = (float)cps[2];
                returnPoints[++currentIndex] = (float)cps[3];
                returnPoints[++currentIndex] = (float)x2;
                returnPoints[++currentIndex] = (float)y2;
                ++currentIndex;
            }
            if (i + 6 >= points.length) {
                x0 = points[i];
                y0 = points[i + 1];
                x1 = points[i + 2];
                y1 = points[i + 3];
                x2 = points[i + 4];
                y2 = points[i + 5];
                x3 = points[i + 4];
                y3 = points[i + 5];
                cps = SwingFormFactory.findControlPoint(x0, y0, x1, y1, x2, y2, x3, y3, 1.0);
                returnPoints[currentIndex] = (float)x1;
                returnPoints[++currentIndex] = (float)y1;
                returnPoints[++currentIndex] = (float)cps[0];
                returnPoints[++currentIndex] = (float)cps[1];
                returnPoints[++currentIndex] = (float)cps[2];
                returnPoints[++currentIndex] = (float)cps[3];
                returnPoints[++currentIndex] = (float)x2;
                returnPoints[++currentIndex] = (float)y2;
                break;
            }
            x0 = points[i];
            y0 = points[i + 1];
            x1 = points[i + 2];
            y1 = points[i + 3];
            x2 = points[i + 4];
            y2 = points[i + 5];
            x3 = points[i + 6];
            y3 = points[i + 7];
            cps = SwingFormFactory.findControlPoint(x0, y0, x1, y1, x2, y2, x3, y3, 1.0);
            returnPoints[currentIndex] = (float)x1;
            returnPoints[++currentIndex] = (float)y1;
            returnPoints[++currentIndex] = (float)cps[0];
            returnPoints[++currentIndex] = (float)cps[1];
            returnPoints[++currentIndex] = (float)cps[2];
            returnPoints[++currentIndex] = (float)cps[3];
            returnPoints[++currentIndex] = (float)x2;
            returnPoints[++currentIndex] = (float)y2;
            ++currentIndex;
        }
        return returnPoints;
    }

    private static double[] findControlPoint(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3, double smooth_value) {
        double xc1 = (x0 + x1) / 2.0;
        double yc1 = (y0 + y1) / 2.0;
        double xc2 = (x1 + x2) / 2.0;
        double yc2 = (y1 + y2) / 2.0;
        double xc3 = (x2 + x3) / 2.0;
        double yc3 = (y2 + y3) / 2.0;
        double len1 = Math.sqrt((x1 - x0) * (x1 - x0) + (y1 - y0) * (y1 - y0));
        double len2 = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
        double len3 = Math.sqrt((x3 - x2) * (x3 - x2) + (y3 - y2) * (y3 - y2));
        double k1 = len1 / (len1 + len2);
        double k2 = len2 / (len2 + len3);
        double xm1 = xc1 + (xc2 - xc1) * k1;
        double ym1 = yc1 + (yc2 - yc1) * k1;
        double xm2 = xc2 + (xc3 - xc2) * k2;
        double ym2 = yc2 + (yc3 - yc2) * k2;
        double ctrl1_x = xm1 + (xc2 - xm1) * smooth_value + x1 - xm1;
        double ctrl1_y = ym1 + (yc2 - ym1) * smooth_value + y1 - ym1;
        double ctrl2_x = xm2 + (xc2 - xm2) * smooth_value + x2 - xm2;
        double ctrl2_y = ym2 + (yc2 - ym2) * smooth_value + y2 - ym2;
        return new double[]{ctrl1_x, ctrl1_y, ctrl2_x, ctrl2_y};
    }

    private static float[] scanInkListTree(Object[] InkListArray, FormObject form, Graphics g) {
        float maxY;
        float maxX;
        float minY;
        float minX;
        block43: {
            Graphics2D g2;
            float[] vals;
            block44: {
                minX = 0.0f;
                minY = 0.0f;
                maxX = 0.0f;
                maxY = 0.0f;
                vals = null;
                g2 = (Graphics2D)g;
                if (InkListArray != null) {
                    int count = InkListArray.length;
                    boolean isFirstPoint = true;
                    if (g != null) {
                        float[] underlineColor = form.getFloatArray(19);
                        Color c1 = new Color(0);
                        if (underlineColor != null) {
                            switch (underlineColor.length) {
                                case 0: {
                                    break;
                                }
                                case 1: {
                                    c1 = new Color(underlineColor[0], underlineColor[0], underlineColor[0], 1.0f);
                                    break;
                                }
                                case 3: {
                                    c1 = new Color(underlineColor[0], underlineColor[1], underlineColor[2], 1.0f);
                                    break;
                                }
                                case 4: {
                                    DeviceCMYKColorSpace cmyk = new DeviceCMYKColorSpace();
                                    cmyk.setColor(underlineColor, 4);
                                    c1 = new Color(cmyk.getColor().getRGB());
                                    break;
                                }
                            }
                        }
                        g2.setColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
                        g2.fillRect(0, 0, form.getBoundingRectangle().width, form.getBoundingRectangle().height);
                        g2.setColor(c1);
                        g2.setPaint(c1);
                    }
                    for (int i = 0; i < count; ++i) {
                        if (InkListArray[i] instanceof byte[]) {
                            byte[] decodeByteData = (byte[])InkListArray[i];
                            if (vals == null) {
                                vals = new float[count];
                            }
                            if (decodeByteData == null) continue;
                            String val = new String(decodeByteData);
                            float v = Float.parseFloat(val);
                            switch (i % 2) {
                                case 0: {
                                    float x;
                                    if (isFirstPoint) {
                                        minX = v;
                                        maxX = v;
                                    } else {
                                        if (v < minX) {
                                            minX = v;
                                        }
                                        if (v > maxX) {
                                            maxX = v;
                                        }
                                    }
                                    vals[i] = x = v - (float)form.getBoundingRectangle().x;
                                    break;
                                }
                                case 1: {
                                    float y;
                                    if (isFirstPoint) {
                                        minY = v;
                                        maxY = v;
                                        isFirstPoint = false;
                                    } else {
                                        if (v < minY) {
                                            minY = v;
                                        }
                                        if (v > maxY) {
                                            maxY = v;
                                        }
                                    }
                                    vals[i] = y = (float)form.getBoundingRectangle().height - (v - (float)form.getBoundingRectangle().y);
                                }
                            }
                            continue;
                        }
                        float[] r = SwingFormFactory.scanInkListTree((Object[])InkListArray[i], form, g);
                        if (isFirstPoint) {
                            minX = r[0];
                            maxX = r[2];
                            minY = r[1];
                            maxY = r[3];
                            isFirstPoint = false;
                            continue;
                        }
                        if (r[0] < minX) {
                            minX = r[0];
                        }
                        if (r[2] > maxX) {
                            maxX = r[2];
                        }
                        if (r[1] < minY) {
                            minY = r[1];
                        }
                        if (!(r[3] > maxY)) continue;
                        maxY = r[3];
                    }
                }
                if (vals == null) break block43;
                if (vals.length >= 6) break block44;
                for (int i = 0; i < vals.length; ++i) {
                    if (i % 2 == 0) {
                        if (vals[i] < minX) {
                            minX = vals[i];
                        }
                        if (!(vals[i] > maxX)) continue;
                        maxX = vals[i];
                        continue;
                    }
                    if (vals[i] < minY) {
                        minY = vals[i];
                    }
                    if (!(vals[i] > maxY)) continue;
                    maxY = vals[i];
                }
                float xOffset = 0.0f;
                float yOffset = 0.0f;
                if (minX < 0.0f) {
                    xOffset = Math.abs(minX);
                }
                if (minY < 0.0f) {
                    yOffset = Math.abs(minY);
                }
                minX += xOffset;
                maxX += xOffset;
                minY += yOffset;
                maxY += yOffset;
                if (g2 == null) break block43;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setStroke(new BasicStroke(1.52f, 1, 1));
                for (int i = 0; i < vals.length; i += 4) {
                    Line2D.Float line = new Line2D.Float(vals[0], vals[1], vals[2], vals[3]);
                    g2.draw(line);
                }
                break block43;
            }
            float[] values = SwingFormFactory.curveInk(vals);
            for (int i = 0; i < values.length; ++i) {
                if (i % 2 == 0) {
                    if (values[i] < minX) {
                        minX = values[i];
                    }
                    if (!(values[i] > maxX)) continue;
                    maxX = values[i];
                    continue;
                }
                if (values[i] < minY) {
                    minY = values[i];
                }
                if (!(values[i] > maxY)) continue;
                maxY = values[i];
            }
            float xOffset = 0.0f;
            float yOffset = 0.0f;
            if (minX < 0.0f) {
                xOffset = Math.abs(minX);
            }
            if (minY < 0.0f) {
                yOffset = Math.abs(minY);
            }
            minX += xOffset;
            maxX += xOffset;
            minY += yOffset;
            maxY += yOffset;
            if (g2 != null) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setStroke(new BasicStroke(1.52f, 1, 1));
                for (int i = 0; i < values.length; i += 8) {
                    CubicCurve2D.Double curve = new CubicCurve2D.Double(values[i] + xOffset, values[i + 1] + yOffset, values[i + 2] + xOffset, values[i + 3] + yOffset, values[i + 4] + xOffset, values[i + 5] + yOffset, values[i + 6] + xOffset, values[i + 7] + yOffset);
                    g2.draw(curve);
                }
            }
        }
        return new float[]{minX, minY, maxX, maxY};
    }

    @Override
    public Object comboBox(FormObject form) {
        JComboBox<Object> comboBox;
        String[] items = form.getItemsList();
        if (items == null) {
            comboBox = new JComboBox();
        } else {
            comboBox = new JComboBox<String>(items);
            Color backgroundColor = FormObject.generateColor(form.getDictionary(7451).getFloatArray(4631));
            if (backgroundColor != null) {
                ComboColorRenderer renderer = new ComboColorRenderer(backgroundColor);
                comboBox.setRenderer(renderer);
            }
        }
        String textValue = form.getSelectedItem();
        if (form.getValuesMap(true) != null) {
            comboBox.setSelectedItem(form.getValuesMap(true).get(textValue));
        } else {
            comboBox.setSelectedItem(textValue);
        }
        int selectionIndex = comboBox.getSelectedIndex();
        form.setSelection(comboBox.getSelectedObjects(), (String)comboBox.getSelectedItem(), new int[]{selectionIndex}, selectionIndex);
        boolean[] flags = form.getFieldFlags();
        if (flags[19]) {
            comboBox.setEditable(true);
        } else {
            comboBox.setEditable(false);
        }
        this.setupUniversalFeatures(comboBox, form);
        if (flags[1]) {
            comboBox.setEditable(false);
            comboBox.setEnabled(false);
        }
        comboBox.addItemListener(new ComboListener(comboBox, form));
        return comboBox;
    }

    @Override
    public Object checkBoxBut(FormObject form) {
        boolean[] flags;
        JCheckBox checkBut = new JCheckBox();
        this.setupButton(checkBut, form);
        this.setupUniversalFeatures(checkBut, form);
        if (checkBut.getBorder() != null) {
            checkBut.setBorderPainted(true);
        }
        if ((flags = form.getFieldFlags()) != null && flags[1]) {
            checkBut.setEnabled(false);
            checkBut.setDisabledIcon(checkBut.getIcon());
            checkBut.setDisabledSelectedIcon(checkBut.getSelectedIcon());
        }
        return checkBut;
    }

    @Override
    public Object listField(FormObject form) {
        String[] items = form.getItemsList();
        JList<Object> list = items != null ? new JList<String>(items) : new JList();
        if (!form.getFieldFlags()[22]) {
            list.setSelectionMode(0);
        }
        if (form.getSelectionIndices() != null) {
            list.setSelectedIndices(form.getSelectionIndices());
        } else if (form.getValuesMap(true) != null) {
            list.setSelectedValue(form.getValuesMap(true).get(form.getSelectedItem()), true);
        } else {
            list.setSelectedValue(form.getSelectedItem(), true);
        }
        form.setSelection(list.getSelectedValues(), (String)list.getSelectedValue(), list.getSelectedIndices(), list.getSelectedIndex());
        this.setupUniversalFeatures(list, form);
        list.addListSelectionListener(new ListListener(list, form));
        return list;
    }

    @Override
    public Object multiLinePassword(FormObject form) {
        String textValue = form.getTextString();
        int maxLength = form.getInt(1209815663);
        JPasswordField multipass = maxLength != -1 ? new JPasswordField(textValue, maxLength) : new JPasswordField(textValue);
        multipass.setEchoChar('*');
        this.setupUniversalFeatures(multipass, form);
        SwingFormFactory.setupTextFeatures(multipass, form);
        boolean[] flags = form.getFieldFlags();
        if (flags != null && flags[1]) {
            multipass.setEditable(false);
        }
        SwingFormFactory.setToolTip(form, multipass);
        return multipass;
    }

    @Override
    public Object multiLineText(FormObject form) {
        JTextPane comp;
        boolean[] flags = form.getFieldFlags();
        boolean[] characteristics = form.getCharacteristics();
        String text = form.getTextString();
        if (flags != null && flags[1] || characteristics != null && characteristics[9]) {
            JTextPane newTextarea = new JTextPane();
            newTextarea.setText(text);
            newTextarea.setEditable(false);
            if (form.getAlignment() != -1) {
                StyledDocument doc = newTextarea.getStyledDocument();
                SimpleAttributeSet center = new SimpleAttributeSet();
                switch (form.getAlignment()) {
                    case 0: {
                        StyleConstants.setAlignment(center, 1);
                        break;
                    }
                    case 4: {
                        StyleConstants.setAlignment(center, 2);
                    }
                }
                doc.setParagraphAttributes(0, doc.getLength(), center, false);
            }
            newTextarea.getDocument().addDocumentListener(new TextDocumentListener(newTextarea, form));
            comp = newTextarea;
        } else {
            JTextPane newTextarea = new JTextPane();
            newTextarea.setText(text);
            if (form.getAlignment() != -1) {
                StyledDocument doc = newTextarea.getStyledDocument();
                SimpleAttributeSet center = new SimpleAttributeSet();
                switch (form.getAlignment()) {
                    case 0: {
                        StyleConstants.setAlignment(center, 1);
                        break;
                    }
                    case 4: {
                        StyleConstants.setAlignment(center, 2);
                    }
                }
                doc.setParagraphAttributes(0, doc.getLength(), center, false);
            }
            newTextarea.getDocument().addDocumentListener(new TextDocumentListener(newTextarea, form));
            comp = newTextarea;
        }
        SwingFormFactory.setToolTip(form, comp);
        this.setupUniversalFeatures(comp, form);
        return comp;
    }

    @Override
    public Object signature(FormObject form) {
        JButton sigBut = new JButton();
        this.setupButton(sigBut, form);
        this.setupUniversalFeatures(sigBut, form);
        boolean[] flags = form.getFieldFlags();
        if (flags != null && flags[1]) {
            sigBut.setEnabled(false);
            sigBut.setDisabledIcon(sigBut.getIcon());
            sigBut.setDisabledSelectedIcon(sigBut.getSelectedIcon());
        }
        if (!form.isAppearanceUsed()) {
            sigBut.setOpaque(false);
            BufferedImage img = new BufferedImage(1, 1, 2);
            Graphics2D imgG2 = img.createGraphics();
            imgG2.setPaint(new Color(221, 228, 255, 175));
            imgG2.fillRect(0, 0, 1, 1);
            sigBut.setIcon(new FixImageIcon(form, img, 0));
        }
        return sigBut;
    }

    @Override
    public Object pushBut(FormObject form) {
        JButton pushBut = new JButton();
        this.setupButton(pushBut, form);
        this.setupUniversalFeatures(pushBut, form);
        boolean[] flags = form.getFieldFlags();
        if (flags != null && flags[1]) {
            pushBut.setEnabled(false);
            pushBut.setDisabledIcon(pushBut.getIcon());
            pushBut.setDisabledSelectedIcon(pushBut.getSelectedIcon());
        }
        return pushBut;
    }

    @Override
    public Object radioBut(FormObject form) {
        JRadioButton radioBut = new JRadioButton();
        this.setupButton(radioBut, form);
        this.setupUniversalFeatures(radioBut, form);
        boolean[] flags = form.getFieldFlags();
        if (flags != null && flags[1]) {
            radioBut.setEnabled(false);
            radioBut.setDisabledIcon(radioBut.getIcon());
            radioBut.setDisabledSelectedIcon(radioBut.getSelectedIcon());
        }
        return radioBut;
    }

    @Override
    public Object singleLinePassword(FormObject form) {
        JPasswordField newPassword = new JPasswordField(form.getTextString());
        newPassword.setEchoChar('*');
        int maxLength = form.getInt(1209815663);
        if (maxLength != -1) {
            newPassword.setColumns(maxLength);
        }
        this.setupUniversalFeatures(newPassword, form);
        SwingFormFactory.setupTextFeatures(newPassword, form);
        boolean[] flags = form.getFieldFlags();
        if (flags != null && flags[1]) {
            newPassword.setEditable(false);
        }
        SwingFormFactory.setToolTip(form, newPassword);
        return newPassword;
    }

    @Override
    public Object singleLineText(FormObject form) {
        JTextField retComp;
        boolean[] flags = form.getFieldFlags();
        boolean[] characteristics = form.getCharacteristics();
        String aptext = this.readAPimagesForText(form);
        if (aptext != null && aptext.contains("&#")) {
            aptext = Strip.stripXML(aptext, true).toString();
        }
        if (aptext != null && !aptext.equals(form.getTextStreamValue(38))) {
            form.setTextStreamValue(38, aptext);
        }
        if (flags != null && flags[1] || characteristics != null && characteristics[9]) {
            if (form.isXFAObject()) {
                JTextField newTextfield = new JTextField(form.getTextString());
                SwingFormFactory.setupTextFeatures(newTextfield, form);
                SwingFormFactory.setToolTip(form, newTextfield);
                newTextfield.setEditable(false);
                retComp = newTextfield;
            } else {
                JTextField newTextfield = new JTextField(form.getTextString());
                SwingFormFactory.setupTextFeatures(newTextfield, form);
                SwingFormFactory.setToolTip(form, newTextfield);
                newTextfield.setEditable(false);
                retComp = newTextfield;
            }
        } else {
            JTextField newTextfield = new JTextField(form.getTextString());
            SwingFormFactory.setupTextFeatures(newTextfield, form);
            SwingFormFactory.setToolTip(form, newTextfield);
            retComp = newTextfield;
        }
        this.setupUniversalFeatures(retComp, form);
        return retComp;
    }

    static void setupTextFeatures(JTextField textcomp, FormObject form) {
        if (form.getAlignment() != -1) {
            textcomp.setHorizontalAlignment(form.getAlignment());
        }
        textcomp.getDocument().addDocumentListener(new TextDocumentListener(textcomp, form));
    }

    private void setupButton(AbstractButton comp, FormObject form) {
        int textPosition;
        ButtonGroup bg;
        String name = form.getTextStreamValue(36);
        if (name == null) {
            name = "";
        }
        if ((bg = (ButtonGroup)this.groups.get(name)) == null) {
            bg = new ButtonGroup();
            this.groups.put(name, bg);
            this.firstButtons.put(name, comp);
        } else {
            AbstractButton firstButton = (AbstractButton)this.firstButtons.get(name);
            if (firstButton != null) {
                this.firstButtons.remove(name);
                bg.add(firstButton);
            }
            bg.add(comp);
        }
        String normalCaption = form.getDictionary(7451).getTextStreamValue(4881);
        comp.setText(normalCaption);
        comp.setContentAreaFilled(false);
        String downCaption = form.getDictionary(7451).getTextStreamValue(4371);
        String rolloverCaption = form.getDictionary(7451).getTextStreamValue(8723);
        if (downCaption != null && !downCaption.isEmpty() || rolloverCaption != null && !rolloverCaption.isEmpty()) {
            comp.addMouseListener(new SwingFormButtonListener(normalCaption, rolloverCaption, downCaption));
        }
        if (form.isAppearanceUsed()) {
            this.setAPImages(form, comp);
        }
        if ((textPosition = form.getTextPosition()) != -1) {
            switch (textPosition) {
                case 0: {
                    comp.setIcon(null);
                    comp.setText(normalCaption);
                    break;
                }
                case 1: {
                    comp.setText(null);
                    break;
                }
                case 2: {
                    comp.setVerticalTextPosition(3);
                    break;
                }
                case 3: {
                    comp.setVerticalTextPosition(1);
                    break;
                }
                case 4: {
                    comp.setHorizontalTextPosition(4);
                    break;
                }
                case 5: {
                    comp.setHorizontalTextPosition(2);
                    break;
                }
                case 6: {
                    comp.setText(null);
                }
            }
        }
        Insets insetZero = new Insets(0, 0, 0, 0);
        comp.setMargin(insetZero);
        comp.addMouseListener((MouseListener)this.formsActionHandler.setHoverCursor());
        comp.addChangeListener(new RadioListener(comp, form));
    }

    private void setAPImages(FormObject form, Object rawComp) {
        PdfObject val;
        Map otherValues;
        AbstractButton comp = (AbstractButton)rawComp;
        PdfObject APobjN = form.getDictionary(4384).getDictionary(30);
        PdfObject APobjD = form.getDictionary(4384).getDictionary(20);
        PdfObject APobjR = form.getDictionary(4384).getDictionary(34);
        PdfObject normalOffDic = null;
        PdfObject normalOnDic = null;
        PdfObject downOffDic = null;
        PdfObject downOnDic = null;
        PdfObject rollOffDic = null;
        PdfObject rollOnDic = null;
        int offsetDownImage = 0;
        int subtype = form.getParameterConstant(1147962727);
        if (APobjN != null || form.getDictionary(7451).getDictionary(25) != null) {
            if (APobjN.getDictionary(2045494) != null) {
                normalOffDic = APobjN.getDictionary(2045494);
            } else if (form.getDictionary(7451).getDictionary(25) != null && form.getDictionary(7451).getDictionary(6422) == null) {
                normalOffDic = form.getDictionary(7451).getDictionary(25);
            } else if (APobjN.getDecodedStream() != null) {
                normalOffDic = APobjN;
            }
            if (normalOffDic != null) {
                comp.setText(null);
                comp.setIcon(new FixImageIcon(form, normalOffDic, form.getDictionary(7451).getInt(34), this.currentPdfFile, subtype, 0));
            }
            if (APobjN.getDictionary(7998) != null) {
                normalOnDic = APobjN.getDictionary(7998);
                form.setNormalOnState("On");
            } else {
                otherValues = APobjN.getOtherDictionaries();
                if (otherValues != null && !otherValues.isEmpty()) {
                    for (String key : otherValues.keySet()) {
                        normalOnDic = val = (PdfObject)otherValues.get(key);
                        form.setNormalOnState(key);
                    }
                }
            }
            if (normalOnDic != null) {
                comp.setText(null);
                comp.setSelectedIcon(new FixImageIcon(form, normalOnDic, form.getDictionary(7451).getInt(34), this.currentPdfFile, subtype, 0));
                if (comp.getIcon() == null) {
                    comp.setIcon(new FixImageIcon(form, null, form.getDictionary(7451).getInt(34)));
                }
            }
        }
        if (form.hasNoDownIcon()) {
            comp.setPressedIcon(comp.getIcon());
        } else {
            if (form.hasOffsetDownIcon()) {
                offsetDownImage = 1;
            } else if (form.hasInvertDownIcon()) {
                offsetDownImage = 2;
            }
            if (offsetDownImage != 0) {
                if (normalOffDic != null) {
                    if (normalOnDic != null) {
                        downOffDic = normalOffDic;
                        downOnDic = normalOnDic;
                    } else {
                        downOffDic = normalOffDic;
                    }
                } else if (normalOnDic != null) {
                    downOffDic = normalOnDic;
                }
            }
            if (APobjD != null) {
                if (APobjD.getDecodedStream() != null) {
                    downOffDic = APobjD;
                } else if (APobjD.getDictionary(2045494) != null) {
                    downOffDic = APobjD.getDictionary(2045494);
                }
                if (APobjD.getDictionary(7998) != null) {
                    downOnDic = APobjD.getDictionary(7998);
                } else {
                    otherValues = APobjD.getOtherDictionaries();
                    if (otherValues != null && !otherValues.isEmpty()) {
                        for (String key : otherValues.keySet()) {
                            downOnDic = val = (PdfObject)otherValues.get(key);
                        }
                    }
                }
            }
            if (downOffDic == null || downOnDic == null) {
                if (downOffDic != null) {
                    comp.setText(null);
                    comp.setPressedIcon(new FixImageIcon(form, downOffDic, form.getDictionary(7451).getInt(34), this.currentPdfFile, subtype, offsetDownImage));
                } else if (downOnDic != null) {
                    comp.setText(null);
                    comp.setPressedIcon(new FixImageIcon(form, downOnDic, form.getDictionary(7451).getInt(34), this.currentPdfFile, subtype, offsetDownImage));
                }
            } else {
                comp.setPressedIcon(new FixImageIcon(form, downOnDic, downOffDic, form.getDictionary(7451).getInt(34), comp.isSelected() ? 1 : 0, this.currentPdfFile, subtype, offsetDownImage));
                comp.addActionListener(new SwingDownIconListener());
            }
        }
        if (APobjR != null) {
            if (APobjR.getDecodedStream() != null) {
                rollOffDic = APobjR;
            } else if (APobjR.getDictionary(2045494) != null) {
                rollOffDic = APobjR.getDictionary(2045494);
            }
            if (rollOffDic != null) {
                comp.setRolloverEnabled(true);
                comp.setText(null);
                comp.setRolloverIcon(new FixImageIcon(form, rollOffDic, form.getDictionary(7451).getInt(34), this.currentPdfFile, subtype, 0));
            }
            if (APobjR.getDictionary(7998) != null) {
                rollOnDic = APobjR.getDictionary(7998);
            } else {
                otherValues = APobjR.getOtherDictionaries();
                if (otherValues != null && !otherValues.isEmpty()) {
                    for (String key : otherValues.keySet()) {
                        rollOnDic = val = (PdfObject)otherValues.get(key);
                    }
                }
            }
            if (rollOnDic != null) {
                comp.setRolloverEnabled(true);
                comp.setText(null);
                comp.setRolloverSelectedIcon(new FixImageIcon(form, rollOnDic, form.getDictionary(7451).getInt(34), this.currentPdfFile, subtype, 0));
                if (comp.getRolloverIcon() == null) {
                    comp.setRolloverIcon(new FixImageIcon(form, null, form.getDictionary(7451).getInt(34)));
                }
            }
        }
        if (form.isSelected()) {
            Icon icn;
            comp.setSelected(true);
            if (comp instanceof JToggleButton && (icn = comp.getPressedIcon()) instanceof FixImageIcon) {
                ((FixImageIcon)icn).swapImage(true);
            }
        }
    }

    private void setupUniversalFeatures(JComponent comp, FormObject form) {
        comp.setOpaque(false);
        Font textFont = form.getTextFont();
        if (textFont != null) {
            comp.setFont(textFont);
        }
        comp.setForeground(form.getTextColor());
        Border newBorder = (Border)SwingData.generateBorderfromForm(form, 1.0f);
        comp.setBorder(newBorder);
        Color backgroundColor = FormObject.generateColor(form.getDictionary(7451).getFloatArray(4631));
        if (backgroundColor != null) {
            comp.setBackground(backgroundColor);
            comp.setOpaque(true);
        } else if (DecoderOptions.isRunningOnMac && comp instanceof JButton) {
            ((JButton)comp).setBorderPainted(false);
            comp.setBorder(null);
        }
        this.setupMouseListener(comp, form);
    }

    private void setupMouseListener(Component currentComp, FormObject form) {
        String noLinkToolTips;
        boolean[] characteristic = form.getCharacteristics();
        if (characteristic[0] || characteristic[1] || characteristic[5]) {
            currentComp.setVisible(false);
        }
        SwingListener jpedalListener = new SwingListener(form, this.formsActionHandler);
        if (currentComp instanceof JComboBox) {
            ((JComboBox)currentComp).getComponent(0).addMouseListener(jpedalListener);
            ((JComboBox)currentComp).getComponent(0).addKeyListener(jpedalListener);
            ((JComboBox)currentComp).getComponent(0).addFocusListener(jpedalListener);
            ((JComboBox)currentComp).addActionListener(jpedalListener);
        }
        if (currentComp instanceof JList) {
            ((JList)currentComp).addListSelectionListener(jpedalListener);
        }
        currentComp.addMouseListener(jpedalListener);
        currentComp.addMouseMotionListener(jpedalListener);
        currentComp.addKeyListener(jpedalListener);
        currentComp.addFocusListener(jpedalListener);
        PdfObject aData = form.getDictionary(17);
        if (!(aData == null || aData.getNameAsConstant(35) != 2433561 || (noLinkToolTips = System.getProperty("org.jpedal.noURLaccess")) != null && noLinkToolTips.equals("true"))) {
            String text = aData.getTextStreamValue(2433561);
            ((JComponent)currentComp).setToolTipText(text);
        }
    }

    private static void setToolTip(FormObject formObject, JComponent retComponent) {
        String userName = formObject.getTextStreamValue(9253);
        if (userName != null) {
            retComponent.setToolTipText(userName);
        }
    }

    @Override
    public GUIData getCustomCompData() {
        return new SwingData();
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public void setAnnotOrder(Map<String, String> annotOrder) {
    }

    public Object getPopupComponent(FormObject form, int cropBoxWith) {
        return new PdfSwingPopup(form, cropBoxWith);
    }
}

