/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.overridingImplementations;

import java.awt.Image;
import javax.swing.ImageIcon;

public class CustomImageIcon
extends ImageIcon {
    private static final long serialVersionUID = 5003778613900628453L;
    protected static float MAXSCALEFACTOR = 1.5f;
    protected int iconWidth = -1;
    protected int iconHeight = -1;
    protected final int iconRotation;
    protected int iconOpp = 180;
    protected int pageRotate;
    protected boolean displaySingle;

    public static void setMaxScaleFactor(float scaleFactor) {
        MAXSCALEFACTOR = scaleFactor;
    }

    public CustomImageIcon(int iconRot) {
        this.iconRotation = iconRot;
        this.iconOpp = this.iconRotation - 180;
        if (this.iconOpp < 0) {
            this.iconOpp += 360;
        }
    }

    public void setAttributes(int newWidth, int newHeight, int pageRotation, boolean displaySing) {
        int finalRotation = CustomImageIcon.validateRotationValue(pageRotation - this.iconRotation);
        this.pageRotate = pageRotation;
        if (finalRotation == this.iconRotation || finalRotation == this.iconOpp) {
            this.iconWidth = newWidth;
            this.iconHeight = newHeight;
        } else {
            this.iconWidth = newHeight;
            this.iconHeight = newWidth;
        }
        this.displaySingle = displaySing;
    }

    protected static int validateRotationValue(int rotation) {
        if ((rotation %= 360) < 0) {
            rotation += 360;
        }
        return rotation;
    }

    @Override
    public int getIconHeight() {
        if (this.iconHeight == -1) {
            Image image = this.getImage();
            if (image == null) {
                return -1;
            }
            return image.getHeight(null);
        }
        return this.iconHeight;
    }

    @Override
    public int getIconWidth() {
        if (this.iconWidth == -1) {
            Image image = this.getImage();
            if (image == null) {
                return -1;
            }
            return image.getWidth(null);
        }
        return this.iconWidth;
    }
}

