/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.javascript.functions;

import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.javascript.functions.JSFunction;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.sun.PrintfFormat;

public class AFSpecial
extends JSFunction {
    public AFSpecial(AcroRenderer acro, FormObject formObject) {
        super(acro, formObject);
    }

    @Override
    public int execute(String js, String[] args, int type, int event, char keyPressed) {
        if (args == null) {
            org.jpedal.objects.javascript.functions.AFSpecial.debug("Unknown implementation in " + js);
        } else if (args.length < 1) {
            org.jpedal.objects.javascript.functions.AFSpecial.debug("Values length is less than 1");
        } else {
            int specialID = -1;
            char c = args[1].charAt(0);
            if (args[1].length() == 1 && c >= '0' && c <= '3') {
                specialID = Integer.parseInt(args[1]);
            }
            boolean isExecuted = true;
            String currentVal = (String)this.formObject.getFormValue();
            String processedVal = "";
            if (type == 1) {
                switch (specialID) {
                    case 0: {
                        if (event == 6) {
                            processedVal = org.jpedal.objects.javascript.functions.AFSpecial.applyRegexp(currentVal, new String[]{"\\d{5}"});
                            break;
                        }
                        if (event != 2) break;
                        processedVal = org.jpedal.objects.javascript.functions.AFSpecial.applyRegexp(currentVal, new String[]{"\\d{0,5}"});
                        break;
                    }
                    case 1: {
                        if (event == 6) {
                            processedVal = org.jpedal.objects.javascript.functions.AFSpecial.applyRegexp(currentVal, new String[]{"\\d{5}(\\.|[- ])?\\d{4}"});
                            break;
                        }
                        if (event != 2) break;
                        processedVal = org.jpedal.objects.javascript.functions.AFSpecial.applyRegexp(currentVal, new String[]{"\\d{0,5}(\\.|[- ])?\\d{0,4}"});
                        break;
                    }
                    case 2: {
                        if (event == 6) {
                            processedVal = org.jpedal.objects.javascript.functions.AFSpecial.applyRegexp(currentVal, new String[]{"\\d{3}(\\.|[- ])?\\d{4}", "\\d{3}(\\.|[- ])?\\d{3}(\\.|[- ])?\\d{4}", "\\(\\d{3}\\)(\\.|[- ])?\\d{3}(\\.|[- ])?\\d{4}", "011(\\.|[- \\d])*"});
                            break;
                        }
                        if (event != 2) break;
                        processedVal = org.jpedal.objects.javascript.functions.AFSpecial.applyRegexp(currentVal, new String[]{"\\d{0,3}(\\.|[- ])?\\d{0,3}(\\.|[- ])?\\d{0,4}", "\\(\\d{0,3}", "\\(\\d{0,3}\\)(\\.|[- ])?\\d{0,3}(\\.|[- ])?\\d{0,4}", "\\(\\d{0,3}(\\.|[- ])?\\d{0,3}(\\.|[- ])?\\d{0,4}", "\\d{0,3}\\)(\\.|[- ])?\\d{0,3}(\\.|[- ])?\\d{0,4}", "011(\\.|[- \\d])*"});
                        break;
                    }
                    case 3: {
                        if (event == 6) {
                            processedVal = org.jpedal.objects.javascript.functions.AFSpecial.applyRegexp(currentVal, new String[]{"\\d{3}(\\.|[- ])?\\d{2}(\\.|[- ])?\\d{4}"});
                            break;
                        }
                        if (event != 2) break;
                        processedVal = org.jpedal.objects.javascript.functions.AFSpecial.applyRegexp(currentVal, new String[]{"\\d{0,3}(\\.|[- ])?\\d{0,2}(\\.|[- ])?\\d{0,4}"});
                        break;
                    }
                    default: {
                        if (event != 6 && event != 2) break;
                        processedVal = org.jpedal.objects.javascript.functions.AFSpecial.applyRegexp(currentVal, new String[]{args[1]});
                    }
                }
                if (event == 6) {
                    if (!processedVal.equals(currentVal)) {
                        this.maskAlert(6, args);
                        this.execute(js, args, type, event, keyPressed);
                    } else {
                        this.formObject.setLastValidValue(processedVal);
                        this.formObject.updateValue(processedVal, false, true);
                    }
                } else if (event != 1 && event != 2) {
                    isExecuted = false;
                }
            } else if (type == 3) {
                float number = 0.0f;
                String mask = "";
                if (currentVal != null && !currentVal.isEmpty()) {
                    switch (specialID) {
                        case 0: {
                            mask = "99999";
                            break;
                        }
                        case 1: {
                            mask = "99999-9999";
                            break;
                        }
                        case 2: {
                            int digitCount = org.jpedal.objects.javascript.functions.AFSpecial.countDigits(currentVal);
                            if (digitCount > 9) {
                                mask = "(999) 999-9999";
                                break;
                            }
                            mask = "999-9999";
                            break;
                        }
                        case 3: {
                            mask = "999-99-9999";
                            break;
                        }
                        default: {
                            isExecuted = false;
                        }
                    }
                    if (isExecuted) {
                        processedVal = new PrintfFormat(mask).sprintf(0.0);
                    }
                    this.formObject.setLastValidValue(processedVal);
                    this.formObject.updateValue(processedVal, false, true);
                }
            } else {
                isExecuted = false;
            }
            if (!isExecuted) {
                org.jpedal.objects.javascript.functions.AFSpecial.debug("Unknown setting or command " + args[0] + " in " + js);
            }
        }
        return 0;
    }

    private static int countDigits(String currentVal) {
        int count = 0;
        int len = currentVal.length();
        for (int i = 0; i < len; ++i) {
            char c = currentVal.charAt(i);
            if (c < '0' || c > '9') continue;
            ++count;
        }
        return count;
    }
}

