/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import org.jpedal.exception.PdfException;
import org.jpedal.external.FontHandler;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.raw.FontObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.PdfFontFactory;
import org.jpedal.parser.PdfObjectCache;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;

public class FontResolver {
    public static PdfFont resolveFont(GraphicsState gs, PdfStreamDecoder pdfStreamDecoder, String fontID, PdfFontFactory pdfFontFactory, PdfObjectCache cache) {
        PdfFont restoredFont;
        String fontKey = fontID;
        if (gs != null && cache.resolvedFonts.get("t-" + fontID) != null) {
            fontKey = fontID + ':' + gs.nonstrokeColorSpace.getColor().getRGB();
        }
        if ((restoredFont = (PdfFont)cache.resolvedFonts.get(fontKey)) == null) {
            block11: {
                PdfObject newFont = (PdfObject)cache.unresolvedFonts.get(fontID);
                if (newFont == null) {
                    cache.directFonts.remove(fontID);
                }
                if (pdfStreamDecoder.parserOptions.isFlattenedForm() && newFont == null) {
                    newFont = new FontObject("1 0 R");
                    fontID = FontResolver.resolveFlattenedFont(fontID, newFont);
                }
                if (newFont != null) {
                    pdfStreamDecoder.currentPdfFile.checkResolved(newFont);
                    try {
                        DynamicVectorRenderer current = pdfStreamDecoder.current;
                        boolean fallbackToArial = false;
                        boolean isHTML = current.isHTMLorSVG();
                        if (isHTML && !current.getBooleanValue(46)) {
                            fallbackToArial = true;
                        }
                        restoredFont = pdfFontFactory.createFont(fallbackToArial, newFont, fontID, pdfStreamDecoder.objectStoreStreamRef, pdfStreamDecoder.parserOptions.isRenderPage(), pdfStreamDecoder.errorTracker, pdfStreamDecoder.isPrinting);
                        FontHandler fontHandler = current.getFontHandler();
                        if (fontHandler != null) {
                            fontHandler.processFont(isHTML, restoredFont, current, newFont, pdfStreamDecoder.currentPdfFile);
                        }
                    }
                    catch (PdfException e) {
                        if (!LogWriter.isOutput()) break block11;
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                }
            }
            if (restoredFont != null && !pdfStreamDecoder.parserOptions.isFlattenedForm()) {
                pdfStreamDecoder.cache.resolvedFonts.put(fontKey, restoredFont);
                if (restoredFont.getFontType() == 1228944679) {
                    pdfStreamDecoder.cache.resolvedFonts.put("t-" + fontID, "T3");
                }
            }
        }
        return restoredFont;
    }

    private static String resolveFlattenedFont(String fontID, PdfObject newFont) {
        String name = StandardFonts.expandName(fontID.replace(",", "-"));
        if (FontMappings.fontSubstitutionAliasTable.get(name) == null && FontMappings.fontSubstitutionTable != null && FontMappings.fontSubstitutionTable.get(name) == null) {
            String rawName = name.toLowerCase();
            name = rawName.contains("bold") ? "Arial-Bold" : (rawName.contains("italic") ? "Arial-Italic" : "Arial");
        }
        newFont.setName((Object)678461817, name);
        newFont.setName((Object)879786873, name);
        newFont.setConstant(1147962727, 1217103210);
        fontID = StandardFonts.expandName(name);
        return fontID;
    }
}

