/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.gs;

import org.jpedal.color.GenericColorSpace;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.TextState;
import org.jpedal.parser.ParserOptions;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_Object;

public class GraphicsStates {
    private boolean isStackInitialised;
    private Vector_Object graphicsStateStack;
    private Vector_Object strokeColorStateStack;
    private Vector_Object nonstrokeColorStateStack;
    private Vector_Object textStateStack;
    int depth;
    ParserOptions parserOptions = new ParserOptions();

    public GraphicsStates(ParserOptions parserOptions) {
        this.parserOptions = parserOptions;
    }

    public void pushGraphicsState(GraphicsState gs, DynamicVectorRenderer current) {
        if (!this.isStackInitialised) {
            this.isStackInitialised = true;
            this.graphicsStateStack = new Vector_Object(10);
            this.textStateStack = new Vector_Object(10);
            this.strokeColorStateStack = new Vector_Object(20);
            this.nonstrokeColorStateStack = new Vector_Object(20);
        }
        ++this.depth;
        this.graphicsStateStack.push(gs.clone());
        this.textStateStack.push(gs.getTextState().clone());
        this.nonstrokeColorStateStack.push(gs.nonstrokeColorSpace.clone());
        this.strokeColorStateStack.push(gs.strokeColorSpace.clone());
        current.resetOnColorspaceChange();
    }

    public GraphicsState restoreGraphicsState(GraphicsState gs, DynamicVectorRenderer current) {
        if (!this.isStackInitialised) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("No GraphicsState saved to retrieve");
            }
            gs = new GraphicsState();
            gs.setTextState(new TextState());
        } else if (this.depth > 0) {
            --this.depth;
            gs = (GraphicsState)this.graphicsStateStack.pull();
            gs.setTextState((TextState)this.textStateStack.pull());
            gs.strokeColorSpace = (GenericColorSpace)this.strokeColorStateStack.pull();
            gs.nonstrokeColorSpace = (GenericColorSpace)this.nonstrokeColorStateStack.pull();
            if (gs.strokeColorSpace.getID() == -2073385820) {
                gs.strokeColorSpace.restoreColorStatus();
            }
            if (gs.nonstrokeColorSpace.getID() == -2073385820) {
                gs.nonstrokeColorSpace.restoreColorStatus();
            }
        }
        if (this.parserOptions.isRenderPage()) {
            current.drawClip(gs, this.parserOptions.defaultClip, false);
            current.resetOnColorspaceChange();
            current.drawFillColor(gs.getNonstrokeColor());
            current.drawStrokeColor(gs.getStrokeColor());
            current.setGraphicsState(2, gs.getAlpha(2), gs.getBMValue());
            current.setGraphicsState(1, gs.getAlpha(1), gs.getBMValue());
        }
        return gs;
    }

    public int getDepth() {
        return this.depth;
    }

    public void correctDepth(int currentDepth, GraphicsState gs, DynamicVectorRenderer current) {
        while (this.depth > currentDepth) {
            this.restoreGraphicsState(gs, current);
        }
    }
}

