/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image;

import java.awt.image.BufferedImage;
import org.jpedal.color.ColorspaceFactory;
import org.jpedal.color.DeviceRGBColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.external.ErrorTracker;
import org.jpedal.external.ImageHandler;
import org.jpedal.io.IDObjectDecoder;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.ObjectUtils;
import org.jpedal.io.PdfFilteredReader;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.PdfImageData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.XObject;
import org.jpedal.parser.image.ImageDecoder;
import org.jpedal.parser.image.data.ImageData;

public class ID
extends ImageDecoder {
    public ID(int imageCount, PdfObjectReader currentPdfFile, ErrorTracker errorTracker, ImageHandler customImageHandler, ObjectStore objectStoreStreamRef, PdfImageData pdfImages, int formLevel, PdfPageData pageData, String imagesInFile, String formName) {
        super(imageCount, currentPdfFile, errorTracker, customImageHandler, objectStoreStreamRef, pdfImages, formLevel, pageData, imagesInFile, formName);
    }

    @Override
    public int processImage(int dataPointer, int startInlineStream, byte[] stream, int tokenNumber) throws Exception {
        int inline_start_pointer;
        XObject XObject2 = new XObject(6420);
        IDObjectDecoder objectDecoder = new IDObjectDecoder(this.currentPdfFile.getObjectReader());
        objectDecoder.setEndPt(dataPointer - 2);
        objectDecoder.readDictionaryAsObject(XObject2, startInlineStream, stream);
        BufferedImage image = null;
        int i = inline_start_pointer = dataPointer + 1;
        int streamLength = stream.length;
        while ((streamLength - i <= 3 || stream[i + 1] != 69 || stream[i + 2] != 73 || (stream[i + 3] != 10 || streamLength != i + 4 && stream[i + 4] != 81) && (stream[i + 3] != 32 || stream[i + 4] != 10)) && (streamLength - i <= 3 || stream[i] != 32 && stream[i] != 10 && stream[i] != 13 && (stream[i + 3] != 32 || stream[i + 4] != 81) || stream[i + 1] != 69 || stream[i + 2] != 73 || stream[i + 3] != 32 && stream[i + 3] != 10 && stream[i + 3] != 13) && ++i != streamLength) {
        }
        if (this.renderImages || this.finalImagesExtracted || this.clippedImagesExtracted || this.rawImagesExtracted) {
            Object col;
            String colKey;
            String image_name = this.parserOptions.getFileName() + "-IN-" + tokenNumber;
            int endPtr = i;
            if (i < stream.length && stream[endPtr] != 32 && stream[endPtr] != 10 && stream[endPtr] != 13) {
                ++endPtr;
            }
            if (stream[inline_start_pointer] == 10) {
                ++inline_start_pointer;
            }
            byte[] i_data = new byte[endPtr - inline_start_pointer];
            System.arraycopy(stream, inline_start_pointer, i_data, 0, endPtr - inline_start_pointer);
            XObject2.setStream(i_data);
            PdfObject ColorSpace2 = ((PdfObject)XObject2).getDictionary(2087749783);
            if (ColorSpace2 != null && (colKey = ColorSpace2.getGeneralStringValue()) != null && (col = this.cache.get(2, colKey)) != null) {
                ColorSpace2 = (PdfObject)col;
            }
            if (this.customImageHandler != null) {
                image = this.customImageHandler.processImageData(this.gs, XObject2);
            }
            PdfArrayIterator filters = ((PdfObject)XObject2).getMixedArray(1011108731);
            boolean needsDecoding = false;
            if (filters != null && filters.hasMoreTokens()) {
                int firstValue = filters.getNextValueAsConstant(false);
                needsDecoding = firstValue != 1399277700 && firstValue != 1180911742;
            }
            int i_w = ((PdfObject)XObject2).getInt(959726687);
            int i_h = ((PdfObject)XObject2).getInt(959926393);
            int i_bpc = ((PdfObject)XObject2).getInt(-1344207655);
            boolean inline_imageMask = ((PdfObject)XObject2).getBoolean(1516403337);
            if (needsDecoding) {
                PdfFilteredReader filter = new PdfFilteredReader();
                i_data = filter.decodeFilters(ObjectUtils.setupDecodeParms(XObject2, this.currentPdfFile.getObjectReader()), i_data, filters, i_w, i_h, null);
            }
            GenericColorSpace decodeColorData = new DeviceRGBColorSpace();
            if (ColorSpace2 != null) {
                decodeColorData = ColorspaceFactory.getColorSpaceInstance(this.currentPdfFile, ColorSpace2);
                decodeColorData.setPrinting(this.isPrinting);
                this.cache.put(1, decodeColorData.getID(), (Object)"x");
            }
            if (i_data != null) {
                if (this.customImageHandler == null || image == null && !this.customImageHandler.alwaysIgnoreGenericHandler()) {
                    ImageData imageData = new ImageData(0);
                    imageData.setWidth(i_w);
                    imageData.setHeight(i_h);
                    imageData.setDepth(i_bpc);
                    imageData.setObjectData(i_data);
                    imageData.setCompCount(decodeColorData.getColorSpace().getNumComponents());
                    image = this.processImage(decodeColorData, image_name, imageData, inline_imageMask, XObject2, false);
                    this.currentImage = image_name;
                }
                if (this.isPrinting && image != null && this.gs != null && image.getHeight() == 1 && this.gs.CTM[1][1] < 1.0f) {
                    image = null;
                }
                if (image != null) {
                    if (this.current.isHTMLorSVG()) {
                        this.generateTransformedImage(image, image_name);
                    } else if (this.parserOptions.renderDirectly() || this.useHiResImageForDisplay) {
                        this.gs.x = this.gs.CTM[2][0];
                        this.gs.y = this.gs.CTM[2][1];
                        this.current.drawImage(this.parserOptions.getPageNumber(), image, this.gs, false, image_name, -1);
                    } else if (this.clippedImagesExtracted) {
                        this.generateTransformedImage(image, image_name);
                    } else {
                        this.generateTransformedImageSingle(image, image_name);
                    }
                    if (image != null) {
                        image.flush();
                    }
                }
            }
        }
        dataPointer = i + 3;
        return dataPointer;
    }
}

