/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;

public class ImageUtils {
    public static BufferedImage rotateImage(BufferedImage savedImage, int angle) {
        BufferedImage rotatedImage;
        if (angle == 180) {
            AffineTransform tx = AffineTransform.getScaleInstance(-1.0, -1.0);
            tx.translate(-savedImage.getWidth(null), -savedImage.getHeight(null));
            AffineTransformOp op = new AffineTransformOp(tx, 1);
            rotatedImage = op.filter(savedImage, null);
        } else {
            int w = savedImage.getWidth();
            int h = savedImage.getHeight();
            rotatedImage = new BufferedImage(h, w, savedImage.getType());
            Graphics2D g2 = rotatedImage.createGraphics();
            g2.rotate(Math.toRadians(angle), w / 2, h / 2);
            int diff = (w - h) / 2;
            if (angle == 90) {
                g2.drawImage((Image)savedImage, diff, diff, null);
            } else if (angle == 270) {
                g2.drawImage((Image)savedImage, -diff, -diff, null);
            }
        }
        return rotatedImage;
    }

    public static BufferedImage invertImage(BufferedImage savedImage) {
        AffineTransform tx = AffineTransform.getScaleInstance(1.0, -1.0);
        tx.translate(0.0, -savedImage.getHeight(null));
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        BufferedImage invertedImage = op.filter(savedImage, null);
        return invertedImage;
    }
}

