/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.jpedal.exception.PdfException;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.ParserOptions;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.ImageDisplay;
import org.jpedal.utils.LogWriter;

public class PDFObjectToImage {
    public static BufferedImage getImageFromPdfObject(PdfObject newSMask, int fx, int fw, int fy, int fh, PdfObjectReader currentPdfFile, ParserOptions parserOptions, int formLevel, float multiplyer, boolean useTransparency, float scaling) {
        BufferedImage smaskImage;
        int h;
        PdfStreamDecoder glyphDecoder;
        ImageDisplay glyphDisplay;
        ObjectStore localStore;
        byte[] objectData;
        block13: {
            objectData = currentPdfFile.readStream(newSMask, true, true, false, false, false, newSMask.getCacheName(currentPdfFile.getObjectReader()));
            localStore = new ObjectStore();
            glyphDisplay = new ImageDisplay(0, false, 20, localStore);
            glyphDisplay.setMode(DynamicVectorRenderer.Mode.SMASK);
            boolean useHiRes = true;
            glyphDecoder = new PdfStreamDecoder(currentPdfFile, true, null);
            glyphDecoder.setParameters(parserOptions.isPageContent(), parserOptions.isRenderPage(), parserOptions.getRenderMode(), parserOptions.getExtractionMode(), false, false);
            glyphDecoder.setObjectValue(-8, localStore);
            glyphDisplay.setHiResImageForDisplayMode(true);
            glyphDecoder.setRenderer(glyphDisplay);
            glyphDecoder.setMultiplyer(multiplyer);
            glyphDecoder.setFormLevel(formLevel);
            try {
                PdfObject SMaskResources = newSMask.getDictionary(2004251818);
                if (SMaskResources != null) {
                    glyphDecoder.readResources(SMaskResources, false);
                }
            }
            catch (PdfException e) {
                if (!LogWriter.isOutput()) break block13;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        int w = fw - fx;
        if (w < 0) {
            w = -w;
            fx = fw;
        }
        if (w == 0) {
            w = 1;
        }
        if ((h = fh - fy) < 0) {
            h = -h;
            fy = fh;
        }
        if (h == 0) {
            h = 1;
        }
        try {
            PdfObject group;
            smaskImage = new BufferedImage((int)((float)w * scaling), (int)((float)h * scaling), 2);
            Graphics2D formG2 = smaskImage.createGraphics();
            formG2.scale(scaling, scaling);
            formG2.translate(-fx, -fy);
            glyphDisplay.setG2(formG2);
            if (useTransparency && (group = newSMask.getDictionary(1111442775)) != null) {
                currentPdfFile.checkResolved(group);
                String Tname = group.getName(35);
                PdfObject cs = group.getDictionary(2087749783);
                if ((group.getBoolean(25) || group.getBoolean(27) || cs == null || cs.getParameterConstant(2087749783) != 1498837125) && Tname.equals("Transparency")) {
                    formG2.setComposite(AlphaComposite.getInstance(3, 0.5f));
                }
            }
        }
        catch (Error err) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception: " + err.getMessage());
            }
            smaskImage = null;
        }
        if (objectData != null) {
            glyphDecoder.decodeStreamIntoObjects(objectData, false);
        }
        glyphDecoder.dispose();
        localStore.flush();
        return smaskImage;
    }
}

