/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import org.jpedal.io.ColorSpaceConvertor;

public class SMask {
    static final int[] transparentPixel = new int[]{0, 0, 0, 0};

    public static BufferedImage applySmask(BufferedImage image, BufferedImage smask, boolean isRGB) {
        boolean isRotated;
        if (smask == null) {
            return image;
        }
        if (smask.getType() == 12) {
            smask = ColorSpaceConvertor.convertToARGB(smask);
        }
        boolean debug = false;
        boolean maybeFourBit = true;
        WritableRaster mask = smask.getRaster();
        WritableRaster imgRas = null;
        boolean isConverted = false;
        int imageW = image.getWidth();
        int imageH = image.getHeight();
        int smaskW = smask.getWidth();
        int smaskH = smask.getHeight();
        boolean bl = isRotated = imageW > imageH && smaskW < smaskH || imageW < imageH && smaskW > smaskH;
        if (isRotated) {
            smaskH = smask.getWidth();
            smaskW = smask.getHeight();
        }
        float ratioW = 0.0f;
        float ratioH = 0.0f;
        if (!(isRotated || imageW == smaskW && imageH == smaskH)) {
            ratioW = (float)imageW / (float)smaskW;
            ratioH = (float)imageH / (float)smaskH;
            if (isRGB && (double)ratioW == 0.5 && (double)ratioH == 0.5) {
                BufferedImage resizedImage = new BufferedImage(smaskW, smaskH, image.getType());
                Graphics2D g = resizedImage.createGraphics();
                g.dispose();
                g.setComposite(AlphaComposite.Src);
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g.drawImage(image, 0, 0, smaskW, smaskH, null);
                image = resizedImage;
                imageW = smaskW;
                imageH = smaskH;
                ratioW = 1.0f;
                ratioH = 1.0f;
            }
        }
        int colorComponents = smask.getColorModel().getNumComponents();
        int[] values = new int[colorComponents];
        int[] pix = new int[4];
        int maskH = mask.getHeight();
        for (int y = 0; y < imageH; ++y) {
            for (int x = 0; x < imageW; ++x) {
                int line = y;
                if (isRotated) {
                    if (ratioW == 0.0f) {
                        mask.getPixels(line, maskH - 1 - x, 1, 1, values);
                    } else {
                        mask.getPixels((int)((float)line / ratioW), (int)((float)x / ratioH), 1, 1, values);
                    }
                } else if (ratioW == 0.0f) {
                    mask.getPixels(x, line, 1, 1, values);
                } else {
                    mask.getPixels((int)((float)x / ratioW), (int)((float)line / ratioH), 1, 1, values);
                }
                if (!isConverted) {
                    if (image.getType() != 2) {
                        image = ColorSpaceConvertor.convertToARGB(image);
                    }
                    imgRas = image.getRaster();
                    isConverted = true;
                }
                imgRas.getPixels(x, y, 1, 1, pix);
                if (values.length == 3) {
                    imgRas.setPixels(x, y, 1, 1, new int[]{pix[0], pix[1], pix[2], values[0]});
                    continue;
                }
                if (colorComponents == 1) {
                    if (maybeFourBit && values[0] < 16 && pix[0] < 16 && pix[1] < 16 && pix[2] < 16) {
                        imgRas.setPixels(x, y, 1, 1, new int[]{pix[0] * 16, pix[1] * 16, pix[2] * 16, values[0]});
                        continue;
                    }
                    imgRas.setPixels(x, y, 1, 1, new int[]{pix[0], pix[1], pix[2], values[0]});
                    maybeFourBit = false;
                    continue;
                }
                if (values[0] == 0 && values[1] == 0 && values[2] == 0 && values[3] == 0) {
                    if (pix[3] == 255) continue;
                    imgRas.setPixels(x, y, 1, 1, transparentPixel);
                    continue;
                }
                if (pix[0] == 0 && pix[1] == 0 && pix[2] == 0 && pix[3] == 0) {
                    if (values[0] == 0 && values[1] == 0 && values[2] == 0 && values[3] == 0) {
                        imgRas.setPixels(x, y, 1, 1, transparentPixel);
                        continue;
                    }
                    if (values[3] != 255) continue;
                    imgRas.setPixels(x, y, 1, 1, transparentPixel);
                    continue;
                }
                if (values[3] == 0 && pix[0] != 0 && pix[1] != 0 && pix[2] != 0) {
                    imgRas.setPixels(x, y, 1, 1, new int[]{pix[0], pix[1], pix[2], 255 - values[0]});
                    continue;
                }
                if (values[0] == 0 && values[1] == 0 && values[2] == 0 && values[3] == 255) {
                    imgRas.setPixels(x, y, 1, 1, transparentPixel);
                    continue;
                }
                if (pix[0] == 0 && pix[1] == 0 && pix[2] == 0 && pix[3] < 20) {
                    imgRas.setPixels(x, y, 1, 1, transparentPixel);
                    continue;
                }
                if (pix[0] == 0 && pix[1] == 0 && pix[2] == 0 && pix[3] < 64) {
                    if (values[0] > pix[3]) {
                        imgRas.setPixels(x, y, 1, 1, new int[]{0, 0, 0, values[0] - pix[3]});
                        continue;
                    }
                    imgRas.setPixels(x, y, 1, 1, transparentPixel);
                    continue;
                }
                if (pix[0] == 255 && pix[1] == 255 && pix[2] == 255 && pix[3] == 255) {
                    imgRas.setPixels(x, y, 1, 1, new int[]{pix[0], pix[1], pix[2], values[0]});
                    continue;
                }
                if (values[3] == 255 && pix[0] != 0 && pix[1] != 0 && pix[2] != 0 && values[0] > pix[3]) continue;
                imgRas.setPixels(x, y, 1, 1, new int[]{pix[0], pix[1], pix[2], values[0]});
            }
        }
        return image;
    }
}

