/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.shape;

import java.awt.Shape;
import java.awt.geom.Area;
import javafx.scene.shape.Path;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfShape;
import org.jpedal.parser.ParserOptions;
import org.jpedal.render.DynamicVectorRenderer;

public class B {
    public static Shape execute(boolean isStar, boolean isLowerCase, GraphicsState gs, int formLevel, PdfShape currentDrawShape, DynamicVectorRenderer current, ParserOptions parserOptions) {
        boolean useJavaFX = parserOptions.useJavaFX();
        boolean renderPage = parserOptions.isRenderPage();
        Shape currentShape = null;
        if (parserOptions.isLayerVisible()) {
            boolean hasShape;
            if (isStar) {
                currentDrawShape.setEVENODDWindingRule();
            } else {
                currentDrawShape.setNONZEROWindingRule();
            }
            if (isLowerCase) {
                currentDrawShape.closeShape();
            }
            Path fxPath = null;
            if (useJavaFX) {
                fxPath = currentDrawShape.getPath();
            } else {
                currentShape = currentDrawShape.generateShapeFromPath(gs.CTM, gs.getLineWidth(), 66, current.getType());
                if (currentShape != null && currentShape.getBounds2D().getWidth() < 1.0 && currentShape.getBounds2D().getHeight() < 1.0) {
                    currentDrawShape.resetPath();
                    return null;
                }
            }
            boolean bl = hasShape = currentShape != null || fxPath != null;
            if (!useJavaFX && !isLowerCase && formLevel > 2 && hasShape && currentDrawShape.isClosed() && gs.getClippingShape() != null && gs.nonstrokeColorSpace.getID() == 1498837125 && gs.nonstrokeColorSpace.getColor().getRGB() == -1) {
                Area a = gs.getClippingShape();
                a.subtract(new Area(currentShape));
                currentShape = a;
            }
            if (renderPage && hasShape) {
                gs.setStrokeColor(gs.strokeColorSpace.getColor());
                gs.setNonstrokeColor(gs.nonstrokeColorSpace.getColor());
                if (gs.nonstrokeColorSpace.getColor().getRGB() == -16777216 && gs.getAlpha(1) == 0.0f) {
                    gs.setFillType(1);
                } else {
                    gs.setFillType(3);
                }
                if (useJavaFX) {
                    current.drawShape(fxPath, gs, 66);
                } else {
                    current.drawShape(currentShape, gs, 66);
                    if (current.isHTMLorSVG()) {
                        current.eliminateHiddenText(currentShape, gs, currentDrawShape.getSegmentCount(), false);
                    }
                }
            }
        }
        currentDrawShape.setClip(false);
        currentDrawShape.resetPath();
        return currentShape;
    }
}

