/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.text;

import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.parser.ParserOptions;
import org.jpedal.parser.text.GlyphData;
import org.jpedal.parser.text.TD;

public class CIDTextUtils {
    static int getCIDCharValues(int i, byte[] stream, int streamLength, GlyphData glyphData, PdfFont currentFontData, ParserOptions parserOptions) {
        boolean hasCharString;
        boolean debug = false;
        float actualWidth = 0.0f;
        if (StandardFonts.CMAP == null) {
            StandardFonts.readCMAP();
        }
        int firstVal = glyphData.getRawInt();
        String newValue = null;
        if (firstVal == 92) {
            firstVal = stream[++i] & 0xFF;
            if (streamLength > i + 2 && Character.isDigit((char)stream[i])) {
                int numberCount = 1;
                if (Character.isDigit((char)stream[i + 1])) {
                    ++numberCount;
                    if (Character.isDigit((char)stream[i + 2])) {
                        ++numberCount;
                    }
                }
                firstVal = TD.readEscapeValue(i, numberCount, 8, stream);
                i = i + numberCount - 1;
                if (firstVal > 255) {
                    firstVal -= 256;
                }
            } else if (firstVal == 117) {
                firstVal = TD.readEscapeValue(i + 1, 4, 16, stream);
                i += 4;
            } else {
                firstVal = CIDTextUtils.convertEscapeChar(firstVal);
            }
            glyphData.setRaw(firstVal);
        } else {
            firstVal = glyphData.getRawChar();
        }
        String firstValue = StandardFonts.CMAP[glyphData.getRawChar()];
        boolean isEmbedded = currentFontData.isFontEmbedded;
        boolean bl = hasCharString = glyphData.getRawInt() > 0 && currentFontData.CMapName != null && currentFontData.getFontType() == -1684566726 && currentFontData.getGlyphData().getCharStrings().containsKey(String.valueOf(glyphData.getRawInt()));
        if (currentFontData.CMapName == null || !currentFontData.CMapName.equals("OneByteIdentityH")) {
            if (!hasCharString && (currentFontData.hasDoubleBytes || firstValue == null || currentFontData.isDoubleBytes() != 0 || glyphData.getRawInt() > 128 && glyphData.getRawInt() != 233)) {
                int iBefore = i++;
                int secondVal = stream[i] & 0xFF;
                boolean secondByteIsEscaped = false;
                if (stream[i] == 92) {
                    ++i;
                    secondByteIsEscaped = true;
                    if (glyphData.getRawInt() == 0) {
                        while (stream[i] == 13 || stream[i] == 92 && stream[i - 1] == 13) {
                            ++i;
                        }
                    }
                    secondVal = stream[i] & 0xFF;
                    if (streamLength > i + 2 && Character.isDigit((char)stream[i])) {
                        int numberCount = 1;
                        if (Character.isDigit((char)stream[i + 1])) {
                            ++numberCount;
                            if (Character.isDigit((char)stream[i + 2])) {
                                ++numberCount;
                            }
                        }
                        secondVal = TD.readEscapeValue(i, numberCount, 8, stream);
                        i = i + numberCount - 1;
                        if (secondVal > 255) {
                            secondVal -= 256;
                        }
                    } else if (secondVal == 117) {
                        secondVal = TD.readEscapeValue(i + 1, 4, 16, stream);
                        i += 4;
                    } else {
                        secondVal = CIDTextUtils.convertEscapeChar(secondVal);
                    }
                }
                int secondByte = secondVal;
                char combinedVal = (char)((glyphData.getRawChar() << 8) + secondVal);
                newValue = StandardFonts.CMAP[combinedVal];
                int isDouble = currentFontData.isDoubleBytes(firstVal, secondByte, secondByteIsEscaped);
                if (isEmbedded && (isDouble == 1 || combinedVal < '\u0100' || newValue != null)) {
                    glyphData.setRawInt(combinedVal);
                    glyphData.setRawChar(combinedVal);
                } else if (!isEmbedded && isDouble == 1 && (newValue != null || combinedVal < '\u0100' || !secondByteIsEscaped && secondByte != 41)) {
                    glyphData.setRawInt(combinedVal);
                    glyphData.setRawChar(combinedVal);
                } else if (isDouble == 0 && !isEmbedded && firstVal > 128 && newValue != null && firstValue == null) {
                    glyphData.setRawInt(combinedVal);
                    glyphData.setRawChar(combinedVal);
                } else if (isDouble == 0 && !isEmbedded && firstVal > 128 && newValue == null && firstValue != null) {
                    i = iBefore;
                    newValue = firstValue;
                } else {
                    i = iBefore;
                }
                if (!isEmbedded && (actualWidth = currentFontData.getDefaultWidth(glyphData.getRawInt())) == -1.0f) {
                    actualWidth = currentFontData.getDefaultWidth(-1);
                }
            } else {
                actualWidth = -1.0f;
                if (!(isEmbedded || currentFontData.getFontType() != -1684566726 && currentFontData.getFontType() != -1684566724 || (actualWidth = currentFontData.getDefaultWidth(glyphData.getRawInt())) != -1.0f)) {
                    actualWidth = currentFontData.getDefaultWidth(-1) / 2.0f;
                }
            }
        }
        glyphData.setActualWidth(actualWidth);
        if (newValue != null) {
            glyphData.setDisplayValue(newValue);
        } else {
            glyphData.setDisplayValue(String.valueOf(glyphData.getRawChar()));
        }
        if (parserOptions.isTextExtracted()) {
            glyphData.setUnicodeValue(currentFontData.getUnicodeValue(glyphData.getDisplayValue(), glyphData.getRawChar()));
        }
        if (glyphData.getRawChar() == '\\') {
            glyphData.setValueForHTML(92);
            glyphData.setRawChar('x');
        }
        return i;
    }

    static int convertEscapeChar(int secondVal) {
        if (secondVal == 110) {
            secondVal = 10;
        } else if (secondVal == 98) {
            secondVal = 8;
        } else if (secondVal == 116) {
            secondVal = 9;
        } else if (secondVal == 114) {
            secondVal = 13;
        } else if (secondVal == 102) {
            secondVal = 12;
        }
        return secondVal;
    }
}

