/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.text;

import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.T1GlyphFactory;
import org.jpedal.parser.ParserOptions;
import org.jpedal.parser.text.GlyphData;
import org.jpedal.parser.text.TD;

class HexTextUtils {
    HexTextUtils() {
    }

    static int getHexValue(byte[] stream, int i, GlyphData glyphData, PdfFont currentFontData, ParserOptions parserOptions) {
        int chars = 0;
        int charSize = glyphData.getCharSize();
        for (int i2 = 1; i2 < charSize; ++i2) {
            byte nextInt = stream[i + i2];
            if (nextInt == 62) {
                i2 = 4;
                charSize = 2;
                glyphData.setCharSize(2);
                continue;
            }
            if (nextInt == 10 || nextInt == 13) {
                ++i;
                --i2;
                continue;
            }
            ++chars;
        }
        return HexTextUtils.setValue(glyphData, HexTextUtils.getValue(chars, stream, i), i, charSize, currentFontData, parserOptions);
    }

    static int getHexCIDValue(byte[] stream, int i, GlyphData glyphData, PdfFont currentFontData, ParserOptions parserOptions) {
        char combinedVal;
        int isDouble;
        int charSize = 2;
        int val = HexTextUtils.getValue(1, stream, i);
        HexTextUtils.setValue(glyphData, val, i, charSize, currentFontData, parserOptions);
        if (StandardFonts.CMAP == null) {
            StandardFonts.readCMAP();
        }
        boolean hasCharString = glyphData.getRawInt() > 0 && currentFontData.CMapName != null && currentFontData.getFontType() == -1684566726 && currentFontData.getGlyphData().getCharStrings().containsKey(String.valueOf(glyphData.getRawInt()));
        boolean debug = false;
        boolean isMultiByte = false;
        if (!(currentFontData.CMapName != null && currentFontData.CMapName.equals("OneByteIdentityH") || stream[i] == 62 || hasCharString || (isDouble = currentFontData.isDoubleBytes(val, (combinedVal = (char)HexTextUtils.getValue(3, stream, i)) & 0xFF, false)) != 1 && currentFontData.glyphs.getEmbeddedGlyph(new T1GlyphFactory(false), null, null, combinedVal, "", -1.0f, null) == null)) {
            isMultiByte = true;
            val = combinedVal;
            charSize = 4;
        }
        if (isMultiByte) {
            return HexTextUtils.setValue(glyphData, val, i, charSize, currentFontData, parserOptions);
        }
        return i + 1;
    }

    private static int setValue(GlyphData glyphData, int val, int i, int charSize, PdfFont currentFontData, ParserOptions parserOptions) {
        glyphData.setRawInt(val);
        i = i + charSize - 1;
        glyphData.setRawChar((char)val);
        glyphData.setDisplayValue(currentFontData.getGlyphValue(val));
        if (currentFontData.isCIDFont() && currentFontData.getCMAP() != null && currentFontData.getUnicodeMapping(val) == null) {
            glyphData.setRawChar(glyphData.getDisplayValue().charAt(0));
            glyphData.setRawInt(glyphData.getRawChar());
        }
        if (parserOptions.isTextExtracted()) {
            glyphData.setUnicodeValue(currentFontData.getUnicodeValue(glyphData.getDisplayValue(), glyphData.getRawInt()));
        }
        return i;
    }

    private static int getValue(int chars, byte[] stream, int i) {
        int ptr = 0;
        int val = 0;
        for (int aa = 0; aa < chars + 1; ++aa) {
            int topHex = stream[i + chars - aa];
            if (topHex >= 65 && topHex <= 70) {
                topHex -= 55;
            } else if (topHex >= 97 && topHex <= 102) {
                topHex -= 87;
            } else {
                if (topHex < 48 || topHex > 57) continue;
                topHex -= 48;
            }
            val += topHex << TD.multiply16[ptr];
            ++ptr;
        }
        return val;
    }
}

