/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render;

import com.idrsolutions.pdf.color.blends.BlendMode;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.examples.handlers.DefaultImageHelper;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ColorHandler;
import org.jpedal.external.FontHandler;
import org.jpedal.external.ImageHandler;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.GraphicsState;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.RenderUtils;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;
import org.jpedal.utils.repositories.generic.Vector_Rectangle_Int;

public abstract class BaseDisplay
implements DynamicVectorRenderer {
    private boolean isRenderingToImage;
    protected Vector_Int objectType;
    protected static final int defaultSize = 5000;
    protected int type;
    boolean isType3Font;
    private boolean saveImageData = true;
    protected boolean addBackground = true;
    protected Vector_Rectangle_Int areas;
    protected ObjectStore objectStoreRef;
    protected int currentItem = -1;
    protected static int itemToRender = -1;
    protected static int endItem = -1;
    Area lastClip;
    boolean hasClips;
    int blendMode = 1111314299;
    boolean colorsLocked;
    Graphics2D g2;
    public boolean useHiResImageForDisplay;
    String rawKey;
    PdfPaint fillCol;
    PdfPaint strokeCol;
    public int rawPageNumber;
    int xx;
    int yy;
    public static boolean invertHighlight;
    boolean isPrinting;
    ImageHandler customImageHandler;
    ColorHandler customColorHandler;
    double cropX;
    double cropH;
    float scaling = 1.0f;
    float lastScaling;
    protected Vector_Object pageObjects;
    protected final Map imageIDtoName = new HashMap(10);
    protected boolean needsHorizontalInvert;
    protected boolean needsVerticalInvert;
    int w;
    int h;
    protected Color backgroundColor = Color.WHITE;
    protected static Color textColor;
    protected static int colorThresholdToReplace;
    protected boolean changeLineArtAndText;
    public static RenderingHints userHints;
    private DynamicVectorRenderer.Mode mode = DynamicVectorRenderer.Mode.PDF;

    @Override
    public void setInset(int x, int y) {
        this.xx = x;
        this.yy = y;
    }

    @Override
    public void setG2(Graphics2D g2) {
        this.g2 = g2;
        if (userHints != null) {
            this.g2.setRenderingHints(userHints);
        }
    }

    @Override
    public void init(int width, int height, Color backgroundColor) {
        this.w = width;
        this.h = height;
        this.backgroundColor = backgroundColor;
    }

    @Override
    public void paintBackground(Shape dirtyRegion) {
        if (this.addBackground && this.g2 != null) {
            this.g2.setColor(this.backgroundColor);
            if (dirtyRegion == null) {
                this.g2.fill(new Rectangle(this.xx, this.yy, (int)((float)this.w * this.scaling), (int)((float)this.h * this.scaling)));
            } else {
                this.g2.fill(dirtyRegion);
            }
        }
    }

    protected static boolean checkColorThreshold(int col) {
        int r = col & 0xFF;
        int g = col >> 8 & 0xFF;
        int b = col >> 16 & 0xFF;
        return r <= colorThresholdToReplace && g <= colorThresholdToReplace && b <= colorThresholdToReplace;
    }

    void renderEmbeddedText(int text_fill_type, Object rawglyph, int glyphType, AffineTransform glyphAT, Rectangle textHighlight, PdfPaint strokePaint, PdfPaint fillPaint, float strokeOpacity, float fillOpacity, int lineWidth) {
        float strokeOnlyLine = 0.0f;
        if (text_fill_type == 1 && (double)lineWidth >= 1.0) {
            strokeOnlyLine = lineWidth;
        }
        PdfGlyph glyph = (PdfGlyph)rawglyph;
        AffineTransform at = this.g2.getTransform();
        double[] affValues = new double[6];
        at.getMatrix(affValues);
        if (glyph != null) {
            Color color;
            this.g2.transform(glyphAT);
            Composite comp = this.g2.getComposite();
            if ((text_fill_type & 2) == 2) {
                if (textColor != null && (itemToRender == -1 || endItem == -1 || itemToRender <= endItem) && BaseDisplay.checkColorThreshold(fillPaint.getRGB())) {
                    fillPaint = new PdfColor(textColor.getRed(), textColor.getGreen(), textColor.getBlue());
                }
                fillPaint.setScaling(this.cropX, this.cropH, this.scaling, (float)glyphAT.getTranslateX(), (float)glyphAT.getTranslateY());
                if (this.customColorHandler != null) {
                    this.customColorHandler.setPaint(this.g2, fillPaint, this.rawPageNumber, this.isPrinting);
                } else if (DecoderOptions.Helper != null) {
                    DecoderOptions.Helper.setPaint(this.g2, fillPaint, this.rawPageNumber, this.isPrinting);
                } else {
                    this.g2.setPaint(fillPaint);
                }
                this.renderComposite(fillOpacity);
                if (textHighlight != null) {
                    if (invertHighlight) {
                        color = this.g2.getColor();
                        this.g2.setColor(new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue()));
                    } else if (DecoderOptions.backgroundColor != null) {
                        this.g2.setColor(DecoderOptions.backgroundColor);
                    }
                }
                if (glyphType == 6 && !glyph.ignoreColors()) {
                    glyph.setT3Colors(strokePaint, fillPaint, false);
                }
                glyph.render(2, this.g2, this.scaling, false);
                this.g2.setComposite(comp);
            }
            if (text_fill_type == 1) {
                glyph.setStrokedOnly(true);
            }
            if (!(DecoderOptions.isRunningOnMac && this.isPrinting && text_fill_type == 3 || (text_fill_type & 1) != 1)) {
                block27: {
                    if (strokePaint != null) {
                        if (textColor != null && (itemToRender == -1 || endItem == -1 || itemToRender <= endItem) && BaseDisplay.checkColorThreshold(strokePaint.getRGB())) {
                            strokePaint = new PdfColor(textColor.getRed(), textColor.getGreen(), textColor.getBlue());
                        }
                        strokePaint.setScaling(this.cropX, this.cropH, this.scaling, 0.0f, 0.0f);
                    }
                    if (this.customColorHandler != null) {
                        this.customColorHandler.setPaint(this.g2, strokePaint, this.rawPageNumber, this.isPrinting);
                    } else if (DecoderOptions.Helper != null) {
                        DecoderOptions.Helper.setPaint(this.g2, strokePaint, this.rawPageNumber, this.isPrinting);
                    } else {
                        this.g2.setPaint(strokePaint);
                    }
                    this.renderComposite(strokeOpacity);
                    if (textHighlight != null) {
                        if (invertHighlight) {
                            color = this.g2.getColor();
                            this.g2.setColor(new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue()));
                        } else if (DecoderOptions.backgroundColor != null) {
                            this.g2.setColor(DecoderOptions.backgroundColor);
                        }
                    }
                    try {
                        glyph.render(1, this.g2, strokeOnlyLine, false);
                    }
                    catch (Exception e) {
                        if (!LogWriter.isOutput()) break block27;
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                }
                this.g2.setComposite(comp);
            }
            this.g2.setTransform(at);
        }
    }

    void renderShape(Shape defaultClip, int fillType, PdfPaint strokeCol, PdfPaint fillCol, Stroke shapeStroke, Object currentShape, float strokeOpacity, float fillOpacity) {
        System.out.println("renderShape in base display should never be called");
    }

    void renderShape(Shape defaultClip, int fillType, PdfPaint strokeCol, PdfPaint fillCol, Stroke shapeStroke, Shape currentShape, float strokeOpacity, float fillOpacity) {
        boolean clipChanged = false;
        Shape clip = this.g2.getClip();
        Composite comp = this.g2.getComposite();
        if (fillType == 2 || fillType == 3) {
            block22: {
                if (fillCol != null) {
                    if (fillCol.getRGB() != -1 && this.changeLineArtAndText && textColor != null && !fillCol.isPattern() && (itemToRender == -1 || endItem == -1 || itemToRender <= endItem) && BaseDisplay.checkColorThreshold(fillCol.getRGB())) {
                        fillCol = new PdfColor(textColor.getRed(), textColor.getGreen(), textColor.getBlue());
                    }
                    fillCol.setScaling(this.cropX, this.cropH, this.scaling, 0.0f, 0.0f);
                }
                if (this.customColorHandler != null) {
                    this.customColorHandler.setPaint(this.g2, fillCol, this.rawPageNumber, this.isPrinting);
                } else if (DecoderOptions.Helper != null) {
                    DecoderOptions.Helper.setPaint(this.g2, fillCol, this.rawPageNumber, this.isPrinting);
                } else {
                    this.g2.setPaint(fillCol);
                }
                this.renderComposite(fillOpacity);
                try {
                    double iw = currentShape.getBounds2D().getWidth();
                    double ih = currentShape.getBounds2D().getHeight();
                    if ((ih == 0.0 || iw == 0.0) && ((BasicStroke)this.g2.getStroke()).getLineWidth() <= 1.0f) {
                        this.g2.fillRect(currentShape.getBounds().x, currentShape.getBounds().y, currentShape.getBounds().width, currentShape.getBounds().height);
                    } else {
                        this.g2.fill(currentShape);
                    }
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) break block22;
                    LogWriter.writeLog("Exception " + e + " filling shape");
                }
            }
            this.g2.setComposite(comp);
        }
        if (fillType == 1 || fillType == 3) {
            Stroke currentStroke = this.g2.getStroke();
            if (currentShape.getBounds2D().getWidth() < 1.0 && ((BasicStroke)shapeStroke).getLineWidth() > 10.0f) {
                this.g2.setStroke(new BasicStroke(1.0f));
            } else {
                this.g2.setStroke(shapeStroke);
            }
            if (this.changeLineArtAndText && textColor != null && !strokeCol.isPattern() && (itemToRender == -1 || endItem == -1 || itemToRender <= endItem) && BaseDisplay.checkColorThreshold(strokeCol.getRGB())) {
                strokeCol = new PdfColor(textColor.getRed(), textColor.getGreen(), textColor.getBlue());
            }
            strokeCol.setScaling(this.cropX, this.cropH, this.scaling, 0.0f, 0.0f);
            if (this.customColorHandler != null) {
                this.customColorHandler.setPaint(this.g2, strokeCol, this.rawPageNumber, this.isPrinting);
            } else if (DecoderOptions.Helper != null) {
                DecoderOptions.Helper.setPaint(this.g2, strokeCol, this.rawPageNumber, this.isPrinting);
            } else {
                this.g2.setPaint(strokeCol);
            }
            this.renderComposite(strokeOpacity);
            if (!this.isPrinting && clip != null && clip.getBounds2D().getWidth() % 1.0 > (double)0.65f && clip.getBounds2D().getHeight() % 1.0 > (double)0.1f && currentShape.getBounds().getWidth() == clip.getBounds().getWidth()) {
                this.g2.setClip(BaseDisplay.convertPDFClipToJavaClip(new Area(clip)));
                clipChanged = true;
            }
            if (!this.isPrinting && clip != null && (clip.getBounds2D().getHeight() < 1.0 || clip.getBounds2D().getWidth() < 1.0)) {
                this.g2.setClip(defaultClip);
                clipChanged = true;
            }
            this.g2.draw(currentShape);
            this.g2.setStroke(currentStroke);
            this.g2.setComposite(comp);
        }
        if (clipChanged) {
            this.g2.setClip(clip);
        }
    }

    void renderImage(AffineTransform imageAf, BufferedImage image, float alpha, GraphicsState currentGraphicsState, float x, float y) {
        boolean renderDirect;
        boolean bl = renderDirect = currentGraphicsState != null;
        if (image == null || this.g2 == null) {
            return;
        }
        AffineTransform before = this.g2.getTransform();
        Composite c = this.g2.getComposite();
        this.renderComposite(alpha);
        if (renderDirect || this.useHiResImageForDisplay) {
            BufferedImage newImage;
            boolean useCustomRenderer;
            float[][] CTM = new float[3][3];
            if (currentGraphicsState != null) {
                CTM = currentGraphicsState.CTM;
            } else {
                double[] values = new double[6];
                imageAf.getMatrix(values);
                CTM[0][0] = (float)values[0];
                CTM[0][1] = (float)values[1];
                CTM[1][0] = (float)values[2];
                CTM[1][1] = (float)values[3];
                CTM[2][0] = x;
                CTM[2][1] = y;
            }
            int w = image.getWidth();
            int h = image.getHeight();
            double[] values = new double[]{CTM[0][0] / (float)w, CTM[0][1] / (float)w, -CTM[1][0] / (float)h, -CTM[1][1] / (float)h, 0.0, 0.0};
            AffineTransform upside_down = new AffineTransform(values);
            this.g2.translate(CTM[2][0] + CTM[1][0], CTM[2][1] + CTM[1][1]);
            boolean bl2 = useCustomRenderer = this.customImageHandler != null;
            if (useCustomRenderer && (useCustomRenderer = this.customImageHandler.drawImageOnscreen(image, 0, upside_down, null, this.g2, renderDirect, this.objectStoreRef, this.isPrinting))) {
                this.g2.setComposite(c);
                return;
            }
            if (this.customColorHandler != null) {
                newImage = this.customColorHandler.processImage(image, this.rawPageNumber, this.isPrinting);
                if (newImage != null) {
                    image = newImage;
                }
            } else if (DecoderOptions.Helper != null && (newImage = DecoderOptions.Helper.processImage(image, this.rawPageNumber, this.isPrinting)) != null) {
                image = newImage;
            }
            Shape g2clip = this.g2.getClip();
            boolean isClipReset = false;
            if (g2clip != null) {
                boolean isSimpleOutline;
                double cy = this.g2.getClip().getBounds2D().getY();
                double ch = this.g2.getClip().getBounds2D().getHeight();
                double diff = (double)image.getHeight() - ch;
                if (diff < 0.0) {
                    diff = -diff;
                }
                if (diff > 0.0 && diff < 1.0 && cy < 0.0 && image.getHeight() > 1 && image.getHeight() < 10 && (isSimpleOutline = BaseDisplay.isSimpleOutline(this.g2.getClip()))) {
                    double cx = this.g2.getClip().getBounds2D().getX();
                    double cw = this.g2.getClip().getBounds2D().getWidth();
                    this.g2.setClip(new Rectangle((int)cx, (int)cy, (int)cw, (int)ch));
                    isClipReset = false;
                }
            }
            AffineTransform aff = this.g2.getTransform();
            double mx = aff.getScaleX();
            double my = aff.getScaleX();
            double sx = upside_down.getScaleX();
            double sy = upside_down.getScaleY();
            if (image.getType() != 0 && mx == 0.0 && my == 0.0 && sx > 0.0 && sy < 0.0) {
                mx = aff.getShearX();
                my = aff.getShearY();
                sx = Math.abs(sx);
                sy = Math.abs(sy);
                if (mx > 0.0 && my > 0.0) {
                    int newWidth = Math.abs((int)((double)image.getWidth() * sx * mx));
                    int newHeight = Math.abs((int)((double)image.getHeight() * sy * my));
                    if (newWidth > 0 && newHeight > 0 && newWidth > image.getWidth() && newHeight > image.getHeight()) {
                        BufferedImage bi = new BufferedImage(newWidth, newHeight, image.getType());
                        Graphics2D g = bi.createGraphics();
                        g.setRenderingHints(this.g2.getRenderingHints());
                        g.drawImage(image, AffineTransform.getScaleInstance(mx * sx, my * sy), null);
                        upside_down.scale(1.0 / sx, -(1.0 / sy));
                        aff.scale(1.0 / mx, -(1.0 / my));
                        this.g2.setTransform(aff);
                        image = bi;
                    }
                }
            }
            this.g2.drawImage(image, upside_down, null);
            if (isClipReset) {
                this.g2.setClip(g2clip);
            }
        } else {
            this.g2.drawImage((Image)image, (int)x, (int)y, null);
        }
        this.g2.setTransform(before);
        this.g2.setComposite(c);
    }

    public static boolean isSimpleOutline(Shape path) {
        int count;
        PathIterator i = path.getPathIterator(null);
        for (count = 0; !i.isDone() && count < 6; ++count) {
            i.next();
        }
        return count < 6;
    }

    final void renderText(float x, float y, int type, Area transformedGlyph2, Rectangle textHighlight, PdfPaint strokePaint, PdfPaint textFillCol, float strokeOpacity, float fillOpacity) {
        Color col;
        Paint currentCol = this.g2.getPaint();
        Composite comp = this.g2.getComposite();
        if ((type & 2) == 2) {
            if (textFillCol != null) {
                if (textColor != null && (itemToRender == -1 || endItem == -1 || itemToRender <= endItem) && BaseDisplay.checkColorThreshold(textFillCol.getRGB())) {
                    textFillCol = new PdfColor(textColor.getRed(), textColor.getGreen(), textColor.getBlue());
                }
                textFillCol.setScaling(this.cropX, this.cropH, this.scaling, x, y);
            }
            if (this.customColorHandler != null) {
                this.customColorHandler.setPaint(this.g2, textFillCol, this.rawPageNumber, this.isPrinting);
            } else if (DecoderOptions.Helper != null) {
                DecoderOptions.Helper.setPaint(this.g2, textFillCol, this.rawPageNumber, this.isPrinting);
            } else {
                this.g2.setPaint(textFillCol);
            }
            this.renderComposite(fillOpacity);
            if (textHighlight != null) {
                if (invertHighlight) {
                    col = this.g2.getColor();
                    this.g2.setColor(new Color(255 - col.getRed(), 255 - col.getGreen(), 255 - col.getBlue()));
                } else if (DecoderOptions.backgroundColor != null) {
                    this.g2.setColor(DecoderOptions.backgroundColor);
                }
            }
            this.g2.fill(transformedGlyph2);
            this.g2.setComposite(comp);
        }
        if ((type & 1) == 1) {
            float lineWidth;
            if (strokePaint != null) {
                if (textColor != null && (itemToRender == -1 || endItem == -1 || itemToRender <= endItem) && BaseDisplay.checkColorThreshold(strokePaint.getRGB())) {
                    strokePaint = new PdfColor(textColor.getRed(), textColor.getGreen(), textColor.getBlue());
                }
                strokePaint.setScaling(this.cropX + (double)x, this.cropH + (double)y, this.scaling, x, y);
            }
            if (this.customColorHandler != null) {
                this.customColorHandler.setPaint(this.g2, strokePaint, this.rawPageNumber, this.isPrinting);
            } else if (DecoderOptions.Helper != null) {
                DecoderOptions.Helper.setPaint(this.g2, strokePaint, this.rawPageNumber, this.isPrinting);
            } else {
                this.g2.setPaint(strokePaint);
            }
            this.renderComposite(strokeOpacity);
            if (textHighlight != null) {
                if (invertHighlight) {
                    col = this.g2.getColor();
                    this.g2.setColor(new Color(255 - col.getRed(), 255 - col.getGreen(), 255 - col.getBlue()));
                } else if (DecoderOptions.backgroundColor != null) {
                    this.g2.setColor(DecoderOptions.backgroundColor);
                }
            }
            if ((lineWidth = (float)(1.0 / this.g2.getTransform().getScaleX())) < 0.0f) {
                lineWidth = -lineWidth;
            }
            this.g2.setStroke(new BasicStroke(lineWidth));
            if (lineWidth < 0.1f) {
                this.g2.draw(transformedGlyph2);
            } else {
                this.g2.fill(transformedGlyph2);
            }
            this.g2.setComposite(comp);
        }
        this.g2.setPaint(currentCol);
    }

    @Override
    public ObjectStore getObjectStore() {
        return this.objectStoreRef;
    }

    @Override
    public void setHiResImageForDisplayMode(boolean useHiResImageForDisplay) {
        this.useHiResImageForDisplay = useHiResImageForDisplay;
    }

    @Override
    public void setScalingValues(double cropX, double cropH, float scaling) {
        this.cropX = cropX;
        this.cropH = cropH;
        this.scaling = scaling;
    }

    @Override
    public void setCustomImageHandler(ImageHandler customImageHandler) {
        this.customImageHandler = customImageHandler;
    }

    @Override
    public void setCustomColorHandler(ColorHandler colorController) {
        this.customColorHandler = colorController;
    }

    @Override
    public void resetOnColorspaceChange() {
    }

    @Override
    public void drawFontBounds(Rectangle newfontBB) {
    }

    @Override
    public void drawAffine(double[] afValues) {
    }

    @Override
    public void drawFontSize(int fontSize) {
    }

    @Override
    public void setLineWidth(int lineWidth) {
    }

    @Override
    public void stopClearOnNextRepaint(boolean flag) {
    }

    @Override
    public boolean hasObjectsBehind(float[][] CTM) {
        int h;
        boolean hasObject = false;
        int x = (int)CTM[2][0];
        int y = (int)CTM[2][1];
        int w = (int)CTM[0][0];
        if (w == 0) {
            w = (int)CTM[0][1];
        }
        if ((h = (int)CTM[1][1]) == 0) {
            h = (int)CTM[1][0];
        }
        if (h < 0) {
            y += h;
        }
        if (w < 0) {
            x += w;
            w = x - w;
        }
        if (this.areas == null) {
            return true;
        }
        int[][] areas = this.areas.get();
        int count = areas.length;
        for (int i = 0; i < count; ++i) {
            boolean yOverlap;
            if (areas[i] == null) continue;
            int rx = areas[i][0];
            int ry = areas[i][1];
            int rw = areas[i][2];
            int rh = areas[i][3];
            boolean xOverlap = BaseDisplay.valueInRange(x, rx, rx + rw) || BaseDisplay.valueInRange(rx, x, x + w);
            boolean bl = yOverlap = xOverlap && BaseDisplay.valueInRange(y, ry, ry + rh) || BaseDisplay.valueInRange(ry, y, y + h);
            if (!xOverlap || !yOverlap) continue;
            i = count;
            hasObject = true;
        }
        return hasObject;
    }

    private static boolean valueInRange(int value, int min, int max) {
        return value >= min && value <= max;
    }

    @Override
    public void flagDecodingFinished() {
    }

    @Override
    public void flagImageDeleted(int i) {
    }

    @Override
    public void setOCR(boolean isOCR) {
    }

    @Override
    public byte[] serializeToByteArray(Set fontsAlreadyOnClient) throws IOException {
        return new byte[0];
    }

    @Override
    public void checkFontSaved(Object glyph, String name, PdfFont currentFontData) {
    }

    @Override
    public Rectangle getArea(int i) {
        return null;
    }

    @Override
    public int[] getAreaAsArray(int i) {
        return this.areas.elementAt(i);
    }

    @Override
    public int isInsideImage(int x, int y) {
        int outLine = -1;
        int[][] areas = this.areas.get();
        int[] possArea = null;
        int count = areas.length;
        if (this.objectType != null) {
            int[] types = this.objectType.get();
            for (int i = 0; i < count; ++i) {
                if (areas[i] == null || !RenderUtils.rectangleContains(areas[i], x, y) || types[i] != 3) continue;
                if (possArea != null) {
                    int area2 = areas[i][3] * areas[i][2];
                    void area1 = possArea[3] * possArea[2];
                    if (area2 < area1) {
                        possArea = areas[i];
                    }
                    outLine = i;
                    continue;
                }
                possArea = areas[i];
                outLine = i;
            }
        }
        return outLine;
    }

    @Override
    public void saveImage(int id, String des, String type) {
        block9: {
            BufferedImage image;
            String name = (String)this.imageIDtoName.get(id);
            if (this.useHiResImageForDisplay) {
                image = this.objectStoreRef.loadStoredImage(name);
                if (image == null) {
                    image = (BufferedImage)this.pageObjects.elementAt(id);
                }
            } else {
                image = (BufferedImage)this.pageObjects.elementAt(id);
            }
            if (image != null) {
                if (image.getType() == 0 || type.equals("jpg") && image.getType() == 2) {
                    image = ColorSpaceConvertor.convertToRGB(image);
                }
                if (this.needsHorizontalInvert) {
                    image = RenderUtils.invertImageBeforeSave(image, true);
                }
                if (this.needsVerticalInvert) {
                    image = RenderUtils.invertImageBeforeSave(image, false);
                }
                try {
                    DefaultImageHelper.write(image, type, des);
                }
                catch (IOException ex) {
                    if (!LogWriter.isOutput()) break block9;
                    LogWriter.writeLog("Exception in writing image " + ex);
                }
            }
        }
    }

    protected void showMessageDialog(String message) {
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public int getObjectUnderneath(int x, int y) {
        int typeFound = -1;
        int[][] areas = this.areas.get();
        int count = areas.length;
        if (this.objectType != null) {
            int[] types = this.objectType.get();
            boolean nothing = true;
            for (int i = count - 1; i > -1; --i) {
                if (areas[i] == null || !RenderUtils.rectangleContains(areas[i], x, y) || types[i] == 2 || types[i] == 7) continue;
                nothing = false;
                typeFound = types[i];
                i = -1;
            }
            if (nothing) {
                return -1;
            }
        }
        return typeFound;
    }

    @Override
    public void setneedsVerticalInvert(boolean b) {
        this.needsVerticalInvert = b;
    }

    @Override
    public void setneedsHorizontalInvert(boolean b) {
        this.needsHorizontalInvert = b;
    }

    @Override
    public void stopG2HintSetting(boolean isSet) {
    }

    @Override
    public void setPrintPage(int currentPrintPage) {
    }

    @Override
    public void drawShape(Shape currentShape, GraphicsState currentGraphicsState, int cmd) {
    }

    @Override
    public void drawCustom(Object value) {
    }

    @Override
    public void drawEmbeddedText(float[][] Trm, int fontSize, PdfGlyph embeddedGlyph, Object javaGlyph, int type, GraphicsState gs, double[] at, String glyf, PdfFont currentFontData, float glyfWidth) {
    }

    @Override
    public void paint(Rectangle[] highlights, AffineTransform viewScaling, Rectangle userAnnot) {
    }

    @Override
    public void setMessageFrame(Container frame) {
    }

    @Override
    public void dispose() {
    }

    @Override
    public int drawImage(int pageNumber, BufferedImage image, GraphicsState currentGraphicsState, boolean alreadyCached, String name, int previousUse) {
        return -1;
    }

    @Override
    public void drawFillColor(PdfPaint currentCol) {
    }

    @Override
    public void drawAdditionalObjectsOverPage(int[] type, Color[] colors, Object[] obj) throws PdfException {
    }

    @Override
    public void flushAdditionalObjOnPage() {
    }

    @Override
    public void setOptimsePainting(boolean optimsePainting) {
    }

    @Override
    public void flush() {
    }

    @Override
    public void drawText(float[][] Trm, String text, GraphicsState currentGraphicsState, float x, float y, Font javaFont) {
    }

    @Override
    public Rectangle getOccupiedArea() {
        return null;
    }

    @Override
    public void setGraphicsState(int fillType, float value, int BM) {
    }

    @Override
    public void drawStrokeColor(Paint currentCol) {
    }

    @Override
    public void drawTR(int value) {
    }

    @Override
    public void drawStroke(Stroke current) {
    }

    @Override
    public void drawClip(GraphicsState currentGraphicsState, Shape defaultClip, boolean alwaysDraw) {
    }

    @Override
    public void writeCustom(int key, Object value) {
    }

    @Override
    public void flagCommand(int commandID, int tokenNumber) {
    }

    @Override
    public void setValue(int key, int i) {
        switch (key) {
            case 1: {
                this.backgroundColor = new Color(i);
                break;
            }
            case 2: {
                textColor = new Color(i);
                break;
            }
            case 3: {
                this.changeLineArtAndText = i > 0;
                break;
            }
            case 4: {
                colorThresholdToReplace = i;
            }
        }
    }

    @Override
    public int getValue(int key) {
        return -1;
    }

    @Override
    public BufferedImage getSingleImagePattern() {
        return null;
    }

    @Override
    public boolean isScalingControlledByUser() {
        return false;
    }

    @Override
    public boolean avoidDownSamplingImage() {
        return false;
    }

    @Override
    public boolean getBooleanValue(int key) {
        return false;
    }

    @Override
    public float getScaling() {
        return this.scaling;
    }

    @Override
    public void saveAdvanceWidth(String baseFontName, String s, int potentialWidth) {
    }

    public static int isRectangle(Shape bounds) {
        int count;
        PathIterator i = bounds.getPathIterator(null);
        for (count = 0; !i.isDone() && count < 8; ++count) {
            i.next();
        }
        return count;
    }

    @Override
    public void setMode(DynamicVectorRenderer.Mode mode) {
        this.mode = mode;
    }

    @Override
    public DynamicVectorRenderer.Mode getMode() {
        return this.mode;
    }

    @Override
    public Object getObjectValue(int id) {
        return null;
    }

    @Override
    public void drawShape(Object currentShape, GraphicsState currentGraphicsState, int cmd) {
        System.out.println("drawShape in BaseDisplay Should never be called");
    }

    @Override
    public void eliminateHiddenText(Shape currentShape, GraphicsState gs, int count, boolean ignoreScaling) {
    }

    private void renderComposite(float alpha) {
        if (this.blendMode == 1111314299 || this.blendMode == 1987215544) {
            if (alpha != 1.0f) {
                this.g2.setComposite(AlphaComposite.getInstance(3, alpha));
            }
        } else {
            BlendMode comp = new BlendMode(this.blendMode, alpha);
            this.g2.setComposite(comp);
        }
    }

    @Override
    public boolean isHTMLorSVG() {
        return false;
    }

    @Override
    public void saveImageData(boolean value) {
        this.saveImageData = value;
    }

    @Override
    public boolean saveImageData() {
        return this.saveImageData;
    }

    public boolean isRenderingToImage() {
        return this.isRenderingToImage;
    }

    @Override
    public void setIsRenderingToImage(boolean isRenderingToImage) {
        this.isRenderingToImage = isRenderingToImage;
    }

    public static Area convertPDFClipToJavaClip(Area clip) {
        if (clip != null) {
            double sx = (clip.getBounds2D().getWidth() + 2.0) / clip.getBounds2D().getWidth();
            double sy = (clip.getBounds2D().getHeight() + 2.0) / clip.getBounds2D().getHeight();
            double posX = clip.getBounds2D().getX();
            double posY = clip.getBounds2D().getY();
            Area a = (Area)clip.clone();
            a.transform(AffineTransform.getTranslateInstance(-posX, -posY));
            a.transform(AffineTransform.getScaleInstance(sx, sy));
            a.transform(AffineTransform.getTranslateInstance(posX - 1.0, posY - 1.0));
            return a;
        }
        return clip;
    }

    @Override
    public FontHandler getFontHandler() {
        return null;
    }

    static {
        colorThresholdToReplace = 255;
    }
}

