/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render;

import java.awt.Color;
import java.awt.Shape;
import org.jpedal.color.PdfColor;
import org.jpedal.exception.PdfException;
import org.jpedal.objects.GraphicsState;
import org.jpedal.render.BaseDisplay;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.ImageObject;
import org.jpedal.render.TextObject;

abstract class GUIDisplay
extends BaseDisplay
implements DynamicVectorRenderer {
    GUIDisplay() {
    }

    public void drawUserContent(int[] type1, Object[] obj, Color[] colors) throws PdfException {
        int count = type1.length;
        block10: for (int i = 0; i < count; ++i) {
            int currentType = type1[i];
            switch (currentType) {
                case 18: {
                    this.setGraphicsState(2, ((Float)obj[i]).floatValue(), 1111314299);
                    continue block10;
                }
                case 17: {
                    this.setGraphicsState(1, ((Float)obj[i]).floatValue(), 1111314299);
                    continue block10;
                }
                case 19: {
                    GraphicsState gs = new GraphicsState();
                    gs.setFillType(1);
                    this.drawShape((Shape)obj[i], gs, 83);
                    continue block10;
                }
                case 20: {
                    GraphicsState gs = new GraphicsState();
                    gs.setFillType(2);
                    gs.setNonstrokeColor(new PdfColor(colors[i].getRed(), colors[i].getGreen(), colors[i].getBlue()));
                    this.drawShape((Shape)obj[i], gs, 70);
                    continue block10;
                }
                case 23: {
                    this.drawCustom(obj[i]);
                    continue block10;
                }
                case 3: {
                    ImageObject imgObj = (ImageObject)obj[i];
                    GraphicsState gs = new GraphicsState();
                    gs.CTM = new float[][]{{imgObj.image.getWidth(), 0.0f, 1.0f}, {0.0f, imgObj.image.getHeight(), 1.0f}, {0.0f, 0.0f, 0.0f}};
                    gs.x = imgObj.x;
                    gs.y = imgObj.y;
                    this.drawImage(this.rawPageNumber, imgObj.image, gs, false, "extImg" + i, -1);
                    continue block10;
                }
                case 16: {
                    TextObject textObj = (TextObject)obj[i];
                    GraphicsState gs = new GraphicsState();
                    float fontSize = textObj.font.getSize();
                    double[] afValues = new double[]{fontSize, 0.0, 0.0, fontSize, 0.0, 0.0};
                    this.drawAffine(afValues);
                    this.drawTR(2);
                    gs.setTextRenderType(2);
                    gs.setNonstrokeColor(new PdfColor(colors[i].getRed(), colors[i].getGreen(), colors[i].getBlue()));
                    this.drawText(null, textObj.text, gs, textObj.x, -textObj.y, textObj.font);
                    continue block10;
                }
                case 0: {
                    continue block10;
                }
                default: {
                    throw new PdfException("Unrecognised type " + currentType);
                }
            }
        }
    }
}

