/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

public class FastMath {
    public static double sqrt(double a) {
        if (a < 0.0) {
            return Double.NaN;
        }
        double e = 1.0E-15;
        double t = a;
        while (Math.abs(t - a / t) > 1.0E-15 * t) {
            t = (a / t + t) / 2.0;
        }
        return t;
    }

    public static final int pow(int x, int n) {
        if (n == 0) {
            return 1;
        }
        int a = x;
        for (int i = 1; i < n; ++i) {
            a *= x;
        }
        return a;
    }

    public static final float pow(float x, int n) {
        if (n == 0) {
            return 1.0f;
        }
        float a = x;
        for (int i = 1; i < n; ++i) {
            a *= x;
        }
        return a;
    }

    public static final double pow(double x, int n) {
        if (n == 0) {
            return 1.0;
        }
        double a = x;
        for (int i = 1; i < n; ++i) {
            a *= x;
        }
        return a;
    }
}

