/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils.repositories;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jpedal.io.PathSerializer;
import org.jpedal.utils.repositories.generic.GUIVector_Rectangle;

public class Vector_Rectangle
extends GUIVector_Rectangle
implements Serializable {
    private Rectangle[] items;

    public Vector_Rectangle(int number) {
        this.items = new Rectangle[this.max_size];
        this.max_size = number;
        this.items = new Rectangle[this.max_size];
    }

    public void writeToStream(ByteArrayOutputStream bos) throws IOException {
        ObjectOutputStream os = new ObjectOutputStream(bos);
        os.writeObject(this.max_size);
        for (int i = 0; i < this.max_size; ++i) {
            Rectangle nextObj = this.items[i];
            if (nextObj == null) {
                os.writeObject(null);
                continue;
            }
            PathIterator pathIterator = nextObj.getPathIterator(new AffineTransform());
            PathSerializer.serializePath(os, pathIterator);
        }
    }

    public void restoreFromStream(ByteArrayInputStream bis) throws IOException, ClassNotFoundException {
        int size;
        ObjectInputStream os = new ObjectInputStream(bis);
        this.max_size = size = ((Integer)os.readObject()).intValue();
        this.items = new Rectangle[size];
        for (int i = 0; i < size; ++i) {
            GeneralPath path = PathSerializer.deserializePath(os);
            this.items[i] = path == null ? null : path.getBounds();
        }
    }

    public Vector_Rectangle() {
        this.items = new Rectangle[this.max_size];
    }

    public synchronized void addElement(Rectangle value) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = value;
        ++this.current_item;
    }

    public final void clear() {
        this.checkPoint = -1;
        if (this.current_item > 0) {
            for (int i = 0; i < this.current_item; ++i) {
                this.items[i] = null;
            }
        } else {
            for (int i = 0; i < this.max_size; ++i) {
                this.items[i] = null;
            }
        }
        this.current_item = 0;
    }

    public final Rectangle[] get() {
        return this.items;
    }

    private void checkSize(int i) {
        if (i >= this.max_size) {
            int old_size = this.max_size;
            this.max_size += this.increment_size;
            if (this.max_size <= i) {
                this.max_size = i + this.increment_size + 2;
            }
            Rectangle[] temp = this.items;
            this.items = new Rectangle[this.max_size];
            System.arraycopy(temp, 0, this.items, 0, old_size);
            this.increment_size = Vector_Rectangle.incrementSize(this.increment_size);
        }
    }

    public void trim() {
        Rectangle[] newItems = new Rectangle[this.current_item];
        System.arraycopy(this.items, 0, newItems, 0, this.current_item);
        this.items = newItems;
        this.max_size = this.current_item;
    }
}

