/*
 * ===========================================
 * Java Pdf Extraction Decoding Access Library
 * ===========================================
 *
 * Project Info:  http://www.idrsolutions.com
 * Help section for developers at http://www.idrsolutions.com/support/
 *
 * (C) Copyright 1997-2017 IDRsolutions and Contributors.
 *
 * This file is part of JPedal/JPDF2HTML5
 *
     This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


 *
 * ---------------
 * CertificateHolder.java
 * ---------------
 */

package org.jpedal.objects.acroforms.gui.certificates;

import java.math.BigInteger;
import javax.swing.JDialog;

public class CertificateHolder extends javax.swing.JPanel {


    private Details detailsTab;
    private General generalTab;
    private final JDialog frame;

    public void setValues(final String name, final int version, final String hashAlgorithm, final String subjectFields, final String issuerFields,
                          final BigInteger serialNumber, final String notBefore, final String notAfter, final String publicKeyDescription, final String publicKey,
                          final String x509Data, final String sha1Digest, final String md5Digest) {
        // TODO Auto-generated method stub
        generalTab = new General();
        detailsTab = new Details();

        generalTab.setValues(name, notBefore, notAfter);
        detailsTab.setValues(version, hashAlgorithm, subjectFields, issuerFields,
                serialNumber, notBefore, notAfter, publicKeyDescription, publicKey, x509Data, sha1Digest, md5Digest);

        jTabbedPane1.addTab("General", generalTab);
        jTabbedPane1.addTab("Details", detailsTab);
    }


    /**
     * Creates new form CertificateHolder
     *
     * @param dialog
     */
    public CertificateHolder(final JDialog dialog) {
        initComponents();
        this.frame = dialog;
    }

    /**
     * This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {

        jTabbedPane1 = new javax.swing.JTabbedPane();
        jButton1 = new javax.swing.JButton();

        setLayout(null);
        add(jTabbedPane1);
        jTabbedPane1.setBounds(10, 10, 420, 360);

        jButton1.setText("OK");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            @Override
            public void actionPerformed(final java.awt.event.ActionEvent evt) {
                close(evt);
            }
        });
        add(jButton1);
        jButton1.setBounds(350, 390, 73, 23);
    } // </editor-fold>//GEN-END:initComponents

    @SuppressWarnings("UnusedParameters")
    private void close(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_close
        frame.setVisible(false);

        // TODO add your handling code here:
    } //GEN-LAST:event_close


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JTabbedPane jTabbedPane1;
    // End of variables declaration//GEN-END:variables


}
