/*
 * ===========================================
 * Java Pdf Extraction Decoding Access Library
 * ===========================================
 *
 * Project Info:  http://www.idrsolutions.com
 * Help section for developers at http://www.idrsolutions.com/support/
 *
 * (C) Copyright 1997-2017 IDRsolutions and Contributors.
 *
 * This file is part of JPedal/JPDF2HTML5
 *
     This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


 *
 * ---------------
 * Details.java
 * ---------------
 */

package org.jpedal.objects.acroforms.gui.certificates;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigInteger;
import javax.swing.table.TableModel;

public class Details extends javax.swing.JPanel {

    private String publicKey;

    public void setValues(final int version, final String hashAlgorithm, final String subject, final String issuer, final BigInteger serialNumber, final String notBefore,
                          final String notAfter, final String publicKeyDescription, final String publicKey, final String x509Data, final String sha1Digest, final String md5Digest) {
        final TableModel model = jTable1.getModel();

        this.publicKey = publicKey;

        model.setValueAt(String.valueOf(version), 0, 1);
        model.setValueAt(hashAlgorithm, 1, 1);
        model.setValueAt(subject, 2, 1);
        model.setValueAt(issuer, 3, 1);
        model.setValueAt(Long.toHexString(serialNumber.longValue()).toUpperCase(), 4, 1);
        model.setValueAt(notBefore, 5, 1);
        model.setValueAt(notAfter, 6, 1);
        model.setValueAt(publicKeyDescription, 7, 1);
        model.setValueAt(x509Data, 8, 1);
        model.setValueAt(sha1Digest, 9, 1);
        model.setValueAt(md5Digest, 10, 1);
    }

    /**
     * Creates new form Details
     */
    Details() {
        initComponents();

        //jTable1.getModel().setValueAt("Test String", 0, 1);

        jTable1.addMouseListener(new MouseListener() {
            @Override
            public void mouseClicked(final MouseEvent e) {
                final int selectedRow = jTable1.getSelectedRow();
                if (selectedRow == 7) { // public key row
                    descriptionBox.setText(publicKey);
                } else {
                    descriptionBox.setText((String) jTable1.getModel().getValueAt(selectedRow, 1));
                }

                descriptionBox.setCaretPosition(0);
            }

            @Override
            public void mousePressed(final MouseEvent e) {
            }

            @Override
            public void mouseReleased(final MouseEvent e) {
            }

            @Override
            public void mouseEntered(final MouseEvent e) {
            }

            @Override
            public void mouseExited(final MouseEvent e) {
            }
        });
    }

    /**
     * This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();
        jScrollPane2 = new javax.swing.JScrollPane();
        descriptionBox = new javax.swing.JTextArea();

        setLayout(null);

        jLabel1.setText("Certificate data:");
        add(jLabel1);
        jLabel1.setBounds(10, 10, 220, 14);

        jTable1.setModel(new javax.swing.table.DefaultTableModel(
                new Object[][]{
                        {"Version", null},
                        {"Signature algorithum", null},
                        {"Subject", null},
                        {"Issuer", null},
                        {"Serial number", null},
                        {"Validity starts", null},
                        {"Validity ends", null},
                        {"Public key", null},
                        {"X.509 data", null},
                        {"SHA-1 digest", null},
                        {"MD5 digest", null}
                },
                new String[]{
                        "Name", "Value"
                }
        ) {
            final Class[] types = {
                    String.class, String.class
            };
            final boolean[] canEdit = {
                    false, false
            };

            @Override
            public Class getColumnClass(final int columnIndex) {
                return types[columnIndex];
            }

            @Override
            public boolean isCellEditable(final int rowIndex, final int columnIndex) {
                return canEdit[columnIndex];
            }
        });
        jScrollPane1.setViewportView(jTable1);

        add(jScrollPane1);
        jScrollPane1.setBounds(10, 30, 380, 150);

        descriptionBox.setColumns(20);
        descriptionBox.setEditable(false);
        descriptionBox.setLineWrap(true);
        descriptionBox.setRows(5);
        descriptionBox.setWrapStyleWord(true);
        jScrollPane2.setViewportView(descriptionBox);

        add(jScrollPane2);
        jScrollPane2.setBounds(10, 190, 380, 120);
    } // </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextArea descriptionBox;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JTable jTable1;
    // End of variables declaration//GEN-END:variables


}
