/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import com.google.common.base.Objects;
import java.util.Objects;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.OpType;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.HasDerivedName;
import org.jpmml.converter.PMMLEncoder;

public class BinaryFeature
extends Feature
implements HasDerivedName {
    private String value = null;

    public BinaryFeature(PMMLEncoder encoder, TypeDefinitionField field, String value) {
        this(encoder, field.getName(), field.getDataType(), value);
    }

    public BinaryFeature(PMMLEncoder encoder, FieldName name, DataType dataType, String value) {
        super(encoder, name, dataType);
        this.setValue(value);
    }

    @Override
    public FieldName getDerivedName() {
        return FieldName.create((String)(this.getName().getValue() + "=" + this.getValue()));
    }

    @Override
    public ContinuousFeature toContinuousFeature() {
        FieldName derivedName;
        PMMLEncoder encoder = this.ensureEncoder();
        DerivedField derivedField = encoder.getDerivedField(derivedName = this.getDerivedName());
        if (derivedField == null) {
            NormDiscrete normDiscrete = new NormDiscrete(this.getName(), this.getValue());
            derivedField = encoder.createDerivedField(derivedName, OpType.CONTINUOUS, DataType.DOUBLE, (Expression)normDiscrete);
        }
        return new ContinuousFeature(encoder, (TypeDefinitionField)derivedField);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hashCode(this.getValue());
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof BinaryFeature) {
            BinaryFeature that = (BinaryFeature)object;
            return super.equals(object) && Objects.equals(this.getValue(), that.getValue());
        }
        return false;
    }

    @Override
    protected Objects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("value", (Object)this.getValue());
    }

    public String getValue() {
        return this.value;
    }

    private void setValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.value = value;
    }
}

