/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import com.google.common.base.Objects;
import java.util.Objects;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.OpType;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.PMMLEncoder;

public abstract class Feature {
    private PMMLEncoder encoder = null;
    private FieldName name = null;
    private DataType dataType = null;

    public Feature(PMMLEncoder encoder, FieldName name, DataType dataType) {
        this.setEncoder(encoder);
        this.setName(name);
        this.setDataType(dataType);
    }

    public abstract ContinuousFeature toContinuousFeature();

    public ContinuousFeature toContinuousFeature(DataType dataType) {
        FieldName name;
        ContinuousFeature continuousFeature = this.toContinuousFeature();
        if (dataType.equals((Object)continuousFeature.getDataType())) {
            return continuousFeature;
        }
        PMMLEncoder encoder = this.ensureEncoder();
        DerivedField derivedField = encoder.getDerivedField(name = FieldName.create((String)(dataType.name().toLowerCase() + "(" + continuousFeature.getName().getValue() + ")")));
        if (derivedField == null) {
            derivedField = encoder.createDerivedField(name, OpType.CONTINUOUS, dataType, (Expression)continuousFeature.ref());
        }
        return new ContinuousFeature(encoder, (TypeDefinitionField)derivedField);
    }

    public FieldRef ref() {
        return new FieldRef(this.getName());
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + Objects.hashCode(this.getEncoder());
        result = 31 * result + Objects.hashCode(this.getName());
        result = 31 * result + Objects.hashCode(this.getDataType());
        return result;
    }

    public boolean equals(Object object) {
        if (object instanceof Feature) {
            Feature that = (Feature)object;
            return this.getClass().equals(that.getClass()) && Objects.equals(this.getEncoder(), that.getEncoder()) && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getDataType(), that.getDataType());
        }
        return false;
    }

    public String toString() {
        Objects.ToStringHelper helper = this.toStringHelper();
        return helper.toString();
    }

    protected Objects.ToStringHelper toStringHelper() {
        return com.google.common.base.Objects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("dataType", (Object)this.getDataType());
    }

    protected PMMLEncoder ensureEncoder() {
        PMMLEncoder encoder = this.getEncoder();
        if (encoder == null) {
            throw new IllegalStateException();
        }
        return encoder;
    }

    public PMMLEncoder getEncoder() {
        return this.encoder;
    }

    private void setEncoder(PMMLEncoder encoder) {
        this.encoder = encoder;
    }

    public FieldName getName() {
        return this.name;
    }

    private void setName(FieldName name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.name = name;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    private void setDataType(DataType dataType) {
        if (dataType == null) {
            throw new IllegalArgumentException();
        }
        this.dataType = dataType;
    }
}

