/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataField;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.Visitor;
import org.jpmml.converter.Decorator;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.model.visitors.DataDictionaryCleaner;
import org.jpmml.model.visitors.DeepFieldResolver;
import org.jpmml.model.visitors.MiningSchemaCleaner;
import org.jpmml.model.visitors.TransformationDictionaryCleaner;

public class ModelEncoder
extends PMMLEncoder {
    private Map<FieldName, List<Decorator>> decorators = new LinkedHashMap<FieldName, List<Decorator>>();

    public PMML encodePMML(Model model) {
        PMML pmml = this.encodePMML();
        pmml.addModels(new Model[]{model});
        List<DeepFieldResolver> visitors = Arrays.asList(new MiningSchemaCleaner(), new TransformationDictionaryCleaner(), new DataDictionaryCleaner());
        for (Visitor visitor : visitors) {
            visitor.applyTo((Visitable)pmml);
        }
        MiningSchema miningSchema = model.getMiningSchema();
        List list = miningSchema.getMiningFields();
        for (MiningField miningField : list) {
            FieldName name = miningField.getName();
            List<Decorator> decorators = this.getDecorators(name);
            if (decorators == null) continue;
            DataField dataField = this.getDataField(name);
            if (dataField == null) {
                throw new IllegalArgumentException();
            }
            for (Decorator decorator : decorators) {
                decorator.decorate(dataField, miningField);
            }
        }
        return pmml;
    }

    public List<Decorator> getDecorators(FieldName name) {
        return this.decorators.get(name);
    }

    public void addDecorator(FieldName name, Decorator decorator) {
        List<Decorator> decorators = this.decorators.get(name);
        if (decorators == null) {
            decorators = new ArrayList<Decorator>();
            this.decorators.put(name, decorators);
        }
        decorators.add(decorator);
    }
}

