/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.dmg.pmml.Application;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Array;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Header;
import org.dmg.pmml.Interval;
import org.dmg.pmml.RealSparseArray;
import org.dmg.pmml.Timestamp;
import org.dmg.pmml.Value;
import org.jpmml.converter.ValueUtil;

public class PMMLUtil {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");

    private PMMLUtil() {
    }

    public static Header createHeader(Class<?> clazz) {
        Package _package = clazz.getPackage();
        return PMMLUtil.createHeader(_package.getImplementationTitle(), _package.getImplementationVersion());
    }

    public static Header createHeader(String name, String version) {
        Application application = new Application().setName(name).setVersion(version);
        return PMMLUtil.createHeader(application);
    }

    public static Header createHeader(Application application) {
        Date now = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        dateFormat.setTimeZone(UTC);
        Timestamp timestamp = new Timestamp().addContent(new Object[]{dateFormat.format(now)});
        Header header = new Header().setApplication(application).setTimestamp(timestamp);
        return header;
    }

    public static List<String> getValues(DataField dataField) {
        return PMMLUtil.getValues(dataField, null);
    }

    public static List<String> getValues(DataField dataField, Value.Property property) {
        ArrayList<String> result = new ArrayList<String>();
        if (property == null) {
            property = Value.Property.VALID;
        }
        List pmmlValues = dataField.getValues();
        for (Value pmmlValue : pmmlValues) {
            if (!property.equals((Object)pmmlValue.getProperty())) continue;
            result.add(pmmlValue.getValue());
        }
        return result;
    }

    public static void addValues(DataField dataField, List<String> values) {
        PMMLUtil.addValues(dataField, values, null);
    }

    public static void addValues(DataField dataField, List<String> values, Value.Property property) {
        if (Value.Property.VALID.equals((Object)property)) {
            property = null;
        }
        List pmmlValues = dataField.getValues();
        for (String value : values) {
            Value pmmlValue = new Value(value).setProperty(property);
            pmmlValues.add(pmmlValue);
        }
    }

    public static void addIntervals(DataField dataField, List<Interval> intervals) {
        dataField.getIntervals().addAll(intervals);
    }

    public static Apply createApply(String function, Expression ... expressions) {
        Apply apply = new Apply(function).addExpressions(expressions);
        return apply;
    }

    public static Constant createConstant(Object value) {
        Constant constant = new Constant(ValueUtil.formatValue(value));
        if (value instanceof Double) {
            constant.setDataType(DataType.DOUBLE);
        }
        return constant;
    }

    public static Array createRealArray(List<? extends Number> values) {
        Function<Number, String> function = new Function<Number, String>(){

            public String apply(Number number) {
                return ValueUtil.formatValue(number);
            }
        };
        String value = ValueUtil.formatArrayValue(Lists.transform(values, (Function)function));
        Array array = new Array(Array.Type.REAL, value);
        return array;
    }

    public static RealSparseArray createRealSparseArray(List<? extends Number> values, Double defaultValue) {
        RealSparseArray sparseArray = new RealSparseArray().setN(Integer.valueOf(values.size())).setDefaultValue(defaultValue);
        int index = 1;
        for (Number number : values) {
            if (!ValueUtil.equals(number, defaultValue)) {
                sparseArray.addIndices(new Integer[]{index});
                sparseArray.addEntries(new Double[]{ValueUtil.asDouble(number)});
            }
            ++index;
        }
        return sparseArray;
    }

    public static List<FieldName> getNames(List<? extends Field> fields) {
        Function<Field, FieldName> function = new Function<Field, FieldName>(){

            public FieldName apply(Field field) {
                return field.getName();
            }
        };
        return Lists.newArrayList((Iterable)Lists.transform(fields, (Function)function));
    }

    public static <F extends Field> F getField(FieldName name, List<F> fields) {
        return PMMLUtil.getField(name, fields, 0);
    }

    public static <F extends Field> F getField(FieldName name, List<F> fields, int offset) {
        for (int i = offset; i < fields.size(); ++i) {
            Field field = (Field)fields.get(i);
            if (!name.equals((Object)field.getName())) continue;
            return (F)field;
        }
        throw new IllegalArgumentException();
    }
}

