/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter.support_vector_machine;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.dmg.pmml.Array;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.RealSparseArray;
import org.dmg.pmml.regression.CategoricalPredictor;
import org.dmg.pmml.support_vector_machine.Coefficient;
import org.dmg.pmml.support_vector_machine.Coefficients;
import org.dmg.pmml.support_vector_machine.SupportVector;
import org.dmg.pmml.support_vector_machine.SupportVectorMachine;
import org.dmg.pmml.support_vector_machine.SupportVectorMachineModel;
import org.dmg.pmml.support_vector_machine.SupportVectors;
import org.dmg.pmml.support_vector_machine.VectorDictionary;
import org.dmg.pmml.support_vector_machine.VectorFields;
import org.dmg.pmml.support_vector_machine.VectorInstance;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.CMatrixUtil;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Matrix;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;

public class LibSVMUtil {
    private LibSVMUtil() {
    }

    public static SupportVectorMachineModel createRegression(Matrix<Double> sv, List<String> ids, Double rho, List<Double> coefs, Schema schema) {
        VectorDictionary vectorDictionary = LibSVMUtil.createVectorDictionary(sv, ids, schema);
        List vectorInstances = vectorDictionary.getVectorInstances();
        ArrayList<SupportVectorMachine> supportVectorMachines = new ArrayList<SupportVectorMachine>();
        supportVectorMachines.add(LibSVMUtil.createSupportVectorMachine(vectorInstances, rho, coefs));
        SupportVectorMachineModel supportVectorMachineModel = new SupportVectorMachineModel(MiningFunction.REGRESSION, ModelUtil.createMiningSchema(schema), vectorDictionary, supportVectorMachines);
        return supportVectorMachineModel;
    }

    public static SupportVectorMachineModel createClassification(Matrix<Double> sv, List<Integer> nSv, List<String> ids, List<Double> rho, List<Double> coefs, Schema schema) {
        int i;
        int numberOfVectors = sv.getRows();
        int numberOfFeatures = sv.getColumns();
        VectorDictionary vectorDictionary = LibSVMUtil.createVectorDictionary(sv, ids, schema);
        List vectorInstances = vectorDictionary.getVectorInstances();
        ArrayList<SupportVectorMachine> supportVectorMachines = new ArrayList<SupportVectorMachine>();
        int[] offsets = new int[nSv.size() + 1];
        for (i = 0; i < nSv.size(); ++i) {
            offsets[i + 1] = offsets[i] + nSv.get(i);
        }
        i = 0;
        CategoricalLabel categoricalLabel = (CategoricalLabel)schema.getLabel();
        int size = categoricalLabel.size();
        for (int first = 0; first < size; ++first) {
            for (int second = first + 1; second < size; ++second) {
                ArrayList<VectorInstance> svmVectorInstances = new ArrayList<VectorInstance>();
                svmVectorInstances.addAll(LibSVMUtil.slice(vectorInstances, offsets, first));
                svmVectorInstances.addAll(LibSVMUtil.slice(vectorInstances, offsets, second));
                Double svmRho = rho.get(i);
                ArrayList<Double> svmCoefs = new ArrayList<Double>();
                svmCoefs.addAll(LibSVMUtil.slice(CMatrixUtil.getRow(coefs, size - 1, numberOfVectors, second - 1), offsets, first));
                svmCoefs.addAll(LibSVMUtil.slice(CMatrixUtil.getRow(coefs, size - 1, numberOfVectors, first), offsets, second));
                SupportVectorMachine supportVectorMachine = LibSVMUtil.createSupportVectorMachine(svmVectorInstances, svmRho, svmCoefs).setTargetCategory(categoricalLabel.getValue(first)).setAlternateTargetCategory(categoricalLabel.getValue(second));
                supportVectorMachines.add(supportVectorMachine);
                ++i;
            }
        }
        SupportVectorMachineModel supportVectorMachineModel = new SupportVectorMachineModel(MiningFunction.CLASSIFICATION, ModelUtil.createMiningSchema(schema), vectorDictionary, supportVectorMachines).setClassificationMethod(SupportVectorMachineModel.ClassificationMethod.ONE_AGAINST_ONE);
        return supportVectorMachineModel;
    }

    public static VectorDictionary createVectorDictionary(Matrix<Double> sv, List<String> ids, Schema schema) {
        List<Feature> features;
        int numberOfVectors = sv.getRows();
        int numberOfFeatures = sv.getColumns();
        if (numberOfFeatures != (features = schema.getFeatures()).size()) {
            throw new IllegalArgumentException();
        }
        BitSet featureMask = new BitSet(numberOfFeatures);
        Double defaultValue = 0.0;
        for (int i = 0; i < numberOfVectors; ++i) {
            List<Double> values = sv.getRowValues(i);
            BitSet vectorFeatureMask = ValueUtil.getIndices(values, defaultValue);
            vectorFeatureMask.flip(0, numberOfFeatures);
            featureMask.or(vectorFeatureMask);
        }
        int numberOfUsedFeatures = featureMask.cardinality();
        VectorFields vectorFields = new VectorFields();
        for (int i = 0; i < numberOfFeatures; ++i) {
            Feature feature = schema.getFeature(i);
            if (!featureMask.get(i)) continue;
            if (feature instanceof BinaryFeature) {
                BinaryFeature binaryFeature = (BinaryFeature)feature;
                CategoricalPredictor categoricalPredictor = new CategoricalPredictor(binaryFeature.getName(), binaryFeature.getValue(), 1.0);
                vectorFields.addContent(new PMMLObject[]{categoricalPredictor});
                continue;
            }
            ContinuousFeature continuousFeature = feature.toContinuousFeature();
            vectorFields.addContent(new PMMLObject[]{continuousFeature.ref()});
        }
        VectorDictionary vectorDictionary = new VectorDictionary(vectorFields);
        for (int i = 0; i < numberOfVectors; ++i) {
            List<Double> values = sv.getRowValues(i);
            if (numberOfUsedFeatures < numberOfFeatures) {
                values = ValueUtil.filterByIndices(values, featureMask);
            }
            VectorInstance vectorInstance = new VectorInstance(ids.get(i));
            if (ValueUtil.isSparse(values, defaultValue, 0.75)) {
                RealSparseArray sparseArray = PMMLUtil.createRealSparseArray(values, defaultValue);
                vectorInstance.setRealSparseArray(sparseArray);
            } else {
                Array array = PMMLUtil.createRealArray(values);
                vectorInstance.setArray(array);
            }
            vectorDictionary.addVectorInstances(new VectorInstance[]{vectorInstance});
        }
        return vectorDictionary;
    }

    public static SupportVectorMachine createSupportVectorMachine(List<VectorInstance> vectorInstances, Double rho, List<Double> coefs) {
        if (vectorInstances.size() != coefs.size()) {
            throw new IllegalArgumentException();
        }
        Coefficients coefficients = new Coefficients().setAbsoluteValue(rho);
        SupportVectors supportVectors = new SupportVectors();
        for (int i = 0; i < vectorInstances.size(); ++i) {
            VectorInstance vectorInstance = vectorInstances.get(i);
            Coefficient coefficient = new Coefficient().setValue(coefs.get(i));
            coefficients.addCoefficients(new Coefficient[]{coefficient});
            SupportVector supportVector = new SupportVector(vectorInstance.getId());
            supportVectors.addSupportVectors(new SupportVector[]{supportVector});
        }
        SupportVectorMachine supportVectorMachine = new SupportVectorMachine(coefficients).setSupportVectors(supportVectors);
        return supportVectorMachine;
    }

    private static <E> List<E> slice(List<E> list, int[] offsets, int index) {
        return list.subList(offsets[index], offsets[index + 1]);
    }
}

