/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Label;

public class Schema {
    private Label label = null;
    private List<Feature> features = null;

    public Schema(Label label, List<Feature> features) {
        this.setLabel(label);
        this.setFeatures(features);
    }

    public Schema toAnonymousSchema() {
        Label label = this.getLabel();
        List<Feature> features = this.getFeatures();
        return new Schema(label != null ? label.toAnonymousLabel() : null, features);
    }

    public Schema toSubSchema(int[] indexes) {
        Label label = this.getLabel();
        List<Feature> features = this.getFeatures();
        ArrayList<Feature> selectedFeatures = new ArrayList<Feature>(indexes.length);
        for (int index : indexes) {
            Feature feature = features.get(index);
            selectedFeatures.add(feature);
        }
        return new Schema(label, selectedFeatures);
    }

    public Schema toTransformedSchema(Function<Feature, Feature> function) {
        Label label = this.getLabel();
        List<Feature> features = this.getFeatures();
        ArrayList<Feature> transformedFeatures = new ArrayList<Feature>(Lists.transform(features, function));
        return new Schema(label, transformedFeatures);
    }

    public Label getLabel() {
        return this.label;
    }

    private void setLabel(Label label) {
        this.label = label;
    }

    public Feature getFeature(int index) {
        List<Feature> features = this.getFeatures();
        return features.get(index);
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    private void setFeatures(List<Feature> features) {
        this.features = features;
    }
}

